/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.buildmap;

import com.ibm.team.build.internal.ui.helper.BuildUIHelper;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.actions.OpenLocalFileInBuildAction;
import com.ibm.team.enterprise.build.ui.actions.OpenRemoteFileAction;
import com.ibm.team.enterprise.build.ui.editors.buildmap.AbstractBuildMapFormPage;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapEditorInput;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapInputsResolvedStyledLabelProvider;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapInputsUnresolvedStyledLabelProvider;
import com.ibm.team.enterprise.build.ui.editors.buildmap.ResolvedInputNode;
import com.ibm.team.enterprise.build.ui.editors.buildmap.ResolvedInputRootNode;
import com.ibm.team.enterprise.build.ui.editors.buildmap.ResovledInputsTreeContentProvider;
import com.ibm.team.enterprise.build.ui.editors.result.BuildReportViewerToolTipSupport;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.parserOutputs.ParserOutputData;
import com.ibm.team.enterprise.internal.build.ui.parserOutputs.ParserOutputNode;
import com.ibm.team.enterprise.internal.build.ui.parserOutputs.ParserOutputSourceNode;
import com.ibm.team.enterprise.internal.build.ui.parserOutputs.ParserOutputTreeContentProvider;
import com.ibm.team.enterprise.internal.build.ui.parserOutputs.ParserOutputTreeLabelProvider;
import com.ibm.team.enterprise.internal.build.ui.parserOutputs.ParserOutputsBuildMapQuery;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildMap;
import com.ibm.team.enterprise.internal.buildmap.common.IInput;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.PageBook;
import org.xml.sax.SAXException;

public class BuildMapInputsPage
extends AbstractBuildMapFormPage {
    private SashForm fViewContentParent = null;
    private Composite fTopCom = null;
    private Composite fResourcePrefixCom = null;
    private Text fResourcePrefixText = null;
    private Tree fResolvedInputsTree = null;
    private TreeViewer fResolvedInputsTreeView = null;
    private Table fUnresolvedInputsTable = null;
    private TableViewer fUnresolvedInputsTableView = null;
    private PageBook fWholePageBook = null;
    private PageBook fUnresolvedPageBook = null;
    private Composite fNoUnresolvedInputsComposite = null;
    private Composite fUnresovledInputComposite = null;
    private Composite fUnresolvedInputsTableComposite = null;
    private BuildMapInputsResolvedStyledLabelProvider fResolvedLabelProvider = null;
    private ResolvedInputRootNode[] fInputsList = null;
    private List<IBuildFile> fUnResovledInputsList = null;
    private BuildMapInputsUnresolvedStyledLabelProvider fUnresolvedStyledLabelProvider = null;
    private Tree fParserOutputsTree = null;
    private TreeViewer fParserOutputsTreeView = null;
    private Composite fParserOutputsTableComposite = null;
    private Composite fNoParserOutputTableComposite = null;
    private PageBook fParserOutputPageBook = null;
    private ToolItem fRetrieveDetails = null;
    private List<IBuildFile> fParserOutputsList = null;
    private ParserOutputsBuildMapQuery fParserOutputQuery = null;
    private IShareable shareable = null;

    public BuildMapInputsPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    public void initializeContent() {
        if (this.fBuildMap != null && this.fWholePageBook != null) {
            if (this.fBuildMap == null) {
                this.fWholePageBook.showPage((Control)this.fNoBuildMapControl);
                this.fNoBuildMapLink.setText(NLS.bind((String)Messages.BuildMapEditor_NOMAP_LABEL, (Object)this.fBuildMapURI));
                this.fNoBuildMapControl.layout();
            } else {
                this.fWholePageBook.showPage((Control)this.fViewContentParent);
            }
            this.updateContent();
        }
    }

    @Override
    protected void createContainerContent(Composite container) {
        this.fWholePageBook = new PageBook(container, 0);
        this.fWholePageBook.setBackground(container.getBackground());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fWholePageBook);
        this.createNoBuildMapControl((Composite)this.fWholePageBook);
        this.fViewContentParent = new SashForm((Composite)this.fWholePageBook, 512);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fViewContentParent);
        this.fViewContentParent.setBackground(container.getBackground());
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.fViewContentParent);
        this.fTopCom = new Composite((Composite)this.fViewContentParent, 0);
        this.fTopCom.setBackground(container.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fTopCom);
        GridLayoutFactory.fillDefaults().margins(5, 2).applyTo(this.fTopCom);
        this.createInputsResovledPart(this.fTopCom);
        Composite bottomCom = new Composite((Composite)this.fViewContentParent, 0);
        bottomCom.setBackground(container.getBackground());
        GridLayoutFactory.fillDefaults().margins(5, 2).applyTo(bottomCom);
        this.createUnresolveInputsdPart(bottomCom);
        Composite generatedSrcComp = new Composite((Composite)this.fViewContentParent, 0);
        generatedSrcComp.setBackground(container.getBackground());
        GridLayoutFactory.fillDefaults().margins(5, 2).applyTo(generatedSrcComp);
        this.createGeneratedSourcesPart(generatedSrcComp);
        this.fViewContentParent.setWeights(new int[]{50, 30, 20});
        this.initializeContent();
        this.fTopCom.layout();
        bottomCom.layout();
        generatedSrcComp.layout();
        container.layout();
    }

    private void createGeneratedSourcesPart(Composite parent) {
        Section parserOutputSection = this.createSection(parent, Messages.BuildMapEditor_PARSEROUTPUTS_SECTION_TITLE, null, 0, true, true);
        this.createToolbarForGeneratedSourcesSection(parserOutputSection);
        this.fParserOutputPageBook = new PageBook((Composite)parserOutputSection, 0);
        parserOutputSection.setClient((Control)this.fParserOutputPageBook);
        this.fNoParserOutputTableComposite = this.fFormToolkit.createComposite((Composite)this.fParserOutputPageBook);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fNoParserOutputTableComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(this.fNoParserOutputTableComposite);
        this.fFormToolkit.createLabel(this.fNoParserOutputTableComposite, Messages.BuildMapEditor_PARSEROUTPUTS_NO_CONTENT_LABEL);
        this.fParserOutputsTableComposite = this.fFormToolkit.createComposite((Composite)this.fParserOutputPageBook);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fParserOutputsTableComposite);
        TreeColumnLayout columnLayout = new TreeColumnLayout();
        this.fParserOutputsTableComposite.setLayout((Layout)columnLayout);
        this.fParserOutputsTree = this.fFormToolkit.createTree(this.fParserOutputsTableComposite, 68352);
        this.fParserOutputsTreeView = new TreeViewer(this.fParserOutputsTree);
        BuildReportUtil.createTreeColumn(this.fParserOutputsTree, this.fParserOutputsTreeView, columnLayout, Messages.BuildMapEditor_OUTPUTS_FILE_LOCATION_TABLE_COLUMN, 20, 16384, 0, Messages.BuildMapEditor_OUTPUTS_FILE_LOCATION_TABLE_COLUMN, 2);
        BuildReportUtil.createTreeColumn(this.fParserOutputsTree, this.fParserOutputsTreeView, columnLayout, Messages.BuildMapEditor_INPUTS_TYPE_TABLE_COLUMN, 10, 16384, 1, Messages.BuildMapEditor_INPUTS_TYPE_TABLE_COLUMN, 2);
        BuildReportUtil.createTreeColumn(this.fParserOutputsTree, this.fParserOutputsTreeView, columnLayout, Messages.BuildMapEditor_INPUTS_LAST_MODIFIED_TABLE_COLUMN, 20, 16384, 2, Messages.BuildMapEditor_INPUTS_LAST_MODIFIED_TABLE_COLUMN, 2);
        BuildReportUtil.createTreeColumn(this.fParserOutputsTree, this.fParserOutputsTreeView, columnLayout, Messages.BuildMapEditor_INPUTS_PARSER_OUTPUT_SOURCE_TABLE_COLUMN, 20, 16384, 3, Messages.BuildMapEditor_INPUTS_PARSER_OUTPUT_SOURCE_TABLE_COLUMN_TOOLTIP, 2);
        BuildReportUtil.createTreeColumn(this.fParserOutputsTree, this.fParserOutputsTreeView, columnLayout, Messages.BuildMapEditor_INPUTS_PARSER_OUTPUT_BUILD_MAP_TABLE_COLUMN, 15, 16384, 4, Messages.BuildMapEditor_INPUTS_PARSER_OUTPUT_BUILD_MAP_TABLE_COLUMN_TOOLTIP, 2);
        BuildReportViewerToolTipSupport.enableFor((ColumnViewer)this.fParserOutputsTreeView);
        this.fParserOutputsTree.setLinesVisible(true);
        this.fParserOutputsTree.setHeaderVisible(true);
        this.fParserOutputsTreeView.setLabelProvider((IBaseLabelProvider)new ParserOutputTreeLabelProvider());
        this.fParserOutputsTreeView.setContentProvider((IContentProvider)new ParserOutputTreeContentProvider());
        final TreeViewerFocusCellManager cellManagers = new TreeViewerFocusCellManager(this.fParserOutputsTreeView, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.fParserOutputsTreeView){});
        this.fParserOutputsTree.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                BuildMapInputsPage.this.handleOpenBuildMapEditor(cellManagers);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.fParserOutputsTree.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (13 == e.keyCode) {
                    BuildMapInputsPage.this.handleOpenBuildMapEditor(cellManagers);
                }
            }
        });
        this.fParserOutputsTree.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                this.doEvent(e);
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseEnter(MouseEvent e) {
                this.doEvent(e);
            }

            private void doEvent(MouseEvent e) {
                Object element;
                ViewerCell viewerCell = BuildMapInputsPage.this.fParserOutputsTreeView.getCell(new Point(e.x, e.y));
                if (viewerCell != null && (element = viewerCell.getElement()) instanceof ParserOutputNode) {
                    int columnIndex = viewerCell.getColumnIndex();
                    if (4 == columnIndex) {
                        viewerCell.getControl().setCursor(Display.getCurrent().getSystemCursor(21));
                    } else {
                        viewerCell.getControl().setCursor(Display.getCurrent().getSystemCursor(0));
                    }
                }
            }
        });
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BuildMapInputsPage.this.showPopupMenu(manager, BuildMapInputsPage.this.fParserOutputsTreeView.getSelection(), true);
            }
        });
        Menu openFileMenu = menuMgr.createContextMenu(this.fParserOutputsTreeView.getControl());
        this.fParserOutputsTreeView.getControl().setMenu(openFileMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fParserOutputsTreeView);
        parserOutputSection.setExpanded(true);
    }

    private void createToolbarForGeneratedSourcesSection(Section section) {
        ToolBar toolBar = new ToolBar((Composite)section, 0x800100);
        this.fRetrieveDetails = new ToolItem(toolBar, 8);
        this.fRetrieveDetails.setText(Messages.BuildMapEditor_INPUTS_PARSER_OUTPUT_RETRIEVE_BUTTON);
        this.fRetrieveDetails.setToolTipText(Messages.BuildMapEditor_INPUTS_PARSER_OUTPUT_RETRIEVE_BUTTON_TOOLTIP);
        this.fRetrieveDetails.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BuildMapInputsPage.this.fParserOutputsList.size() > 0) {
                    BuildMapInputsPage.this.retrieveParserOutputDetails();
                }
            }
        });
        section.setTextClient((Control)toolBar);
    }

    private void retrieveParserOutputDetails() {
        TeamBuildJob job = new TeamBuildJob(Messages.BuildMapEditor_INPUTS_PARSER_OUTPUT_RETRIEVE_DETAILS_JOB_TITLE, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                try {
                    BuildMapInputsPage.this.fParserOutputQuery = new ParserOutputsBuildMapQuery(BuildMapInputsPage.this.fTeamRepository);
                    BuildMapInputsPage.this.fParserOutputQuery.runQuery(UUID.valueOf((String)BuildMapInputsPage.this.fBuildMap.getBuildDefinitionUUID()), BuildMapInputsPage.this.fParserOutputsList, BuildMapInputsPage.this.fBuildMap.getBuildLabel());
                }
                catch (Exception e) {
                    Activator.getDefault().logError(e);
                    return new Status(4, "com.ibm.team.enterprise.build.ui", Messages.BuildMapEditor_INPUTS_PARSER_OUTPUT_ERROR_RETRIEVE_DETAILS, (Throwable)e);
                }
                return null;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BuildMapInputsPage.this.refreshParserOutputTreeView(true);
                    }
                });
            }
        };
        job.schedule();
    }

    private void handleOpenBuildMapEditor(TreeViewerFocusCellManager cellManagers) {
        ViewerCell viewerCell = cellManagers.getFocusCell();
        if (viewerCell != null) {
            ParserOutputSourceNode buildFile;
            URI buildMapURI;
            Object element = viewerCell.getElement();
            int columnIndex = viewerCell.getColumnIndex();
            if (element instanceof ParserOutputSourceNode && 4 == columnIndex && (buildMapURI = (buildFile = (ParserOutputSourceNode)element).getData().getBuildMapUri()) != null) {
                final BuildMapEditorInput editorInput = new BuildMapEditorInput(buildMapURI, this.fBuildmapMap, this.fUuidStateIDVersionIDMap, this.fComponentUUIDNameMap, this.fSysDefCache, this.fTeamRepository);
                UIUpdaterJob fUIJob = new UIUpdaterJob(""){
                    IBuildMap buildMap;
                    {
                        super($anonymous0);
                        this.buildMap = null;
                    }

                    public IStatus runInBackground(IProgressMonitor monitor) {
                        try {
                            this.buildMap = editorInput.fetchBuildMap(null);
                        }
                        catch (TeamRepositoryException e) {
                            Activator.getDefault().logError(e);
                        }
                        catch (SAXException e) {
                            Activator.getDefault().logError(e);
                        }
                        catch (IOException e) {
                            Activator.getDefault().logError(e);
                        }
                        catch (ParserConfigurationException e) {
                            Activator.getDefault().logError(e);
                        }
                        return super.runInBackground(monitor);
                    }

                    public IStatus runInUI(IProgressMonitor monitor) {
                        if (this.buildMap != null) {
                            try {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "com.ibm.team.enterprise.build.ui.editors.buildMapEditor");
                            }
                            catch (PartInitException ex) {
                                Activator.getDefault().logError(ex);
                            }
                        } else {
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ViewBuildMapDialog_TITLE, (String)Messages.ViewBuildMapAction_ERROR_INVALID_SELECTION);
                        }
                        return super.runInUI(monitor);
                    }
                };
                fUIJob.schedule();
            }
        }
    }

    private void createInputsResovledPart(Composite topCom) {
        Section resolvedInputSection = this.createSection(topCom, Messages.BuildMapEditor_INPUTS_RESOLVED_SECTION_TITLE, null, 0, true, true);
        Composite resolvedInputComposite = this.fFormToolkit.createComposite((Composite)resolvedInputSection);
        resolvedInputSection.setClient((Control)resolvedInputComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)resolvedInputComposite);
        GridLayoutFactory.fillDefaults().applyTo(resolvedInputComposite);
        this.fResourcePrefixCom = this.fFormToolkit.createComposite(resolvedInputComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fResourcePrefixCom);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.fResourcePrefixCom);
        this.fFormToolkit.createLabel(this.fResourcePrefixCom, Messages.BuildMapEditor_GENERAL_RESOURCE_PREFIX_LABEL);
        this.fResourcePrefixText = BuildUIHelper.createNonEditableText((FormToolkit)this.fFormToolkit, (Composite)this.fResourcePrefixCom, (String)"", (int)0);
        Composite treeComposite = this.fFormToolkit.createComposite(resolvedInputComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeComposite);
        this.fResolvedInputsTree = this.fFormToolkit.createTree(treeComposite, 0x10010800);
        this.fResolvedInputsTree.setLinesVisible(true);
        this.fResolvedInputsTree.setHeaderVisible(true);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        this.fResolvedInputsTreeView = new TreeViewer(this.fResolvedInputsTree);
        BuildReportUtil.createTreeColumn(this.fResolvedInputsTree, this.fResolvedInputsTreeView, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_SOURCE, 20, 16384, 0, Messages.BuildReportPage_TABLE_COLUMN_SOURCE, 1);
        BuildReportUtil.createTreeColumn(this.fResolvedInputsTree, this.fResolvedInputsTreeView, treeColumnLayout, Messages.BuildMapEditor_INPUTS_PATH_TABLE_COLUMN, 15, 16384, 1, Messages.BuildMapEditor_INPUTS_PATH_TABLE_COLUMN, 1);
        BuildReportUtil.createTreeColumn(this.fResolvedInputsTree, this.fResolvedInputsTreeView, treeColumnLayout, Messages.BuildMapEditor_INPUTS_TYPE_TABLE_COLUMN, 8, 16384, 2, Messages.BuildMapEditor_INPUTS_TYPE_TABLE_COLUMN, 1);
        BuildReportUtil.createTreeColumn(this.fResolvedInputsTree, this.fResolvedInputsTreeView, treeColumnLayout, Messages.BuildReportPage_TABLE_COLUMN_VERSION_ID, 5, 16384, 3, Messages.BuildReportPage_TABLE_COLUMN_VERSION_ID, 1);
        treeComposite.setLayout((Layout)treeColumnLayout);
        BuildReportViewerToolTipSupport.enableFor((ColumnViewer)this.fResolvedInputsTreeView);
        HashSet<Integer> qualifierSet = new HashSet<Integer>();
        qualifierSet.add(0);
        this.fResolvedLabelProvider = new BuildMapInputsResolvedStyledLabelProvider(null, qualifierSet);
        this.fResolvedInputsTreeView.setLabelProvider((IBaseLabelProvider)this.fResolvedLabelProvider);
        this.fResolvedInputsTreeView.setContentProvider((IContentProvider)new ResovledInputsTreeContentProvider(this.fResolvedInputsTreeView));
        resolvedInputSection.setExpanded(true);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                BuildMapInputsPage.this.showPopupMenu(manager, BuildMapInputsPage.this.fResolvedInputsTreeView.getSelection(), false);
            }
        });
        Menu openFileMenu = menuMgr.createContextMenu(this.fResolvedInputsTreeView.getControl());
        this.fResolvedInputsTreeView.getControl().setMenu(openFileMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.fResolvedInputsTreeView);
    }

    private void showPopupMenu(IMenuManager manager, ISelection selection, boolean isParserOutput) {
        this.shareable = null;
        if (selection instanceof IStructuredSelection) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            String fileStateid = null;
            String fileUUID = null;
            String scmLocation = null;
            if (!isParserOutput && selected instanceof ResolvedInputNode) {
                IBuildFile file = ((ResolvedInputNode)selected).getBuildFile();
                fileStateid = file.getFileStateUUID();
                fileUUID = file.getFileUUID();
                scmLocation = file.getSCMLocation();
            } else if (isParserOutput && selected instanceof ParserOutputSourceNode) {
                ParserOutputSourceNode parserSourceNode = (ParserOutputSourceNode)selected;
                fileUUID = parserSourceNode.getData().getSourceFileItemUuid();
                fileStateid = parserSourceNode.getData().getSourceFileStateUuid();
                scmLocation = parserSourceNode.getData().getScmLocation();
            }
            if (fileUUID != null && fileUUID.length() > 0) {
                final IVersionableHandle fileHandle = (IVersionableHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)fileUUID), null);
                Display.getCurrent().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Collection shareables = null;
                        try {
                            shareables = SharingManager.getInstance().findShareables(fileHandle, null);
                        }
                        catch (FileSystemException e) {
                            Activator.getDefault().logError(e);
                        }
                        if (shareables != null && !shareables.isEmpty()) {
                            BuildMapInputsPage.this.shareable = (IShareable)shareables.iterator().next();
                        }
                    }
                });
                if (this.shareable != null) {
                    manager.add((IAction)new OpenLocalFileInBuildAction(this.shareable, this.getEditor().getSite()));
                }
                manager.add((IAction)new OpenRemoteFileAction(this.fTeamRepository, UUID.valueOf((String)fileUUID), UUID.valueOf((String)fileStateid), (IWorkbenchPart)this.getEditor(), scmLocation));
            }
        }
    }

    private void createUnresolveInputsdPart(Composite bottomCom) {
        Section unResolvedInputSection = this.createSection(bottomCom, Messages.BuildMapEditor_INPUTS_UNRESOLVED_SECTION_TITLE, null, 0, true, true);
        this.fUnresolvedPageBook = new PageBook((Composite)unResolvedInputSection, 0);
        unResolvedInputSection.setClient((Control)this.fUnresolvedPageBook);
        this.fNoUnresolvedInputsComposite = this.fFormToolkit.createComposite((Composite)this.fUnresolvedPageBook);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fNoUnresolvedInputsComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(this.fNoUnresolvedInputsComposite);
        this.fFormToolkit.createLabel(this.fNoUnresolvedInputsComposite, Messages.BuildMapEditor_INPUTS_UNRESOLVED_NO_CONTENT_LABEL);
        this.fUnresovledInputComposite = this.fFormToolkit.createComposite((Composite)this.fUnresolvedPageBook);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fUnresovledInputComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.fUnresovledInputComposite);
        this.fUnresolvedInputsTableComposite = this.fFormToolkit.createComposite(this.fUnresovledInputComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fUnresolvedInputsTableComposite);
        TableColumnLayout columnLayout = new TableColumnLayout();
        this.fUnresolvedInputsTableComposite.setLayout((Layout)columnLayout);
        this.fUnresolvedInputsTable = this.fFormToolkit.createTable(this.fUnresolvedInputsTableComposite, 68352);
        this.fUnresolvedInputsTableView = new TableViewer(this.fUnresolvedInputsTable);
        BuildReportUtil.createTableColumn(this.fUnresolvedInputsTableView, this.fUnresolvedInputsTable, columnLayout, Messages.BuildMapEditor_INPUTS_DEPENDENCY_RESOURCE_TABLE_COLUMN, 20, 16384, 0, Messages.BuildMapEditor_INPUTS_DEPENDENCY_RESOURCE_TABLE_COLUMN, 0);
        BuildReportUtil.createTableColumn(this.fUnresolvedInputsTableView, this.fUnresolvedInputsTable, columnLayout, Messages.BuildMapEditor_INPUTS_PATH_TABLE_COLUMN, 20, 16384, 1, Messages.BuildMapEditor_INPUTS_PATH_TABLE_COLUMN, 0);
        BuildReportUtil.createTableColumn(this.fUnresolvedInputsTableView, this.fUnresolvedInputsTable, columnLayout, Messages.BuildMapEditor_INPUTS_TYPE_TABLE_COLUMN, 6, 16384, 2, Messages.BuildMapEditor_INPUTS_TYPE_TABLE_COLUMN, 0);
        this.fUnresolvedInputsTable.setLinesVisible(true);
        this.fUnresolvedInputsTable.setHeaderVisible(true);
        HashSet<Integer> qualifierSet = new HashSet<Integer>();
        qualifierSet.add(0);
        this.fUnresolvedStyledLabelProvider = new BuildMapInputsUnresolvedStyledLabelProvider(null, qualifierSet);
        this.fUnresolvedInputsTableView.setLabelProvider((IBaseLabelProvider)this.fUnresolvedStyledLabelProvider);
        this.fUnresolvedInputsTableView.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        unResolvedInputSection.setExpanded(true);
    }

    public void updateContent() {
        if (this.fBuildMap == null) {
            return;
        }
        if (this.fInputsList != null) {
            this.fInputsList = null;
        }
        if (this.fUnResovledInputsList != null) {
            this.fUnResovledInputsList.clear();
        } else {
            this.fUnResovledInputsList = new ArrayList<IBuildFile>();
        }
        final String prefix = this.fBuildMap.getResourcePrefix();
        ArrayList<IBuildFile> tempInputsList = new ArrayList<IBuildFile>();
        if (this.fBuildMap != null) {
            Set inputs = this.fBuildMap.getInputs();
            for (IInput input : inputs) {
                IBuildFile buildFile = (IBuildFile)input.getArtifact();
                if ((buildFile = buildFile.clone()).getSCMLocation() != null && !buildFile.getSCMLocation().isEmpty()) {
                    tempInputsList.add(buildFile);
                    continue;
                }
                String path = buildFile.getBuildPath();
                String file = buildFile.getBuildFile();
                String newFile = null;
                int fileIndex = path.indexOf(file);
                if (fileIndex > 1) {
                    int colonIndex = path.indexOf(":");
                    if (colonIndex > 0) {
                        String[] parts = path.split(":");
                        StringBuilder pathBuilder = new StringBuilder();
                        int i = 0;
                        while (i < parts.length) {
                            String part = parts[i];
                            int tempFileIndex = part.indexOf(file);
                            if (tempFileIndex > 0) {
                                if (newFile == null || newFile.isEmpty()) {
                                    newFile = "*LIBL/" + part.substring(tempFileIndex);
                                }
                                pathBuilder.append(part.substring(0, tempFileIndex - 1));
                                if (i < parts.length - 1) {
                                    pathBuilder.append(":");
                                }
                            }
                            ++i;
                        }
                        if (newFile != null) {
                            buildFile.setBuildFile(newFile);
                            buildFile.setBuildPath(pathBuilder.toString());
                        }
                    } else {
                        buildFile.setBuildFile(path.substring(fileIndex));
                        buildFile.setBuildPath(path.substring(0, fileIndex - 1));
                    }
                }
                this.fUnResovledInputsList.add(buildFile);
            }
            List<IBuildFile> realInputsList = BuildReportUtil.createDependencySetFromInputs(SCMPlatform.getWorkspaceManager((ITeamRepository)this.fTeamRepository), this.fTeamRepository, this.fUuidStateIDVersionIDMap, this.fComponentUUIDNameMap, tempInputsList, false);
            LinkedHashMap<String, ResolvedInputRootNode> treeNodeMpas = new LinkedHashMap<String, ResolvedInputRootNode>();
            for (IBuildFile buildFile : realInputsList) {
                String projectName = buildFile.getProjectName();
                String componentName = buildFile.getComponentName();
                String rootKey = String.valueOf(projectName) + "(" + componentName + ")";
                ResolvedInputRootNode rootNode = (ResolvedInputRootNode)treeNodeMpas.get(rootKey);
                if (rootNode == null) {
                    rootNode = new ResolvedInputRootNode(projectName, componentName, null);
                    treeNodeMpas.put(rootKey, rootNode);
                }
                if (rootNode == null) continue;
                List<ResolvedInputNode> children = rootNode.getChildren();
                if (children == null) {
                    children = new ArrayList<ResolvedInputNode>();
                    rootNode.setChildren(children);
                }
                children.add(new ResolvedInputNode(rootNode, buildFile, this.fIsOnZos));
            }
            if (treeNodeMpas.size() > 0) {
                Collection treeNodes = treeNodeMpas.values();
                this.fInputsList = treeNodes.toArray(new ResolvedInputRootNode[treeNodes.size()]);
            } else {
                this.fInputsList = new ResolvedInputRootNode[0];
            }
        }
        if (this.fParserOutputsList == null) {
            this.fParserOutputsList = new ArrayList<IBuildFile>();
        } else {
            this.fParserOutputsList.clear();
        }
        Object parserOutputs = this.fBuildMap.getParserOutputs();
        if (parserOutputs != null && parserOutputs instanceof Set) {
            Set parserOutputsSet = (Set)parserOutputs;
            for (IBuildFile parserFile : parserOutputsSet) {
                this.fParserOutputsList.add(parserFile);
            }
        }
        if (this.fParserOutputsList.size() > 0 && this.fUnresolvedStyledLabelProvider != null) {
            this.fUnresolvedStyledLabelProvider.setGeneratedSources(this.fParserOutputsList);
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (BuildMapInputsPage.this.fBuildMap != null && prefix != null) {
                    BuildMapInputsPage.this.fResourcePrefixText.setText(prefix);
                    BuildMapInputsPage.this.fResolvedLabelProvider.setResourcePrefix(prefix);
                    BuildMapInputsPage.this.fResourcePrefixText.getParent().layout();
                }
                BuildMapInputsPage.this.fResolvedInputsTreeView.setInput((Object)BuildMapInputsPage.this.fInputsList);
                BuildMapInputsPage.this.fResolvedInputsTree.redraw();
                BuildMapInputsPage.this.fResolvedInputsTreeView.expandAll();
                if (BuildMapInputsPage.this.fUnResovledInputsList != null && BuildMapInputsPage.this.fUnResovledInputsList.size() > 0) {
                    BuildMapInputsPage.this.fUnresolvedPageBook.showPage((Control)BuildMapInputsPage.this.fUnresovledInputComposite);
                    BuildMapInputsPage.this.fUnresolvedInputsTableView.setInput((Object)BuildMapInputsPage.this.fUnResovledInputsList);
                    BuildMapInputsPage.this.fUnresolvedInputsTable.getParent().layout();
                } else {
                    BuildMapInputsPage.this.fUnresolvedPageBook.showPage((Control)BuildMapInputsPage.this.fNoUnresolvedInputsComposite);
                }
                BuildMapInputsPage.this.refreshParserOutputTreeView(false);
            }
        });
    }

    private void refreshParserOutputTreeView(boolean isDetails) {
        com.ibm.team.enterprise.internal.build.ui.parserOutputs.Tree tree = null;
        if (isDetails) {
            tree = this.fParserOutputQuery.getTree();
        } else {
            tree = new com.ibm.team.enterprise.internal.build.ui.parserOutputs.Tree();
            this.retrieveParserOutputRoots(tree);
        }
        if (tree != null && tree.hasChildren()) {
            this.fParserOutputPageBook.showPage((Control)this.fParserOutputsTableComposite);
            if (this.fRetrieveDetails != null && !this.fRetrieveDetails.isDisposed()) {
                this.fRetrieveDetails.setEnabled(true);
            }
            this.fParserOutputsTreeView.setInput((Object)tree);
            this.fParserOutputsTree.redraw();
            this.fParserOutputsTree.getParent().layout();
        } else {
            this.fParserOutputPageBook.showPage((Control)this.fNoParserOutputTableComposite);
            if (this.fRetrieveDetails != null && !this.fRetrieveDetails.isDisposed()) {
                this.fRetrieveDetails.setEnabled(true);
            }
        }
    }

    private void retrieveParserOutputRoots(com.ibm.team.enterprise.internal.build.ui.parserOutputs.Tree tree) {
        if (this.fParserOutputsList != null && this.fParserOutputsList.size() > 0) {
            for (IBuildFile fParserOutput : this.fParserOutputsList) {
                String sourceFullPath = BuildReportUtil.generateBuildFileFullPath((IBuildFile)fParserOutput);
                ParserOutputData data = new ParserOutputData(sourceFullPath, fParserOutput.getType(), new Timestamp(fParserOutput.getTimestamp()));
                ParserOutputNode node = new ParserOutputNode(data);
                tree.addToRoot(node);
            }
        }
    }

    @Override
    public void refreshContent() {
        this.fBuildMap = null;
        this.fProjectAreaHandle = null;
        this.fLangDef = null;
        this.fLangDefLatest = true;
        this.fSourceFile = null;
    }
}

