/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.buildmap;

import com.ibm.team.enterprise.common.client.util.URIUtilities;
import com.ibm.team.enterprise.common.ui.EnterpriseHyperlinkHandler;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildMap;
import com.ibm.team.enterprise.internal.buildmap.common.util.BuildMapConversionUtil;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.xml.sax.SAXException;

public class BuildMapEditorInput
implements IEditorInput {
    private URI fBuildMapURI = null;
    private UUID fBuildFileUUID;
    private UUID fBuildDefinitionUUID;
    private ITeamRepository fTeamRepository = null;
    private Map<URI, IBuildMap> fBuildmapMap = null;
    private Map<String, String> fUuidStateIDVersionIDMap = null;
    private Map<String, String> fComponentUUIDNameMap = null;
    private Map<String, ISystemDefinition> fSysDefCache = null;
    private IBuildMap fBuildMap = null;
    private boolean fIsOldBuildMap = false;
    private Map<String, IAuditableHandle> fBuildMapStatesMap = null;

    public BuildMapEditorInput(URI fBuildMapURI, Map<URI, IBuildMap> fBuildmapMap, Map<String, String> fUuidStateIDVersionIDMap, Map<String, String> fComponentUUIDNameMap, Map<String, ISystemDefinition> fSysDefCache, ITeamRepository fTeamRepository) {
        this.fBuildMapURI = fBuildMapURI;
        this.fBuildmapMap = fBuildmapMap;
        this.fUuidStateIDVersionIDMap = fUuidStateIDVersionIDMap;
        this.fComponentUUIDNameMap = fComponentUUIDNameMap == null ? new HashMap() : fComponentUUIDNameMap;
        this.fSysDefCache = fSysDefCache == null ? new HashMap() : fSysDefCache;
        this.fTeamRepository = fTeamRepository;
    }

    public BuildMapEditorInput(UUID buildFileUUID, UUID buildDefinitionUUID, ITeamRepository repository) {
        this.fBuildDefinitionUUID = buildDefinitionUUID;
        this.fBuildFileUUID = buildFileUUID;
        this.fTeamRepository = repository;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (!(obj instanceof BuildMapEditorInput)) {
            return result;
        }
        BuildMapEditorInput newInput = (BuildMapEditorInput)obj;
        URI newBuildMapURI = newInput.getBuildMapURI();
        if (newBuildMapURI == null && newBuildMapURI == null || newBuildMapURI != null && newBuildMapURI.equals(this.fBuildMapURI)) {
            result = true;
        }
        return result;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return "";
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "";
    }

    public URI getBuildMapURI() {
        return this.fBuildMapURI;
    }

    public Map<URI, IBuildMap> getBuildMapMap() {
        return this.fBuildmapMap;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public Map<String, String> getUUIDStateIDVersionIDMap() {
        return this.fUuidStateIDVersionIDMap;
    }

    public Map<String, String> getComponentUUIDNameMap() {
        return this.fComponentUUIDNameMap;
    }

    public Map<String, ISystemDefinition> getSysDefCache() {
        return this.fSysDefCache;
    }

    public boolean isOldBuildMap() {
        return this.fIsOldBuildMap;
    }

    public IBuildMap fetchBuildMap(IProgressMonitor monitor) throws TeamRepositoryException, SAXException, IOException, ParserConfigurationException {
        this.fBuildMap = null;
        if (this.fBuildMapURI != null && this.fTeamRepository != null) {
            if (this.fBuildmapMap == null) {
                this.fBuildmapMap = new HashMap<URI, IBuildMap>();
            }
            this.fBuildMap = this.fBuildmapMap.get(this.fBuildMapURI);
            if (this.fBuildMap == null) {
                if (!this.fTeamRepository.loggedIn()) {
                    this.fTeamRepository.login(monitor);
                }
                this.fBuildMap = BuildReportUtil.getBuildMap(this.fTeamRepository, this.fBuildMapURI);
                if (this.fBuildMap != null && this.fBuildmapMap != null) {
                    this.fBuildmapMap.put(this.fBuildMapURI, this.fBuildMap);
                }
            }
            if (this.fBuildMap != null) {
                this.fIsOldBuildMap = BuildReportUtil.isOldBuildMap(this.fBuildMap, this.fBuildMapURI, this.fTeamRepository);
            }
        } else if (this.fBuildDefinitionUUID != null && this.fBuildFileUUID != null && this.fTeamRepository != null) {
            if (this.fBuildmapMap == null) {
                this.fBuildmapMap = new HashMap<URI, IBuildMap>();
            }
            this.fBuildMap = BuildReportUtil.getBuildMap(this.fTeamRepository, this.fBuildDefinitionUUID, this.fBuildFileUUID);
            if (this.fBuildMap != null && this.fBuildmapMap != null) {
                this.fIsOldBuildMap = BuildReportUtil.isOldBuildMap(this.fBuildMap, this.fBuildMapURI, this.fTeamRepository);
                EnterpriseHyperlinkHandler hyperlinkHandler = new EnterpriseHyperlinkHandler();
                com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap newBuildMap = BuildMapConversionUtil.convert((IBuildMap)this.fBuildMap);
                if (newBuildMap instanceof IItem) {
                    this.fBuildMapURI = URIUtilities.createItemURI((ITeamRepository)this.fTeamRepository, (IItem)newBuildMap);
                    this.fBuildMap.setUri(this.fBuildMapURI.toString());
                    this.fBuildmapMap.put(this.fBuildMapURI, this.fBuildMap);
                }
            }
        }
        return this.fBuildMap;
    }

    public IBuildMap getBuildMap() {
        return this.fBuildMap;
    }

    public Map<String, IAuditableHandle> getfBuildMapStates() {
        return this.fBuildMapStatesMap;
    }

    public URI getfBuildMapURI() {
        return this.fBuildMapURI;
    }

    public void setfBuildMapURI(URI fBuildMapURI) {
        this.fBuildMapURI = fBuildMapURI;
        this.fBuildMapStatesMap = null;
    }
}

