/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.buildmap;

import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.editors.buildmap.AbstractBuildMapFormPage;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapDetailsPage;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapEditorInput;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapInputsPage;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapLogsPage;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapOutputsPage;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapOverviewPage;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.buildmap.common.IBuild;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildMap;
import com.ibm.team.enterprise.internal.buildmap.common.IInput;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.ui.editor.TeamFormEditor;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BuildMapEditor
extends TeamFormEditor {
    private IBuildMap fBuildMap = null;
    private IBuildFile fSourceFile = null;
    private ITeamRepository fTeamRepository = null;
    private IProjectAreaHandle fProjectAreaHandle = null;
    private ILanguageDefinition fLangDef = null;
    private boolean fLangDefLatest = true;
    private Form fHeaderForm = null;
    private URI fBuildMapURI = null;
    private boolean fIsOldBuildMap = false;
    private Map<URI, IBuildMap> fBuildmapMap = null;
    private Map<String, String> fUuidStateIDVersionIDMap = null;
    private Map<String, String> fComponentUUIDNameMap = null;
    private Map<String, ISystemDefinition> fSysDefCache = null;

    protected void addPages() {
        BuildMapOverviewPage overviewPage = new BuildMapOverviewPage((FormEditor)this, "com.ibm.team.enterprise.build.ui.editors.buildMapEditor.overview", Messages.BuildMapEditor_OVERVIEW_TAB);
        try {
            this.addPage((IFormPage)overviewPage);
        }
        catch (PartInitException e) {
            Activator.getDefault().logError(e);
        }
    }

    public void doSaveAs() {
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.fHeaderForm = headerForm.getForm().getForm();
        FormToolkit toolkit = headerForm.getToolkit();
        toolkit.decorateFormHeading(this.fHeaderForm);
        IToolBarManager toolbarManager = headerForm.getForm().getToolBarManager();
        this.addRefreshAction(toolbarManager);
        this.fHeaderForm.updateToolBar();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        if (input != null && input instanceof BuildMapEditorInput) {
            BuildMapEditorInput fBuildMapInput = (BuildMapEditorInput)input;
            this.fBuildMapURI = fBuildMapInput.getBuildMapURI();
            this.fBuildmapMap = fBuildMapInput.getBuildMapMap();
            this.fTeamRepository = fBuildMapInput.getTeamRepository();
            this.fUuidStateIDVersionIDMap = fBuildMapInput.getUUIDStateIDVersionIDMap();
            this.fComponentUUIDNameMap = fBuildMapInput.getComponentUUIDNameMap();
            this.fSysDefCache = fBuildMapInput.getSysDefCache();
            this.fIsOldBuildMap = fBuildMapInput.isOldBuildMap();
            this.initializeBuildMap(this.fBuildMapURI, this.fBuildmapMap, -1);
        }
    }

    private void initializeBuildMap(final URI fBuildMapURI2, final Map<URI, IBuildMap> fBuildmapMap2, final int activePageIndex) {
        if (this.fTeamRepository == null || this.fBuildMapURI == null) {
            return;
        }
        TeamBuildJob job = new TeamBuildJob(Messages.BuildMapEditor_RETRIEVE_BUILDMAP_JOB_TITLE, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                BuildMapEditor.this.fBuildMap = null;
                if (fBuildmapMap2 != null) {
                    BuildMapEditor.this.fBuildMap = (IBuildMap)fBuildmapMap2.get(fBuildMapURI2);
                }
                if (BuildMapEditor.this.fBuildMap == null) {
                    if (!BuildMapEditor.this.fTeamRepository.loggedIn()) {
                        BuildMapEditor.this.fTeamRepository.login(monitor);
                    }
                    BuildMapEditor.this.fBuildMap = BuildReportUtil.getBuildMap(BuildMapEditor.this.fTeamRepository, fBuildMapURI2);
                    if (BuildMapEditor.this.fBuildMap != null && fBuildmapMap2 != null) {
                        fBuildmapMap2.put(fBuildMapURI2, BuildMapEditor.this.fBuildMap);
                    }
                }
                if (BuildMapEditor.this.fBuildMap != null) {
                    BuildMapEditor.this.setSourceFile();
                    try {
                        BuildMapEditor.this.retrieveLangDefAndProjectArea();
                    }
                    catch (TeamRepositoryException e) {
                        Activator.getDefault().logError(e);
                    }
                    if (!BuildMapEditor.this.fIsOldBuildMap) {
                        BuildMapEditor.this.fIsOldBuildMap = BuildReportUtil.isOldBuildMap(BuildMapEditor.this.fBuildMap, fBuildMapURI2, BuildMapEditor.this.fTeamRepository);
                    }
                }
                return null;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (BuildMapEditor.this.fSourceFile != null) {
                            String partName = BuildReportUtil.generateBuildFileFullPath((String)BuildMapEditor.this.fSourceFile.getBuildPath(), (String)(BuildMapEditor.this.fSourceFile.isHFS() ? "" : BuildMapEditor.this.fSourceFile.getBuildFile()), (String)BuildMapEditor.this.fSourceFile.getOutputType(), (String)BuildMapEditor.this.fSourceFile.getSequential(), (boolean)BuildMapEditor.this.fSourceFile.isHFS());
                            if (partName != null && partName.length() > 0) {
                                BuildMapEditor.this.setPartName(partName);
                                String promotionFlag = BuildMapEditor.this.fBuildMap.getSourceBuildMapSlug();
                                if (promotionFlag != null && !promotionFlag.isEmpty()) {
                                    BuildMapEditor.this.fHeaderForm.setText(NLS.bind((String)Messages.BuildMapEditor_NAME, (Object)partName, (Object)Messages.BuildMapEditor_PROMOTION_BUILDLABEL));
                                } else {
                                    BuildMapEditor.this.fHeaderForm.setText(NLS.bind((String)Messages.BuildMapEditor_NAME, (Object)partName, (Object)BuildMapEditor.this.fBuildMap.getBuildLabel()));
                                }
                            } else {
                                BuildMapEditor.this.fHeaderForm.setText(Messages.BuildMapEditor_NAME_NOBUILDMAP);
                            }
                        }
                        BuildMapEditor.this.addOtherPages();
                        int count = -1;
                        if (BuildMapEditor.this.pages != null) {
                            count = BuildMapEditor.this.pages.size();
                        }
                        int realActivePageIndex = 0;
                        if (activePageIndex > -1) {
                            realActivePageIndex = activePageIndex;
                        }
                        BuildMapEditor.this.setActivePage(realActivePageIndex);
                        int i = 0;
                        while (i < count) {
                            Object page = BuildMapEditor.this.pages.get(i);
                            if (page instanceof AbstractBuildMapFormPage) {
                                AbstractBuildMapFormPage formPage = (AbstractBuildMapFormPage)((Object)page);
                                formPage.setBuildMap(BuildMapEditor.this.fBuildMap);
                                formPage.setSourceFile(BuildMapEditor.this.fSourceFile);
                                formPage.setLangDefAndProjectArea(BuildMapEditor.this.fProjectAreaHandle, BuildMapEditor.this.fLangDef, BuildMapEditor.this.fLangDefLatest, BuildMapEditor.this.fIsOldBuildMap);
                                if (i == realActivePageIndex) {
                                    formPage.initializeContent();
                                }
                            }
                            ++i;
                        }
                    }
                });
            }
        };
        job.schedule();
    }

    private void setSourceFile() {
        Set inputs;
        if (this.fBuildMap != null && (inputs = this.fBuildMap.getInputs()) != null) {
            for (IInput input : inputs) {
                IBuildFile buildFile = (IBuildFile)input.getArtifact();
                if (!"SELF".equals(buildFile.getType())) continue;
                this.fSourceFile = buildFile;
                break;
            }
        }
    }

    private void addOtherPages() {
        if (this.fBuildMap != null) {
            Set logs;
            Set outputs;
            Set inputs = this.fBuildMap.getInputs();
            if (inputs != null && inputs.size() > 0) {
                BuildMapInputsPage inputPage = new BuildMapInputsPage((FormEditor)this, "com.ibm.team.enterprise.build.ui.editors.buildMapEditor.inputs", Messages.BuildMapEditor_INPUTS_TAB);
                try {
                    this.addPage((IFormPage)inputPage);
                }
                catch (PartInitException e) {
                    Activator.getDefault().logError(e);
                }
            }
            if ((outputs = this.fBuildMap.getOutputs()) != null && outputs.size() > 0) {
                BuildMapOutputsPage outputPage = new BuildMapOutputsPage((FormEditor)this, "com.ibm.team.enterprise.build.ui.editors.buildMapEditor.outputs", Messages.BuildMapEditor_OUTPUTS_TAB);
                try {
                    this.addPage((IFormPage)outputPage);
                }
                catch (PartInitException e) {
                    Activator.getDefault().logError(e);
                }
            }
            if ((logs = this.fBuildMap.getLogs()) != null && logs.size() > 0) {
                BuildMapLogsPage outputPage = new BuildMapLogsPage((FormEditor)this, "com.ibm.team.enterprise.build.ui.editors.buildMapEditor.logs", Messages.BuildMapEditor_LOGS_TAB);
                try {
                    this.addPage((IFormPage)outputPage);
                }
                catch (PartInitException e) {
                    Activator.getDefault().logError(e);
                }
            }
            BuildMapDetailsPage detailsPage = new BuildMapDetailsPage((FormEditor)this, "com.ibm.team.enterprise.build.ui.editors.buildMapEditor.details", Messages.BuildMapEditor_DETAILS_TAB);
            try {
                this.addPage((IFormPage)detailsPage);
            }
            catch (PartInitException e) {
                Activator.getDefault().logError(e);
            }
        }
    }

    private void retrieveLangDefAndProjectArea() throws TeamRepositoryException {
        ISystemDefinitionModelClient client;
        String langDefStateID;
        IBuild tempBuild = this.fBuildMap.getBuild();
        String langDefUUID = tempBuild != null ? tempBuild.getLanguageDefinitionUuid() : null;
        String string = langDefStateID = tempBuild != null ? tempBuild.getLanguageDefinitionStateId() : null;
        if ((this.fLangDef == null || this.fLangDef != null && (this.fLangDef.getItemId().getUuidValue() != null && !this.fLangDef.getItemId().getUuidValue().equals(langDefUUID) || this.fLangDef.getStateId() != null && !this.fLangDef.getStateId().equals((Object)langDefStateID))) && (client = (ISystemDefinitionModelClient)this.fTeamRepository.getClientLibrary(ISystemDefinitionModelClient.class)) != null && !"".equals(langDefUUID)) {
            ISystemDefinition latestSysDef = client.findSystemDefinition(langDefUUID, null, ILanguageDefinition.ITEM_TYPE, null);
            if (latestSysDef != null && !latestSysDef.getStateId().equals((Object)UUID.valueOf((String)langDefStateID))) {
                this.fLangDefLatest = false;
            }
            this.fLangDef = (ILanguageDefinition)BuildReportUtil.getSystemDefinition(langDefUUID, langDefStateID, "languagedefinition", this.fSysDefCache, this.fTeamRepository, null);
        }
        String projectUUID = null;
        if (this.fLangDef != null) {
            projectUUID = this.fLangDef.getProjectArea().getItemId().getUuidValue();
            if (this.fProjectAreaHandle == null || this.fProjectAreaHandle != null && !this.fProjectAreaHandle.getItemId().getUuidValue().equals(projectUUID)) {
                IProjectAreaHandle tempHandle = (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)projectUUID), null);
                this.fProjectAreaHandle = (IProjectAreaHandle)this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)tempHandle, 0, null);
            }
        }
    }

    private Action addRefreshAction(IToolBarManager toolBarManager) {
        Action action = new Action(){

            public void run() {
                if (BuildMapEditor.this.fBuildMapURI != null && BuildMapEditor.this.fBuildmapMap != null) {
                    BuildMapEditor.this.fBuildmapMap.remove(BuildMapEditor.this.fBuildMapURI);
                }
                int activePageIndex = BuildMapEditor.this.getActivePage();
                int count = -1;
                if (BuildMapEditor.this.pages != null) {
                    count = BuildMapEditor.this.pages.size();
                }
                int i = 0;
                while (i < count) {
                    Object page = BuildMapEditor.this.pages.get(i);
                    if (page instanceof AbstractBuildMapFormPage) {
                        AbstractBuildMapFormPage formPage = (AbstractBuildMapFormPage)((Object)page);
                        formPage.refreshContent();
                    }
                    ++i;
                }
                BuildMapEditor.this.removePages();
                BuildMapEditor.this.addPages();
                BuildMapEditor.this.initializeBuildMap(BuildMapEditor.this.fBuildMapURI, BuildMapEditor.this.fBuildmapMap, activePageIndex);
            }
        };
        action.setEnabled(true);
        action.setToolTipText(Messages.BuildableSubsetEditor_ACTION_REFRESH);
        action.setImageDescriptor(Activator.getImageDescriptor("icons/elcl16/refresh.gif"));
        toolBarManager.add((IAction)action);
        return action;
    }

    public IBuildMap getBuildMap() {
        return this.fBuildMap;
    }

    public boolean isOldBuildMap() {
        return this.fIsOldBuildMap;
    }

    public Map<URI, IBuildMap> getBuildMapMap() {
        return this.fBuildmapMap;
    }

    public ITeamRepository getTeamRepository() {
        return this.fTeamRepository;
    }

    public Map<String, String> getUUIDStateIDVersionIDMap() {
        return this.fUuidStateIDVersionIDMap;
    }

    public Map<String, String> getComponentUUIDNameMap() {
        return this.fComponentUUIDNameMap;
    }

    public Map<String, ISystemDefinition> getSysDefCache() {
        return this.fSysDefCache;
    }

    public void removePages() {
        super.removePages();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }
}

