/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors.buildmap;

import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapEditor;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapEditorInput;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildReportUtil;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildFile;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildMap;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.ui.editor.TeamFormPage;
import java.net.URI;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractBuildMapFormPage
extends TeamFormPage {
    protected ITeamRepository fTeamRepository = null;
    protected Map<String, String> fUuidStateIDVersionIDMap = null;
    protected Map<String, String> fComponentUUIDNameMap = null;
    protected Map<URI, IBuildMap> fBuildmapMap = null;
    protected Map<String, ISystemDefinition> fSysDefCache = null;
    protected FormToolkit fFormToolkit = null;
    protected URI fBuildMapURI = null;
    protected IBuildMap fBuildMap = null;
    protected Composite fDefaultControl = null;
    protected Composite fNoBuildMapControl = null;
    protected Label fNoBuildMapLink = null;
    protected IProjectAreaHandle fProjectAreaHandle = null;
    protected ILanguageDefinition fLangDef = null;
    protected boolean fLangDefLatest = true;
    protected IBuildFile fSourceFile = null;
    protected boolean fIsOnZos = true;
    protected boolean fIsOldBuildMap = false;

    public AbstractBuildMapFormPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        BuildMapEditor editor = (BuildMapEditor)this.getEditor();
        if (input != null && input instanceof BuildMapEditorInput) {
            this.fBuildMapURI = ((BuildMapEditorInput)input).getBuildMapURI();
        }
        this.fTeamRepository = editor.getTeamRepository();
        this.fUuidStateIDVersionIDMap = editor.getUUIDStateIDVersionIDMap();
        this.fComponentUUIDNameMap = editor.getComponentUUIDNameMap();
        this.fBuildmapMap = editor.getBuildMapMap();
        this.fSysDefCache = editor.getSysDefCache();
    }

    public void setBuildMap(IBuildMap fBuildMap) {
        this.fBuildMap = fBuildMap;
    }

    public void setLangDefAndProjectArea(IProjectAreaHandle fProjectAreaHandle, ILanguageDefinition fLangDef, boolean fLangDefLatest, boolean fIsOldBuildMap) {
        this.fProjectAreaHandle = fProjectAreaHandle;
        this.fLangDef = fLangDef;
        this.fLangDefLatest = fLangDefLatest;
        this.fIsOnZos = BuildReportUtil.isOnZos((ISystemDefinition)fLangDef);
        this.fIsOldBuildMap = fIsOldBuildMap;
    }

    public void setSourceFile(IBuildFile fSourceFile) {
        this.fSourceFile = fSourceFile;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.fFormToolkit = managedForm.getToolkit();
        this.fFormToolkit.setBorderStyle(2048);
        Composite body = managedForm.getForm().getBody();
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(body);
        Composite container = this.fFormToolkit.createComposite(body);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().applyTo(container);
        this.createContainerContent(container);
        managedForm.reflow(true);
    }

    protected void createNoBuildMapControl(Composite parentCom) {
        this.fNoBuildMapControl = this.fFormToolkit.createComposite(parentCom);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(this.fNoBuildMapControl);
        this.fNoBuildMapLink = this.fFormToolkit.createLabel(this.fNoBuildMapControl, "");
    }

    protected Section createSection(Composite parent, String title, String description, int style, boolean grabH, boolean grabV) {
        Section result = null;
        if (parent != null) {
            int origStyle = 256;
            origStyle |= style;
            boolean isDescription = false;
            if (description != null && description.length() > 0) {
                origStyle |= 0x80;
                isDescription = true;
            }
            result = this.fFormToolkit.createSection(parent, origStyle);
            result.setText(title);
            if (isDescription) {
                result.setDescription(description);
            }
            GridDataFactory.fillDefaults().grab(grabH, grabV).applyTo((Control)result);
        }
        return result;
    }

    protected abstract void createContainerContent(Composite var1);

    public abstract void initializeContent();

    public abstract void refreshContent();
}

