/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.build.ui.editors.IResourcePrefixValidator;
import com.ibm.team.enterprise.ibmi.build.ui.editors.LibraryPrefixValidator;
import com.ibm.team.enterprise.zos.build.ui.editors.DataSetPrefixValidator;

public class UtilFactory {
    private IResourcePrefixValidator libraryPrefixValidator;
    private IResourcePrefixValidator datasetPrefixValidator;
    private static UtilFactory instance;

    public static UtilFactory getInstance() {
        if (instance == null) {
            instance = new UtilFactory();
        }
        return instance;
    }

    public IResourcePrefixValidator getResourcePrefixValidator(IBuildDefinition buildDefinition) {
        if (buildDefinition == null) {
            return null;
        }
        if (IBuildUtility.isIBMiDependencyBuild((IBuildDefinition)buildDefinition)) {
            if (this.libraryPrefixValidator == null) {
                this.libraryPrefixValidator = new LibraryPrefixValidator();
            }
            return this.libraryPrefixValidator;
        }
        if (IBuildUtility.isZOSDependencyBuild((IBuildDefinition)buildDefinition)) {
            if (this.datasetPrefixValidator == null) {
                this.datasetPrefixValidator = new DataSetPrefixValidator();
            }
            return this.datasetPrefixValidator;
        }
        return null;
    }
}

