/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors;

import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.streams.InputStreamStorage;
import com.ibm.team.internal.repository.rcp.streams.ByteArrayInputStreamProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.DisposableInputStreamProvider;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import com.ibm.team.scm.common.VersionedContentDeleted;
import com.ibm.team.scm.common.internal.util.StateId;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;

public class RemoteFileEditorInput
implements IStorageEditorInput {
    private InputStreamStorage storage;
    private FileState fileState;
    private IInputStreamProvider cachedInputStream;
    private String scmLocation;

    public static RemoteFileEditorInput createInput(ITeamRepository repository, StateId<? extends IVersionable> item, String scmLocation, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            DisposableInputStreamProvider buffer;
            String encoding;
            FileState fileState;
            block23: {
                IVersionable fetchedItem = (IVersionable)RepoFetcher.fetchItem((ITeamRepository)repository, item, (IProgressMonitor)progress.newChild(30));
                if (!(fetchedItem instanceof ISymbolicLink) && !(fetchedItem instanceof IFileItem)) {
                    throw new IllegalArgumentException("Cannot create input for item other than file or symbolic link");
                }
                fileState = ClientFileStateFactory.create((ITeamRepository)repository, (IItemType)fetchedItem.getItemType(), (IVersionable)fetchedItem);
                IInputStreamProvider provider = fileState.getContents();
                encoding = fileState.getCharacterEncoding();
                InputStream in = provider.getInputStream((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progress, 30));
                try {
                    try {
                        buffer = TemporaryOutputStream.createLocalBuffer((InputStream)in, (String)fileState.getPath().getFileExtension(), (boolean)false, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progress, 40));
                    }
                    catch (IOException e) {
                        if (!(e.getCause() instanceof VersionedContentDeleted)) {
                            throw e;
                        }
                        String msg = Messages.RemoteFileEditorInput_CONTENT_DELETED;
                        byte[] bytes = null;
                        if (encoding != "") {
                            try {
                                Charset c = Charset.forName(encoding);
                                if (c.canEncode()) {
                                    CharsetEncoder ce = c.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                                    ByteBuffer result = ce.encode(CharBuffer.wrap(msg));
                                    bytes = new byte[result.limit()];
                                    result.get(bytes);
                                }
                            }
                            catch (UnsupportedCharsetException unsupportedCharsetException) {
                            }
                            catch (IllegalCharsetNameException illegalCharsetNameException) {
                            }
                            catch (MalformedInputException malformedInputException) {
                            }
                            catch (UnmappableCharacterException unmappableCharacterException) {
                                // empty catch block
                            }
                        }
                        if (bytes == null) {
                            encoding = "UTF-8";
                            bytes = msg.getBytes(encoding);
                        }
                        buffer = new ByteArrayInputStreamProvider(bytes);
                        in.close();
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    in.close();
                    throw throwable;
                }
                in.close();
            }
            RemoteFileEditorInput remoteFileEditorInput = new RemoteFileEditorInput(fileState, (IInputStreamProvider)buffer, encoding, scmLocation);
            return remoteFileEditorInput;
        }
        catch (IOException e) {
            if (e.getCause() instanceof VersionablePermissionDeniedException) {
                VersionablePermissionDeniedException cause = (VersionablePermissionDeniedException)e.getCause();
                if (cause.getLocalizedMessage() != null) {
                    throw new TeamRepositoryException(cause.getLocalizedMessage(), (Throwable)cause);
                }
                throw new TeamRepositoryException((Throwable)cause);
            }
            throw new TeamRepositoryException(Messages.RemoteFileEditorInput_UNABLE_FETCH_REMOTE_CONTENT, (Throwable)e);
        }
        finally {
            progress.done();
        }
    }

    private RemoteFileEditorInput(FileState fileState, IInputStreamProvider cachedInputStream, String encoding, String scmLocation) {
        Assert.isNotNull((Object)fileState);
        this.fileState = fileState;
        this.cachedInputStream = cachedInputStream;
        this.storage = new InputStreamStorage(cachedInputStream, encoding, fileState.getPath().getName());
        this.scmLocation = scmLocation;
    }

    public RemoteFileEditorInput asPathEditorInput(IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        DisposableInputStreamProvider diskBuffer = TemporaryOutputStream.createLocalBuffer((InputStream)this.cachedInputStream.getInputStream((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progress, 50)), (String)this.fileState.getPath().getFileExtension(), (boolean)true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)progress, 50));
        this.dispose(this.cachedInputStream);
        return new RemoteFileEditorInput(this.fileState, (IInputStreamProvider)diskBuffer, this.storage.getCharset(), this.scmLocation);
    }

    private void dispose(IInputStreamProvider provider) {
        if (provider instanceof DisposableInputStreamProvider) {
            DisposableInputStreamProvider disp = (DisposableInputStreamProvider)provider;
            try {
                disp.dispose();
            }
            catch (IOException e) {
                Activator.getDefault().logError(e);
            }
        }
    }

    public final boolean exists() {
        return false;
    }

    public final ImageDescriptor getImageDescriptor() {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
    }

    public String getName() {
        return this.fileState.getPath().getName();
    }

    public final IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.scmLocation == null || this.scmLocation.trim().isEmpty() ? this.fileState.getPath().getName() : this.scmLocation;
    }

    public final Object getAdapter(Class arg0) {
        return null;
    }

    public final IStorage getStorage() throws CoreException {
        return this.storage;
    }
}

