/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class OutputPublishingConfigurationEditor
extends AbstractConfigurationElementEditor {
    private IBuildDefinition fBuildDefinitionWorkingCopy;
    protected Button fShouldPublishButton;
    protected Button fShouldPublishForErrorOnlyButton;
    protected Button fPublishLogsAsZipFilesButton;

    public OutputPublishingConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        parent.setLayout((Layout)new TableWrapLayout());
        Section section = toolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(256, 256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(Messages.JobOutputPublishingConfigurationEditor_SECTION_TITLE);
        section.setDescription(Messages.JobOutputPublishingConfigurationEditor_SECTION_DESCRIPTION);
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.fShouldPublishButton = toolkit.createButton(composite, Messages.JobOutputPublishingConfigurationEditor_SHOULDPUBLISH_BUTTON_LABEL, 32);
        this.fShouldPublishButton.setLayoutData((Object)new TableWrapData(2, 32, 1, 1));
        boolean publishOutputs = Boolean.valueOf(this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.publishoutputs").getValue());
        this.fShouldPublishButton.setSelection(publishOutputs);
        this.fShouldPublishButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputPublishingConfigurationEditor.this.validate();
                boolean selected = OutputPublishingConfigurationEditor.this.fShouldPublishButton.getSelection();
                OutputPublishingConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.publishoutputs").setValue(Boolean.toString(selected));
                OutputPublishingConfigurationEditor.this.fShouldPublishForErrorOnlyButton.setEnabled(selected);
                OutputPublishingConfigurationEditor.this.setDirty(true);
            }
        });
        this.fShouldPublishForErrorOnlyButton = toolkit.createButton(composite, Messages.JobOutputPublishingConfigurationEditor_SHOULDPUBLISH_ERROR_ONLY_BUTTON_LABEL, 32);
        this.fShouldPublishForErrorOnlyButton.setLayoutData((Object)new TableWrapData(2, 32, 1, 1));
        IBuildProperty publishOutputsForErrorOnlyProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.publishoutputs.erroronly");
        boolean publishOutputsForErrorOnly = publishOutputsForErrorOnlyProperty == null ? false : Boolean.valueOf(publishOutputsForErrorOnlyProperty.getValue());
        this.fShouldPublishForErrorOnlyButton.setSelection(publishOutputsForErrorOnly);
        this.fShouldPublishForErrorOnlyButton.setEnabled(publishOutputs);
        this.fShouldPublishForErrorOnlyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputPublishingConfigurationEditor.this.validate();
                boolean selected = OutputPublishingConfigurationEditor.this.fShouldPublishForErrorOnlyButton.getSelection();
                OutputPublishingConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.publishoutputs.erroronly").setValue(Boolean.toString(selected));
                OutputPublishingConfigurationEditor.this.setDirty(true);
            }
        });
        this.fPublishLogsAsZipFilesButton = toolkit.createButton(composite, Messages.JobOutputPublishingConfigurationEditor_PUBLISH_SUCCESSFUL_LOGS_AS_ZIPS_LABEL, 32);
        this.fPublishLogsAsZipFilesButton.setLayoutData((Object)new TableWrapData(2, 32, 1, 1));
        IBuildProperty publishSuccessfulLogsAsZipsProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.publishoutputs.successfulLogsAsZips");
        boolean publishSuccessfulLogsAsZips = publishSuccessfulLogsAsZipsProperty == null ? false : Boolean.valueOf(publishSuccessfulLogsAsZipsProperty.getValue());
        this.fPublishLogsAsZipFilesButton.setSelection(publishSuccessfulLogsAsZips);
        this.fPublishLogsAsZipFilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutputPublishingConfigurationEditor.this.validate();
                OutputPublishingConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.publishoutputs.successfulLogsAsZips").setValue(Boolean.toString(OutputPublishingConfigurationEditor.this.fPublishLogsAsZipFilesButton.getSelection()));
                OutputPublishingConfigurationEditor.this.setDirty(true);
            }
        });
        Composite batchComposite = new Composite(composite, 0);
        layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        layout.leftMargin = 0;
        batchComposite.setLayout((Layout)layout);
        TableWrapData data = new TableWrapData(256);
        batchComposite.setLayoutData((Object)data);
        Label nameLabel = new Label(batchComposite, 0);
        nameLabel.setText(Messages.JobOutputPublishingConfigurationEditor_PUBLISH_BATCH_SIZE);
        nameLabel.setLayoutData((Object)new TableWrapData(2, 32));
        final Spinner batchSpinner = new Spinner(batchComposite, 2048);
        batchSpinner.setMinimum(1);
        batchSpinner.setMaximum(Integer.MAX_VALUE);
        String valueStr = this.fBuildDefinitionWorkingCopy.getPropertyValue("team.enterprise.build.publishoutputs.batchsize", String.valueOf(10));
        int value = 0;
        value = valueStr != null && valueStr.length() > 0 ? Integer.valueOf(valueStr) : 10;
        if (value < 1) {
            value = 1;
        }
        batchSpinner.setSelection(value);
        batchSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IBuildProperty property = OutputPublishingConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.publishoutputs.batchsize");
                String spinValue = String.valueOf(batchSpinner.getSelection());
                if (property == null) {
                    OutputPublishingConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.publishoutputs.batchsize", spinValue);
                    property = OutputPublishingConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.publishoutputs.batchsize");
                    if (property != null) {
                        property.setGenericEditAllowed(false);
                    }
                } else {
                    property.setValue(spinValue);
                }
                OutputPublishingConfigurationEditor.this.setDirty(true);
            }
        });
        batchSpinner.setLayoutData((Object)new TableWrapData());
        section.setClient((Control)composite);
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.fBuildDefinitionWorkingCopy = definition;
    }

    public boolean validate() {
        return true;
    }
}

