/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.internal.scm.ComponentLoadRules;
import com.ibm.team.build.internal.scm.LoadComponents;
import com.ibm.team.build.internal.ui.BuildUIPlugin;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.build.common.Messages;
import com.ibm.team.enterprise.build.ui.dialogs.ComponentSelectionDialog;
import com.ibm.team.enterprise.build.ui.editors.ComponentSelectionComposite;
import com.ibm.team.enterprise.build.ui.editors.IResourcePrefixValidator;
import com.ibm.team.enterprise.build.ui.editors.UtilFactory;
import com.ibm.team.enterprise.scd.common.model.IScanConfiguration;
import com.ibm.team.enterprise.scd.internal.client.IScdClient;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.ui.FileSelectionDialog;
import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wizards.newworkspace.NewWorkspaceWizard;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.parts.impl.IPartResult;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.Workspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class FileAgentJazzScmConfigurationEditor
extends AbstractConfigurationElementEditor {
    private FormToolkit toolkit;
    private IBuildDefinition buildDefinitionWorkingCopy;
    protected Hyperlink workspaceTitleHyperlink;
    protected Color enabledHyperlinkForegroundColor;
    protected Color disabledHyperlinkForegroundColor;
    protected Text workspaceNameText;
    protected Button acceptBeforeFetchButton;
    protected Button buildOnlyIfChangesButton;
    protected Button selectWorkspaceButton;
    protected Button createWorkspaceButton;
    protected Button deleteLoadDirectoryButton;
    protected IWorkspace workspace;
    protected IWorkspace stream;
    protected Text fetchDestinationText;
    protected Text datasetPrefixText;
    protected Button fetchWorkspaceBeforeBuildCheckbox;
    protected Button fetchAllCheckbox;
    protected Button logLoading;
    protected Button createFoldersForComponentsCheckbox;
    protected Text excludeComponentsField;
    protected Button excludeComponentsSelectButton;
    protected Button excludeComponentsClearButton;
    protected Text loadRulesField;
    protected Button loadRulesSelectButton;
    protected Button loadRulesClearButton;
    protected ComponentLoadRules fComponentLoadRules;
    protected LoadComponents fLoadComponents;
    private IScdClient scdClient;
    private Composite streamNoScanningWarningHolder;
    private ComponentSelectionComposite alwaysLoadComponentComposite;
    private static final String WORKSPACE_FLOW_WARNING_ID = "workspace.flow.warning";

    public FileAgentJazzScmConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        this.toolkit = toolkit;
        TableWrapLayout layout = new TableWrapLayout();
        layout.verticalSpacing = 15;
        parent.setLayout((Layout)layout);
        this.createWorkspaceNameWidgets(parent);
        this.createLoadOptionsWidgets(parent);
        this.createAcceptOptionsWidgets(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getContextHelpId());
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.buildDefinitionWorkingCopy = definition;
    }

    public boolean validate() {
        boolean isValid = true;
        if (this.workspaceNameText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.workspaceNameText, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_WORKSPACE_REQUIRED, (Control)this.workspaceNameText);
            isValid = false;
        } else {
            this.removeMessage(this.workspaceNameText, (Control)this.workspaceNameText);
        }
        if (this.fetchDestinationText.getText().trim().length() == 0) {
            this.addErrorMessageForRequiredField(this.fetchDestinationText, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_LOAD_DIRECTORY_REQUIRED, (Control)this.fetchDestinationText);
            isValid = false;
        } else {
            this.removeMessage(this.fetchDestinationText, (Control)this.fetchDestinationText);
        }
        IResourcePrefixValidator resourcePrefixValidator = UtilFactory.getInstance().getResourcePrefixValidator(this.buildDefinitionWorkingCopy);
        if (resourcePrefixValidator != null) {
            IStatus status = resourcePrefixValidator.validate(this.datasetPrefixText.getText());
            if (status.getSeverity() == 4) {
                this.addErrorMessageForRequiredField(this.datasetPrefixText, status.getMessage(), (Control)this.datasetPrefixText);
                isValid = false;
            } else if (status.getSeverity() == 2) {
                this.addWarningMessage(this.datasetPrefixText, status.getMessage(), (Control)this.datasetPrefixText);
            } else {
                this.removeMessage(this.datasetPrefixText, (Control)this.datasetPrefixText);
            }
        }
        this.setPageStatusIndicator(!isValid, false);
        return isValid;
    }

    private void createWorkspaceNameWidgets(Composite parent) {
        Section section = this.toolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_SECTION_TEXT_REPOSITORY);
        section.setDescription(com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_REPOSITORY_DESCRIPTION);
        Composite composite = this.toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 5;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.workspaceTitleHyperlink = this.toolkit.createHyperlink(composite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_WORKSPACE_LABEL, 0);
        this.workspaceTitleHyperlink.addHyperlinkListener(this.getWorkspaceHyperlinkListener());
        this.enabledHyperlinkForegroundColor = this.workspaceTitleHyperlink.getForeground();
        this.workspaceTitleHyperlink.setLayoutData((Object)new TableWrapData());
        this.workspaceTitleHyperlink.addHyperlinkListener(this.getWorkspaceHyperlinkListener());
        this.workspaceNameText = this.toolkit.createText(composite, "", 0);
        this.disabledHyperlinkForegroundColor = this.workspaceNameText.getForeground();
        this.addControlDecorator((Control)this.workspaceNameText, NLS.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_BUILD_PROPERTY_DESC, (Object)"team.enterprise.scm.workspaceUUID"), 131072);
        this.workspaceNameText.setEnabled(false);
        this.workspaceNameText.setEditable(false);
        TableWrapData layoutData = new TableWrapData(256, 32);
        this.workspaceNameText.setLayoutData((Object)layoutData);
        this.selectWorkspaceButton = this.toolkit.createButton(composite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_SELECT_WORKSPACE_BUTTON_TITLE, 0);
        this.selectWorkspaceButton.addSelectionListener(this.getSelectWorkspaceListener());
        this.selectWorkspaceButton.setLayoutData((Object)new TableWrapData());
        this.createWorkspaceButton = this.toolkit.createButton(composite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_CREATE_WORKSPACE_BUTTON_TITLE, 0);
        this.createWorkspaceButton.addSelectionListener(this.getCreateWorkspaceListener());
        this.createWorkspaceButton.setLayoutData((Object)new TableWrapData());
        this.streamNoScanningWarningHolder = new Composite(composite, 0){

            public boolean setFocus() {
                boolean yes;
                boolean isFocus = FileAgentJazzScmConfigurationEditor.this.workspaceNameText.setFocus();
                if (isFocus && FileAgentJazzScmConfigurationEditor.this.stream != null && (yes = MessageDialog.openQuestion((Shell)FileAgentJazzScmConfigurationEditor.this.streamNoScanningWarningHolder.getShell(), (String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_SCD_SCANNING_DIALOG_TITLE, (String)NLS.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_SCD_SCANNING_DIALOG_PROMPT, (Object)(FileAgentJazzScmConfigurationEditor.this.stream != null ? FileAgentJazzScmConfigurationEditor.this.stream.getName() : FileAgentJazzScmConfigurationEditor.this.stream))))) {
                    Job job = new Job(NLS.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_SCD_SCANNING_JOB, (Object)(FileAgentJazzScmConfigurationEditor.this.stream != null ? FileAgentJazzScmConfigurationEditor.this.stream.getName() : FileAgentJazzScmConfigurationEditor.this.stream))){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                IScanConfiguration[] scanConfiguration = new IScanConfiguration[1];
                                if ((this).FileAgentJazzScmConfigurationEditor.this.stream != null) {
                                    scanConfiguration[0] = FileAgentJazzScmConfigurationEditor.this.getScdClient().getScanConfiguration((IWorkspaceHandle)(this).FileAgentJazzScmConfigurationEditor.this.stream);
                                    if (scanConfiguration[0] == null) {
                                        FileAgentJazzScmConfigurationEditor.this.getScdClient().createAndSaveDefaultScanConfiguration((this).FileAgentJazzScmConfigurationEditor.this.stream);
                                    }
                                }
                                return Status.OK_STATUS;
                            }
                            catch (TeamRepositoryException e) {
                                return new Status(4, "com.ibm.team.enterprise.build.ui", NLS.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_SCD_SCANNING_ERROR, (Object)((this).FileAgentJazzScmConfigurationEditor.this.stream != null ? (this).FileAgentJazzScmConfigurationEditor.this.stream.getName() : (this).FileAgentJazzScmConfigurationEditor.this.stream)), (Throwable)e);
                            }
                        }
                    };
                    job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            (this).FileAgentJazzScmConfigurationEditor.this.workspaceNameText.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    FileAgentJazzScmConfigurationEditor.this.removeMessage("STREAM_NOT_SCANNED_WARNING_ID", (Control)FileAgentJazzScmConfigurationEditor.this.streamNoScanningWarningHolder);
                                }
                            });
                        }
                    });
                    job.schedule();
                }
                return isFocus;
            }
        };
        TableWrapData tableLayoutData = new TableWrapData();
        tableLayoutData.maxWidth = 0;
        tableLayoutData.maxHeight = 0;
        this.streamNoScanningWarningHolder.setLayoutData((Object)tableLayoutData);
        this.streamNoScanningWarningHolder.setVisible(false);
        IBuildProperty property = this.buildDefinitionWorkingCopy.getProperty("team.enterprise.scm.workspaceUUID");
        if (property.getValue().length() == 0) {
            this.setWorkspaceNameText("", false);
            return;
        }
        this.setWorkspaceNameText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_PENDING, false);
        final IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)property.getValue()), null);
        String jobName = com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_FETCHING_JOB_NAME;
        TeamBuildJob job = new TeamBuildJob(jobName, true, this.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                FileAgentJazzScmConfigurationEditor.this.workspace = FileAgentJazzScmConfigurationEditor.this.fetchWorkspace(workspaceHandle, monitor);
                FileAgentJazzScmConfigurationEditor.this.retrieveTargetStreamFromBuildWorkspace(FileAgentJazzScmConfigurationEditor.this.workspace, monitor);
                FileAgentJazzScmConfigurationEditor.this.handleUpdateWorkspaceText(FileAgentJazzScmConfigurationEditor.this.workspace.getName());
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (status.getSeverity() == 4) {
                    FileAgentJazzScmConfigurationEditor.this.handleFetchFailed(status);
                }
            }
        };
        job.schedule();
    }

    private void createLoadOptionsWidgets(Composite parent) {
        this.createSpacer(parent, 5, 1);
        Section section = this.toolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(128));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(Messages.EnterpriseRequestDialogOption_CATEGORY_LOAD_OPTIONS);
        section.setDescription(com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_SECTION_DESC_LOAD);
        Composite composite = this.toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        IBuildProperty property = this.buildDefinitionWorkingCopy.getProperty("team.enterprise.scm.resourcePrefix");
        String description = IBuildUtility.isIBMiDependencyBuild((IBuildDefinition)this.buildDefinitionWorkingCopy) ? NLS.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_RESOURCE_PREFIX_DESC, (Object)"team.enterprise.scm.resourcePrefix") : NLS.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmconfigurationEditor_DATASET_PREFIX_DESC, (Object)"team.enterprise.scm.resourcePrefix");
        this.datasetPrefixText = this.createLabeledText(composite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_RESOURCE_PREFIX, "", property.getValue());
        this.addControlDecorator((Control)this.datasetPrefixText, description, 131072);
        this.datasetPrefixText.addModifyListener(this.getDatasetPrefixModifiedListener());
        this.fetchAllCheckbox = this.createCheckbox(composite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_FETCH_ALL_LABEL, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_FETCH_ALL_DESC, "team.enterprise.build.ant.fetchAll");
        this.fetchAllCheckbox.addSelectionListener(this.getFetchAllSelectionListener());
        this.alwaysLoadComponentComposite = new ComponentSelectionComposite(composite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_ALWAYS_LOAD_COMPONENT_LABEL, this.getEditorSite(), "com.ibm.team.enterprise.build.common.IFileAgentJazzScmConfigurationElement", "team.enterprise.scm.alwaysLoadComponents", this.buildDefinitionWorkingCopy, (IWorkspaceHandle)this.stream, this.getTeamRepository(), this.toolkit);
        this.alwaysLoadComponentComposite.setComponentSelectionTitle(com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_ALWAYS_LOAD_COMPONENT_SELECTION_DLG_TITLE);
        this.alwaysLoadComponentComposite.setComponentSelectionDesc(com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_ALWAYS_LOAD_COMPONENT_SELECTION_DLG_DESC);
        this.alwaysLoadComponentComposite.setComponentClearConfirmationTitle(com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_CLEAR_LOAD_COMPONENTS_CONFIRM_TITLE);
        this.alwaysLoadComponentComposite.setComponentClearConfirmationDesc(com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_ALWAYS_LOAD_COMPONENT_CLEAR_DLG_DESC);
        TableWrapData layoutData = new TableWrapData(128, 32, 1, 2);
        layoutData.indent = 15;
        this.alwaysLoadComponentComposite.setLayoutData(layoutData);
        this.alwaysLoadComponentComposite.addPropertyListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                FileAgentJazzScmConfigurationEditor.this.setDirty(true);
            }
        });
        this.alwaysLoadComponentComposite.setEnabled(false);
        this.logLoading = this.createCheckbox(composite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_LOG_LOADING_LABEL, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_LOG_LOADING_DESC, "team.enterprise.scm.log.loading");
        this.logLoading.addSelectionListener(this.getLogLoadingSelectionListener());
        this.createSpacer(composite, 5, 2);
        property = this.buildDefinitionWorkingCopy.getProperty("team.enterprise.scm.fetchDestination");
        description = NLS.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfiguartionEditor_LOAD_DIRECTORY_DESC, (Object)"team.enterprise.scm.fetchDestination");
        this.fetchDestinationText = this.createLabeledText(composite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_DESTINATION_LABEL, "", property.getValue());
        this.fetchDestinationText.addModifyListener(this.getFetchDestinationModifiedListener());
        this.addControlDecorator((Control)this.fetchDestinationText, description, 131072);
        boolean shouldDelete = false;
        property = this.buildDefinitionWorkingCopy.getProperty("team.enterprise.scm.deleteDestinationBeforeFetch");
        if (property != null) {
            shouldDelete = Boolean.valueOf(property.getValue());
        }
        this.deleteLoadDirectoryButton = this.toolkit.createButton(composite, Messages.EnterpriseRequestDialogOption_DELETE_LOAD_DIRECTORY, 32);
        this.deleteLoadDirectoryButton.setLayoutData((Object)new TableWrapData(2, 32, 1, 2));
        this.deleteLoadDirectoryButton.setSelection(shouldDelete);
        this.deleteLoadDirectoryButton.addSelectionListener(this.getDeleteBeforeFetchSelectionListener());
        this.deleteLoadDirectoryButton.setEnabled(this.fetchDestinationText.getText().trim().length() > 0);
        this.fetchWorkspaceBeforeBuildCheckbox = this.createCheckbox(composite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_FETCH_WORKSPACE_BEFORE_BUILD_LABEL, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_FETCH_WORKSPACE_BEFORE_BUILD_DESC, "team.enterprise.build.ant.fetchWorkspaceBeforeBuild");
        this.createFoldersForComponentsCheckbox = this.createCheckbox(composite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_CREATE_FOLDERS_FOR_COMPONENT_LABEL, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_CREATE_FOLDERS_FOR_COMPONENT_DESC, "team.enterprise.scm.createFoldersForComponents");
        this.createSpacer(composite, 5, 2);
        this.fetchWorkspaceBeforeBuildCheckbox.setEnabled(false);
        this.createFoldersForComponentsCheckbox.setEnabled(false);
        this.fetchAllCheckbox.setEnabled(false);
        this.logLoading.setEnabled(false);
        this.fetchWorkspaceBeforeBuildCheckbox.addSelectionListener(this.getFetchWorkspaceBeforeBuildSelectionListener());
        this.workspaceNameText.addModifyListener(this.getWorkSpaceNameTextModifiedListener());
        Composite loadRuleBottomComposite = this.toolkit.createComposite(composite);
        TableWrapData loadRuleBottomCompositeLayoutData = new TableWrapData(256, 32);
        loadRuleBottomCompositeLayoutData.indent = 0;
        loadRuleBottomCompositeLayoutData.colspan = 2;
        loadRuleBottomComposite.setLayoutData((Object)loadRuleBottomCompositeLayoutData);
        TableWrapLayout loadRuleBottomCompositeLayout = new TableWrapLayout();
        loadRuleBottomCompositeLayout.numColumns = 4;
        loadRuleBottomCompositeLayout.bottomMargin = 0;
        loadRuleBottomCompositeLayout.leftMargin = 0;
        loadRuleBottomCompositeLayout.rightMargin = 0;
        loadRuleBottomCompositeLayout.topMargin = 0;
        loadRuleBottomComposite.setLayout((Layout)loadRuleBottomCompositeLayout);
        this.createExcludeComponentsSection(loadRuleBottomComposite);
        this.createSpacer(loadRuleBottomComposite, 10, 4);
        this.createLoadRulesSection(loadRuleBottomComposite);
    }

    private void createExcludeComponentsSection(Composite parent) {
        Label label = this.toolkit.createLabel(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_EXCLUDE_COMPONENTS_LABEL);
        TableWrapData layoutData = new TableWrapData();
        layoutData.colspan = 4;
        label.setLayoutData((Object)layoutData);
        label.setForeground(Display.getDefault().getSystemColor(21));
        label = this.toolkit.createLabel(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_EXCLUDE_COMPONENTS_LABEL2);
        label.setLayoutData((Object)new TableWrapData(2, 32));
        String excludeComponents = this.buildDefinitionWorkingCopy.getPropertyValue("team.enterprise.scm.loadComponents", "");
        this.excludeComponentsField = this.toolkit.createText(parent, excludeComponents);
        this.excludeComponentsField.setLayoutData((Object)new TableWrapData(256));
        this.excludeComponentsField.setEnabled(false);
        this.setLoadComponents(new LoadComponents(this.getTeamRepository(), excludeComponents));
        this.excludeComponentsSelectButton = this.toolkit.createButton(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_SELECT_COMPONENT_LOAD_RULES_BUTTON_TITLE, 8);
        this.excludeComponentsSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Collection<IComponentHandle> loadComponents;
                LoadComponents initialSelection = FileAgentJazzScmConfigurationEditor.this.getLoadComponents();
                Collection<Object> initialHandleSelection = initialSelection == null ? Collections.emptyList() : initialSelection.getComponentHandles();
                if (initialHandleSelection != (loadComponents = FileAgentJazzScmConfigurationEditor.this.openLoadComponentsSelector(initialHandleSelection))) {
                    FileAgentJazzScmConfigurationEditor.this.createNewLoadComponents(loadComponents);
                }
            }
        });
        this.excludeComponentsSelectButton.setEnabled(false);
        this.excludeComponentsClearButton = this.toolkit.createButton(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_CLEAR_COMPONENTRULES_BUTTON, 8);
        this.excludeComponentsClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IBuildProperty property;
                if (MessageDialog.openConfirm((Shell)FileAgentJazzScmConfigurationEditor.this.excludeComponentsClearButton.getShell(), (String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_CLEAR_LOAD_COMPONENTS_CONFIRM_TITLE, (String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_CLEAR_LOAD_COMPONENTS_CONFIRM_TEXT) && (property = FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.getProperty("team.enterprise.scm.loadComponents")) != null) {
                    property.setValue("");
                    FileAgentJazzScmConfigurationEditor.this.setLoadComponents(new LoadComponents(Collections.emptyList()));
                    FileAgentJazzScmConfigurationEditor.this.updateLoadComponents();
                    FileAgentJazzScmConfigurationEditor.this.setDirty(true);
                }
            }
        });
        label = this.toolkit.createLabel(parent, NLS.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_EXCLUDE_COMPONENTS_DESC, (Object)"team.enterprise.scm.loadComponents"));
        layoutData = new TableWrapData();
        layoutData.colspan = 4;
        label.setLayoutData((Object)layoutData);
        label.setForeground(Display.getDefault().getSystemColor(16));
        this.updateLoadComponents();
    }

    private void createLoadRulesSection(Composite parent) {
        Label label = this.toolkit.createLabel(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_LOAD_RULES_LABEL);
        TableWrapData layoutData = new TableWrapData();
        layoutData.colspan = 4;
        label.setLayoutData((Object)layoutData);
        label.setForeground(Display.getDefault().getSystemColor(21));
        label = this.toolkit.createLabel(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_LOAD_RULES_LABEL2);
        label.setLayoutData((Object)new TableWrapData(2, 32));
        String loadRules = this.buildDefinitionWorkingCopy.getPropertyValue("team.enterprise.scm.componentLoadRules", "");
        this.loadRulesField = this.toolkit.createText(parent, loadRules);
        this.loadRulesField.setLayoutData((Object)new TableWrapData(128));
        this.loadRulesField.setEnabled(false);
        this.fComponentLoadRules = new ComponentLoadRules(loadRules);
        this.loadRulesSelectButton = this.toolkit.createButton(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_SELECT_COMPONENT_LOAD_RULES_BUTTON_TITLE, 8);
        this.loadRulesSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Map initialSelection = FileAgentJazzScmConfigurationEditor.this.fComponentLoadRules != null ? FileAgentJazzScmConfigurationEditor.this.fComponentLoadRules.getLoadRuleFiles() : Collections.emptyMap();
                Map<IComponentHandle, IFileItemHandle> componentLoadRuleFiles = FileAgentJazzScmConfigurationEditor.this.openComponentLoadRulesSelector(initialSelection);
                FileAgentJazzScmConfigurationEditor.this.setComponentLoadRules(componentLoadRuleFiles);
                FileAgentJazzScmConfigurationEditor.this.setDirty(true);
            }
        });
        this.loadRulesSelectButton.setEnabled(false);
        this.loadRulesClearButton = this.toolkit.createButton(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_CLEAR_COMPONENTRULES_BUTTON, 8);
        this.loadRulesClearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IBuildProperty property;
                if (MessageDialog.openConfirm((Shell)FileAgentJazzScmConfigurationEditor.this.loadRulesClearButton.getShell(), (String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_CLEAR_LOAD_COMPONENTS_CONFIRM_TITLE, (String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_CLEAR_LOAD_RULES_CONFIRM_TEXT) && (property = FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.getProperty("team.enterprise.scm.componentLoadRules")) != null) {
                    property.setValue("");
                    FileAgentJazzScmConfigurationEditor.this.fComponentLoadRules = new ComponentLoadRules("");
                    FileAgentJazzScmConfigurationEditor.this.updateComponentLoadRules(FileAgentJazzScmConfigurationEditor.this.fComponentLoadRules);
                    FileAgentJazzScmConfigurationEditor.this.setDirty(true);
                }
            }
        });
        label = this.toolkit.createLabel(parent, NLS.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_LOAD_RULES_DESC, (Object)"team.enterprise.scm.componentLoadRules"));
        layoutData = new TableWrapData();
        layoutData.colspan = 4;
        label.setLayoutData((Object)layoutData);
        label.setForeground(Display.getDefault().getSystemColor(16));
        this.updateComponentLoadRules(this.fComponentLoadRules);
        this.updateEnablement();
    }

    private void createAcceptOptionsWidgets(Composite parent) {
        this.createSpacer(parent, 15, 1);
        Section section = this.toolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(128));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_SECTION_TEXT_ACCEPT);
        Composite composite = this.toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData());
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        IBuildProperty property = this.buildDefinitionWorkingCopy.getProperty("team.enterprise.scm.acceptBeforeFetch");
        this.acceptBeforeFetchButton = this.createCheckbox(composite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_ACCEPT_DESC, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_BUILD_PROPERTY_DESC, "team.enterprise.scm.acceptBeforeFetch");
        TableWrapData layoutData = new TableWrapData(2, 32, 1, 2);
        this.acceptBeforeFetchButton.setLayoutData((Object)layoutData);
        if (IBuildUtility.isDependencyBuild((IBuildDefinition)this.buildDefinitionWorkingCopy)) {
            this.acceptBeforeFetchButton.setSelection(true);
            this.acceptBeforeFetchButton.setEnabled(false);
        } else {
            this.acceptBeforeFetchButton.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        }
        this.acceptBeforeFetchButton.addSelectionListener(this.getAcceptBeforeFetchSelectionListener());
        property = this.buildDefinitionWorkingCopy.getProperty("team.enterprise.scm.buildOnlyIfChanges");
        this.buildOnlyIfChangesButton = this.createCheckbox(composite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_CHANGES_DESC, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_BUILD_PROPERTY_DESC, "team.enterprise.scm.buildOnlyIfChanges");
        layoutData = new TableWrapData(2, 32, 1, 2);
        this.buildOnlyIfChangesButton.setLayoutData((Object)layoutData);
        this.buildOnlyIfChangesButton.setSelection(Boolean.valueOf(property.getValue()).booleanValue());
        this.buildOnlyIfChangesButton.addSelectionListener(this.getBuildOnlyIfChangesSelectionListener());
        this.buildOnlyIfChangesButton.setEnabled(this.acceptBeforeFetchButton.getSelection());
    }

    protected IHyperlinkListener getWorkspaceHyperlinkListener() {
        return new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                FileAgentJazzScmConfigurationEditor.this.openWorkspaceEditor();
            }
        };
    }

    protected void openWorkspaceEditor() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            TeamPlacePart2.open((IWorkbenchPage)page, (TeamPlaceEditorInput)TeamPlaceEditorInput.newForEdit((AbstractPlaceWrapper)AbstractPlaceWrapper.newWrapper((IWorkspace)this.workspace)));
        }
    }

    protected SelectionListener getSelectWorkspaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileAgentJazzScmConfigurationEditor.this.setWorkspace(FileAgentJazzScmConfigurationEditor.this.openWorkspaceChooserDialog(FileAgentJazzScmConfigurationEditor.this.workspaceTitleHyperlink.getShell(), FileAgentJazzScmConfigurationEditor.this.getTeamRepository()));
            }
        };
    }

    protected IWorkspace openWorkspaceChooserDialog(Shell shell, ITeamRepository teamRepository) {
        AbstractPlaceWrapper wrapper = WorkspaceAndStreamSelectionDialog.getWorkspaceOrStream((Shell)shell, (ITeamRepository)teamRepository, null, null, (WORKSPACES_OR_STREAMS)WORKSPACES_OR_STREAMS.WORKSPACES, (boolean)false, null, null);
        if (wrapper != null) {
            return wrapper.getWorkspace();
        }
        return null;
    }

    protected SelectionListener getCreateWorkspaceListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileAgentJazzScmConfigurationEditor.this.openWorkspaceCreationDialog();
            }
        };
    }

    protected void openWorkspaceCreationDialog() {
        NewWorkspaceWizard wizard = new NewWorkspaceWizard(UIContext.createPartContext((IWorkbenchPart)this), this.getTeamRepository(), false, (IPartResult)new IPartResult<AbstractPlaceWrapper>(){

            public void setResult(AbstractPlaceWrapper result) {
                FileAgentJazzScmConfigurationEditor.this.setWorkspace(result.getWorkspace());
            }
        }, true, (IReadScope)IReadScope.FACTORY.createPublicScope());
        new WizardDialog(this.workspaceTitleHyperlink.getShell(), (IWizard)wizard).open();
    }

    protected void setWorkspace(IWorkspace newWorkspace) {
        if (newWorkspace != null) {
            this.workspace = newWorkspace;
            this.retrieveTargetStreamFromBuildWorkspace(this.workspace, null);
            IBuildProperty property = this.buildDefinitionWorkingCopy.getProperty("team.enterprise.scm.workspaceUUID");
            property.setValue(this.workspace.getItemId().getUuidValue());
            this.setWorkspaceNameText(this.workspace.getName(), true);
            IBuildProperty oldWorkspaceProperty = this.buildDefinitionWorkingCopy.getProperty("teamz.scm.workspaceUUID");
            if (oldWorkspaceProperty != null) {
                oldWorkspaceProperty.setValue(this.workspace.getItemId().getUuidValue());
            }
            this.validate();
            this.setDirty(true);
            if (this.shouldShowWorkspaceFlowWarning()) {
                this.checkWorkspaceFlow();
            }
        }
    }

    private void checkWorkspaceFlow() {
        CurrentFlows flows = null;
        if (this.workspace != null) {
            Workspace ws = (Workspace)this.workspace;
            flows = ws.getCurrentFlows();
        }
        if (flows == null || flows.getCurrentDeliverFlow() == null) {
            this.addErrorMessage(WORKSPACE_FLOW_WARNING_ID, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_WORKSPACE_FLOW_WARNING_SHORT, (IStatus)new Status(2, "com.ibm.team.enterprise.build.ui", com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_WORKSPACE_FLOW_WARNING));
        } else {
            this.removeMessage(WORKSPACE_FLOW_WARNING_ID);
        }
        final IScanConfiguration[] scanConfiguration = new IScanConfiguration[1];
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (FileAgentJazzScmConfigurationEditor.this.stream != null) {
                        scanConfiguration[0] = FileAgentJazzScmConfigurationEditor.this.getScdClient().getScanConfiguration((IWorkspaceHandle)FileAgentJazzScmConfigurationEditor.this.stream);
                    }
                }
                catch (TeamRepositoryException tre) {
                    BuildUIPlugin.log((Throwable)tre);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (scanConfiguration[0] == null) {
            if (this.stream != null) {
                this.addWarningMessage("STREAM_NOT_SCANNED_WARNING_ID", NLS.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_STREAM_NOT_SUPPORT_SCANNING_WARNING, (Object)this.stream.getName()), (Control)this.streamNoScanningWarningHolder);
            } else {
                this.addWarningMessage("STREAM_NOT_SCANNED_WARNING_ID", com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_WORKSPACE_FLOW_WARNING, (Control)this.streamNoScanningWarningHolder);
            }
        } else {
            this.removeMessage("STREAM_NOT_SCANNED_WARNING_ID", (Control)this.streamNoScanningWarningHolder);
        }
    }

    private boolean shouldShowWorkspaceFlowWarning() {
        return IBuildUtility.isDependencyBuild((IBuildDefinition)this.buildDefinitionWorkingCopy);
    }

    protected IWorkspace fetchWorkspace(IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return (IWorkspace)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 0, monitor);
    }

    protected void retrieveTargetStreamFromBuildWorkspace(final IWorkspace workspace, IProgressMonitor monitor) {
        this.stream = null;
        if (workspace == null) {
            return;
        }
        final CurrentFlows cf = ((Workspace)workspace).getCurrentFlows();
        if (cf == null || cf.getDefaultDeliverFlow() == null) {
            return;
        }
        UIUpdaterJob job = new UIUpdaterJob("Retrieve Stream"){

            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    UUID uuid = cf.getDefaultDeliverFlow();
                    IWorkspaceHandle streamHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(uuid, null);
                    FileAgentJazzScmConfigurationEditor.this.stream = (IWorkspace)FileAgentJazzScmConfigurationEditor.this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)streamHandle, 1, monitor);
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    FileAgentJazzScmConfigurationEditor.this.stream = null;
                    String workspaceName = "Unreachable";
                    if (workspace != null) {
                        workspaceName = workspace.getName();
                    }
                    return new Status(4, "com.ibm.team.enterprise.build.ui", NLS.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_RETRIEVE_TARGET_STREAM_ERROR, (Object)workspaceName), (Throwable)e);
                }
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (FileAgentJazzScmConfigurationEditor.this.alwaysLoadComponentComposite != null && !FileAgentJazzScmConfigurationEditor.this.alwaysLoadComponentComposite.isDisposed()) {
                    FileAgentJazzScmConfigurationEditor.this.alwaysLoadComponentComposite.setEnabled(FileAgentJazzScmConfigurationEditor.this.stream != null && FileAgentJazzScmConfigurationEditor.this.fetchAllCheckbox.getSelection());
                    FileAgentJazzScmConfigurationEditor.this.alwaysLoadComponentComposite.setWorkspace((IWorkspaceHandle)FileAgentJazzScmConfigurationEditor.this.stream);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected void handleUpdateWorkspaceText(final String workspaceName) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FileAgentJazzScmConfigurationEditor.this.workspaceNameText.isDisposed()) {
                    FileAgentJazzScmConfigurationEditor.this.setWorkspaceNameText(workspaceName, true);
                }
                if (FileAgentJazzScmConfigurationEditor.this.shouldShowWorkspaceFlowWarning()) {
                    FileAgentJazzScmConfigurationEditor.this.checkWorkspaceFlow();
                }
            }
        });
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.toolkit.createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    private void setWorkspaceNameText(String text, boolean workspaceSet) {
        this.workspaceNameText.setText(text);
        this.workspaceNameText.setEnabled(workspaceSet);
        this.setWorkspaceTitleHyperlinkEnablement(workspaceSet);
    }

    private void setWorkspaceTitleHyperlinkEnablement(boolean enabled) {
        this.workspaceTitleHyperlink.setForeground(enabled ? this.enabledHyperlinkForegroundColor : this.disabledHyperlinkForegroundColor);
        this.workspaceTitleHyperlink.setUnderlined(enabled);
        this.workspaceTitleHyperlink.setEnabled(enabled);
    }

    private Text createLabeledText(Composite parent, String label, String description, String textValue) {
        this.toolkit.createLabel(parent, label);
        Text text = this.toolkit.createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256));
        return text;
    }

    private Button createCheckbox(Composite parent, String label, String description, final String propertyName) {
        final Button button = this.toolkit.createButton(parent, label, 32);
        TableWrapData data = new TableWrapData();
        data.colspan = 2;
        button.setLayoutData((Object)data);
        String tempDescription = description;
        IBuildProperty buildProperty = null;
        if (propertyName != null) {
            buildProperty = this.buildDefinitionWorkingCopy.getProperty(propertyName);
            tempDescription = NLS.bind((String)tempDescription, (Object)propertyName);
        }
        if (buildProperty != null) {
            button.setSelection(Boolean.parseBoolean(buildProperty.getValue()));
        }
        if (propertyName != null) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IBuildProperty buildProperty = FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.getProperty(propertyName);
                    if (buildProperty != null) {
                        buildProperty.setValue(Boolean.toString(button.getSelection()));
                        FileAgentJazzScmConfigurationEditor.this.setDirty(true);
                    }
                }
            });
        }
        this.addControlDecorator((Control)button, tempDescription, 131072);
        return button;
    }

    protected void handleFetchFailed(final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FileAgentJazzScmConfigurationEditor.this.workspaceNameText.isDisposed()) {
                    String errorMessage = com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_ERROR_FETCHING;
                    if (status.getException() instanceof ItemNotFoundException) {
                        errorMessage = com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_WORKSPACE_DELETED;
                    }
                    FileAgentJazzScmConfigurationEditor.this.setWorkspaceNameText(errorMessage, false);
                }
            }
        });
    }

    private ModifyListener getFetchDestinationModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean workEnabled;
                FileAgentJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.getProperty("team.enterprise.scm.fetchDestination");
                String destination = FileAgentJazzScmConfigurationEditor.this.fetchDestinationText.getText().trim();
                property.setValue(destination);
                boolean bl = FileAgentJazzScmConfigurationEditor.this.workspaceNameText != null ? FileAgentJazzScmConfigurationEditor.this.workspaceNameText.getText().trim().length() > 0 : (workEnabled = false);
                if (destination.length() == 0) {
                    FileAgentJazzScmConfigurationEditor.this.deleteLoadDirectoryButton.setSelection(false);
                    FileAgentJazzScmConfigurationEditor.this.deleteLoadDirectoryButton.setEnabled(false);
                    FileAgentJazzScmConfigurationEditor.this.getDeleteBeforeFetchSelectionListener().widgetSelected(null);
                    FileAgentJazzScmConfigurationEditor.this.fetchWorkspaceBeforeBuildCheckbox.setEnabled(false);
                } else {
                    FileAgentJazzScmConfigurationEditor.this.deleteLoadDirectoryButton.setEnabled(true);
                    FileAgentJazzScmConfigurationEditor.this.fetchWorkspaceBeforeBuildCheckbox.setEnabled(workEnabled);
                }
                FileAgentJazzScmConfigurationEditor.this.setLoadExcludeSectionsStatus(workEnabled);
                FileAgentJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getDatasetPrefixModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileAgentJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.getProperty("team.enterprise.scm.resourcePrefix");
                String prefix = FileAgentJazzScmConfigurationEditor.this.datasetPrefixText.getText().trim();
                boolean isIBMi = IBuildUtility.isIBMiDependencyBuild((IBuildDefinition)FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy);
                if (isIBMi && prefix.indexOf(34) < 0) {
                    prefix = prefix.toUpperCase();
                }
                property.setValue(prefix);
                if (prefix.length() == 0) {
                    FileAgentJazzScmConfigurationEditor.this.fetchAllCheckbox.setEnabled(false);
                    FileAgentJazzScmConfigurationEditor.this.logLoading.setEnabled(false);
                } else {
                    FileAgentJazzScmConfigurationEditor.this.fetchAllCheckbox.setEnabled(true);
                    FileAgentJazzScmConfigurationEditor.this.logLoading.setEnabled(true);
                }
                FileAgentJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    private ModifyListener getWorkSpaceNameTextModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileAgentJazzScmConfigurationEditor.this.validate();
                String WorkSpace = FileAgentJazzScmConfigurationEditor.this.workspaceNameText.getText().trim();
                boolean destTextNotEmpty = FileAgentJazzScmConfigurationEditor.this.fetchDestinationText != null ? FileAgentJazzScmConfigurationEditor.this.fetchDestinationText.getText().trim().length() > 0 : false;
                boolean isWorkEnable = false;
                if (WorkSpace.length() > 0) {
                    isWorkEnable = true;
                }
                FileAgentJazzScmConfigurationEditor.this.fetchWorkspaceBeforeBuildCheckbox.setEnabled(destTextNotEmpty && isWorkEnable);
                FileAgentJazzScmConfigurationEditor.this.setLoadExcludeSectionsStatus(isWorkEnable);
            }
        };
    }

    private void setLoadExcludeSectionsStatus(boolean workEnable) {
        boolean loadWorkEnable = false;
        if (this.fetchWorkspaceBeforeBuildCheckbox != null && !this.fetchWorkspaceBeforeBuildCheckbox.isDisposed() && this.fetchWorkspaceBeforeBuildCheckbox.isEnabled() && this.fetchWorkspaceBeforeBuildCheckbox.getSelection()) {
            loadWorkEnable = true;
        }
        boolean available = false;
        if (workEnable && loadWorkEnable) {
            available = true;
        }
        if (this.loadRulesClearButton != null && !this.loadRulesClearButton.isDisposed()) {
            this.loadRulesSelectButton.setEnabled(available);
            if (this.loadRulesField != null && !this.loadRulesField.isDisposed() && available && this.loadRulesField.getText().trim().length() > 0) {
                this.loadRulesClearButton.setEnabled(true);
            } else {
                this.loadRulesClearButton.setEnabled(false);
            }
        }
        if (this.excludeComponentsSelectButton != null && !this.excludeComponentsSelectButton.isDisposed()) {
            this.excludeComponentsSelectButton.setEnabled(available);
            if (this.excludeComponentsField != null && !this.excludeComponentsField.isDisposed() && available && this.excludeComponentsField.getText().trim().length() > 0) {
                this.excludeComponentsClearButton.setEnabled(true);
            } else {
                this.excludeComponentsClearButton.setEnabled(false);
            }
        }
        if (this.createFoldersForComponentsCheckbox != null && !this.createFoldersForComponentsCheckbox.isDisposed()) {
            this.createFoldersForComponentsCheckbox.setEnabled(available);
        }
    }

    protected SelectionListener getDeleteBeforeFetchSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileAgentJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.getProperty("team.enterprise.scm.deleteDestinationBeforeFetch");
                property.setValue(Boolean.toString(FileAgentJazzScmConfigurationEditor.this.deleteLoadDirectoryButton.getSelection()));
                FileAgentJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getAcceptBeforeFetchSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileAgentJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.getProperty("team.enterprise.scm.acceptBeforeFetch");
                property.setValue(Boolean.toString(FileAgentJazzScmConfigurationEditor.this.acceptBeforeFetchButton.getSelection()));
                FileAgentJazzScmConfigurationEditor.this.buildOnlyIfChangesButton.setSelection(FileAgentJazzScmConfigurationEditor.this.acceptBeforeFetchButton.getSelection());
                FileAgentJazzScmConfigurationEditor.this.buildOnlyIfChangesButton.setEnabled(FileAgentJazzScmConfigurationEditor.this.acceptBeforeFetchButton.getSelection());
                FileAgentJazzScmConfigurationEditor.this.getBuildOnlyIfChangesSelectionListener().widgetSelected(null);
                FileAgentJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getBuildOnlyIfChangesSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileAgentJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.getProperty("team.enterprise.scm.buildOnlyIfChanges");
                property.setValue(Boolean.toString(FileAgentJazzScmConfigurationEditor.this.buildOnlyIfChangesButton.getSelection()));
                FileAgentJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getFetchWorkspaceBeforeBuildSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileAgentJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.fetchWorkspaceBeforeBuild");
                boolean isSelected = FileAgentJazzScmConfigurationEditor.this.fetchWorkspaceBeforeBuildCheckbox.getSelection();
                property.setValue(Boolean.toString(isSelected));
                FileAgentJazzScmConfigurationEditor.this.setLoadExcludeSectionsStatus(FileAgentJazzScmConfigurationEditor.this.workspaceNameText != null ? FileAgentJazzScmConfigurationEditor.this.workspaceNameText.getText().trim().length() > 0 : false);
                FileAgentJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getFetchAllSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileAgentJazzScmConfigurationEditor.this.validate();
                IBuildProperty property = FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.fetchAll");
                property.setValue(Boolean.toString(FileAgentJazzScmConfigurationEditor.this.fetchAllCheckbox.getSelection()));
                FileAgentJazzScmConfigurationEditor.this.alwaysLoadComponentComposite.setEnabled(FileAgentJazzScmConfigurationEditor.this.stream != null && FileAgentJazzScmConfigurationEditor.this.fetchAllCheckbox.getSelection());
                FileAgentJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected SelectionListener getLogLoadingSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileAgentJazzScmConfigurationEditor.this.validate();
                FileAgentJazzScmConfigurationEditor.this.buildDefinitionWorkingCopy.setProperty("team.enterprise.scm.log.loading", Boolean.toString(FileAgentJazzScmConfigurationEditor.this.logLoading.getSelection()));
                FileAgentJazzScmConfigurationEditor.this.setDirty(true);
            }
        };
    }

    protected void updateEnablement() {
        if (this.workspaceNameText.getText().trim().length() != 0 && this.datasetPrefixText.getText().trim().length() != 0 && this.fetchDestinationText.getText().trim().length() != 0) {
            this.fetchAllCheckbox.setEnabled(true);
            this.logLoading.setEnabled(true);
            this.loadRulesSelectButton.setEnabled(true);
            this.excludeComponentsSelectButton.setEnabled(true);
            this.deleteLoadDirectoryButton.setEnabled(true);
            this.fetchWorkspaceBeforeBuildCheckbox.setEnabled(true);
            this.createFoldersForComponentsCheckbox.setEnabled(true);
        }
    }

    public IBuildDefinition getBuildDefinitionWorkingCopy() {
        return this.buildDefinitionWorkingCopy;
    }

    public Text getWorkspaceNameText() {
        return this.workspaceNameText;
    }

    public Text getFetchDestinationText() {
        return this.fetchDestinationText;
    }

    public Text getDatasetPrefixText() {
        return this.datasetPrefixText;
    }

    protected String getContextHelpId() {
        if (IBuildUtility.isIBMiDependencyBuild((IBuildDefinition)this.buildDefinitionWorkingCopy)) {
            return "com.ibm.team.build.ui.editor_builddefinitionsystemibmiantjazzscm";
        }
        return "com.ibm.team.build.ui.editor_builddefinitionsystemzosantjazzscm";
    }

    protected Map<IComponentHandle, IFileItemHandle> openComponentLoadRulesSelector(Map<IComponentHandle, IFileItemHandle> initialSelection) {
        Map componentLoadRuleFiles = FileSelectionDialog.pickFilePerComponent((Shell)this.loadRulesField.getShell(), (ITeamRepository)this.getTeamRepository(), (IWorkspace)this.workspace, (String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_PICK_LOAD_RULES_DIALOG_DESCRIPTION, initialSelection);
        return componentLoadRuleFiles;
    }

    protected void setComponentLoadRules(Map<IComponentHandle, IFileItemHandle> componentLoadRuleFiles) {
        if (componentLoadRuleFiles != null) {
            this.fComponentLoadRules = new ComponentLoadRules(componentLoadRuleFiles);
            String componentLoadRulesProperty = this.fComponentLoadRules.getBuildPropertySetting();
            this.buildDefinitionWorkingCopy.setProperty("team.enterprise.scm.componentLoadRules", componentLoadRulesProperty);
            this.updateComponentLoadRules(this.fComponentLoadRules);
            this.setDirty(true);
        }
    }

    protected void updateComponentLoadRules(ComponentLoadRules rules) {
        int numLoadRules = this.fComponentLoadRules.getLoadRuleFiles().values().size();
        String text = "";
        if (numLoadRules > 0) {
            text = numLoadRules > 1 ? com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_NUMBER_OF_LOADRULE_FILES_TEXT_MULTI : com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_NUMBER_OF_LOADRULE_FILES_TEXT;
        }
        this.loadRulesField.setText(NLS.bind((String)text, (Object)numLoadRules));
        this.loadRulesClearButton.setEnabled(numLoadRules > 0);
    }

    protected synchronized void setLoadComponents(LoadComponents loadComponents) {
        this.fLoadComponents = loadComponents;
    }

    protected synchronized LoadComponents getLoadComponents() {
        return this.fLoadComponents;
    }

    protected void createNewLoadComponents(Collection<IComponentHandle> loadComponents) {
        if (loadComponents != null) {
            LoadComponents componentsToExclude = new LoadComponents(loadComponents);
            this.setLoadComponents(componentsToExclude);
            String loadComponentsProperty = componentsToExclude.getBuildProperty();
            this.buildDefinitionWorkingCopy.setProperty("team.enterprise.scm.loadComponents", loadComponentsProperty);
            this.updateLoadComponents();
            this.setDirty(true);
        }
    }

    protected void updateLoadComponents() {
        int numLoadComponents = this.getLoadComponents().getComponentHandles().size();
        if (numLoadComponents == 0) {
            this.excludeComponentsField.setText("");
        } else {
            String messageId = numLoadComponents > 1 ? com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_NUMBER_OF_LOAD_COMPONENTS_TEXT_MULTI : com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_NUMBER_OF_LOAD_COMPONENTS_TEXT;
            this.excludeComponentsField.setText(NLS.bind((String)messageId, (Object)numLoadComponents));
        }
        this.excludeComponentsClearButton.setEnabled(numLoadComponents > 0);
    }

    protected Collection<IComponentHandle> openLoadComponentsSelector(Collection<IComponentHandle> initialSelection) {
        Object[] componentsSelected;
        ComponentSelectionDialog selectionDialog = new ComponentSelectionDialog(this.excludeComponentsField.getShell(), this.getTeamRepository(), (IWorkspaceHandle)this.workspace, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_PICK_LOAD_COMPONENTS_TITLE, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_PICK_LOAD_COMPONENTS, initialSelection);
        Collection<IComponentHandle> result = initialSelection;
        if (selectionDialog.open() == 0 && (componentsSelected = selectionDialog.getResult()) != null) {
            result = new ArrayList<IComponentHandle>(componentsSelected.length);
            int i = 0;
            while (i < componentsSelected.length) {
                result.add((IComponentHandle)((IComponent)componentsSelected[i]));
                ++i;
            }
        }
        return result;
    }

    private void addControlDecorator(Control targetControl, String descriptionText, int style) {
        final ControlDecoration dec = new ControlDecoration(targetControl, style);
        if (targetControl instanceof Text) {
            dec.setMarginWidth(2);
        }
        dec.setDescriptionText(descriptionText);
        dec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        dec.hide();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 26) {
                    dec.show();
                }
                if (event.type == 27) {
                    dec.hide();
                }
            }
        };
        targetControl.addListener(26, listener);
        targetControl.addListener(27, listener);
    }

    protected IScdClient getScdClient() {
        if (this.scdClient == null) {
            this.scdClient = (IScdClient)this.getTeamRepository().getClientLibrary(IScdClient.class);
        }
        return this.scdClient;
    }
}

