/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.build.internal.ui.editors.builddefinition.BuildDefinitionEditor;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.enterprise.common.common.IEnterpriseConfiguration;
import com.ibm.team.enterprise.common.ui.IDialogItem;
import com.ibm.team.enterprise.common.ui.elements.DialogButtonItem;
import com.ibm.team.enterprise.common.ui.elements.DialogTextItem;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.common.client.EnterpriseConfigurationCache;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class EnterpriseGatewayConfigurationEditor
extends AbstractConfigurationElementEditor {
    private BuildDefinitionEditor buildDefinitionEditor;
    private IBuildDefinition buildDefinitionWorkingCopy;
    private IDialogItem<Boolean, Button> enabledItem;
    private IDialogItem<String, Text> procnameItem;
    private IDialogItem<String, Text> acctnumItem;
    private IDialogItem<String, Text> groupidItem;
    private IDialogItem<String, Text> regionszItem;
    private IDialogItem<String, Text> steplibItem;
    private IProcessArea processArea;
    private IProjectAreaHandle projectAreaHandle;
    private IEnterpriseConfiguration configuration;
    private final VerifyListener verifyListener = e -> {
        e.text = e.text.toUpperCase();
    };
    private Boolean enabled = false;

    public EnterpriseGatewayConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public final void initialize(BuildDefinitionEditor editor) {
        super.initialize(editor);
        this.buildDefinitionEditor = editor;
        this.processArea = this.buildDefinitionEditor.getProcessArea();
        this.projectAreaHandle = this.processArea.getProjectArea();
        this.configuration = EnterpriseConfigurationCache.getInstance().get(this.projectAreaHandle);
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        parent.setLayout((Layout)new TableWrapLayout());
        Section section = toolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(256, 256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(Messages.EnterpriseGatewayConfigurationEditor_SECTION_TITLE);
        section.setDescription(Messages.EnterpriseGatewayConfigurationEditor_SECTION_DESCRIPTION);
        section.clientVerticalSpacing = 10;
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        section.setClient((Control)composite);
        this.enabled = Boolean.parseBoolean(this.buildDefinitionWorkingCopy.getConfigurationPropertyValue("com.ibm.team.enterprise.build.common.IEnterpriseGatewayConfigurationElement", "team.enterprise.gateway.enabled", "false"));
        this.enabledItem = new DialogButtonItem(toolkit).set((Object)this.enabled).set(IDialogItem.labelText, Messages.EnterpriseGatewayConfigurationEditor_LABEL_ENABLED_TEXT).set(IDialogItem.labelHelp, Messages.EnterpriseGatewayConfigurationEditor_LABEL_ENABLED_HELP).set(IDialogItem.valueGrabH, Boolean.valueOf(false)).set(IDialogItem.valueSpanC, Integer.valueOf(2)).set(IDialogItem.valueStyle, Integer.valueOf(IDialogItem.Style.CHECK.getStyle())).set(IDialogItem.helpLbl, Messages.EnterpriseGatewayConfigurationEditor_HELP_ENABLED_LABEL).set(IDialogItem.helpTxt, Messages.EnterpriseGatewayConfigurationEditor_HELP_ENABLED_TEXT).set(IDialogItem.selectionListener, SelectionListener.widgetSelectedAdapter(e -> {
            this.enabled = ((Button)this.enabledItem.getControl()).getSelection();
            this.buildDefinitionWorkingCopy.setConfigurationProperty("com.ibm.team.enterprise.build.common.IEnterpriseGatewayConfigurationElement", "team.enterprise.gateway.enabled", Boolean.toString(this.enabled));
            this.enableWidgets(this.enabled);
            this.setDirty(true);
        })).build();
        this.enabledItem.create(composite);
        this.procnameItem = new DialogTextItem(toolkit).set((Object)this.buildDefinitionWorkingCopy.getConfigurationPropertyValue("com.ibm.team.enterprise.build.common.IEnterpriseGatewayConfigurationElement", "team.enterprise.gateway.procname", "")).set(IDialogItem.labelText, Messages.EnterpriseGatewayConfigurationEditor_LABEL_PROCNAME_TEXT).set(IDialogItem.labelHelp, Messages.EnterpriseGatewayConfigurationEditor_LABEL_PROCNAME_HELP).set(IDialogItem.valueHintW, Integer.valueOf(40)).set(IDialogItem.valueLimit, Integer.valueOf(8)).set(IDialogItem.helpLbl, Messages.EnterpriseGatewayConfigurationEditor_HELP_PROCNAME_LABEL).set(IDialogItem.helpTxt, Messages.EnterpriseGatewayConfigurationEditor_HELP_PROCNAME_TEXT).set(IDialogItem.verifyListener, this.verifyListener).set(IDialogItem.modifyListener, e -> {
            if (this.validateProcname()) {
                this.buildDefinitionWorkingCopy.setConfigurationProperty("com.ibm.team.enterprise.build.common.IEnterpriseGatewayConfigurationElement", "team.enterprise.gateway.procname", ((Text)this.procnameItem.getItem()).getText().trim());
                this.setDirty(true);
            }
            composite.redraw();
        }).build();
        this.procnameItem.create(composite);
        this.acctnumItem = new DialogTextItem(toolkit).set((Object)this.buildDefinitionWorkingCopy.getConfigurationPropertyValue("com.ibm.team.enterprise.build.common.IEnterpriseGatewayConfigurationElement", "team.enterprise.gateway.acctnum", "")).set(IDialogItem.labelText, Messages.EnterpriseGatewayConfigurationEditor_LABEL_ACCTNUM_TEXT).set(IDialogItem.labelHelp, Messages.EnterpriseGatewayConfigurationEditor_LABEL_ACCTNUM_HELP).set(IDialogItem.valueHintW, Integer.valueOf(200)).set(IDialogItem.valueMaxW, Integer.valueOf(300)).set(IDialogItem.valueLimit, Integer.valueOf(40)).set(IDialogItem.helpLbl, Messages.EnterpriseGatewayConfigurationEditor_HELP_ACCTNUM_LABEL).set(IDialogItem.helpTxt, Messages.EnterpriseGatewayConfigurationEditor_HELP_ACCTNUM_TEXT).set(IDialogItem.verifyListener, this.verifyListener).set(IDialogItem.modifyListener, e -> {
            if (this.validateAcctnum()) {
                this.buildDefinitionWorkingCopy.setConfigurationProperty("com.ibm.team.enterprise.build.common.IEnterpriseGatewayConfigurationElement", "team.enterprise.gateway.acctnum", ((Text)this.acctnumItem.getItem()).getText().trim());
                this.setDirty(true);
            }
            composite.redraw();
        }).build();
        this.acctnumItem.create(composite);
        this.groupidItem = new DialogTextItem(toolkit).set((Object)this.buildDefinitionWorkingCopy.getConfigurationPropertyValue("com.ibm.team.enterprise.build.common.IEnterpriseGatewayConfigurationElement", "team.enterprise.gateway.groupid", "")).set(IDialogItem.labelText, Messages.EnterpriseGatewayConfigurationEditor_LABEL_GROUPID_TEXT).set(IDialogItem.labelHelp, Messages.EnterpriseGatewayConfigurationEditor_LABEL_GROUPID_HELP).set(IDialogItem.valueHintW, Integer.valueOf(40)).set(IDialogItem.valueLimit, Integer.valueOf(8)).set(IDialogItem.helpLbl, Messages.EnterpriseGatewayConfigurationEditor_HELP_GROUPID_LABEL).set(IDialogItem.helpTxt, Messages.EnterpriseGatewayConfigurationEditor_HELP_GROUPID_TEXT).set(IDialogItem.verifyListener, this.verifyListener).set(IDialogItem.modifyListener, e -> {
            if (this.validateGroupid()) {
                this.buildDefinitionWorkingCopy.setConfigurationProperty("com.ibm.team.enterprise.build.common.IEnterpriseGatewayConfigurationElement", "team.enterprise.gateway.groupid", ((Text)this.groupidItem.getItem()).getText().trim());
                this.setDirty(true);
            }
            composite.redraw();
        }).build();
        this.groupidItem.create(composite);
        this.regionszItem = new DialogTextItem(toolkit).set((Object)this.buildDefinitionWorkingCopy.getConfigurationPropertyValue("com.ibm.team.enterprise.build.common.IEnterpriseGatewayConfigurationElement", "team.enterprise.gateway.regionsz", "")).set(IDialogItem.labelText, Messages.EnterpriseGatewayConfigurationEditor_LABEL_REGIONSZ_TEXT).set(IDialogItem.labelHelp, Messages.EnterpriseGatewayConfigurationEditor_LABEL_REGIONSZ_HELP).set(IDialogItem.valueHintW, Integer.valueOf(200)).set(IDialogItem.valueLimit, Integer.valueOf(7)).set(IDialogItem.helpLbl, Messages.EnterpriseGatewayConfigurationEditor_HELP_REGIONSZ_LABEL).set(IDialogItem.helpTxt, Messages.EnterpriseGatewayConfigurationEditor_HELP_REGIONSZ_TEXT).set(IDialogItem.modifyListener, e -> {
            if (this.validateRegionsz()) {
                this.buildDefinitionWorkingCopy.setConfigurationProperty("com.ibm.team.enterprise.build.common.IEnterpriseGatewayConfigurationElement", "team.enterprise.gateway.regionsz", ((Text)this.regionszItem.getItem()).getText().trim());
                this.setDirty(true);
            }
            composite.redraw();
        }).build();
        this.regionszItem.create(composite);
        this.steplibItem = new DialogTextItem(toolkit).set((Object)this.buildDefinitionWorkingCopy.getConfigurationPropertyValue("com.ibm.team.enterprise.build.common.IEnterpriseGatewayConfigurationElement", "team.enterprise.gateway.steplib", "")).set(IDialogItem.labelText, Messages.EnterpriseGatewayConfigurationEditor_LABEL_STEPLIB_TEXT).set(IDialogItem.labelHelp, Messages.EnterpriseGatewayConfigurationEditor_LABEL_STEPLIB_HELP).set(IDialogItem.valueHintW, Integer.valueOf(200)).set(IDialogItem.valueMaxW, Integer.valueOf(800)).set(IDialogItem.helpLbl, Messages.EnterpriseGatewayConfigurationEditor_HELP_STEPLIB_LABEL).set(IDialogItem.helpTxt, Messages.EnterpriseGatewayConfigurationEditor_HELP_STEPLIB_TEXT).set(IDialogItem.verifyListener, this.verifyListener).set(IDialogItem.modifyListener, e -> {
            if (this.validateSteplib()) {
                this.buildDefinitionWorkingCopy.setConfigurationProperty("com.ibm.team.enterprise.build.common.IEnterpriseGatewayConfigurationElement", "team.enterprise.gateway.steplib", ((Text)this.steplibItem.getItem()).getText().trim());
                this.setDirty(true);
            }
            composite.redraw();
        }).build();
        this.steplibItem.create(composite);
        this.enableWidgets(this.enabled);
    }

    private void enableWidgets(Boolean enabled) {
        this.procnameItem.getControl().setEnabled(enabled.booleanValue());
        this.acctnumItem.getControl().setEnabled(enabled.booleanValue());
        this.groupidItem.getControl().setEnabled(enabled.booleanValue());
        this.regionszItem.getControl().setEnabled(enabled.booleanValue());
        this.steplibItem.getControl().setEnabled(enabled.booleanValue());
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        this.buildDefinitionWorkingCopy = definition;
    }

    public Control getFocusControl() {
        Control result = null;
        if (this.enabledItem != null && this.procnameItem != null) {
            result = ((Button)this.enabledItem.getItem()).getSelection() ? this.procnameItem.getControl() : this.enabledItem.getControl();
        }
        return result;
    }

    public boolean validate() {
        boolean isValid = true;
        if (!this.validateProcname()) {
            isValid = false;
        }
        if (!this.validateAcctnum()) {
            isValid = false;
        }
        if (!this.validateGroupid()) {
            isValid = false;
        }
        if (!this.validateRegionsz()) {
            isValid = false;
        }
        if (!this.validateSteplib()) {
            isValid = false;
        }
        return isValid;
    }

    public boolean validateProcname() {
        if (this.procnameItem != null) {
            this.removeMessage(this.procnameItem, this.procnameItem.getControl());
            if (this.procnameItem.getDecoration() != null) {
                this.procnameItem.getDecoration().setDescriptionText(null);
                this.procnameItem.getDecoration().setImage(null);
            }
            String procname = ((Text)this.procnameItem.getItem()).getText().trim();
            if (this.enabled.booleanValue() && this.buildDefinitionEditor.isSaveAttempted() && Verification.isBlank((String)procname)) {
                this.addErrorMessageForRequiredField(this.procnameItem, Messages.EnterpriseGatewayConfigurationEditor_PROCNAME_REQUIRED, this.procnameItem.getControl());
                return false;
            }
            if (this.enabled.booleanValue() && !Verification.isBlank((String)procname) && !Verification.isMemberName((String)procname)) {
                this.addErrorMessage(this.procnameItem, Messages.EnterpriseGatewayConfigurationEditor_PROCNAME_MEMBERNAME, this.procnameItem.getControl());
                return false;
            }
        }
        return true;
    }

    public boolean validateAcctnum() {
        if (this.acctnumItem != null) {
            this.removeMessage(this.acctnumItem, this.acctnumItem.getControl());
            if (this.acctnumItem.getDecoration() != null) {
                this.acctnumItem.getDecoration().setDescriptionText(null);
                this.acctnumItem.getDecoration().setImage(null);
            }
            String acctnum = ((Text)this.acctnumItem.getItem()).getText().trim();
            if (this.enabled.booleanValue() && this.buildDefinitionEditor.isSaveAttempted() && Verification.isBlank((String)acctnum)) {
                this.addErrorMessageForRequiredField(this.acctnumItem, Messages.EnterpriseGatewayConfigurationEditor_ACCTNUM_REQUIRED, this.acctnumItem.getControl());
                return false;
            }
            if (this.enabled.booleanValue()) {
                String nc = this.configuration.getNationalCharacters();
                if (!Verification.isBlank((String)acctnum) && !Verification.isAccountNumber((String)acctnum, (String)nc)) {
                    this.addErrorMessage(this.acctnumItem, Messages.EnterpriseGatewayConfigurationEditor_ACCTNUM_ALPHANUM, this.acctnumItem.getControl());
                    return false;
                }
            }
        }
        return true;
    }

    public boolean validateGroupid() {
        if (this.groupidItem != null) {
            this.removeMessage(this.groupidItem, this.groupidItem.getControl());
            if (this.groupidItem.getDecoration() != null) {
                this.groupidItem.getDecoration().setDescriptionText(null);
                this.groupidItem.getDecoration().setImage(null);
            }
            String acctnum = ((Text)this.groupidItem.getItem()).getText().trim();
            if (this.enabled.booleanValue() && this.buildDefinitionEditor.isSaveAttempted() && Verification.isBlank((String)acctnum)) {
                this.addErrorMessageForRequiredField(this.groupidItem, Messages.EnterpriseGatewayConfigurationEditor_GROUPID_REQUIRED, this.groupidItem.getControl());
                return false;
            }
            if (this.enabled.booleanValue() && !Verification.isBlank((String)acctnum) && !Verification.isMemberName((String)acctnum)) {
                this.addErrorMessage(this.groupidItem, Messages.EnterpriseGatewayConfigurationEditor_GROUPID_MEMBERNAME, this.groupidItem.getControl());
                return false;
            }
        }
        return true;
    }

    public boolean validateRegionsz() {
        if (this.regionszItem != null) {
            this.removeMessage(this.regionszItem, this.regionszItem.getControl());
            if (this.regionszItem.getDecoration() != null) {
                this.regionszItem.getDecoration().setDescriptionText(null);
                this.regionszItem.getDecoration().setImage(null);
            }
            String regionsz = ((Text)this.regionszItem.getItem()).getText().trim();
            if (this.enabled.booleanValue() && this.buildDefinitionEditor.isSaveAttempted() && Verification.isBlank((String)regionsz)) {
                this.addErrorMessageForRequiredField(this.regionszItem, Messages.EnterpriseGatewayConfigurationEditor_REGIONSZ_REQUIRED, this.regionszItem.getControl());
                return false;
            }
            if (this.enabled.booleanValue() && !Verification.isBlank((String)regionsz)) {
                if (!Verification.isInteger((String)regionsz)) {
                    this.addErrorMessage(this.regionszItem, Messages.EnterpriseGatewayConfigurationEditor_REGIONSZ_NUM, this.regionszItem.getControl());
                    return false;
                }
                if (Integer.parseInt(regionsz) < 0 || Integer.parseInt(regionsz) > 2096128) {
                    this.addErrorMessage(this.regionszItem, Messages.EnterpriseGatewayConfigurationEditor_REGIONSZ_VALUE_RANGE, this.regionszItem.getControl());
                    return false;
                }
            }
        }
        return true;
    }

    public boolean validateSteplib() {
        if (this.steplibItem != null) {
            this.removeMessage(this.steplibItem, this.steplibItem.getControl());
            if (this.steplibItem.getDecoration() != null) {
                this.steplibItem.getDecoration().setDescriptionText(null);
                this.steplibItem.getDecoration().setImage(null);
            }
            String steplib = ((Text)this.steplibItem.getItem()).getText().trim();
            if (this.enabled.booleanValue() && !Verification.isBlank((String)steplib)) {
                String[] datasets;
                String[] stringArray = datasets = steplib.split(":");
                int n = datasets.length;
                int n2 = 0;
                while (n2 < n) {
                    String dataset = stringArray[n2];
                    if (!Verification.isDatasetName((String)dataset)) {
                        this.addErrorMessage(this.steplibItem, Messages.EnterpriseGatewayConfigurationEditor_STEPLIB_DATASET, this.steplibItem.getControl());
                        return false;
                    }
                    ++n2;
                }
            }
        }
        return true;
    }
}

