/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors;

import com.ibm.team.enterprise.build.ui.editors.EnterpriseBrowserEditorInput;
import com.ibm.team.enterprise.internal.build.ui.browser.BrowserActionFactory;
import com.ibm.team.enterprise.internal.build.ui.browser.IBrowserAction;
import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.internal.browser.WebBrowserEditor;

public class EnterpriseBrowserEditor
extends WebBrowserEditor {
    private EnterpriseBrowserEditor instance = this;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.webBrowser.getBrowser().addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                String location = event.location;
                try {
                    URI uri = new URI(location);
                    List<IBrowserAction> actions = BrowserActionFactory.getInstance().getActions();
                    ITeamRepository repository = null;
                    IEditorInput input = EnterpriseBrowserEditor.this.getEditorInput();
                    if (input instanceof EnterpriseBrowserEditorInput) {
                        repository = ((EnterpriseBrowserEditorInput)input).getRepository();
                    }
                    if (repository == null && (repository = ClientURIUtils.guessTeamRepository((URI)uri)) == null) {
                        repository = EnterpriseBrowserEditor.this.getConnectedTeamRepository();
                    }
                    for (IBrowserAction action : actions) {
                        if (!action.canSupport(uri)) continue;
                        event.doit = false;
                        action.run(uri, EnterpriseBrowserEditor.this.instance, null, repository);
                        break;
                    }
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }

            public void changed(LocationEvent event) {
            }
        });
    }

    protected ITeamRepository getConnectedTeamRepository() {
        ITeamRepository[] repositories;
        ITeamRepository[] iTeamRepositoryArray = repositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repositories.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository = iTeamRepositoryArray[n2];
            if (repository.loggedIn()) {
                return repository;
            }
            ++n2;
        }
        if (repositories.length > 0) {
            return repositories[0];
        }
        return null;
    }
}

