/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors;

import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.editors.RemoteFileEditorInput;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.filesystem.rcp.core.internal.resources.ResourceUtil;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EditorUtil {
    public static void openEditor(final UIContext context, final RemoteFileEditorInput editorInput, final boolean allowExternal) {
        IContentType contentType = null;
        try {
            contentType = ResourceUtil.getContentTypeFor((InputStream)editorInput.getStorage().getContents(), (String)editorInput.getName());
        }
        catch (CoreException e1) {
            Activator.getDefault().logError(e1);
        }
        final IContentType finalContentType = contentType;
        context.asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    EditorUtil.openEditor(context.getPage(), (IEditorInput)editorInput, finalContentType, false, allowExternal);
                }
                catch (PartInitException e) {
                    MessageDialog.openError((Shell)context.getShell(), (String)Messages.EditorUtil_ERROR_OPEN_EDITOR_TITLE, (String)NLS.bind((String)Messages.EditorUtil_ERROR_FILE_NOT_FOUND, (Object)editorInput.getName()));
                    Activator.getDefault().logError(e);
                }
            }
        });
    }

    public static IEditorPart openEditor(IWorkbenchPage page, IEditorInput input, IContentType content, boolean activate, boolean allowExternal) throws PartInitException {
        RemoteFileEditorInput rfei;
        String name;
        if (!PlatformUI.isWorkbenchRunning()) {
            throw new PartInitException(Messages.EditorUtil_ERROR_WORKBENCH_NOT_RUNNING);
        }
        IWorkbench workbench = page.getWorkbenchWindow().getWorkbench();
        IEditorRegistry registry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(name = input.getName(), content);
        if (descriptor == null && allowExternal && registry.isSystemExternalEditorAvailable(name)) {
            descriptor = registry.findEditor("org.eclipse.ui.systemExternalEditor");
            if (descriptor != null && input instanceof RemoteFileEditorInput) {
                rfei = (RemoteFileEditorInput)input;
                try {
                    input = rfei.asPathEditorInput(null);
                }
                catch (IOException e) {
                    throw new PartInitException(e.getMessage(), (Throwable)e);
                }
            }
        } else if (descriptor != null && descriptor.isOpenExternal() && input instanceof RemoteFileEditorInput) {
            rfei = (RemoteFileEditorInput)input;
            try {
                input = rfei.asPathEditorInput(null);
            }
            catch (IOException e) {
                throw new PartInitException(e.getMessage(), (Throwable)e);
            }
        }
        String id = descriptor == null || !allowExternal && !descriptor.isInternal() ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
        try {
            return page.openEditor(input, id, activate);
        }
        catch (PartInitException e) {
            if (id.equals("org.eclipse.ui.DefaultTextEditor")) {
                throw e;
            }
            return page.openEditor(input, "org.eclipse.ui.DefaultTextEditor");
        }
    }
}

