/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.scm.LoadComponents;
import com.ibm.team.enterprise.build.ui.dialogs.ComponentSelectionDialog;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ComponentSelectionComposite
extends Composite {
    private Label descLabel;
    private Text componentListField;
    private Button selectBtn;
    private Button clearBtn;
    private String componentSelectionTitle = "";
    private String componentSelectionDesc = "";
    private String componentClearConfirmationTitle = "";
    private String componentClearConfirmationDesc = "";
    private LoadComponents selectedComponents;
    private IBuildDefinition buildDefinition;
    private ITeamRepository teamRepository;
    private IEditorSite editorSite;
    private IWorkspaceHandle workspaceHandle;
    private String configurationProperty;
    private String configurationElementId;
    private List<IPropertyChangeListener> propertyListeners;

    public ComponentSelectionComposite(Composite parent, String description, IEditorSite site, String buildConfigurationElementId, String configurationPropertyName, IBuildDefinition buildDefinitionWorkingCopy, IWorkspaceHandle workspace, ITeamRepository repository, FormToolkit toolkit) {
        super(parent, 0);
        this.editorSite = site;
        this.buildDefinition = buildDefinitionWorkingCopy;
        this.teamRepository = repository;
        this.workspaceHandle = workspace;
        this.configurationProperty = configurationPropertyName;
        this.configurationElementId = buildConfigurationElementId;
        this.selectedComponents = new LoadComponents(this.teamRepository, this.buildDefinition.getPropertyValue(this.configurationProperty, ""));
        GridLayoutFactory.fillDefaults().numColumns(3).margins(0, 0).applyTo((Composite)this);
        this.descLabel = toolkit.createLabel((Composite)this, description);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.descLabel);
        this.componentListField = toolkit.createText((Composite)this, "");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.componentListField);
        this.componentListField.setEnabled(false);
        this.selectBtn = toolkit.createButton((Composite)this, Messages.FileAgentJazzScmConfigurationEditor_SELECT_COMPONENT_LOAD_RULES_BUTTON_TITLE, 8);
        this.selectBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Object[] componentsSelected;
                Collection<Object> initialComponentHandleSelection = ComponentSelectionComposite.this.selectedComponents == null ? Collections.emptyList() : ComponentSelectionComposite.this.selectedComponents.getComponentHandles();
                ComponentSelectionDialog selectionDialog = new ComponentSelectionDialog(ComponentSelectionComposite.this.editorSite.getShell(), ComponentSelectionComposite.this.teamRepository, ComponentSelectionComposite.this.workspaceHandle, ComponentSelectionComposite.this.componentSelectionTitle, ComponentSelectionComposite.this.componentSelectionDesc, initialComponentHandleSelection);
                if (selectionDialog.open() == 0 && (componentsSelected = selectionDialog.getResult()) != null) {
                    ArrayList<IComponent> result = new ArrayList<IComponent>(componentsSelected.length);
                    int i = 0;
                    while (i < componentsSelected.length) {
                        result.add((IComponent)componentsSelected[i]);
                        ++i;
                    }
                    ComponentSelectionComposite.this.selectedComponents = new LoadComponents(result);
                    ComponentSelectionComposite.this.buildDefinition.setProperty(ComponentSelectionComposite.this.configurationProperty, ComponentSelectionComposite.this.selectedComponents.getBuildProperty());
                    ComponentSelectionComposite.this.updateSelectedComponentsField();
                    ComponentSelectionComposite.this.firePropertyChangedEvent();
                }
            }
        });
        this.clearBtn = toolkit.createButton((Composite)this, Messages.FileAgentJazzScmConfigurationEditor_CLEAR_COMPONENTRULES_BUTTON, 8);
        this.clearBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MessageDialog.openConfirm((Shell)ComponentSelectionComposite.this.editorSite.getShell(), (String)ComponentSelectionComposite.this.componentClearConfirmationTitle, (String)ComponentSelectionComposite.this.componentClearConfirmationDesc)) {
                    ComponentSelectionComposite.this.selectedComponents = new LoadComponents(Collections.emptyList());
                    ComponentSelectionComposite.this.buildDefinition.setProperty(ComponentSelectionComposite.this.configurationProperty, ComponentSelectionComposite.this.selectedComponents.getBuildProperty());
                    ComponentSelectionComposite.this.updateSelectedComponentsField();
                    ComponentSelectionComposite.this.firePropertyChangedEvent();
                }
            }
        });
        this.setEnabled(workspace != null);
        this.updateSelectedComponentsField();
    }

    private void updateSelectedComponentsField() {
        int numLoadComponents = this.selectedComponents.getComponentHandles().size();
        if (numLoadComponents == 0) {
            this.componentListField.setText("");
        } else {
            String messageId = numLoadComponents > 1 ? Messages.FileAgentJazzScmConfigurationEditor_NUMBER_OF_LOAD_COMPONENTS_TEXT_MULTI : Messages.FileAgentJazzScmConfigurationEditor_NUMBER_OF_LOAD_COMPONENTS_TEXT;
            this.componentListField.setText(NLS.bind((String)messageId, (Object)numLoadComponents));
        }
        this.clearBtn.setEnabled(numLoadComponents > 0);
    }

    public void addPropertyListener(IPropertyChangeListener listener) {
        if (listener != null) {
            if (this.propertyListeners == null) {
                this.propertyListeners = new ArrayList<IPropertyChangeListener>();
            }
            this.propertyListeners.add(listener);
        }
    }

    public void removePropertyListener(IPropertyChangeListener listener) {
        if (listener != null && this.propertyListeners != null) {
            this.propertyListeners.remove(listener);
        }
    }

    private void firePropertyChangedEvent() {
        if (this.propertyListeners != null) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, this.configurationProperty, (Object)"", (Object)this.selectedComponents);
            for (IPropertyChangeListener propertyListener : this.propertyListeners) {
                propertyListener.propertyChange(event);
            }
        }
    }

    public void setComponentSelectionTitle(String componentSelectionTitle) {
        this.componentSelectionTitle = componentSelectionTitle;
    }

    public void setComponentSelectionDesc(String componentSelectionDesc) {
        this.componentSelectionDesc = componentSelectionDesc;
    }

    public void setComponentClearConfirmationTitle(String componentClearConfirmationTitle) {
        this.componentClearConfirmationTitle = componentClearConfirmationTitle;
    }

    public void setComponentClearConfirmationDesc(String componentClearConfirmationDesc) {
        this.componentClearConfirmationDesc = componentClearConfirmationDesc;
    }

    public void setWorkspace(IWorkspaceHandle workspace) {
        if (workspace == null) {
            this.workspaceHandle = null;
            this.selectedComponents = new LoadComponents(Collections.emptyList());
        } else if (!workspace.sameItemId((IItemHandle)this.workspaceHandle)) {
            this.workspaceHandle = workspace;
            this.selectedComponents = new LoadComponents(Collections.emptyList());
        }
    }

    public void setEnabled(boolean value) {
        if (value) {
            this.descLabel.setForeground(Display.getDefault().getSystemColor(21));
            this.clearBtn.setEnabled(this.selectedComponents.getComponentHandles().size() > 0);
        } else {
            this.descLabel.setForeground(null);
            this.clearBtn.setEnabled(false);
        }
        this.selectBtn.setEnabled(value);
    }
}

