/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.common.model.BuildDefinition;
import com.ibm.team.build.internal.common.model.BuildProperty;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.build.ui.editors.builddefinition.AbstractConfigurationElementEditor;
import com.ibm.team.enterprise.build.common.BuildOrderProperty;
import com.ibm.team.enterprise.build.common.BuildOrderPropertyParser;
import com.ibm.team.enterprise.build.common.IBuildOrderProperty;
import com.ibm.team.enterprise.build.common.Messages;
import com.ibm.team.enterprise.common.ui.Activator;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.actions.EditSystemDefinitionActionDelegate;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosPlatformObject;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.LanguageDefinitionSelectionDialog;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public abstract class AbstractEnterpriseConfigurationEditor
extends AbstractConfigurationElementEditor
implements SelectionListener,
ISelectionChangedListener,
ModifyListener,
IDoubleClickListener {
    private static final int LANG_DEF_LABEL_INDENT = 20;
    protected int numSelected;
    protected IBuildDefinition fBuildDefinitionWorkingCopy;
    private IProjectAreaHandle projectArea = null;
    private Button generateButton;
    private Button customButton;
    private Button moveUpButton;
    private Button moveDownButton;
    private Button addButton;
    private Button removeButton;
    private Composite orderingComposite;
    private Composite fieldComposite;
    private Composite buttonComposite;
    private TableViewer orderTableViewer;
    private Text buildFileText;
    private Text buildTargetsText;
    private Label languageDefLabel;
    protected Button buildMapsButton;
    protected Button reuseISPFButton;
    protected Text bpxwdynOptionsText;
    protected Spinner fUpdateFreSpinner;
    protected Adapter fPropertyChangedListener = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            Object currentOrderTableInput;
            Object notifierSource;
            Object notifier = notification.getNotifier();
            if ((notifier instanceof BuildProperty || notifier instanceof BuildDefinition) && (notifierSource = notification.getOldValue()) == (currentOrderTableInput = AbstractEnterpriseConfigurationEditor.this.orderTableViewer.getInput())) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractEnterpriseConfigurationEditor.this.refreshOrderingControl();
                    }
                });
            }
        }
    };

    public AbstractEnterpriseConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    public void dispose() {
        super.dispose();
        IBuildDefinition fWorkingCopy = this.getWorkingCopy();
        if (fWorkingCopy != null) {
            ((BuildDefinition)fWorkingCopy).eAdapters().remove((Object)this.fPropertyChangedListener);
        }
    }

    protected void createBuildFileSection(Composite parent, FormToolkit toolkit) {
        Section buildFileSection = toolkit.createSection(parent, 384);
        buildFileSection.setLayoutData((Object)new TableWrapData(256, 256));
        buildFileSection.setLayout((Layout)new TableWrapLayout());
        buildFileSection.setText(Messages.EnterpriseRequestDialogOption_CATEGORY_BUILD_FILE_TARGETS);
        Composite buildFileComposite = toolkit.createComposite((Composite)buildFileSection);
        buildFileComposite.setLayoutData((Object)new TableWrapData(256, 256));
        buildFileComposite.setLayout((Layout)new TableWrapLayout());
        this.generateButton = toolkit.createButton(buildFileComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_BUTTON_GENERATE, 16);
        this.generateButton.setLayoutData((Object)new TableWrapData());
        this.languageDefLabel = new Label(buildFileComposite, 0);
        TableWrapData ldlLayout = new TableWrapData();
        ldlLayout.indent = 20;
        this.languageDefLabel.setLayoutData((Object)ldlLayout);
        this.orderingComposite = toolkit.createComposite(buildFileComposite);
        this.orderingComposite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout orderingLayout = new TableWrapLayout();
        orderingLayout.numColumns = 2;
        orderingLayout.horizontalSpacing = 10;
        orderingLayout.leftMargin = 20;
        this.orderingComposite.setLayout((Layout)orderingLayout);
        this.createBuildOrderWidgets(this.orderingComposite);
        this.customButton = toolkit.createButton(buildFileComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_BUTTON_EXISTING, 16);
        this.customButton.setLayoutData((Object)new TableWrapData());
        IBuildConfigurationElement element = this.getWorkingCopy().getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.useGeneratedBuildFile");
        if (property != null) {
            boolean propertyValue = Boolean.parseBoolean(property.getValue());
            this.generateButton.setSelection(propertyValue);
            this.customButton.setSelection(!propertyValue);
        } else {
            this.customButton.setSelection(true);
            this.getWorkingCopy().setConfigurationProperty(this.getConfigurationId(), "team.enterprise.build.ant.useGeneratedBuildFile", Boolean.toString(false));
        }
        this.generateButton.addSelectionListener((SelectionListener)this);
        this.customButton.addSelectionListener((SelectionListener)this);
        this.fieldComposite = toolkit.createComposite(buildFileComposite);
        this.fieldComposite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        layout.leftMargin = 20;
        this.fieldComposite.setLayout((Layout)layout);
        Text customBuildLabel = new Text(this.fieldComposite, 8);
        customBuildLabel.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_LABEL_EXISTING);
        customBuildLabel.setForeground(this.getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE"));
        TableWrapData labelData = new TableWrapData(256);
        labelData.colspan = 2;
        customBuildLabel.setLayoutData((Object)labelData);
        this.createBuildFileWidgets(this.fieldComposite);
        this.createBuildTargetWidgets(this.fieldComposite);
        this.createAdvancedWidgets(buildFileComposite);
        this.updateComponentState();
        buildFileSection.setClient((Control)buildFileComposite);
    }

    protected void createUpdateFrequnceConfiguration(Composite parent, int colspan) {
        Composite comp = new Composite(parent, 0);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        layout.leftMargin = 0;
        comp.setLayout((Layout)layout);
        TableWrapData data = new TableWrapData(256);
        data.colspan = colspan;
        comp.setLayoutData((Object)data);
        Label nameLabel = new Label(comp, 0);
        nameLabel.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_UPDATE_FREQUENCE_LABEL);
        nameLabel.setLayoutData((Object)new TableWrapData());
        this.fUpdateFreSpinner = new Spinner(comp, 2048);
        this.fUpdateFreSpinner.setMinimum(1);
        this.fUpdateFreSpinner.setMaximum(500);
        String valueStr = this.getWorkingCopy().getPropertyValue("team.enterprise.build.dependency.preprocessUpdateF", String.valueOf(100));
        int value = 0;
        value = valueStr != null && valueStr.length() > 0 ? Integer.valueOf(valueStr) : 100;
        if (value < 1) {
            value = 1;
        }
        this.fUpdateFreSpinner.setSelection(value);
        this.fUpdateFreSpinner.addModifyListener((ModifyListener)this);
        this.fUpdateFreSpinner.setLayoutData((Object)new TableWrapData());
    }

    protected void createBuildOrderWidgets(Composite parent) {
        final IProcessAreaHandle processArea = this.getWorkingCopy().getProcessArea();
        TeamBuildJob resolveProjectAreaJob = new TeamBuildJob(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_JOBNAME_RESOLVEPROJECTAREA, false, this.getTeamRepository()){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                AbstractEnterpriseConfigurationEditor.this.resolveProjectArea(processArea, monitor);
                return Status.OK_STATUS;
            }
        };
        resolveProjectAreaJob.schedule();
        try {
            resolveProjectAreaJob.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Table orderTable = this.getToolkit().createTable(parent, 66306);
        orderTable.setSize(200, 150);
        TableWrapData tableData = new TableWrapData(256);
        tableData.heightHint = 115;
        orderTable.setLayoutData((Object)tableData);
        orderTable.pack();
        this.orderTableViewer = new TableViewer(orderTable);
        BuildOrderTableContentProvider orderTableContentProvider = new BuildOrderTableContentProvider();
        BuildOrderTableLabelProvider orderTableLabelProvider = new BuildOrderTableLabelProvider();
        this.orderTableViewer.setContentProvider((IContentProvider)orderTableContentProvider);
        this.orderTableViewer.setLabelProvider((IBaseLabelProvider)orderTableLabelProvider);
        IBuildConfigurationElement element = this.getWorkingCopy().getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.buildOrder");
        if (property != null && !property.getValue().equalsIgnoreCase("")) {
            List propertyList = BuildOrderPropertyParser.getInstance().decodeString(property.getValue());
            this.orderTableViewer.setInput((Object)propertyList);
        } else {
            this.orderTableViewer.setInput((Object)processArea);
        }
        this.orderTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.orderTableViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.orderTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractEnterpriseConfigurationEditor.this.numSelected = AbstractEnterpriseConfigurationEditor.this.orderTableViewer.getTable().getSelectionCount();
                AbstractEnterpriseConfigurationEditor.this.updateLabel();
            }
        });
        this.buttonComposite = this.getToolkit().createComposite(parent);
        this.buttonComposite.setLayoutData((Object)new TableWrapData(256, 16));
        TableWrapLayout buttonLayout = new TableWrapLayout();
        buttonLayout.makeColumnsEqualWidth = false;
        this.buttonComposite.setLayout((Layout)buttonLayout);
        this.addButton = this.getToolkit().createButton(this.buttonComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseBuildUI_BUTTON_ADD, 8);
        TableWrapData buttonData = new TableWrapData(128);
        this.addButton.setLayoutData((Object)buttonData);
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton = this.getToolkit().createButton(this.buttonComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseBuildUI_BUTTON_REMOVE, 8);
        buttonData = new TableWrapData(128);
        this.removeButton.setLayoutData((Object)buttonData);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.moveUpButton = this.getToolkit().createButton(this.buttonComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseBuildUI_BUTTON_UP, 8);
        buttonData = new TableWrapData(128);
        this.moveUpButton.setLayoutData((Object)buttonData);
        this.moveUpButton.addSelectionListener((SelectionListener)this);
        this.moveDownButton = this.getToolkit().createButton(this.buttonComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseBuildUI_BUTTON_DOWN, 8);
        buttonData = new TableWrapData(128);
        this.moveDownButton.setLayoutData((Object)buttonData);
        this.moveDownButton.addSelectionListener((SelectionListener)this);
        this.createSpacer(parent, 5, 2);
    }

    protected void resolveProjectArea(IProcessAreaHandle processArea, IProgressMonitor monitor) {
        if (processArea instanceof ITeamAreaHandle) {
            Object origin = ((ITeamAreaHandle)processArea).getOrigin();
            try {
                ITeamArea teamArea = (ITeamArea)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)processArea, 0, monitor);
                this.projectArea = teamArea.getProjectArea();
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        } else if (processArea instanceof IProjectAreaHandle) {
            this.projectArea = (IProjectAreaHandle)processArea;
        }
    }

    protected void createBuildFileWidgets(Composite parent) {
        IBuildConfigurationElement element = this.getWorkingCopy().getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.buildFile");
        this.createSpacer(parent, 5, 2);
        this.buildFileText = this.createLabeledText(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_BUILD_FILE_LABEL, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_BUILD_FILE_DESC, property.getValue());
        this.buildFileText.addModifyListener((ModifyListener)this);
    }

    protected void createBuildTargetWidgets(Composite parent) {
        IBuildConfigurationElement element = this.getWorkingCopy().getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.targets");
        String targets = property.getValue();
        this.createSpacer(parent, 5, 2);
        this.buildTargetsText = this.createLabeledText(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_BUILD_TARGETS_LABEL, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_BUILD_TARGETS_DESCRIPTION, targets);
        this.buildTargetsText.addModifyListener((ModifyListener)this);
    }

    protected Text createLabeledText(Composite parent, String label, String description, String textValue) {
        this.getToolkit().createLabel(parent, label);
        Text text = this.getToolkit().createText(parent, textValue);
        text.setLayoutData((Object)new TableWrapData(256));
        return text;
    }

    protected void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = this.getToolkit().createLabel(parent, "");
        TableWrapData tableWrapData = new TableWrapData(128, 32, 1, horizontalSpan);
        tableWrapData.heightHint = height;
        label.setLayoutData((Object)tableWrapData);
    }

    protected boolean validateBuildFile() {
        if (this.generateButton.getSelection()) {
            BuildOrderTableContentProvider provider = (BuildOrderTableContentProvider)this.orderTableViewer.getContentProvider();
            if (provider != null) {
                List<ILanguageDefinition> langDefList = provider.getLanguageDefinitionsWithTranslators();
                List<BuildOrderTableItem> itemList = provider.getItemList();
                if (langDefList != null && langDefList.isEmpty() && itemList != null && itemList.isEmpty()) {
                    this.addWarningMessage(this.orderTableViewer.getControl(), com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractEnterpriseConfigurationEditor_NoLanguageDefinitionsWarning, this.orderTableViewer.getControl());
                    return true;
                }
            }
        } else if (this.customButton.getSelection() && this.buildFileText.getText().trim().equals("")) {
            this.addErrorMessage(this.buildFileText, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_BUILD_FILE_REQUIRED, (Control)this.buildFileText);
            return false;
        }
        this.removeMessage(this.orderTableViewer.getControl(), this.orderTableViewer.getControl());
        this.removeMessage(this.buildFileText, (Control)this.buildFileText);
        return true;
    }

    protected void updateComponentState() {
        boolean generateBuildFile = this.generateButton.getSelection();
        Control[] controlArray = this.orderingComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control i = controlArray[n2];
            i.setEnabled(generateBuildFile);
            ++n2;
        }
        controlArray = this.buttonComposite.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            Control l = controlArray[n2];
            l.setEnabled(generateBuildFile);
            ++n2;
        }
        this.updateButtonState();
        controlArray = this.fieldComposite.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            Control j = controlArray[n2];
            j.setEnabled(!generateBuildFile);
            ++n2;
        }
    }

    protected void updateButtonState() {
        IStructuredSelection selection = (IStructuredSelection)this.orderTableViewer.getSelection();
        BuildOrderTableContentProvider provider = (BuildOrderTableContentProvider)this.orderTableViewer.getContentProvider();
        List<BuildOrderTableItem> itemList = provider.getItemList();
        if (itemList != null && selection.getFirstElement() != null) {
            int lastIndex = itemList.size() - 1;
            BuildOrderTableItem itemSelection = (BuildOrderTableItem)selection.getFirstElement();
            int selectionIndex = itemList.indexOf(itemSelection);
            int selectionSize = selection.size();
            int greatestIndex = 0;
            if (selectionSize > 1) {
                for (Object currSelection : selection.toList()) {
                    BuildOrderTableItem currItem = (BuildOrderTableItem)currSelection;
                    int currIndex = itemList.indexOf(currItem);
                    if (currIndex <= greatestIndex) continue;
                    greatestIndex = currIndex;
                }
            }
            this.moveUpButton.setEnabled(selectionIndex != 0);
            this.moveDownButton.setEnabled(selectionIndex != lastIndex - (selectionSize - 1) && lastIndex != greatestIndex);
            this.removeButton.setEnabled(true);
        } else {
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void widgetSelected(SelectionEvent event) {
        this.updateComponentState();
        Object eventSource = event.getSource();
        if (eventSource != this.generateButton && eventSource != this.customButton && eventSource != this.moveUpButton && eventSource != this.moveDownButton && eventSource != this.addButton && eventSource != this.removeButton) return;
        if (eventSource == this.generateButton || eventSource == this.customButton) {
            boolean useGeneratedBuildFile = this.generateButton.getSelection();
            IBuildConfigurationElement element = this.getWorkingCopy().getConfigurationElement(this.getConfigurationId());
            IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.useGeneratedBuildFile");
            property.setValue(Boolean.toString(useGeneratedBuildFile));
            if (eventSource == this.generateButton) {
                this.getWorkingCopy().setConfigurationProperty(this.getConfigurationId(), "team.enterprise.build.ant.generateReports", Boolean.toString(this.generateButton.getSelection()));
            }
        } else if (eventSource == this.moveUpButton || eventSource == this.moveDownButton) {
            StructuredSelection tableSelection = (StructuredSelection)this.orderTableViewer.getSelection();
            BuildOrderTableContentProvider contentProvider = (BuildOrderTableContentProvider)this.orderTableViewer.getContentProvider();
            List<BuildOrderTableItem> itemList = contentProvider.getItemList();
            if (eventSource == this.moveUpButton) {
                for (BuildOrderTableItem defItem : tableSelection.toList()) {
                    int originalIndex = itemList.indexOf(defItem);
                    BuildOrderTableItem removedObject = itemList.remove(originalIndex - 1);
                    itemList.add(originalIndex, removedObject);
                }
            } else if (eventSource == this.moveDownButton) {
                List selectionListItems = tableSelection.toList();
                int itemIndex = selectionListItems.size() - 1;
                while (itemIndex >= 0) {
                    BuildOrderTableItem def = (BuildOrderTableItem)selectionListItems.get(itemIndex);
                    int originalIndex = itemList.indexOf(def);
                    BuildOrderTableItem removedObject = itemList.remove(originalIndex);
                    itemList.add(originalIndex + 1, removedObject);
                    --itemIndex;
                }
            }
            this.getWorkingCopy().setConfigurationProperty(this.getConfigurationId(), "team.enterprise.build.ant.buildOrder", this.getCurrentBuildOrderPropertyValue());
            this.orderTableViewer.refresh();
            this.updateLabel();
            this.orderTableViewer.setSelection((ISelection)tableSelection);
            this.orderTableViewer.getTable().showSelection();
        } else if (eventSource == this.addButton) {
            ArrayList<UUID> existingUUIDList = new ArrayList<UUID>();
            List<BuildOrderTableItem> existingItemList = ((BuildOrderTableContentProvider)this.orderTableViewer.getContentProvider()).getItemList();
            for (BuildOrderTableItem existingItem : existingItemList) {
                existingUUIDList.add(existingItem.getLanguageDefinition().getItemId());
            }
            LanguageDefinitionSelectionDialog dialog = this.getLanguageDefintionSelectionDialog(this.getSite().getShell(), this.getTeamRepository(), null, this.getLangDefFilter(existingUUIDList), true);
            if (dialog.open() != 0) return;
            Object[] newRawTargets = dialog.getSelectedSystemDefinitions();
            ArrayList<ILanguageDefinition> convertedTargets = new ArrayList<ILanguageDefinition>();
            if (newRawTargets.length > 0 && newRawTargets[0] instanceof ILanguageDefinition) {
                Object[] objectArray = newRawTargets;
                int removedObject = newRawTargets.length;
                int originalIndex = 0;
                while (originalIndex < removedObject) {
                    Object o = objectArray[originalIndex];
                    ILanguageDefinition langDef = (ILanguageDefinition)o;
                    convertedTargets.add(langDef);
                    ++originalIndex;
                }
            }
            List<BuildOrderTableItem> itemList = ((BuildOrderTableContentProvider)this.orderTableViewer.getContentProvider()).getItemList();
            IProcessAreaHandle currentProcessArea = ((BuildOrderTableContentProvider)this.orderTableViewer.getContentProvider()).getCurrentProcessArea();
            for (ILanguageDefinition singleTarget : convertedTargets) {
                if (!currentProcessArea.getItemId().equals((Object)singleTarget.getProjectArea().getItemId())) {
                    itemList.add(new BuildOrderTableItem(singleTarget, true));
                    continue;
                }
                itemList.add(new BuildOrderTableItem(singleTarget));
            }
            this.orderTableViewer.refresh();
            this.updateLabel();
            this.getWorkingCopy().setConfigurationProperty(this.getConfigurationId(), "team.enterprise.build.ant.buildOrder", this.getCurrentBuildOrderPropertyValue());
        } else if (eventSource == this.removeButton) {
            boolean doRemove = MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_DIALOG_CONFIRM_REMOVE_TITLE, (String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_DIALOG_CONFIRM_REMOVE_MESSAGE);
            if (!doRemove) return;
            List<BuildOrderTableItem> itemList = ((BuildOrderTableContentProvider)this.orderTableViewer.getContentProvider()).getItemList();
            IStructuredSelection tableSelection = (IStructuredSelection)this.orderTableViewer.getSelection();
            List selectionList = tableSelection.toList();
            for (BuildOrderTableItem item : selectionList) {
                itemList.remove(item);
            }
            this.orderTableViewer.refresh();
            this.updateLabel();
            this.getWorkingCopy().setConfigurationProperty(this.getConfigurationId(), "team.enterprise.build.ant.buildOrder", this.getCurrentBuildOrderPropertyValue());
        }
        this.setDirty(true);
    }

    private void updateLabel() {
        if (this.orderTableViewer != null && this.orderTableViewer.getTable() != null && !this.orderTableViewer.getTable().isDisposed()) {
            if (this.orderTableViewer.getTable().getItemCount() == 0) {
                this.languageDefLabel.setText("");
            } else {
                this.languageDefLabel.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.NUMBER_OF_LANG_DEF_MULTIPLE, (Object)this.numSelected, (Object)this.orderTableViewer.getTable().getItemCount()));
            }
        }
    }

    protected abstract LanguageDefinitionSelectionDialog getLanguageDefintionSelectionDialog(Shell var1, ITeamRepository var2, IProjectArea var3, ViewerFilter var4, boolean var5);

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void modifyText(ModifyEvent event) {
        if (event.getSource() == this.buildTargetsText) {
            IBuildConfigurationElement element = this.getWorkingCopy().getConfigurationElement(this.getConfigurationId());
            IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.targets");
            if (property == null) {
                property = BuildItemFactory.createConfigurationProperty();
                property.setName("team.enterprise.build.ant.targets");
                element.getConfigurationProperties().add(property);
            }
            property.setValue(this.buildTargetsText.getText().trim());
            this.setDirty(true);
        } else if (event.getSource() == this.buildFileText) {
            IBuildConfigurationElement element = this.getWorkingCopy().getConfigurationElement(this.getConfigurationId());
            IConfigurationProperty buildFileProperty = element.getConfigurationProperty("team.enterprise.build.ant.buildFile");
            buildFileProperty.setValue(this.buildFileText.getText().trim());
            this.validateBuildFile();
            this.setDirty(true);
        } else if (event.getSource() == this.fUpdateFreSpinner) {
            IBuildProperty property = this.getWorkingCopy().getProperty("team.enterprise.build.dependency.preprocessUpdateF");
            String spinValue = String.valueOf(this.fUpdateFreSpinner.getSelection());
            if (property == null) {
                this.getWorkingCopy().setProperty("team.enterprise.build.dependency.preprocessUpdateF", spinValue);
                property = this.getWorkingCopy().getProperty("team.enterprise.build.dependency.preprocessUpdateF");
                if (property != null) {
                    property.setGenericEditAllowed(false);
                }
            } else {
                property.setValue(spinValue);
            }
            this.validateBuildFile();
            this.setDirty(true);
        }
    }

    public void selectionChanged(SelectionChangedEvent arg0) {
        this.updateButtonState();
    }

    protected String getCurrentBuildOrderPropertyValue() {
        BuildOrderTableContentProvider provider = (BuildOrderTableContentProvider)this.orderTableViewer.getContentProvider();
        ArrayList<BuildOrderProperty> buildOrderList = new ArrayList<BuildOrderProperty>();
        for (BuildOrderTableItem item : provider.getItemList()) {
            buildOrderList.add(new BuildOrderProperty(item.getLanguageDefinition(), true));
        }
        String encodedString = BuildOrderPropertyParser.getInstance().encodeString(buildOrderList);
        return encodedString;
    }

    public void checkStateChanged(CheckStateChangedEvent arg0) {
        this.getWorkingCopy().setConfigurationProperty(this.getConfigurationId(), "team.enterprise.build.ant.buildOrder", this.getCurrentBuildOrderPropertyValue());
        this.setDirty(true);
    }

    public void doubleClick(DoubleClickEvent event) {
        Object tableItem;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (tableItem = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof BuildOrderTableItem) {
            ILanguageDefinition langDef = ((BuildOrderTableItem)tableItem).getLanguageDefinition();
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            OpenLanguageDefEditorJob job = new OpenLanguageDefEditorJob(langDef, this.projectArea, page);
            job.setUser(true);
            job.schedule();
        }
    }

    public boolean validate() {
        boolean isValid = true;
        boolean isGenerate = true;
        if (!this.generateButton.isDisposed()) {
            isGenerate = this.generateButton.getSelection();
        }
        if (!isGenerate && this.buildFileText.getText().trim().equals("")) {
            this.addErrorMessageForRequiredField(this.buildFileText, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_BUILD_FILE_REQUIRED, (Control)this.buildFileText);
            isValid = false;
        } else {
            this.removeMessage(this.buildFileText, (Control)this.buildFileText);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    public Text getBuildFileText() {
        return this.buildFileText;
    }

    public Text getBuildTargetsText() {
        return this.buildTargetsText;
    }

    protected ViewerFilter getLangDefFilter(final List<UUID> duplicateList) {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if ("".equals(element) || element instanceof IProcessAreaHandle || element instanceof PendingUpdateAdapter) {
                    return true;
                }
                if (element instanceof ILanguageDefinition) {
                    ILanguageDefinition langDef = (ILanguageDefinition)element;
                    UUID langDefId = langDef.getItemId();
                    if (langDefId != null && duplicateList.contains(langDefId)) {
                        return false;
                    }
                    return langDef.getTranslators().size() > 0;
                }
                if (element instanceof List) {
                    List sublist = (List)element;
                    for (Object subitem : sublist) {
                        ILanguageDefinition langDef;
                        UUID langDefId;
                        if (!(subitem instanceof ILanguageDefinition) || (langDefId = (langDef = (ILanguageDefinition)subitem).getItemId()) == null || duplicateList.contains(langDefId) || langDef.getTranslators().size() <= 0) continue;
                        return true;
                    }
                    return false;
                }
                return false;
            }
        };
    }

    protected void refreshOrderingControl() {
        this.orderTableViewer.setInput((Object)this.getWorkingCopy().getProcessArea());
        this.orderTableViewer.refresh();
        this.updateLabel();
    }

    public void setWorkingCopy(IBuildDefinition definition) {
        if (this.fBuildDefinitionWorkingCopy != null) {
            ((BuildDefinition)this.fBuildDefinitionWorkingCopy).eAdapters().remove((Object)this.fPropertyChangedListener);
        }
        this.fBuildDefinitionWorkingCopy = definition;
        ((BuildDefinition)this.fBuildDefinitionWorkingCopy).eAdapters().add((Object)this.fPropertyChangedListener);
    }

    protected void addControlDecorator(Control targetControl, String descriptionText, int style) {
        final ControlDecoration dec = new ControlDecoration(targetControl, style);
        if (targetControl instanceof Text) {
            dec.setMarginWidth(2);
        }
        dec.setDescriptionText(descriptionText);
        dec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        dec.hide();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 26) {
                    dec.show();
                }
                if (event.type == 27) {
                    dec.hide();
                }
            }
        };
        targetControl.addListener(26, listener);
        targetControl.addListener(27, listener);
    }

    protected abstract void createAdvancedWidgets(Composite var1);

    protected abstract FormToolkit getToolkit();

    protected abstract IBuildDefinition getWorkingCopy();

    protected abstract String getConfigurationId();

    protected abstract Class<? extends IPlatformObject> getPlatform();

    protected class BuildOrderTableContentProvider
    implements IStructuredContentProvider {
        protected IProcessAreaHandle currentProcessArea = null;
        protected List<BuildOrderTableItem> contentList = null;
        protected Map<String, ILanguageDefinition> languageMap = null;
        protected List<IBuildOrderProperty> propertyList = null;
        protected List<ILanguageDefinition> langDefsWithTranslators = null;
        protected Job fetchLangDefsJob = null;
        protected Job fetchExternalLangDefsJob = null;

        public BuildOrderTableContentProvider() {
            this.fetchLangDefsJob = new FetchLangDefJob(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_JOBNAME_FETCHLANGDEFS, true, AbstractEnterpriseConfigurationEditor.this.getTeamRepository());
            this.fetchExternalLangDefsJob = new FetchExternalLangDefJob(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_JOBNAME_FETCHLANGDEFS, true, AbstractEnterpriseConfigurationEditor.this.getTeamRepository());
        }

        public List<BuildOrderTableItem> getItemList() {
            return this.contentList;
        }

        public List<ILanguageDefinition> getLanguageDefinitionsWithTranslators() {
            if (this.langDefsWithTranslators != null) {
                return this.langDefsWithTranslators;
            }
            return new ArrayList<ILanguageDefinition>();
        }

        public IProcessAreaHandle getCurrentProcessArea() {
            return this.currentProcessArea;
        }

        public void dispose() {
            if (this.languageMap != null) {
                this.languageMap.clear();
            }
            if (this.propertyList != null) {
                this.propertyList.clear();
            }
            if (this.langDefsWithTranslators != null) {
                this.langDefsWithTranslators.clear();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof IProcessAreaHandle) {
                if (AbstractEnterpriseConfigurationEditor.this.projectArea != null) {
                    this.fetchLangDefsJob.schedule();
                }
            } else if (newInput instanceof List) {
                this.propertyList = (List)newInput;
                this.fetchExternalLangDefsJob.schedule();
            }
        }

        public Object[] getElements(Object arg0) {
            Object[] objectArray;
            if (this.contentList == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_JOBNAME_FETCHLANGDEFS;
            } else {
                objectArray = this.contentList.toArray();
            }
            return objectArray;
        }

        public Object[] getEnabledElements() {
            if (this.propertyList != null && !this.propertyList.isEmpty()) {
                ArrayList<BuildOrderTableItem> enabledElements = new ArrayList<BuildOrderTableItem>();
                for (IBuildOrderProperty prop : this.propertyList) {
                    if (!prop.isPropertyEnabled()) continue;
                    String UUID2 = prop.getPropertyUUID();
                    enabledElements.add(new BuildOrderTableItem(this.languageMap.get(UUID2)));
                }
                return enabledElements.toArray();
            }
            return null;
        }

        class FetchExternalLangDefJob
        extends FetchLangDefJob {
            FetchExternalLangDefJob(String jobName, boolean isUserJob, ITeamRepository repo) {
                super(jobName, isUserJob, repo);
            }

            @Override
            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                super.runProtected(monitor);
                if (!BuildOrderTableContentProvider.this.contentList.isEmpty()) {
                    BuildOrderTableContentProvider.this.contentList.clear();
                }
                ArrayList<String> failedUUIDs = new ArrayList<String>(BuildOrderTableContentProvider.this.propertyList.size());
                for (IBuildOrderProperty currProp : BuildOrderTableContentProvider.this.propertyList) {
                    ILanguageDefinition langDef = BuildOrderTableContentProvider.this.languageMap.get(currProp.getPropertyUUID());
                    BuildOrderTableItem tableDef = null;
                    if (langDef == null) {
                        try {
                            ISystemDefinitionModelClient langDefClient = (ISystemDefinitionModelClient)AbstractEnterpriseConfigurationEditor.this.getTeamRepository().getClientLibrary(ISystemDefinitionModelClient.class);
                            langDef = (ILanguageDefinition)langDefClient.findSystemDefinitionComplete(currProp.getPropertyUUID(), null, ILanguageDefinition.ITEM_TYPE, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (TeamRepositoryException e) {
                            failedUUIDs.add(currProp.getPropertyUUID());
                        }
                        if (langDef != null) {
                            tableDef = new BuildOrderTableItem(langDef, true);
                        }
                    } else {
                        tableDef = new BuildOrderTableItem(langDef);
                    }
                    if (tableDef == null) continue;
                    BuildOrderTableContentProvider.this.contentList.add(tableDef);
                }
                if (failedUUIDs.size() > 0) {
                    final String detailedMessage = NLS.bind((String)"Error trying to fetch all the configured language definitions for the build definition ''{0}'' from the project area.", (Object)((BuildOrderTableContentProvider)BuildOrderTableContentProvider.this).AbstractEnterpriseConfigurationEditor.this.fBuildDefinitionWorkingCopy.getId());
                    String message = "Error restoring build configuration.";
                    String title = "Build definition configuration load";
                    Activator.log((String)detailedMessage);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ErrorDialog.openError((Shell)AbstractEnterpriseConfigurationEditor.this.getSite().getShell(), (String)"Build definition configuration load", (String)"Error restoring build configuration.", (IStatus)new Status(4, "com.ibm.team.enterprise.common.ui", detailedMessage));
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        }

        class FetchLangDefJob
        extends TeamBuildJob {
            FetchLangDefJob(String jobName, boolean isUserJob, ITeamRepository repo) {
                super(jobName, isUserJob, repo);
            }

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                BuildOrderTableContentProvider.this.currentProcessArea = AbstractEnterpriseConfigurationEditor.this.projectArea;
                ISystemDefinitionModelClient langDefClient = (ISystemDefinitionModelClient)AbstractEnterpriseConfigurationEditor.this.getTeamRepository().getClientLibrary(ISystemDefinitionModelClient.class);
                try {
                    BuildOrderTableContentProvider.this.langDefsWithTranslators = new ArrayList<ILanguageDefinition>();
                    IItemType langType = AbstractEnterpriseConfigurationEditor.this.getPlatform().equals(IZosPlatformObject.class) ? IZosLanguageDefinition.ITEM_TYPE : IIBMiLanguageDefinition.ITEM_TYPE;
                    List langsFound = langDefClient.findSystemDefinitionsComplete(langType, AbstractEnterpriseConfigurationEditor.this.projectArea, -1, false, (IProgressMonitor)new NullProgressMonitor());
                    for (ISystemDefinition sysDef : langsFound) {
                        ILanguageDefinition langDef = (ILanguageDefinition)sysDef;
                        List translators = langDef.getTranslators();
                        if (translators == null || translators.isEmpty()) continue;
                        BuildOrderTableContentProvider.this.langDefsWithTranslators.add(langDef);
                    }
                    if (BuildOrderTableContentProvider.this.contentList != null) {
                        BuildOrderTableContentProvider.this.contentList.clear();
                    } else {
                        BuildOrderTableContentProvider.this.contentList = new ArrayList<BuildOrderTableItem>();
                    }
                    for (ILanguageDefinition currDef : BuildOrderTableContentProvider.this.langDefsWithTranslators) {
                        BuildOrderTableContentProvider.this.contentList.add(new BuildOrderTableItem(currDef));
                    }
                    if (BuildOrderTableContentProvider.this.languageMap != null) {
                        BuildOrderTableContentProvider.this.languageMap.clear();
                    } else {
                        BuildOrderTableContentProvider.this.languageMap = new HashMap<String, ILanguageDefinition>();
                    }
                    for (ISystemDefinition sysDef : langsFound) {
                        ILanguageDefinition currDef = (ILanguageDefinition)sysDef;
                        BuildOrderTableContentProvider.this.languageMap.put(currDef.getItemId().getUuidValue(), currDef);
                    }
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!AbstractEnterpriseConfigurationEditor.this.orderTableViewer.getControl().isDisposed()) {
                            AbstractEnterpriseConfigurationEditor.this.orderTableViewer.refresh(true);
                            AbstractEnterpriseConfigurationEditor.this.updateLabel();
                        }
                    }
                });
            }
        }
    }

    protected class BuildOrderTableItem {
        protected boolean isExternal = false;
        protected ILanguageDefinition languageDefinition;

        public BuildOrderTableItem(ILanguageDefinition langDef) {
            this.languageDefinition = langDef;
        }

        public BuildOrderTableItem(ILanguageDefinition langDef, boolean showProjectArea) {
            this(langDef);
            this.isExternal = showProjectArea;
        }

        public boolean isProjectAreaVisible() {
            return this.isExternal;
        }

        public ILanguageDefinition getLanguageDefinition() {
            return this.languageDefinition;
        }
    }

    protected class BuildOrderTableLabelProvider
    implements ITableLabelProvider {
        protected IItemManager itemManager = null;

        protected BuildOrderTableLabelProvider() {
        }

        public Image getColumnImage(Object arg0, int arg1) {
            return null;
        }

        public String getColumnText(Object item, int arg1) {
            if (this.itemManager == null) {
                this.itemManager = AbstractEnterpriseConfigurationEditor.this.getTeamRepository().itemManager();
            }
            if (item instanceof BuildOrderTableItem) {
                ILanguageDefinition langDefItem = ((BuildOrderTableItem)item).getLanguageDefinition();
                String columnText = langDefItem.getName();
                if (langDefItem.isArchived()) {
                    columnText = String.valueOf(columnText) + com.ibm.team.enterprise.internal.build.ui.nls.Messages.SystemDefinition_ARCHIVED_SUFFIX;
                }
                if (((BuildOrderTableItem)item).isExternal) {
                    try {
                        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(langDefItem.getProjectArea().getItemId(), null);
                        IProjectArea parentPA = (IProjectArea)this.itemManager.fetchCompleteItem((IItemHandle)projectAreaHandle, 0, (IProgressMonitor)new NullProgressMonitor());
                        String projectAreaName = parentPA.getName();
                        String returnString = columnText.concat(" (" + projectAreaName + ")");
                        return returnString;
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                }
                return columnText;
            }
            if (item instanceof String) {
                return (String)item;
            }
            return null;
        }

        public void addListener(ILabelProviderListener arg0) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object arg0, String arg1) {
            return false;
        }

        public void removeListener(ILabelProviderListener arg0) {
        }
    }

    protected class OpenLanguageDefEditorJob
    extends TeamBuildJob {
        private final ILanguageDefinition languageDefinition;
        private final IProjectAreaHandle projectAreaHandle;
        private final IWorkbenchPage workbenchPage;

        public OpenLanguageDefEditorJob(ILanguageDefinition langdef, IProjectAreaHandle projectArea, IWorkbenchPage workbenchPage) {
            super(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditor_JOBNAME_FETCHLANGDEFS, false);
            this.languageDefinition = langdef;
            this.projectAreaHandle = projectArea;
            this.workbenchPage = workbenchPage;
        }

        protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
            ISystemDefinitionModelClient langDefClient = (ISystemDefinitionModelClient)AbstractEnterpriseConfigurationEditor.this.getTeamRepository().getClientLibrary(ISystemDefinitionModelClient.class);
            ILanguageDefinition langDef = (ILanguageDefinition)langDefClient.fetchSystemDefinitionComplete((ISystemDefinitionHandle)this.languageDefinition, true, (IProgressMonitor)new NullProgressMonitor());
            if (langDef != null) {
                if (langDef instanceof IZosPlatformObject) {
                    com.ibm.team.enterprise.zos.internal.systemdefinition.ui.domain.actions.EditSystemDefinitionActionDelegate.run((ISystemDefinition)langDef, (IProjectAreaHandle)this.projectAreaHandle, (IWorkbenchPage)this.workbenchPage, (boolean)true, (boolean)true);
                } else if (langDef instanceof IIBMiPlatformObject) {
                    EditSystemDefinitionActionDelegate.run((ISystemDefinition)langDef, (IProjectAreaHandle)this.projectAreaHandle, (IWorkbenchPage)this.workbenchPage, (boolean)true, (boolean)true);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

