/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.editors;

import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.scm.LoadComponents;
import com.ibm.team.enterprise.build.client.buildablesubset.IBuildableSubsetClient;
import com.ibm.team.enterprise.build.common.EnterpriseRequestDialogOption;
import com.ibm.team.enterprise.build.common.Messages;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.dialogs.ComponentSelectionDialog;
import com.ibm.team.enterprise.build.ui.editors.AbstractEnterpriseConfigurationEditor;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetSelectionDialog;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetTextTooltipSupport;
import com.ibm.team.enterprise.buildablesubset.common.impl.BuildableSubsetHandle;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.common.ui.dialogs.MessagePromptDialog;
import com.ibm.team.enterprise.systemdefinition.client.SystemDefinitionHandleCache;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.internal.client.ProcessClientService;
import com.ibm.team.process.internal.ide.ui.ProcessIdeUIPlugin;
import com.ibm.team.process.internal.ide.ui.extension.IConfigurationPointExtension;
import com.ibm.team.process.internal.ide.ui.extension.OperationExtension;
import com.ibm.team.process.internal.ide.ui.extension.ProcessExtensionRegistry;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractCompoundDependencyBuildConfigurationEditor
extends AbstractEnterpriseConfigurationEditor
implements SelectionListener,
ModifyListener,
ISelectionChangedListener {
    protected IManagedForm fManagedForm;
    protected Composite fContentContainer;
    protected FormToolkit fToolkit;
    protected CTabFolder tabFolder;
    private int tabFolderIndex = 0;
    protected CTabItem generalTab;
    protected CTabItem optionsTab;
    protected CTabItem requestTab;
    private Composite dependencyOptionsTab;
    private Composite dependencyGeneralTab;
    private Composite dependencyRequestTab;
    protected Text subsetText;
    protected Button buildAllButton;
    protected Button buildSubsetButton;
    protected Button buildChangedButton;
    protected Button allowAdditionalFlowsInputs;
    protected Button skipDependencyDataUpdate;
    protected Button browseSubsetButton;
    protected Button buildDependencySets;
    protected Button conditionButton;
    protected Button reportButton;
    protected Text antHomeText;
    protected Text antArgsText;
    protected Text javaHomeText;
    protected Text javaArgsText;
    protected Text propertiesFileText;
    protected Text workingDirText;
    protected Button mandatorySubsetButton;
    protected Text mandatorySubsetText;
    protected Button browseMandatorySubsetButton;
    protected Button useMandatorySubsetInPersonalButton;
    protected Button trustOutputsButton;
    protected Button publishBuildMapLinksButton;
    protected Button deleteOutputsButton;
    protected Button impactInputsButton;
    protected Button impactParserOutputsButton;
    protected Button impactAlwaysBuildButton;
    protected Text excludedComponentField;
    protected Button excludedComponentSelectBtn;
    protected Button excludedComponentClearBtn;
    protected Button excludeRadioBtn;
    protected Button includeRadioBtn;
    protected IWorkspace buildWorkspace;
    protected LocalResourceManager mgr;
    protected ImageDescriptor selectedCheckboxImageDescriptor;
    protected ImageDescriptor deselectedCheckboxImageDescriptor;
    protected Image selectedCheckboxImage;
    protected Image deselectedCheckboxImage;
    protected Image disabledSelectedCheckboxImage;
    protected Image disabledDeselectedCheckboxImage;
    protected Image grayedCheckboxImage;
    protected List<EnterpriseRequestDialogOption> requestVisbilityOptions;
    protected TreeViewer visibilityTreeViewer;
    protected Composite visibilityTreeComposite;
    protected Boolean isUserJazzAdmin;
    protected Map<String, String> permissionTooltips = new HashMap<String, String>();
    protected Map<String, Boolean> permissionCache;
    private IAction copyVisibilityAction;
    private IAction pasteVisibilityAction;
    private IAction checkVisibilityTeamAction;
    private IAction uncheckVisibilityTeamAction;
    private IAction checkVisibilityPersonalAction;
    private IAction uncheckVisibilityPersonalAction;

    public AbstractCompoundDependencyBuildConfigurationEditor(String elementId, String title) {
        super(elementId, title);
    }

    protected abstract String getContextHelpId();

    protected void createTabs(FormToolkit toolkit) {
        this.generalTab = this.createTab(toolkit, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_TAB_GENERAL);
        this.optionsTab = this.createTab(toolkit, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_TAB_DEPENDENCY);
        this.requestTab = this.createTab(toolkit, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_TAB_REQUEST);
    }

    protected CTabItem createTab(FormToolkit toolkit, String title) {
        CTabItem item = new CTabItem(this.tabFolder, 0);
        item.setText(title);
        return item;
    }

    public void createContent(Composite parent, FormToolkit toolkit) {
        SystemDefinitionHandleCache.getInstance().deleteCache(this.getTeamRepository(), IResourceDefinition.ITEM_TYPE);
        SystemDefinitionHandleCache.getInstance().deleteCache(this.getTeamRepository(), ITranslator.ITEM_TYPE);
        this.initImages();
        this.permissionCache = new HashMap<String, Boolean>();
        this.fToolkit = toolkit;
        parent.setLayout((Layout)new TableWrapLayout());
        TableWrapData data = new TableWrapData(256, 256);
        parent.setLayoutData((Object)data);
        this.tabFolder = new CTabFolder(parent, 0x800080);
        toolkit.adapt((Control)this.tabFolder, true, true);
        this.tabFolder.setLayout((Layout)new TableWrapLayout());
        this.tabFolder.setLayoutData((Object)data);
        toolkit.paintBordersFor((Composite)this.tabFolder);
        this.createTabs(toolkit);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCompoundDependencyBuildConfigurationEditor.this.tabFolderIndex = AbstractCompoundDependencyBuildConfigurationEditor.this.tabFolder.getSelectionIndex();
                AbstractCompoundDependencyBuildConfigurationEditor.this.updateSelection();
            }
        });
        this.tabFolder.setSelection(this.tabFolderIndex);
        this.updateSelection();
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.TB_BG");
        this.tabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{100}, true);
        this.tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(22));
        this.dependencyGeneralTab = this.createGeneralTab((Composite)this.tabFolder, toolkit);
        this.generalTab.setControl((Control)this.dependencyGeneralTab);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.dependencyGeneralTab, this.getContextHelpId());
        this.dependencyOptionsTab = this.createDependencyOptionsTab((Composite)this.tabFolder, toolkit);
        this.optionsTab.setControl((Control)this.dependencyOptionsTab);
        this.dependencyRequestTab = this.createDependencyRequestTab((Composite)this.tabFolder, toolkit);
        this.requestTab.setControl((Control)this.dependencyRequestTab);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.dependencyOptionsTab, this.getOptionsTabContextHelpId());
        this.updateComponentState();
    }

    protected void initImages() {
        if (this.mgr == null) {
            this.mgr = new LocalResourceManager(JFaceResources.getResources());
            this.selectedCheckboxImageDescriptor = ProcessIdeUIPlugin.getImageDescriptor((String)"icons/obj16/permyes_obj.gif");
            this.deselectedCheckboxImageDescriptor = ProcessIdeUIPlugin.getImageDescriptor((String)"icons/obj16/permno_obj.gif");
            this.selectedCheckboxImage = this.mgr.createImageWithDefault(this.selectedCheckboxImageDescriptor);
            this.deselectedCheckboxImage = this.mgr.createImageWithDefault(this.deselectedCheckboxImageDescriptor);
            this.disabledDeselectedCheckboxImage = this.mgr.createImageWithDefault(ProcessIdeUIPlugin.getImageDescriptor((String)"icons/obj16/perminhdno_obj.gif"));
            this.disabledSelectedCheckboxImage = this.mgr.createImageWithDefault(ProcessIdeUIPlugin.getImageDescriptor((String)"icons/obj16/perminhdyes_obj.gif"));
            this.grayedCheckboxImage = this.mgr.createImageWithDefault(ProcessIdeUIPlugin.getImageDescriptor((String)"icons/obj16/permpart_obj.gif"));
        }
    }

    private boolean isUserJazzAdmin() {
        try {
            ProcessClientService processClient = (ProcessClientService)this.getTeamRepository().getClientLibrary(IProcessItemService.class);
            return processClient.assertPermission("JazzAdmins", null);
        }
        catch (Exception e) {
            Activator.getDefault().logError(e);
            return false;
        }
    }

    private boolean userHasPermission(String operation, String action) {
        String key = String.valueOf(operation) + "|" + action;
        Boolean hasPermission = this.permissionCache.get(key);
        if (hasPermission == null) {
            try {
                IProcessAreaHandle processAreaHandle = this.getWorkingCopy().getProcessArea();
                IProcessArea processArea = (IProcessArea)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)processAreaHandle, 0, null);
                IProcessClientService processService = (IProcessClientService)this.getTeamRepository().getClientLibrary(IProcessClientService.class);
                IClientProcess clientProcess = processService.getClientProcess(processArea, null);
                boolean[] permitted = clientProcess.getPermittedActions(processArea, operation, new String[]{action}, null);
                hasPermission = permitted[0];
            }
            catch (Exception e) {
                Activator.getDefault().logError(e);
                hasPermission = false;
            }
            this.permissionCache.put(key, hasPermission);
        }
        return hasPermission;
    }

    protected String getOptionsTabContextHelpId() {
        return "com.ibm.team.build.ui.editor_builddefinitiondependencyoptions";
    }

    private Composite createGeneralTab(Composite folderParent, FormToolkit toolkit) {
        Composite parent = new Composite(folderParent, 0);
        parent.setLayout((Layout)new TableWrapLayout());
        TableWrapData data = new TableWrapData();
        data.grabHorizontal = true;
        parent.setLayoutData((Object)data);
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.createBuildFileSection(parent, toolkit);
        this.createPlatformSpecificSections(parent, toolkit);
        this.createConfigurationSection(parent, toolkit);
        return parent;
    }

    protected Composite createDependencyOptionsTab(Composite folderParent, FormToolkit toolkit) {
        Composite parent = new Composite(folderParent, 0);
        parent.setLayout((Layout)new TableWrapLayout());
        TableWrapData data = new TableWrapData();
        data.grabHorizontal = true;
        parent.setLayoutData((Object)data);
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.createBuildTargetSection(parent, toolkit);
        this.createPersonalBuildDefaultsSection(parent, toolkit);
        this.createAdvancedOptions(parent, toolkit);
        return parent;
    }

    protected Composite createDependencyRequestTab(Composite folderParent, FormToolkit toolkit) {
        Composite parent = new Composite(folderParent, 0);
        parent.setLayout((Layout)new TableWrapLayout());
        TableWrapData data = new TableWrapData();
        data.grabHorizontal = true;
        parent.setLayoutData((Object)data);
        parent.setBackground(Display.getCurrent().getSystemColor(1));
        this.createRequestOptionsSection(parent, toolkit);
        return parent;
    }

    private void createConfigurationSection(Composite parent, FormToolkit toolkit) {
        Section configurationSection = toolkit.createSection(parent, 418);
        configurationSection.setLayoutData((Object)new TableWrapData(256, 256));
        configurationSection.setLayout((Layout)new TableWrapLayout());
        configurationSection.setText(Messages.EnterpriseRequestDialogOption_CATEGORY_ANT_WITH_EE_CONFIGURATION);
        configurationSection.setDescription(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_CONFIG_SECTION_DESCRIPTION);
        Composite composite = toolkit.createComposite((Composite)configurationSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.createAntHomeWidgets(composite);
        this.createAntArgsWidgets(composite);
        this.createWorkingDirWidgets(composite);
        this.createJavaHomeWidgets(composite);
        this.createJavaArgsWidgets(composite);
        this.createPropertiesFileWidgets(composite);
        configurationSection.setClient((Control)composite);
    }

    private void createAntHomeWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.antHome");
        this.antHomeText = this.createLabeledText(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_ANT_HOME_LABEL, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_ANT_HOME_DESC, property.getValue());
        this.antHomeText.addModifyListener((ModifyListener)this);
    }

    private void createAntArgsWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.antArgs");
        this.antArgsText = this.createLabeledText(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_ANT_ARGS_LABEL, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_ANT_ARGS_DESC, property.getValue());
        this.antArgsText.addModifyListener((ModifyListener)this);
    }

    private void createJavaHomeWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.javaHome");
        this.javaHomeText = this.createLabeledText(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_JAVA_HOME_LABEL, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_JAVA_HOME_DESC, property.getValue());
        this.javaHomeText.addModifyListener((ModifyListener)this);
    }

    private void createJavaArgsWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.javaVMArgs");
        this.javaArgsText = this.createLabeledText(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_VM_ARGS_LABEL, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_VM_ARGS_DESC, property.getValue());
        this.javaArgsText.addModifyListener((ModifyListener)this);
    }

    private void createPropertiesFileWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.propertiesFile");
        this.propertiesFileText = this.createLabeledText(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_PROPERTIES_LABEL, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_PROPERTIES_DESC, property.getValue());
        this.propertiesFileText.addModifyListener((ModifyListener)this);
    }

    private void createWorkingDirWidgets(Composite parent) {
        IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
        IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.workingDir");
        this.workingDirText = this.createLabeledText(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_WORKING_DIR_LABEL, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AntConfigurationEditor_WORKING_DIR_DESC, property.getValue());
        this.workingDirText.addModifyListener((ModifyListener)this);
    }

    private void createBuildTargetSection(Composite parent, FormToolkit toolkit) {
        Section targetSection = this.fToolkit.createSection(parent, 384);
        targetSection.setLayoutData((Object)new TableWrapData(256, 256));
        targetSection.setLayout((Layout)new TableWrapLayout());
        targetSection.setDescription(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_SECTION_BUILDTARGET_DESCRIPTION);
        targetSection.setText(Messages.EnterpriseRequestDialogOption_CATEOGRY_BUILD_SCOPE);
        Composite buttonComposite = this.fToolkit.createComposite((Composite)targetSection);
        buttonComposite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout buttonLayout = new TableWrapLayout();
        buttonLayout.numColumns = 4;
        buttonLayout.makeColumnsEqualWidth = false;
        buttonComposite.setLayout((Layout)buttonLayout);
        this.buildAllButton = this.fToolkit.createButton(buttonComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_BUTTON_BUILD_WORKSPACE, 16);
        TableWrapData allButtonData = new TableWrapData();
        allButtonData.colspan = 4;
        this.buildAllButton.setLayoutData((Object)allButtonData);
        this.buildSubsetButton = this.fToolkit.createButton(buttonComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_BUTTON_BUILD_SUBSET, 16);
        this.buildSubsetButton.setLayoutData((Object)new TableWrapData());
        this.buildSubsetButton.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_LABEL_SUBSET_COMBO);
        this.addControlDecorator((Control)this.buildSubsetButton, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_LABEL_SUBSET_COMBO, 131072);
        IBuildProperty subsetProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.buildableSubset");
        String subsetPropertyValue = subsetProperty != null ? subsetProperty.getValue() : "";
        this.subsetText = this.fToolkit.createText(buttonComposite, subsetPropertyValue, 8);
        if (!subsetPropertyValue.isEmpty()) {
            this.subsetText.setData((Object)BuildableSubsetUtil.getSlug((String)subsetPropertyValue, (String)this.fBuildDefinitionWorkingCopy.getItemId().getUuidValue()));
            this.subsetText.setData("subset_handle", (Object)new BuildableSubsetHandle(subsetPropertyValue, this.fBuildDefinitionWorkingCopy.getItemId(), this.fBuildDefinitionWorkingCopy.getOrigin()));
        }
        TableWrapData data = new TableWrapData(256);
        data.colspan = 2;
        data.indent = 5;
        this.subsetText.setLayoutData((Object)data);
        this.subsetText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_BUTTON_BUILD_SUBSET;
            }
        });
        new BuildSubsetTextTooltipSupport(this.subsetText);
        this.browseSubsetButton = this.fToolkit.createButton(buttonComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseBuildUI_BUTTON_BROWSE, 8);
        this.browseSubsetButton.setLayoutData((Object)new TableWrapData());
        this.browseSubsetButton.addSelectionListener((SelectionListener)this);
        this.buildAllButton.setSelection(subsetPropertyValue.isEmpty());
        this.buildSubsetButton.setSelection(!subsetPropertyValue.isEmpty());
        this.buildAllButton.addSelectionListener((SelectionListener)this);
        this.buildSubsetButton.addSelectionListener((SelectionListener)this);
        this.mandatorySubsetButton = this.fToolkit.createButton(buttonComposite, Messages.EnterpriseRequestDialogOption_MANDATORY_SUBSET, 32);
        this.mandatorySubsetButton.setLayoutData((Object)new TableWrapData());
        this.mandatorySubsetButton.addSelectionListener((SelectionListener)this);
        this.mandatorySubsetButton.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_LABEL_MANDATORY_SUBSET_DECORATOR);
        this.addControlDecorator((Control)this.mandatorySubsetButton, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_LABEL_MANDATORY_SUBSET_DECORATOR, 131072);
        IBuildProperty mandatorySubsetProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.mandatorySubset");
        String mandatorySubsetSlug = mandatorySubsetProperty != null ? mandatorySubsetProperty.getValue() : null;
        String mandatorySubsetLabel = BuildableSubsetUtil.getLabelFromSlug((String)mandatorySubsetSlug);
        this.mandatorySubsetText = this.fToolkit.createText(buttonComposite, mandatorySubsetLabel == null ? "" : mandatorySubsetLabel, 8);
        this.mandatorySubsetText.setData((Object)mandatorySubsetSlug);
        this.mandatorySubsetText.setData("subset_handle", (Object)new BuildableSubsetHandle(mandatorySubsetLabel, this.fBuildDefinitionWorkingCopy.getItemId(), this.fBuildDefinitionWorkingCopy.getOrigin()));
        data = new TableWrapData(256);
        data.colspan = 2;
        data.indent = 5;
        this.mandatorySubsetText.setLayoutData((Object)data);
        this.mandatorySubsetText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent event) {
                event.result = "";
            }
        });
        new BuildSubsetTextTooltipSupport(this.mandatorySubsetText);
        this.browseMandatorySubsetButton = this.fToolkit.createButton(buttonComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseBuildUI_BUTTON_BROWSE, 8);
        this.browseMandatorySubsetButton.setLayoutData((Object)new TableWrapData());
        this.browseMandatorySubsetButton.addSelectionListener((SelectionListener)this);
        if (mandatorySubsetLabel != null && !mandatorySubsetLabel.isEmpty()) {
            this.mandatorySubsetButton.setSelection(true);
        } else {
            this.mandatorySubsetText.setEnabled(false);
            this.browseMandatorySubsetButton.setEnabled(false);
        }
        this.useMandatorySubsetInPersonalButton = this.fToolkit.createButton(buttonComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_BUTTON_USE_MANDATORY_SUBSET_IN_PERSONAL, 32);
        this.useMandatorySubsetInPersonalButton.setSelection(Boolean.parseBoolean(this.fBuildDefinitionWorkingCopy.getPropertyValue("team.enterprise.build.ant.mandatorySubset.useInPersonal", null)));
        this.useMandatorySubsetInPersonalButton.setEnabled(this.mandatorySubsetButton.getSelection());
        this.useMandatorySubsetInPersonalButton.addSelectionListener((SelectionListener)this);
        TableWrapData mandPersData = new TableWrapData();
        mandPersData.indent = 15;
        mandPersData.colspan = 4;
        this.useMandatorySubsetInPersonalButton.setLayoutData((Object)mandPersData);
        this.createSpacer(buttonComposite, -1, 4);
        this.buildChangedButton = this.fToolkit.createButton(buttonComposite, Messages.EnterpriseRequestDialogOption_BUILD_CHANGED_ITEMS_ONLY, 32);
        TableWrapData buildChangedData = new TableWrapData();
        buildChangedData.colspan = 4;
        this.buildChangedButton.setLayoutData((Object)buildChangedData);
        this.buildChangedButton.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_LABEL_BUILDCHANGED);
        this.addControlDecorator((Control)this.buildChangedButton, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_LABEL_BUILDCHANGED, 131072);
        IBuildProperty dependencyProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.buildChangesOnly");
        if (dependencyProperty != null) {
            boolean isDependencyBuild = Boolean.parseBoolean(dependencyProperty.getValue());
            this.buildChangedButton.setSelection(isDependencyBuild);
        } else {
            this.buildChangedButton.setSelection(true);
        }
        this.buildChangedButton.addSelectionListener((SelectionListener)this);
        TableWrapData skipDependencyCols = new TableWrapData();
        skipDependencyCols.colspan = 4;
        boolean skipDependencyUpdate = Boolean.valueOf(this.fBuildDefinitionWorkingCopy.getPropertyValue("team.enterprise.build.skipDependencyDataUpdate", Boolean.FALSE.toString()));
        this.skipDependencyDataUpdate = this.fToolkit.createButton(buttonComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_SKIP_DEPENDENCY_DATA_UPDATE_LABEL, 32);
        this.skipDependencyDataUpdate.setLayoutData((Object)skipDependencyCols);
        this.skipDependencyDataUpdate.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_SKIP_DEPENDENCY_DATA_UPDATE_DESC);
        this.skipDependencyDataUpdate.setSelection(skipDependencyUpdate);
        this.skipDependencyDataUpdate.addSelectionListener((SelectionListener)this);
        this.addControlDecorator((Control)this.skipDependencyDataUpdate, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_SKIP_DEPENDENCY_DATA_UPDATE_DESC, 131072);
        TableWrapData allowAdditionalCols = new TableWrapData();
        allowAdditionalCols.colspan = 4;
        boolean allowAdditionalFlows = Boolean.valueOf(this.fBuildDefinitionWorkingCopy.getConfigurationPropertyValue(this.getConfigurationId(), "team.enterprise.build.dependency.resolveAdditionalFlowsDependencies", Boolean.FALSE.toString()));
        this.allowAdditionalFlowsInputs = this.fToolkit.createButton(buttonComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_ADDITIONAL_FLOWS_BUILD_WKS_LABEL, 32);
        this.allowAdditionalFlowsInputs.setLayoutData((Object)allowAdditionalCols);
        this.allowAdditionalFlowsInputs.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_ADDITIONAL_FLOWS_BUILD_WKS_DESC);
        this.allowAdditionalFlowsInputs.setSelection(allowAdditionalFlows);
        this.allowAdditionalFlowsInputs.addSelectionListener((SelectionListener)this);
        this.addControlDecorator((Control)this.allowAdditionalFlowsInputs, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_ADDITIONAL_FLOWS_BUILD_WKS_DESC, 131072);
        this.createSpacer(buttonComposite, -1, 4);
        Composite excludedComponentComposite = this.fToolkit.createComposite(buttonComposite);
        TableWrapData excludedComponentCompositeLayoutData = new TableWrapData(256, 256);
        excludedComponentCompositeLayoutData.colspan = 4;
        excludedComponentComposite.setLayoutData((Object)excludedComponentCompositeLayoutData);
        TableWrapLayout excludedComponentCompositeLayout = new TableWrapLayout();
        excludedComponentCompositeLayout.leftMargin = 0;
        excludedComponentCompositeLayout.rightMargin = 0;
        excludedComponentCompositeLayout.numColumns = 3;
        excludedComponentCompositeLayout.makeColumnsEqualWidth = false;
        excludedComponentComposite.setLayout((Layout)excludedComponentCompositeLayout);
        Label label = this.fToolkit.createLabel(excludedComponentComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_EXCLUDED_COMPONENTS_LABEL);
        TableWrapData labelLayoutData = new TableWrapData(256, 256);
        labelLayoutData.colspan = 3;
        label.setLayoutData((Object)labelLayoutData);
        this.excludeRadioBtn = this.fToolkit.createButton(excludedComponentComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_EXCLUDED_COMPONENTS_RADIO, 16);
        TableWrapData excludedRadioLayout = new TableWrapData(256, 256);
        excludedRadioLayout.colspan = 3;
        this.excludeRadioBtn.setLayoutData((Object)excludedRadioLayout);
        this.includeRadioBtn = this.fToolkit.createButton(excludedComponentComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_INCLUDED_COMPONENTS_RADIO, 16);
        TableWrapData includedRadioLayout = new TableWrapData(256, 256);
        includedRadioLayout.colspan = 3;
        this.includeRadioBtn.setLayoutData((Object)includedRadioLayout);
        this.includeRadioBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractCompoundDependencyBuildConfigurationEditor.this.updateIncludeExcludeRadio(false);
                AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        this.excludeRadioBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractCompoundDependencyBuildConfigurationEditor.this.updateIncludeExcludeRadio(false);
                AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        this.excludedComponentField = this.fToolkit.createText(excludedComponentComposite, "", 8);
        this.excludedComponentField.setLayoutData((Object)new TableWrapData(256));
        this.excludedComponentSelectBtn = this.fToolkit.createButton(excludedComponentComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_SELECT_COMPONENT_LOAD_RULES_BUTTON_TITLE, 8);
        this.excludedComponentSelectBtn.setLayoutData((Object)new TableWrapData());
        this.excludedComponentSelectBtn.setEnabled(false);
        this.excludedComponentSelectBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Collection<IComponentHandle> loadComponents;
                LoadComponents initialSelection = AbstractCompoundDependencyBuildConfigurationEditor.this.getExcludedComponents(false);
                Collection initialHandleSelection = initialSelection == null ? Collections.EMPTY_LIST : initialSelection.getComponentHandles();
                if (initialHandleSelection != (loadComponents = AbstractCompoundDependencyBuildConfigurationEditor.this.openComponentSelectionDialog(initialHandleSelection))) {
                    AbstractCompoundDependencyBuildConfigurationEditor.this.setExcludedComponents(new LoadComponents(loadComponents));
                    AbstractCompoundDependencyBuildConfigurationEditor.this.updateExcludedComponentSection(false);
                    AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
                }
            }
        });
        this.excludedComponentClearBtn = this.fToolkit.createButton(excludedComponentComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_CLEAR_COMPONENTRULES_BUTTON, 8);
        this.excludedComponentClearBtn.setLayoutData((Object)new TableWrapData());
        this.excludedComponentClearBtn.setEnabled(false);
        this.excludedComponentClearBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MessageDialog.openConfirm((Shell)AbstractCompoundDependencyBuildConfigurationEditor.this.excludedComponentClearBtn.getShell(), (String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_CLEAR_LOAD_COMPONENTS_CONFIRM_TITLE, (String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_CLEAR_EXCLUDED_COMPONENTS_CONFIRM_TEXT, (Object)(AbstractCompoundDependencyBuildConfigurationEditor.this.includeRadioBtn.getSelection() ? com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_INCLUDED : com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_EXCLUDED)))) {
                    AbstractCompoundDependencyBuildConfigurationEditor.this.setExcludedComponents(new LoadComponents(AbstractCompoundDependencyBuildConfigurationEditor.this.getTeamRepository(), ""));
                    AbstractCompoundDependencyBuildConfigurationEditor.this.updateExcludedComponentSection(false);
                    AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
                }
            }
        });
        this.updateExcludedComponentSection(true);
        this.updateIncludeExcludeRadio(true);
        this.createImpactSection(buttonComposite);
        targetSection.setClient((Control)buttonComposite);
    }

    private void updateIncludeExcludeRadio(boolean isInit) {
        if (isInit) {
            String include = this.fBuildDefinitionWorkingCopy.getConfigurationPropertyValue(this.getConfigurationId(), "team.enterprise.build.excludedComponentsAreIncludes", Boolean.toString(false));
            if (Boolean.valueOf(include).booleanValue()) {
                this.includeRadioBtn.setSelection(true);
            } else {
                this.excludeRadioBtn.setSelection(true);
            }
        } else {
            this.fBuildDefinitionWorkingCopy.setConfigurationProperty(this.getConfigurationId(), "team.enterprise.build.excludedComponentsAreIncludes", Boolean.toString(this.includeRadioBtn.getSelection()));
        }
    }

    protected Section createPersonalBuildDefaultsSection(Composite parent, FormToolkit toolkit) {
        this.createSpacer(parent, -1, 1);
        Section section = this.fToolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(256, 256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setDescription(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_PersonalBuildOptions_Description);
        section.setText(Messages.EnterpriseRequestDialogOption_CATEGORY_PERSONAL_BUILD);
        Composite composite = this.fToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        composite.setLayout((Layout)new TableWrapLayout());
        final Button fullMinLoad = this.fToolkit.createButton(composite, Messages.EnterpriseRequestDialogOption_MINIMUM_LOAD, 32);
        fullMinLoad.setLayoutData((Object)new TableWrapData());
        fullMinLoad.setSelection(Boolean.parseBoolean(this.fBuildDefinitionWorkingCopy.getPropertyValue("team.enterprise.build.ant.fullMinimumLoad", null)));
        fullMinLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.ant.fullMinimumLoad", Boolean.toString(fullMinLoad.getSelection()));
                AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        section.setClient((Control)composite);
        return section;
    }

    protected Section createAdvancedOptions(Composite parent, FormToolkit toolkit) {
        this.createSpacer(parent, -1, 1);
        Section advancedSection = this.fToolkit.createSection(parent, 384);
        advancedSection.setLayoutData((Object)new TableWrapData(256, 256));
        advancedSection.setLayout((Layout)new TableWrapLayout());
        advancedSection.setDescription(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_SECTION_ADVANCED_DESCRIPTION);
        advancedSection.setText(Messages.EnterpriseRequestDialogOption_CATEGORY_ADVANCED);
        Composite composite = this.fToolkit.createComposite((Composite)advancedSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        composite.setLayout((Layout)new TableWrapLayout());
        final Button verifyOutputs = this.fToolkit.createButton(composite, Messages.EnterpriseRequestDialogOption_SIMULATION_BUILD_BINARY_CHECK, 32);
        verifyOutputs.setLayoutData((Object)new TableWrapData());
        verifyOutputs.setSelection(Boolean.parseBoolean(this.fBuildDefinitionWorkingCopy.getPropertyValue("team.enterprise.build.ant.simulationModeBinaryCheck", null)));
        verifyOutputs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.ant.simulationModeBinaryCheck", Boolean.toString(verifyOutputs.getSelection()));
                AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.simulationModeBinaryCheck").setGenericEditAllowed(false);
                AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        verifyOutputs.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_SIMULATION_BUILD_BINARY_CHECK_DESCRIPTION);
        this.addControlDecorator((Control)verifyOutputs, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseRequestBuildDialog_SIMULATION_BUILD_BINARY_CHECK_DESCRIPTION, 131072);
        advancedSection.setClient((Control)composite);
        return advancedSection;
    }

    protected void createImpactSection(Composite parent) {
        this.createSpacer(parent, -1, 4);
        Section impactSection = this.fToolkit.createSection(parent, 130);
        impactSection.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_ImpactSectionTitle);
        impactSection.setDescription(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_ImpactSectionDescription);
        TableWrapData impactLayoutData = new TableWrapData(256, 256);
        impactLayoutData.colspan = 4;
        impactSection.setLayoutData((Object)impactLayoutData);
        impactSection.setLayout((Layout)new TableWrapLayout());
        Composite impactComposite = this.fToolkit.createComposite((Composite)impactSection);
        impactComposite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 1;
        impactComposite.setLayout((Layout)layout);
        impactSection.setClient((Control)impactComposite);
        this.impactInputsButton = this.fToolkit.createButton(impactComposite, Messages.EnterpriseRequestDialogOption_IMPACTS_REPOSITORY, 32);
        this.impactInputsButton.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_BUTTON_IMPACTS_REPOSITORY_TOOLTIP);
        this.addControlDecorator((Control)this.impactInputsButton, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_BUTTON_IMPACTS_REPOSITORY_TOOLTIP, 131072);
        this.impactInputsButton.setLayoutData((Object)new TableWrapData());
        this.impactInputsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.impacts.disableInputQueries", Boolean.toString(!AbstractCompoundDependencyBuildConfigurationEditor.this.impactInputsButton.getSelection()));
                IBuildProperty property = AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.impacts.disableInputQueries");
                if (property != null) {
                    property.setGenericEditAllowed(false);
                }
                AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.impacts.disableInputQueries");
        if (property != null) {
            this.impactInputsButton.setSelection(!Boolean.parseBoolean(property.getValue()));
        } else {
            this.impactInputsButton.setSelection(true);
        }
        this.impactParserOutputsButton = this.fToolkit.createButton(impactComposite, Messages.EnterpriseRequestDialogOption_IMPACTS_NOT_REPOSITORY, 32);
        this.impactParserOutputsButton.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_BUTTON_IMPACTS_NOT_REPOSITORY_TOOLTIP);
        this.addControlDecorator((Control)this.impactParserOutputsButton, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_BUTTON_IMPACTS_NOT_REPOSITORY_TOOLTIP, 131072);
        this.impactParserOutputsButton.setLayoutData((Object)new TableWrapData());
        this.impactParserOutputsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.impacts.disableParserOutputQueries", Boolean.toString(!AbstractCompoundDependencyBuildConfigurationEditor.this.impactParserOutputsButton.getSelection()));
                IBuildProperty property = AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.impacts.disableParserOutputQueries");
                if (property != null) {
                    property.setGenericEditAllowed(false);
                }
                AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.impacts.disableParserOutputQueries");
        if (property != null) {
            this.impactParserOutputsButton.setSelection(!Boolean.parseBoolean(property.getValue()));
        } else {
            this.impactParserOutputsButton.setSelection(true);
        }
        this.impactAlwaysBuildButton = this.fToolkit.createButton(impactComposite, Messages.EnterpriseRequestDialogOption_IMPACTS_ALWAYS_BUILD, 32);
        this.impactAlwaysBuildButton.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_BUTTON_IMPACTS_ALWAYS_BUILD_TOOLTIP);
        this.addControlDecorator((Control)this.impactAlwaysBuildButton, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_BUTTON_IMPACTS_ALWAYS_BUILD_TOOLTIP, 131072);
        this.impactAlwaysBuildButton.setLayoutData((Object)new TableWrapData());
        this.impactAlwaysBuildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.impacts.disableAlwaysBuildQueries", Boolean.toString(!AbstractCompoundDependencyBuildConfigurationEditor.this.impactAlwaysBuildButton.getSelection()));
                IBuildProperty property = AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.impacts.disableAlwaysBuildQueries");
                if (property != null) {
                    property.setGenericEditAllowed(false);
                }
                AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.impacts.disableAlwaysBuildQueries");
        if (property != null) {
            this.impactAlwaysBuildButton.setSelection(!Boolean.parseBoolean(property.getValue()));
        } else {
            this.impactAlwaysBuildButton.setSelection(true);
        }
    }

    private void createRequestOptionsSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 384);
        section.setLayoutData((Object)new TableWrapData(256, 256));
        section.setLayout((Layout)new TableWrapLayout());
        section.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_RequestOptions_VisibilitySectionTitle);
        section.setDescription(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_RequestOptions_VisibilitySectionDescription);
        Composite visibilityComposite = toolkit.createComposite((Composite)section);
        visibilityComposite.setLayoutData((Object)new TableWrapData(256, 256));
        visibilityComposite.setLayout((Layout)new TableWrapLayout());
        this.visibilityTreeComposite = toolkit.createComposite(visibilityComposite);
        TreeColumnLayout layout = new TreeColumnLayout();
        this.visibilityTreeComposite.setLayout((Layout)layout);
        this.visibilityTreeComposite.setLayoutData((Object)new TableWrapData(256, 256));
        Tree tree = toolkit.createTree(this.visibilityTreeComposite, 66304);
        this.visibilityTreeViewer = new TreeViewer(tree);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new TableWrapData(256, 256));
        this.requestVisbilityOptions = EnterpriseRequestDialogOption.parseOptions((String)this.fBuildDefinitionWorkingCopy.getConfigurationPropertyValue(this.getConfigurationId(), "team.enterprise.build.ui.requestOptionVisibility", null), (boolean)"com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement".equals(this.getConfigurationId()));
        this.visibilityTreeViewer.setContentProvider((IContentProvider)new PropertyOverrideContentProvider());
        this.setVisibilityTreeInput(this.requestVisbilityOptions);
        tree.addListener(3, (Listener)new PropertyOverrideCheckboxListener());
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("visibilityEditActions"));
                manager.add(AbstractCompoundDependencyBuildConfigurationEditor.this.getCopyVisibilityAction());
                manager.add(AbstractCompoundDependencyBuildConfigurationEditor.this.getPasteVisibilityAction());
                manager.add((IContributionItem)new Separator("visibilityToggleActions"));
                MenuManager teamMenu = new MenuManager(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_RequestOptions_VisibilityTable_TeamColumn);
                teamMenu.add(AbstractCompoundDependencyBuildConfigurationEditor.this.getCheckVisibilityTeamAction());
                teamMenu.add(AbstractCompoundDependencyBuildConfigurationEditor.this.getUncheckVisibilityTeamAction());
                manager.add((IContributionItem)teamMenu);
                MenuManager personalMenu = new MenuManager(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_RequestOptions_VisibilityTable_PersonalColumn);
                personalMenu.add(AbstractCompoundDependencyBuildConfigurationEditor.this.getCheckVisibilityPersonalAction());
                personalMenu.add(AbstractCompoundDependencyBuildConfigurationEditor.this.getUncheckVisibilityPersonalAction());
                manager.add((IContributionItem)personalMenu);
            }
        });
        this.getSite().registerContextMenu(this.getSite().getId(), menuManager, (ISelectionProvider)this.visibilityTreeViewer);
        Menu menu = menuManager.createContextMenu((Control)tree);
        tree.setMenu(menu);
        TreeViewerColumn col1 = new TreeViewerColumn(this.visibilityTreeViewer, 16384, 0);
        TreeViewerColumn col2 = new TreeViewerColumn(this.visibilityTreeViewer, 0x1000000, 1);
        TreeViewerColumn col3 = new TreeViewerColumn(this.visibilityTreeViewer, 0x1000000, 2);
        col1.getColumn().setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_RequestOptions_VisibilityTable_PropertyColumn);
        col2.getColumn().setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_RequestOptions_VisibilityTable_TeamColumn);
        col3.getColumn().setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_RequestOptions_VisibilityTable_PersonalColumn);
        PropertyOverrideLabelProvider labelProvider = new PropertyOverrideLabelProvider();
        col1.setLabelProvider((CellLabelProvider)labelProvider);
        col2.setLabelProvider((CellLabelProvider)labelProvider);
        col3.setLabelProvider((CellLabelProvider)labelProvider);
        layout.setColumnData((Widget)col1.getColumn(), (ColumnLayoutData)new ColumnWeightData(70));
        layout.setColumnData((Widget)col2.getColumn(), (ColumnLayoutData)new ColumnWeightData(15));
        layout.setColumnData((Widget)col3.getColumn(), (ColumnLayoutData)new ColumnWeightData(15));
        this.visibilityTreeViewer.refresh();
        this.visibilityTreeViewer.expandAll();
        this.visibilityTreeComposite.pack();
        new TooltipSupport((Control)tree, true, false){

            protected String getMarkup(Object element, boolean isFocus) {
                if (element instanceof String) {
                    return (String)element;
                }
                return super.getMarkup(element, isFocus);
            }

            protected Object mapElement(int x, int y) {
                Object data;
                Point p = new Point(x, y);
                TreeItem item = AbstractCompoundDependencyBuildConfigurationEditor.this.visibilityTreeViewer.getTree().getItem(p);
                if (item != null && (data = item.getData()) instanceof RequestVisibilityTreeNode) {
                    RequestVisibilityTreeNode node = (RequestVisibilityTreeNode)data;
                    if (node.data.containsKey("tooltip1") || node.data.containsKey("tooltip2")) {
                        int i = 1;
                        while (i < AbstractCompoundDependencyBuildConfigurationEditor.this.visibilityTreeViewer.getTree().getColumnCount()) {
                            Rectangle r = item.getBounds(i);
                            if (r.contains(p)) {
                                return node.data.get("tooltip" + i);
                            }
                            ++i;
                        }
                    }
                }
                return null;
            }
        };
        Hyperlink restoreDefaultsLink = toolkit.createHyperlink(visibilityComposite, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_VisibilityRestoreDefaults, 64);
        restoreDefaultsLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                List newOptions = EnterpriseRequestDialogOption.parseOptions(null, (boolean)"com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement".equals(AbstractCompoundDependencyBuildConfigurationEditor.this.getConfigurationId()));
                String newValue = EnterpriseRequestDialogOption.toPropertyString((List)newOptions, null);
                AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setConfigurationProperty(AbstractCompoundDependencyBuildConfigurationEditor.this.getConfigurationId(), "team.enterprise.build.ui.requestOptionVisibility", newValue);
                AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
                AbstractCompoundDependencyBuildConfigurationEditor.this.setVisibilityTreeInput(newOptions);
            }
        });
        restoreDefaultsLink.setLayoutData((Object)new TableWrapData(2));
        section.setClient((Control)visibilityComposite);
    }

    protected IAction getCopyVisibilityAction() {
        if (this.copyVisibilityAction == null) {
            this.copyVisibilityAction = new Action(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_VisibilityMenuCopy){

                public void run() {
                    Clipboard clipboard = null;
                    try {
                        String contents = AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationPropertyValue(AbstractCompoundDependencyBuildConfigurationEditor.this.getConfigurationId(), "team.enterprise.build.ui.requestOptionVisibility", null);
                        if (contents == null || contents.isEmpty()) {
                            List parsed = EnterpriseRequestDialogOption.parseOptions(null, (boolean)"com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement".equals(AbstractCompoundDependencyBuildConfigurationEditor.this.getConfigurationId()));
                            contents = EnterpriseRequestDialogOption.toPropertyString((List)parsed, null);
                        }
                        clipboard = new Clipboard(AbstractCompoundDependencyBuildConfigurationEditor.this.getSite().getWorkbenchWindow().getShell().getDisplay());
                        clipboard.setContents((Object[])new String[]{contents}, new Transfer[]{TextTransfer.getInstance()});
                    }
                    finally {
                        if (clipboard != null && !clipboard.isDisposed()) {
                            clipboard.dispose();
                        }
                    }
                }
            };
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.copyVisibilityAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.copyVisibilityAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        }
        return this.copyVisibilityAction;
    }

    protected IAction getPasteVisibilityAction() {
        if (this.pasteVisibilityAction == null) {
            this.pasteVisibilityAction = new Action(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_VisibilityMenuPaste){

                public void run() {
                    Clipboard clipboard = null;
                    try {
                        List parsed;
                        clipboard = new Clipboard(AbstractCompoundDependencyBuildConfigurationEditor.this.getSite().getWorkbenchWindow().getShell().getDisplay());
                        Object contents = clipboard.getContents((Transfer)TextTransfer.getInstance());
                        boolean validPaste = false;
                        if (contents instanceof String && !(parsed = EnterpriseRequestDialogOption.strictParseOptions((String)((String)contents), (boolean)"com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement".equals(AbstractCompoundDependencyBuildConfigurationEditor.this.getConfigurationId()))).isEmpty()) {
                            validPaste = true;
                            AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setConfigurationProperty(AbstractCompoundDependencyBuildConfigurationEditor.this.getConfigurationId(), "team.enterprise.build.ui.requestOptionVisibility", (String)contents);
                            AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
                            AbstractCompoundDependencyBuildConfigurationEditor.this.setVisibilityTreeInput(parsed);
                        }
                        if (!validPaste) {
                            MessageDialog.openError((Shell)AbstractCompoundDependencyBuildConfigurationEditor.this.getSite().getWorkbenchWindow().getShell(), (String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_VisibilityPasteErrorTitle, (String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_VisibilityPasteErrorMessage);
                        }
                    }
                    finally {
                        if (clipboard != null && !clipboard.isDisposed()) {
                            clipboard.dispose();
                        }
                    }
                }
            };
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.pasteVisibilityAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
            this.pasteVisibilityAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        }
        return this.pasteVisibilityAction;
    }

    protected IAction getCheckVisibilityTeamAction() {
        if (this.checkVisibilityTeamAction == null) {
            this.checkVisibilityTeamAction = this.createToggleVisibilityAction(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_VisibilityCheckAll, true, true);
        }
        return this.checkVisibilityTeamAction;
    }

    protected IAction getUncheckVisibilityTeamAction() {
        if (this.uncheckVisibilityTeamAction == null) {
            this.uncheckVisibilityTeamAction = this.createToggleVisibilityAction(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_VisibilityUncheckAll, true, false);
        }
        return this.uncheckVisibilityTeamAction;
    }

    protected IAction getCheckVisibilityPersonalAction() {
        if (this.checkVisibilityPersonalAction == null) {
            this.checkVisibilityPersonalAction = this.createToggleVisibilityAction(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_VisibilityCheckAll, false, true);
        }
        return this.checkVisibilityPersonalAction;
    }

    protected IAction getUncheckVisibilityPersonalAction() {
        if (this.uncheckVisibilityPersonalAction == null) {
            this.uncheckVisibilityPersonalAction = this.createToggleVisibilityAction(com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_VisibilityUncheckAll, false, false);
        }
        return this.uncheckVisibilityPersonalAction;
    }

    protected IAction createToggleVisibilityAction(String label, final boolean isTeamColumn, final boolean newState) {
        Action action = new Action(label){

            public void run() {
                boolean modified = false;
                for (EnterpriseRequestDialogOption option : AbstractCompoundDependencyBuildConfigurationEditor.this.requestVisbilityOptions) {
                    if (isTeamColumn) {
                        if (!option.isTeamVisibilityModifiable() || option.getTeamVisibility() == newState) continue;
                        option.setTeamVisibility(newState);
                        modified = true;
                        continue;
                    }
                    if (!option.isPersonalVisibilityModifiable() || option.getPersonalVisibility() == newState) continue;
                    option.setPersonalVisibility(newState);
                    modified = true;
                }
                if (modified) {
                    String prevValue = AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationPropertyValue(AbstractCompoundDependencyBuildConfigurationEditor.this.getConfigurationId(), "team.enterprise.build.ui.requestOptionVisibility", null);
                    String newValue = EnterpriseRequestDialogOption.toPropertyString(AbstractCompoundDependencyBuildConfigurationEditor.this.requestVisbilityOptions, (String)prevValue);
                    AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setConfigurationProperty(AbstractCompoundDependencyBuildConfigurationEditor.this.getConfigurationId(), "team.enterprise.build.ui.requestOptionVisibility", newValue);
                    AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
                    AbstractCompoundDependencyBuildConfigurationEditor.this.visibilityTreeViewer.getTree().redraw();
                }
            }
        };
        if (newState) {
            action.setImageDescriptor(this.selectedCheckboxImageDescriptor);
        } else {
            action.setImageDescriptor(this.deselectedCheckboxImageDescriptor);
        }
        return action;
    }

    protected void setVisibilityTreeInput(List<EnterpriseRequestDialogOption> newOptions) {
        boolean modified = false;
        Collection input = null;
        if (newOptions == this.requestVisbilityOptions) {
            modified = true;
            LinkedHashMap<String, RequestVisibilityTreeNode> categories = new LinkedHashMap<String, RequestVisibilityTreeNode>();
            for (EnterpriseRequestDialogOption option : this.requestVisbilityOptions) {
                RequestVisibilityTreeNode category = (RequestVisibilityTreeNode)categories.get(option.getCategory());
                if (category == null) {
                    category = new RequestVisibilityTreeNode(option.getCategory());
                    categories.put(option.getCategory(), category);
                }
                RequestVisibilityTreeNode child = new RequestVisibilityTreeNode(category, option);
                EnterpriseRequestDialogOption.VisibilityPermissions permissions = child.option.getRequiredPermissions();
                if (permissions != null && permissions.getOperation() != null && !permissions.getOperation().isEmpty()) {
                    String personalAction;
                    String teamAction = permissions.getActionForTeamBuilds();
                    if (teamAction != null && !teamAction.isEmpty()) {
                        child.data.put("tooltip1", this.getPermissionTooltip(permissions.getOperation(), teamAction));
                    }
                    if ((personalAction = permissions.getActionForPersonalBuilds()) != null && !personalAction.isEmpty()) {
                        child.data.put("tooltip2", this.getPermissionTooltip(permissions.getOperation(), personalAction));
                    }
                }
                category.children.add(child);
            }
            input = categories.values();
        } else {
            HashMap<String, EnterpriseRequestDialogOption> newOptionMap = new HashMap<String, EnterpriseRequestDialogOption>(newOptions.size());
            for (EnterpriseRequestDialogOption option : newOptions) {
                newOptionMap.put(option.getId(), option);
            }
            for (EnterpriseRequestDialogOption existingOption : this.requestVisbilityOptions) {
                EnterpriseRequestDialogOption newOption = (EnterpriseRequestDialogOption)newOptionMap.get(existingOption.getId());
                if (newOption == null) continue;
                if (existingOption.getPersonalVisibility() != newOption.getPersonalVisibility()) {
                    modified = true;
                    existingOption.setPersonalVisibility(newOption.getPersonalVisibility());
                }
                if (existingOption.getTeamVisibility() == newOption.getTeamVisibility()) continue;
                modified = true;
                existingOption.setTeamVisibility(newOption.getTeamVisibility());
            }
        }
        if (modified) {
            if (input != null) {
                this.visibilityTreeViewer.setInput(input);
                this.visibilityTreeViewer.expandAll();
                this.fetchPermissionsInBackground();
            } else {
                this.visibilityTreeViewer.getTree().redraw();
            }
        }
    }

    private void fetchPermissionsInBackground() {
        final Object input = this.visibilityTreeViewer.getInput();
        new UIUpdaterJob(""){

            public IStatus runInBackground(IProgressMonitor monitor) {
                AbstractCompoundDependencyBuildConfigurationEditor.this.isUserJazzAdmin = AbstractCompoundDependencyBuildConfigurationEditor.this.isUserJazzAdmin();
                if (input instanceof Collection) {
                    Collection nodes = (Collection)input;
                    for (RequestVisibilityTreeNode node : nodes) {
                        this.setPermissions(node);
                    }
                }
                return Status.OK_STATUS;
            }

            private void setPermissions(RequestVisibilityTreeNode node) {
                EnterpriseRequestDialogOption.VisibilityPermissions permissions;
                if (node.option != null && (permissions = node.option.getRequiredPermissions()) != null && permissions.getOperation() != null && !permissions.getOperation().isEmpty()) {
                    String personalAction;
                    String teamAction = permissions.getActionForTeamBuilds();
                    if (teamAction != null && !teamAction.isEmpty()) {
                        node.data.put("hasperm1", AbstractCompoundDependencyBuildConfigurationEditor.this.isUserJazzAdmin != false || AbstractCompoundDependencyBuildConfigurationEditor.this.userHasPermission(permissions.getOperation(), teamAction));
                    }
                    if ((personalAction = permissions.getActionForPersonalBuilds()) != null && !personalAction.isEmpty()) {
                        node.data.put("hasperm2", AbstractCompoundDependencyBuildConfigurationEditor.this.isUserJazzAdmin != false || AbstractCompoundDependencyBuildConfigurationEditor.this.userHasPermission(permissions.getOperation(), personalAction));
                    }
                }
                for (RequestVisibilityTreeNode child : node.children) {
                    this.setPermissions(child);
                }
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                AbstractCompoundDependencyBuildConfigurationEditor.this.visibilityTreeViewer.getTree().redraw();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private String getPermissionTooltip(String operationID, String actionID) {
        String key = String.valueOf(operationID) + "|" + actionID;
        String permissionMsg = this.permissionTooltips.get(key);
        if (permissionMsg == null) {
            String operationLabel = operationID;
            String actionLabel = actionID;
            ProcessExtensionRegistry registry = new ProcessExtensionRegistry(this.getTeamRepository());
            IConfigurationPointExtension[] iConfigurationPointExtensionArray = registry.getConfigurationPoints();
            int n = iConfigurationPointExtensionArray.length;
            int n2 = 0;
            block0: while (n2 < n) {
                IConfigurationPointExtension ext = iConfigurationPointExtensionArray[n2];
                if (operationID.equals(ext.getIdentifier())) {
                    operationLabel = ext.getName();
                    if (!(ext instanceof OperationExtension)) break;
                    List actions = ((OperationExtension)ext).getCachedActions(null);
                    for (Object action : actions) {
                        OperationExtension.ActionElement actionElement;
                        if (!(action instanceof OperationExtension.ActionElement) || !actionID.equals((actionElement = (OperationExtension.ActionElement)action).getId())) continue;
                        actionLabel = actionElement.getLabel();
                        break block0;
                    }
                    break;
                }
                ++n2;
            }
            permissionMsg = NLS.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_VisibilityMissingPermissionTooltip, (Object)operationLabel, (Object)actionLabel);
            this.permissionTooltips.put(key, permissionMsg);
        }
        return permissionMsg;
    }

    private void updateSelection() {
        this.tabFolder.getSelection();
    }

    @Override
    protected void updateComponentState() {
        super.updateComponentState();
        if (this.optionsTab.getControl() != null) {
            boolean buildTargetItems = this.buildSubsetButton.getSelection() && this.validateBuildWorkspace((Control)this.subsetText);
            this.browseSubsetButton.setEnabled(buildTargetItems);
        }
        this.validateSubsetExistence();
        this.validateMandatorySubsetExistence();
    }

    protected IBuildDefinition getBuildDefinitionWorkingCopy() {
        return this.fBuildDefinitionWorkingCopy;
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        if (!this.validateBuildFile()) {
            isValid = false;
        }
        if (!this.validateSubset()) {
            isValid = false;
        }
        if (!this.validateMandatorySubset()) {
            isValid = false;
        }
        if (!this.platformSpecificValidation()) {
            isValid = false;
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    protected boolean platformSpecificValidation() {
        return true;
    }

    protected boolean validateBuildWorkspace(Control targetControl) {
        IBuildProperty property;
        if (this.buildSubsetButton.getSelection() && (property = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.scm.workspaceUUID")).getValue().isEmpty()) {
            this.addErrorMessage(targetControl, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_ERROR_SUBSET_NOWORKSPACE, targetControl);
            return false;
        }
        this.removeMessage(targetControl, targetControl);
        return true;
    }

    protected boolean validateSubset() {
        if (this.buildSubsetButton.getSelection()) {
            if (this.validateBuildWorkspace((Control)this.subsetText)) {
                if (!this.subsetText.isDisposed() && this.subsetText.getText().isEmpty()) {
                    this.addErrorMessage(this.buildSubsetButton, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_ERROR_SUBSET_NONE, (Control)this.buildSubsetButton);
                    return false;
                }
            } else {
                return false;
            }
        }
        this.removeMessage(this.buildSubsetButton, (Control)this.buildSubsetButton);
        return true;
    }

    protected boolean validateMandatorySubset() {
        if (this.mandatorySubsetButton.getSelection()) {
            if (this.validateBuildWorkspace((Control)this.mandatorySubsetText)) {
                if (!this.mandatorySubsetText.isDisposed() && this.mandatorySubsetText.getText().isEmpty()) {
                    this.addErrorMessage(this.mandatorySubsetButton, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_ERROR_SUBSET_NONE, (Control)this.mandatorySubsetButton);
                    return false;
                }
            } else {
                return false;
            }
        }
        this.removeMessage(this.mandatorySubsetButton, (Control)this.mandatorySubsetButton);
        return true;
    }

    protected void validateSubsetExistence() {
        this.validateSubsetExistence(this.subsetText);
    }

    protected void validateMandatorySubsetExistence() {
        this.validateSubsetExistence(this.mandatorySubsetText);
    }

    protected void validateSubsetExistence(final Text textControl) {
        String slug;
        if (textControl != null && !textControl.isDisposed() && (slug = (String)textControl.getData()) != null && !slug.isEmpty()) {
            final IBuildableSubsetClient client = (IBuildableSubsetClient)this.getTeamRepository().getClientLibrary(IBuildableSubsetClient.class);
            final String currentText = textControl.getText();
            Job job = new Job(""){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        boolean exists = client.exists(slug);
                        if (!exists) {
                            UIJob uiJob = new UIJob(""){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    if (textControl != null && !textControl.isDisposed()) {
                                        textControl.setText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_BUILD_SUBSET_DELETED);
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            uiJob.schedule();
                        } else if (currentText.equals(com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_BUILD_SUBSET_DELETED)) {
                            final String subsetLabel = BuildableSubsetUtil.getLabelFromSlug((String)slug);
                            UIJob uiJob = new UIJob(""){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    textControl.setText(subsetLabel);
                                    return Status.OK_STATUS;
                                }
                            };
                            uiJob.schedule();
                        }
                    }
                    catch (TeamRepositoryException e) {
                        Activator.getDefault().logError(e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    @Override
    public void modifyText(ModifyEvent event) {
        super.modifyText(event);
        if (event.getSource() == this.antHomeText) {
            IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
            IConfigurationProperty buildFileProperty = element.getConfigurationProperty("team.enterprise.build.ant.antHome");
            buildFileProperty.setValue(this.antHomeText.getText().trim());
            this.setDirty(true);
        } else if (event.getSource() == this.antArgsText) {
            IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
            IConfigurationProperty buildFileProperty = element.getConfigurationProperty("team.enterprise.build.ant.antArgs");
            buildFileProperty.setValue(this.antArgsText.getText().trim());
            this.setDirty(true);
        } else if (event.getSource() == this.workingDirText) {
            IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
            IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.workingDir");
            property.setValue(this.workingDirText.getText().trim());
            this.setDirty(true);
        } else if (event.getSource() == this.javaHomeText) {
            IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
            IConfigurationProperty buildFileProperty = element.getConfigurationProperty("team.enterprise.build.ant.javaHome");
            buildFileProperty.setValue(this.javaHomeText.getText().trim());
            this.setDirty(true);
        } else if (event.getSource() == this.javaArgsText) {
            IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
            IConfigurationProperty buildFileProperty = element.getConfigurationProperty("team.enterprise.build.ant.javaVMArgs");
            buildFileProperty.setValue(this.javaArgsText.getText().trim());
            this.setDirty(true);
        } else if (event.getSource() == this.propertiesFileText) {
            IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
            IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.propertiesFile");
            property.setValue(this.propertiesFileText.getText().trim());
            this.setDirty(true);
        }
    }

    public void setFocus() {
        super.setFocus();
        this.validate();
        this.updateComponentState();
    }

    @Override
    protected FormToolkit getToolkit() {
        return this.fToolkit;
    }

    @Override
    protected IBuildDefinition getWorkingCopy() {
        return this.fBuildDefinitionWorkingCopy;
    }

    @Override
    protected abstract String getConfigurationId();

    protected abstract void createPlatformSpecificSections(Composite var1, FormToolkit var2);

    @Override
    protected void createAdvancedWidgets(Composite parent) {
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.dependency.trustOutputs");
        this.trustOutputsButton = this.getToolkit().createButton(parent, Messages.EnterpriseRequestDialogOption_TRUST_OUTPUTS, 32);
        this.trustOutputsButton.setLayoutData((Object)new TableWrapData(256));
        if (property != null) {
            boolean trustOutputs = Boolean.parseBoolean(property.getValue());
            this.trustOutputsButton.setSelection(trustOutputs);
        } else {
            this.trustOutputsButton.setSelection(false);
        }
        this.trustOutputsButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                AbstractCompoundDependencyBuildConfigurationEditor.this.getWorkingCopy().setProperty("team.enterprise.build.dependency.trustOutputs", Boolean.toString(AbstractCompoundDependencyBuildConfigurationEditor.this.trustOutputsButton.getSelection()));
                AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        if ("com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement".equals(this.getConfigurationId())) {
            this.deleteOutputsButton = this.fToolkit.createButton(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_BUTTON_DELETEOUTPUTS, 32);
            this.deleteOutputsButton.setLayoutData((Object)new TableWrapData());
            this.deleteOutputsButton.setToolTipText(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_LABEL_DELETEOUTPUTS);
            this.addControlDecorator((Control)this.deleteOutputsButton, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_LABEL_DELETEOUTPUTS, 131072);
            IBuildProperty deleteProperty = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.dependency.needToDeleteOutputs");
            if (deleteProperty != null && !deleteProperty.getValue().isEmpty()) {
                this.deleteOutputsButton.setSelection(Boolean.parseBoolean(deleteProperty.getValue()));
            } else {
                this.deleteOutputsButton.setSelection(false);
            }
            this.deleteOutputsButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    AbstractCompoundDependencyBuildConfigurationEditor.this.validate();
                    IBuildProperty buildProperty = AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.dependency.needToDeleteOutputs");
                    if (buildProperty == null) {
                        AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.dependency.needToDeleteOutputs", Boolean.toString(AbstractCompoundDependencyBuildConfigurationEditor.this.deleteOutputsButton.getSelection()));
                    } else {
                        buildProperty.setValue(Boolean.toString(AbstractCompoundDependencyBuildConfigurationEditor.this.deleteOutputsButton.getSelection()));
                    }
                    AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
                }
            });
        }
        property = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.suppressBuildMapLinks");
        this.publishBuildMapLinksButton = this.getToolkit().createButton(parent, com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_BUTTON_BUILDMAPLINKS, 32);
        this.publishBuildMapLinksButton.setLayoutData((Object)new TableWrapData(256));
        if (property != null) {
            boolean publishBuildMapLinks = !Boolean.parseBoolean(property.getValue());
            this.publishBuildMapLinksButton.setSelection(publishBuildMapLinks);
        } else {
            this.publishBuildMapLinksButton.setSelection(false);
        }
        this.publishBuildMapLinksButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                boolean shouldContinueWithSelection;
                if (AbstractCompoundDependencyBuildConfigurationEditor.this.publishBuildMapLinksButton.getSelection() && !(shouldContinueWithSelection = MessagePromptDialog.openQuestion((Shell)AbstractCompoundDependencyBuildConfigurationEditor.this.getSite().getShell(), (String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_DLG_TITLE, (String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_CONFIRM_PUBLISH_BUILDMAP, (IPreferenceStore)com.ibm.team.enterprise.common.ui.Activator.getDefault().getPreferenceStore(), (String)"promptPublishingBuildMapLinks"))) {
                    event.doit = false;
                    AbstractCompoundDependencyBuildConfigurationEditor.this.publishBuildMapLinksButton.setSelection(!AbstractCompoundDependencyBuildConfigurationEditor.this.publishBuildMapLinksButton.getSelection());
                    return;
                }
                AbstractCompoundDependencyBuildConfigurationEditor.this.getWorkingCopy().setProperty("team.enterprise.build.suppressBuildMapLinks", Boolean.toString(!AbstractCompoundDependencyBuildConfigurationEditor.this.publishBuildMapLinksButton.getSelection()));
                AbstractCompoundDependencyBuildConfigurationEditor.this.addPublishBuildMapLinkWarning();
                AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
            }
        });
        this.addPublishBuildMapLinkWarning();
    }

    @Override
    public void widgetSelected(SelectionEvent event) {
        block29: {
            super.widgetSelected(event);
            this.updateComponentState();
            Object eventSource = event.getSource();
            if (eventSource == this.buildAllButton || eventSource == this.buildSubsetButton || eventSource == this.buildChangedButton || eventSource == this.conditionButton || eventSource == this.allowAdditionalFlowsInputs || eventSource == this.skipDependencyDataUpdate) {
                if (eventSource == this.buildAllButton || eventSource == this.buildSubsetButton) {
                    boolean buildAllItems = this.buildAllButton.getSelection();
                    if (buildAllItems) {
                        this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.ant.buildableSubset", "");
                    } else if (!this.subsetText.getText().isEmpty()) {
                        this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.ant.buildableSubset", this.subsetText.getText());
                    }
                    this.validateSubset();
                } else if (eventSource == this.buildChangedButton) {
                    IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.buildChangesOnly");
                    property.setValue(Boolean.toString(this.buildChangedButton.getSelection()));
                } else if (eventSource == this.conditionButton) {
                    IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
                    IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.ant.conditionalBuild");
                    property.setValue(Boolean.toString(this.conditionButton.getSelection()));
                } else if (eventSource == this.allowAdditionalFlowsInputs) {
                    IBuildConfigurationElement element = this.fBuildDefinitionWorkingCopy.getConfigurationElement(this.getConfigurationId());
                    IConfigurationProperty property = element.getConfigurationProperty("team.enterprise.build.dependency.resolveAdditionalFlowsDependencies");
                    if (property == null) {
                        property = BuildItemFactory.createConfigurationProperty();
                        property.setName("team.enterprise.build.dependency.resolveAdditionalFlowsDependencies");
                        element.getConfigurationProperties().add(property);
                    }
                    property.setValue(Boolean.toString(this.allowAdditionalFlowsInputs.getSelection()));
                } else if (eventSource == this.skipDependencyDataUpdate) {
                    this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.skipDependencyDataUpdate", Boolean.toString(this.skipDependencyDataUpdate.getSelection()));
                }
                this.setDirty(true);
            } else if (eventSource == this.browseSubsetButton || eventSource == this.browseMandatorySubsetButton) {
                try {
                    Shell parentShell = this.getSite().getShell();
                    BuildSubsetSelectionDialog dialog = new BuildSubsetSelectionDialog(parentShell, this.getTeamRepository(), this.getWorkingCopy(), eventSource == this.browseMandatorySubsetButton, false);
                    if (dialog.open() == 0) {
                        ISubset selectedSubset = dialog.getSelectedSubset();
                        String subsetSlug = BuildableSubsetUtil.getSlug((String)selectedSubset.getLabel(), (String)selectedSubset.getBuildDefinition().getItemId().getUuidValue());
                        if (eventSource == this.browseSubsetButton) {
                            this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.ant.buildableSubset", selectedSubset.getLabel());
                            this.subsetText.setText(selectedSubset.getLabel());
                            this.subsetText.setData((Object)subsetSlug);
                            this.subsetText.setData("subset_handle", (Object)selectedSubset);
                        } else {
                            this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.ant.mandatorySubset", subsetSlug);
                            this.mandatorySubsetText.setText(selectedSubset.getLabel());
                            this.mandatorySubsetText.setData((Object)subsetSlug);
                            this.mandatorySubsetText.setData("subset_handle", (Object)selectedSubset);
                        }
                        this.setDirty(true);
                        this.validate();
                        break block29;
                    }
                    this.setDirty(this.isDirty());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (eventSource == this.mandatorySubsetButton) {
                if (this.mandatorySubsetButton.getSelection()) {
                    this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.ant.mandatorySubset", (String)this.mandatorySubsetText.getData());
                    this.mandatorySubsetText.setEnabled(true);
                    this.browseMandatorySubsetButton.setEnabled(true);
                    this.useMandatorySubsetInPersonalButton.setEnabled(true);
                } else {
                    this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.ant.mandatorySubset", "");
                    this.mandatorySubsetText.setEnabled(false);
                    this.browseMandatorySubsetButton.setEnabled(false);
                    this.useMandatorySubsetInPersonalButton.setEnabled(false);
                }
                IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.mandatorySubset");
                if (property != null) {
                    property.setGenericEditAllowed(false);
                }
                this.validateMandatorySubset();
                this.setDirty(true);
            } else if (eventSource == this.useMandatorySubsetInPersonalButton) {
                this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.ant.mandatorySubset.useInPersonal", Boolean.toString(this.useMandatorySubsetInPersonalButton.getSelection()));
                IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.build.ant.mandatorySubset.useInPersonal");
                if (property != null) {
                    property.setGenericEditAllowed(false);
                }
                this.setDirty(true);
            }
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.retrieveBuildWorkspaceForBuildDefinition();
        }
    }

    protected Collection<IComponentHandle> openComponentSelectionDialog(Collection<IComponentHandle> initialSelection) {
        Object[] componentsSelected;
        if (this.buildWorkspace == null) {
            return initialSelection;
        }
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(this.buildWorkspace.getItemId(), null);
        ComponentSelectionDialog selectionDialog = new ComponentSelectionDialog(this.excludedComponentField.getShell(), this.getTeamRepository(), workspaceHandle, com.ibm.team.enterprise.internal.build.ui.nls.Messages.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_PICK_EXCLUDED_COMPONENTS_TITLE, (Object)(this.includeRadioBtn.getSelection() ? com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_INCLUDED : com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_EXCLUDED)), com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_EXCLUDED_COMPONENTS_LABEL, initialSelection);
        Collection<IComponentHandle> result = initialSelection;
        if (selectionDialog.open() == 0 && (componentsSelected = selectionDialog.getResult()) != null) {
            result = new ArrayList<IComponentHandle>(componentsSelected.length);
            int i = 0;
            while (i < componentsSelected.length) {
                result.add((IComponentHandle)((IComponent)componentsSelected[i]));
                ++i;
            }
        }
        return result;
    }

    protected void updateExcludedComponentSection(boolean isInitialized) {
        int numLoadComponents = this.getExcludedComponents(isInitialized).getComponentHandles().size();
        if (numLoadComponents == 0) {
            this.excludedComponentField.setText("");
        } else {
            String messageId = numLoadComponents > 1 ? com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_NUMBER_OF_LOAD_COMPONENTS_TEXT_MULTI : com.ibm.team.enterprise.internal.build.ui.nls.Messages.FileAgentJazzScmConfigurationEditor_NUMBER_OF_LOAD_COMPONENTS_TEXT;
            this.excludedComponentField.setText(NLS.bind((String)messageId, (Object)numLoadComponents));
        }
        this.excludedComponentClearBtn.setEnabled(numLoadComponents > 0);
    }

    protected void retrieveBuildWorkspaceForBuildDefinition() {
        this.buildWorkspace = null;
        IBuildProperty property = this.fBuildDefinitionWorkingCopy.getProperty("team.enterprise.scm.workspaceUUID");
        if (property != null && property.getValue().isEmpty()) {
            return;
        }
        final String buildWorkspaceUuid = property.getValue();
        Job job = new Job(com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_LOAD_BUILD_WKS_JOB){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IWorkspaceHandle buildWorkspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildWorkspaceUuid), null);
                    AbstractCompoundDependencyBuildConfigurationEditor.this.buildWorkspace = (IWorkspace)AbstractCompoundDependencyBuildConfigurationEditor.this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)buildWorkspaceHandle, 0, monitor);
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.enterprise.build.ui", NLS.bind((String)com.ibm.team.enterprise.internal.build.ui.nls.Messages.EnterpriseConfigurationEditorDependency_LOAD_BUILD_WKS_JOB_ERROR, (Object)AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getId()), (Throwable)e);
                }
            }
        };
        try {
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        AbstractCompoundDependencyBuildConfigurationEditor.this.excludedComponentSelectBtn.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                (this).AbstractCompoundDependencyBuildConfigurationEditor.this.excludedComponentSelectBtn.setEnabled((this).AbstractCompoundDependencyBuildConfigurationEditor.this.buildWorkspace != null);
                            }
                        });
                    }
                }
            });
            job.schedule();
            job.join();
        }
        catch (InterruptedException e) {
            this.buildWorkspace = null;
        }
    }

    protected LoadComponents getExcludedComponents(boolean isInitialized) {
        String componentUUIDs = this.fBuildDefinitionWorkingCopy.getConfigurationPropertyValue(this.getConfigurationId(), "team.enterprise.build.excludedComponents", "");
        if (isInitialized && componentUUIDs.isEmpty() && (componentUUIDs = this.fBuildDefinitionWorkingCopy.getPropertyValue("team.enterprise.build.excludedComponents", "")).length() > 0) {
            LoadComponents newLoadComponents = new LoadComponents(this.getTeamRepository(), componentUUIDs);
            this.setExcludedComponents(newLoadComponents);
            this.setDirty(true);
        }
        return new LoadComponents(this.getTeamRepository(), componentUUIDs);
    }

    protected void setExcludedComponents(LoadComponents loadComponents) {
        String oldExcludedComUUIDs = this.fBuildDefinitionWorkingCopy.getPropertyValue("team.enterprise.build.excludedComponents", "");
        if (oldExcludedComUUIDs.length() > 0) {
            this.fBuildDefinitionWorkingCopy.setProperty("team.enterprise.build.excludedComponents", "");
        }
        this.fBuildDefinitionWorkingCopy.setConfigurationProperty(this.getConfigurationId(), "team.enterprise.build.excludedComponents", loadComponents.getBuildProperty());
    }

    @Override
    public void dispose() {
        if (this.mgr != null) {
            this.mgr.dispose();
            this.mgr = null;
            this.selectedCheckboxImageDescriptor = null;
            this.deselectedCheckboxImageDescriptor = null;
        }
        super.dispose();
    }

    protected void addPublishBuildMapLinkWarning() {
        if (this.publishBuildMapLinksButton.getSelection()) {
            this.addWarningMessage(this.publishBuildMapLinksButton, com.ibm.team.enterprise.internal.build.ui.nls.Messages.AbstractCompoundDependencyBuildConfigurationEditor_WARN_PUBLISH_BUILDMAP, (Control)this.publishBuildMapLinksButton);
        } else {
            this.removeMessage(this.publishBuildMapLinksButton, (Control)this.publishBuildMapLinksButton);
        }
    }

    private class PropertyOverrideCheckboxListener
    implements Listener {
        private PropertyOverrideCheckboxListener() {
        }

        public void handleEvent(Event event) {
            if (!(event.widget instanceof Tree) || event.button != 1) {
                return;
            }
            Tree tree = (Tree)event.widget;
            Point p = new Point(event.x, event.y);
            TreeItem item = tree.getItem(p);
            if (item != null) {
                int i = 1;
                while (i < tree.getColumnCount()) {
                    Rectangle r = item.getBounds(i);
                    if (r.contains(p)) {
                        Object data;
                        if (i <= 0 || !((data = item.getData()) instanceof RequestVisibilityTreeNode)) break;
                        boolean modified = false;
                        RequestVisibilityTreeNode node = (RequestVisibilityTreeNode)data;
                        if (node.option == null) {
                            Boolean newState = null;
                            Image curImg = (Image)node.data.get("img" + i);
                            if (curImg == AbstractCompoundDependencyBuildConfigurationEditor.this.deselectedCheckboxImage || curImg == AbstractCompoundDependencyBuildConfigurationEditor.this.grayedCheckboxImage) {
                                newState = Boolean.TRUE;
                            } else if (curImg == AbstractCompoundDependencyBuildConfigurationEditor.this.selectedCheckboxImage) {
                                newState = Boolean.FALSE;
                            }
                            if (newState != null) {
                                for (RequestVisibilityTreeNode child : node.children) {
                                    if (i == 1) {
                                        if (child.option == null || !child.option.isTeamVisibilityModifiable() || child.option.getTeamVisibility() == newState.booleanValue()) continue;
                                        child.option.setTeamVisibility(newState.booleanValue());
                                        modified = true;
                                        continue;
                                    }
                                    if (child.option == null || !child.option.isPersonalVisibilityModifiable() || child.option.getPersonalVisibility() == newState.booleanValue()) continue;
                                    child.option.setPersonalVisibility(newState.booleanValue());
                                    modified = true;
                                }
                            }
                        } else if (i == 1) {
                            if (node.option.isTeamVisibilityModifiable()) {
                                node.option.setTeamVisibility(!node.option.getTeamVisibility());
                                modified = true;
                            }
                        } else if (node.option.isPersonalVisibilityModifiable()) {
                            node.option.setPersonalVisibility(!node.option.getPersonalVisibility());
                            modified = true;
                        }
                        if (!modified) break;
                        String prevValue = AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.getConfigurationPropertyValue(AbstractCompoundDependencyBuildConfigurationEditor.this.getConfigurationId(), "team.enterprise.build.ui.requestOptionVisibility", null);
                        String newValue = EnterpriseRequestDialogOption.toPropertyString(AbstractCompoundDependencyBuildConfigurationEditor.this.requestVisbilityOptions, (String)prevValue);
                        AbstractCompoundDependencyBuildConfigurationEditor.this.fBuildDefinitionWorkingCopy.setConfigurationProperty(AbstractCompoundDependencyBuildConfigurationEditor.this.getConfigurationId(), "team.enterprise.build.ui.requestOptionVisibility", newValue);
                        AbstractCompoundDependencyBuildConfigurationEditor.this.setDirty(true);
                        tree.redraw();
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    private class PropertyOverrideContentProvider
    implements ITreeContentProvider {
        Object[] options;

        public Object[] getElements(Object inputElement) {
            return this.options == null ? new Object[]{} : this.options;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof RequestVisibilityTreeNode) {
                return ((RequestVisibilityTreeNode)parentElement).children.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof RequestVisibilityTreeNode) {
                return ((RequestVisibilityTreeNode)element).parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof RequestVisibilityTreeNode) {
                return !((RequestVisibilityTreeNode)element).children.isEmpty();
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof Collection) {
                this.options = ((Collection)newInput).toArray();
            }
        }

        public void dispose() {
        }
    }

    private class PropertyOverrideLabelProvider
    extends OwnerDrawLabelProvider {
        private PropertyOverrideLabelProvider() {
        }

        protected void paint(Event event, Object element) {
            if (!(element instanceof RequestVisibilityTreeNode)) {
                return;
            }
            RequestVisibilityTreeNode node = (RequestVisibilityTreeNode)element;
            if (event.index == 0) {
                TreeItem treeItem = (TreeItem)event.item;
                treeItem.setText(node.label);
            } else if (event.index > 0) {
                if (node.parent == null) {
                    this.paintParentCheckbox(node, event);
                } else {
                    this.paintChildCheckbox(node, event);
                }
            }
        }

        private void paintParentCheckbox(RequestVisibilityTreeNode node, Event event) {
            int totalToConsider = 0;
            int checked = 0;
            for (RequestVisibilityTreeNode child : node.children) {
                if (child.option == null) continue;
                if (event.index == 1) {
                    if (!child.option.isTeamVisibilityModifiable()) continue;
                    ++totalToConsider;
                    if (!child.option.getTeamVisibility()) continue;
                    ++checked;
                    continue;
                }
                if (event.index != 2 || !child.option.isPersonalVisibilityModifiable()) continue;
                ++totalToConsider;
                if (!child.option.getPersonalVisibility()) continue;
                ++checked;
            }
            Image img = totalToConsider == 0 ? AbstractCompoundDependencyBuildConfigurationEditor.this.disabledDeselectedCheckboxImage : (checked == 0 ? AbstractCompoundDependencyBuildConfigurationEditor.this.deselectedCheckboxImage : (checked == totalToConsider ? AbstractCompoundDependencyBuildConfigurationEditor.this.selectedCheckboxImage : AbstractCompoundDependencyBuildConfigurationEditor.this.grayedCheckboxImage));
            TreeItem treeItem = (TreeItem)event.item;
            Rectangle cellBounds = treeItem.getBounds(event.index);
            Rectangle imageBounds = img.getBounds();
            int x = cellBounds.x + (cellBounds.width - imageBounds.width) / 2;
            int y = cellBounds.y + (cellBounds.height - imageBounds.height) / 2;
            event.gc.drawImage(img, x, y);
            node.data.put("img" + event.index, img);
        }

        private void paintChildCheckbox(RequestVisibilityTreeNode node, Event event) {
            Image img = event.index == 1 ? (!node.option.isTeamVisibilityModifiable() ? (node.option.getTeamVisibility() ? AbstractCompoundDependencyBuildConfigurationEditor.this.disabledSelectedCheckboxImage : AbstractCompoundDependencyBuildConfigurationEditor.this.disabledDeselectedCheckboxImage) : (node.option.getTeamVisibility() ? AbstractCompoundDependencyBuildConfigurationEditor.this.selectedCheckboxImage : AbstractCompoundDependencyBuildConfigurationEditor.this.deselectedCheckboxImage)) : (!node.option.isPersonalVisibilityModifiable() ? (node.option.getPersonalVisibility() ? AbstractCompoundDependencyBuildConfigurationEditor.this.disabledSelectedCheckboxImage : AbstractCompoundDependencyBuildConfigurationEditor.this.disabledDeselectedCheckboxImage) : (node.option.getPersonalVisibility() ? AbstractCompoundDependencyBuildConfigurationEditor.this.selectedCheckboxImage : AbstractCompoundDependencyBuildConfigurationEditor.this.deselectedCheckboxImage));
            TreeItem treeItem = (TreeItem)event.item;
            Rectangle cellBounds = treeItem.getBounds(event.index);
            Rectangle imageBounds = img.getBounds();
            int x = cellBounds.x + (cellBounds.width - imageBounds.width) / 2;
            int y = cellBounds.y + (cellBounds.height - imageBounds.height) / 2;
            event.gc.drawImage(img, x, y);
            Object hasPermission = node.data.get("hasperm" + event.index);
            if (hasPermission instanceof Boolean && !((Boolean)hasPermission).booleanValue()) {
                event.gc.drawString("*", x + imageBounds.width + 2, y, true);
            }
        }

        protected void measure(Event event, Object element) {
        }
    }

    private class RequestVisibilityTreeNode {
        RequestVisibilityTreeNode parent;
        List<RequestVisibilityTreeNode> children;
        String label;
        EnterpriseRequestDialogOption option;
        final Map<Object, Object> data;

        public RequestVisibilityTreeNode(String label) {
            this.label = label;
            this.children = new ArrayList<RequestVisibilityTreeNode>();
            this.data = new HashMap<Object, Object>();
        }

        public RequestVisibilityTreeNode(RequestVisibilityTreeNode parent, EnterpriseRequestDialogOption option) {
            this(option.getLabel());
            this.parent = parent;
            this.option = option;
        }
    }
}

