/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.dialogs;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.dialogs.DependencyBuildDefinitionSelectionDialog;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ViewBuildMapDialog
extends TitleAreaDialog {
    private Text buildDefinitionField;
    private IBuildDefinition buildDefinition;
    private ITeamRepository repository;

    public ViewBuildMapDialog(ITeamRepository repository, Shell parentShell) {
        super(parentShell);
        this.repository = repository;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.setTitle(Messages.ViewBuildMapDialog_TITLE);
        this.setMessage(Messages.ViewBuildMapDialog_DESC);
        this.validateInput();
        return control;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ViewBuildMapDialog_TITLE);
        this.setTitleImage(Activator.getImage("icons/obj16/buildmap_wiz.jpg"));
    }

    protected Control createDialogArea(Composite parent) {
        final Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        Composite mainComposite = new Composite(dialogAreaComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(mainComposite);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)new Label(mainComposite, 0));
        Label buildDefinitionLabelField = new Label(mainComposite, 16384);
        buildDefinitionLabelField.setText(Messages.BuildableSubsetEditor_LABEL_BUILDDEFINITION);
        this.buildDefinitionField = new Text(mainComposite, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.buildDefinitionField);
        Button browseBtn = new Button(mainComposite, 8);
        browseBtn.setText(Messages.BuildableSubsetEditor_BUTTON_BROWSE_DEFINITION);
        GridDataFactory.fillDefaults().applyTo((Control)browseBtn);
        browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IProcessAreaHandle processArea = null;
                DependencyBuildDefinitionSelectionDialog dlg = new DependencyBuildDefinitionSelectionDialog(dialogAreaComposite.getShell(), false, processArea);
                if (dlg.open() == 0) {
                    ViewBuildMapDialog.this.buildDefinition = dlg.getFirstSelectedBuildDefinition();
                    ViewBuildMapDialog.this.buildDefinitionField.setText(ViewBuildMapDialog.this.buildDefinition.getId());
                    ViewBuildMapDialog.this.validateInput();
                }
            }
        });
        String previousSelectedBuildDefinitionUuidValue = Activator.getDefault().getDialogSettings().get("SELECTED_BUILD_DEFINITION_UUID_VALUE");
        if (previousSelectedBuildDefinitionUuidValue != null && !"".equals(previousSelectedBuildDefinitionUuidValue)) {
            this.buildDefinitionField.setText(Messages.BuildSubsetDialog_JOB_FETCH_BUILDDEF);
            this.createBuildDefinitionFetchJob(previousSelectedBuildDefinitionUuidValue).schedule();
        }
        return dialogAreaComposite;
    }

    public IBuildDefinition getBuildDefinition() {
        return this.buildDefinition;
    }

    private void validateInput() {
        this.getButton(0).setEnabled(this.buildDefinition != null);
    }

    private Job createBuildDefinitionFetchJob(final String buildDefinitionUuidValue) {
        return new TeamBuildJob(Messages.BuildSubsetDialog_JOB_FETCH_BUILDDEF, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                try {
                    IBuildDefinitionHandle buildDefinitionHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildDefinitionUuidValue), null);
                    ViewBuildMapDialog.this.buildDefinition = (IBuildDefinition)ViewBuildMapDialog.this.repository.itemManager().fetchCompleteItem((IItemHandle)buildDefinitionHandle, 0, monitor);
                }
                catch (Exception e) {
                    Activator.getDefault().getDialogSettings().put("SELECTED_BUILD_DEFINITION_UUID_VALUE", "");
                    Activator.getDefault().logError(e);
                }
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ViewBuildMapDialog.this.buildDefinition == null) {
                            ViewBuildMapDialog.this.buildDefinitionField.setText("");
                        } else {
                            ViewBuildMapDialog.this.buildDefinitionField.setText(ViewBuildMapDialog.this.buildDefinition.getId());
                        }
                        ViewBuildMapDialog.this.validateInput();
                    }
                });
            }
        };
    }

    protected void okPressed() {
        if (this.buildDefinition != null) {
            Activator.getDefault().getDialogSettings().put("SELECTED_BUILD_DEFINITION_UUID_VALUE", this.buildDefinition.getItemId().getUuidValue());
        }
        super.okPressed();
    }
}

