/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.dialogs;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.dialogs.DependencyBuildDefinitionSelectionDialog;
import com.ibm.team.enterprise.build.ui.pickers.NameByFilePicker;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.utils.WidgetFactoryContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class QueryBuildMapDialog
extends TitleAreaDialog {
    private static final int HMARGIN = 10;
    private static final int LWIDTH = 590;
    private static final String DEFAULT_TITLE = Messages.QueryBuildMapDialog_DEFAULTITLE;
    private static final String DEFAULT_MESSAGE = Messages.QueryBuildMapDialog_DEFAULTDESC;
    private ITeamRepository fRepository;
    private IBuildDefinition fBuildDef;
    private String fFileName;
    private NameByFilePicker fFileNamePicker;
    private Text fFNamePickerText;
    private Text fBuildDefText;
    private Button fBuildBrowseBtn;
    private String fTitle;
    private String fDesc;

    public QueryBuildMapDialog(ITeamRepository repository, Shell parentShell) {
        this(DEFAULT_TITLE, DEFAULT_MESSAGE, repository, parentShell, null);
    }

    public QueryBuildMapDialog(ITeamRepository repository, Shell parentShell, IBuildDefinition buildDef) {
        this(DEFAULT_TITLE, DEFAULT_MESSAGE, repository, parentShell, buildDef);
    }

    public QueryBuildMapDialog(String title, String desc, ITeamRepository repository, Shell parentShell) {
        this(title, desc, repository, parentShell, null);
    }

    public QueryBuildMapDialog(String title, String desc, ITeamRepository repository, Shell parentShell, IBuildDefinition buildDef) {
        super(parentShell);
        this.fRepository = repository;
        this.fBuildDef = buildDef;
        this.fTitle = title;
        this.fDesc = desc;
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Control control = super.createContents(parent);
        this.setTitle(this.fTitle);
        this.setMessage(this.fDesc);
        this.validateInput();
        return control;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.QueryBuildMapDialog_SHELLTITLE);
        this.setTitleImage(Activator.getImage("icons/obj16/buildmap_wiz.jpg"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        Composite mainComposite = new Composite(dialogAreaComposite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 0).applyTo(mainComposite);
        this.addBuildDefControls(mainComposite);
        Label separator = new Label(mainComposite, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, 3, 1);
        data.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        this.addFileSpecControls(mainComposite);
        return dialogAreaComposite;
    }

    private void addBuildDefControls(Composite parent) {
        Label buildDefinitionLabelField = new Label(parent, 16384);
        buildDefinitionLabelField.setText(Messages.BuildableSubsetEditor_LABEL_BUILDDEFINITION);
        buildDefinitionLabelField.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        buildDefinitionLabelField.setFont(parent.getFont());
        this.fBuildDefText = new Text(parent, 2060);
        GridData data = new GridData(4, 4, true, false, 2, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fBuildDefText.setLayoutData((Object)data);
        this.fBuildDefText.setFont(parent.getFont());
        if (this.fBuildDef != null) {
            this.fBuildDefText.setText(this.fBuildDef.getId());
        }
        this.fBuildBrowseBtn = new Button(parent, 8);
        this.fBuildBrowseBtn.setText(Messages.BuildableSubsetEditor_BUTTON_BROWSE_DEFINITION);
        GridDataFactory.fillDefaults().applyTo((Control)this.fBuildBrowseBtn);
        this.fBuildBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IProcessAreaHandle processArea = null;
                DependencyBuildDefinitionSelectionDialog dlg = new DependencyBuildDefinitionSelectionDialog(QueryBuildMapDialog.this.getShell(), false, processArea);
                if (dlg.open() == 0) {
                    QueryBuildMapDialog.this.fBuildDef = dlg.getFirstSelectedBuildDefinition();
                    QueryBuildMapDialog.this.fBuildDefText.setText(QueryBuildMapDialog.this.fBuildDef.getId());
                }
            }
        });
        String previousSelectedBuildDefinitionUuidValue = Activator.getDefault().getDialogSettings().get("SELECTED_BUILD_DEFINITION_UUID_VALUE");
        if (previousSelectedBuildDefinitionUuidValue != null && !"".equals(previousSelectedBuildDefinitionUuidValue) && this.fBuildDef == null) {
            this.fBuildDefText.setText(Messages.BuildSubsetDialog_JOB_FETCH_BUILDDEF);
            this.createBuildDefinitionFetchJob(previousSelectedBuildDefinitionUuidValue).schedule();
        }
    }

    private void addFileSpecControls(Composite parent) {
        Group fileGroup = new Group(parent, 0);
        fileGroup.setText(Messages.QueryBuildMapDialog_MEMBERGROUP_NAME);
        GridData data = new GridData(4, 4, true, true, 3, 1);
        fileGroup.setLayoutData((Object)data);
        fileGroup.setLayout((Layout)new GridLayout(3, false));
        Label partToSearchLabel = new Label((Composite)fileGroup, 64);
        partToSearchLabel.setText(Messages.QueryBuildMapDialog_SEARCHMEMBER_LABEL);
        data = new GridData();
        data.horizontalSpan = 3;
        data.widthHint = 590;
        partToSearchLabel.setLayoutData((Object)data);
        this.fFNamePickerText = new Text((Composite)fileGroup, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fFNamePickerText);
        this.fFileNamePicker = new NameByFilePicker((Composite)fileGroup, WidgetFactoryContext.forDialogBox(), this.fFNamePickerText);
        this.fFNamePickerText.setToolTipText(Messages.QueryBuildMapDialog_SEARCHMEMBER_TOOLTIP);
        this.fFNamePickerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QueryBuildMapDialog.this.fFileName = QueryBuildMapDialog.this.fFNamePickerText.getText();
                QueryBuildMapDialog.this.validateInput();
            }
        });
        Label separator = new Label((Composite)fileGroup, 0);
        separator.setVisible(false);
        separator = new Label((Composite)fileGroup, 0);
        separator.setVisible(false);
    }

    private Job createBuildDefinitionFetchJob(final String buildDefinitionUuidValue) {
        return new TeamBuildJob(Messages.BuildSubsetDialog_JOB_FETCH_BUILDDEF, true){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                try {
                    IBuildDefinitionHandle buildDefinitionHandle = (IBuildDefinitionHandle)IBuildDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)buildDefinitionUuidValue), null);
                    QueryBuildMapDialog.this.fBuildDef = (IBuildDefinition)QueryBuildMapDialog.this.fRepository.itemManager().fetchCompleteItem((IItemHandle)buildDefinitionHandle, 0, monitor);
                }
                catch (Exception e) {
                    Activator.getDefault().getDialogSettings().put("SELECTED_BUILD_DEFINITION_UUID_VALUE", "");
                    Activator.getDefault().logError(e);
                }
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (QueryBuildMapDialog.this.fBuildDef == null) {
                            QueryBuildMapDialog.this.fBuildDefText.setText("");
                        } else {
                            QueryBuildMapDialog.this.fBuildDefText.setText(QueryBuildMapDialog.this.fBuildDef.getId());
                        }
                        QueryBuildMapDialog.this.validateInput();
                    }
                });
            }
        };
    }

    private void validateInput() {
        this.getButton(0).setEnabled(this.fBuildDef != null && this.fFileName != null && !this.fFileName.isEmpty());
    }

    public IBuildDefinition getBuildDefinition() {
        return this.fBuildDef;
    }

    public String getFileName() {
        return this.fFileName;
    }
}

