/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.dialogs;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.ui.dialogs.definitions.BuildDefinitionSelectionDialog;
import com.ibm.team.enterprise.build.ui.dialogs.EnterpriseBuildDefinitionLabelProvider;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.ArrayList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class EnterpriseBuildDefinitionSelectionDialog
extends BuildDefinitionSelectionDialog {
    private IProcessAreaHandle fProcessArea = null;
    private ITeamRepository fRepository = null;
    private Button fShowAllItemsButton;
    private Button fShowSubSetItemsButton;
    private Object[] fElements = null;
    private boolean fShowRepository = false;

    public EnterpriseBuildDefinitionSelectionDialog(Shell parent, boolean isMultiSelectAllowed, IProcessAreaHandle processArea) {
        super(parent, isMultiSelectAllowed);
        this.fProcessArea = processArea;
    }

    public EnterpriseBuildDefinitionSelectionDialog(Shell parent, boolean isMultiSelectAllowed, ITeamRepository repository) {
        super(parent, isMultiSelectAllowed);
        this.fRepository = repository;
    }

    public EnterpriseBuildDefinitionSelectionDialog(Shell parent, String title, String message, boolean isMultiSelectAllowed, boolean showRepository, IProcessAreaHandle processArea) {
        super(parent, title, message, isMultiSelectAllowed, showRepository);
        this.fProcessArea = processArea;
        this.fShowRepository = showRepository;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.fProcessArea != null || this.fRepository != null) {
            GridLayoutFactory.swtDefaults().applyTo(composite);
            GridDataFactory.createFrom((GridData)GridDataFactory.fillDefaults().grab(true, true).create()).applyTo((Control)composite);
            this.createRadioButtonBar(composite);
            if (this.fProcessArea != null) {
                this.fFilteredList.setLabelProvider((ILabelProvider)new EnterpriseBuildDefinitionLabelProvider(this.fShowRepository, this.fProcessArea));
            } else {
                this.fFilteredList.setLabelProvider((ILabelProvider)new EnterpriseBuildDefinitionLabelProvider(this.fShowRepository, this.fRepository));
            }
            ((EnterpriseBuildDefinitionLabelProvider)this.fFilteredList.getLabelProvider()).setShowProjectArea(this.fShowAllItemsButton.getSelection());
        }
        return composite;
    }

    private void createRadioButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 4);
        int defaultMargin = 4;
        GridLayoutFactory.fillDefaults().numColumns(2).margins(defaultMargin, defaultMargin).equalWidth(true).applyTo(composite);
        GridDataFactory.fillDefaults().applyTo((Control)composite);
        this.fShowSubSetItemsButton = this.createRadioButton(composite, Messages.EnterpriseBuildDefinitionSelectionDialog_SHOW_BUILD_DEFINITIONS_IN_PROJECT_AREA, this.getShowListener(), this.fProcessArea != null);
        this.fShowAllItemsButton = this.createRadioButton(composite, Messages.EnterpriseBuildDefinitionSelectionDialog_SHOW_ALL_BUILD_DEFINITIONS, this.getShowListener(), this.fProcessArea == null);
    }

    private Button createRadioButton(Composite parent, String text, SelectionAdapter adapter, boolean isSelected) {
        Button newButton = new Button(parent, 16);
        newButton.setText(text);
        newButton.addSelectionListener((SelectionListener)adapter);
        newButton.setSelection(isSelected);
        GridDataFactory.fillDefaults().grab(true, false).align(1, 4).applyTo((Control)newButton);
        return newButton;
    }

    private SelectionAdapter getShowListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection() && EnterpriseBuildDefinitionSelectionDialog.this.fElements != null && EnterpriseBuildDefinitionSelectionDialog.this.fProcessArea != null) {
                    if (e.widget == EnterpriseBuildDefinitionSelectionDialog.this.fShowSubSetItemsButton) {
                        ((EnterpriseBuildDefinitionLabelProvider)EnterpriseBuildDefinitionSelectionDialog.this.fFilteredList.getLabelProvider()).setShowProjectArea(false);
                    } else {
                        ((EnterpriseBuildDefinitionLabelProvider)EnterpriseBuildDefinitionSelectionDialog.this.fFilteredList.getLabelProvider()).setShowProjectArea(true);
                    }
                    EnterpriseBuildDefinitionSelectionDialog.this.setListElements(EnterpriseBuildDefinitionSelectionDialog.this.fElements);
                }
            }
        };
    }

    public void setListElements(Object[] elements) {
        if (this.fElements == null && elements != null && elements.length != 0 && elements[0] instanceof IBuildDefinition) {
            this.fElements = elements;
        }
        if (this.fElements != null) {
            super.setListElements(this.getSelectedList());
        } else {
            super.setListElements(elements);
        }
    }

    private Object[] getSelectedList() {
        if (this.fShowSubSetItemsButton != null && this.fShowSubSetItemsButton.getSelection()) {
            ArrayList<Object> subsetElements = new ArrayList<Object>();
            Object[] objectArray = this.fElements;
            int n = this.fElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object buildDef = objectArray[n2];
                if (buildDef instanceof IBuildDefinition && ((IBuildDefinition)buildDef).getProcessArea() instanceof IProjectAreaHandle && ((IBuildDefinition)buildDef).getProcessArea().getItemId().equals((Object)this.fProcessArea.getItemId())) {
                    subsetElements.add(buildDef);
                }
                ++n2;
            }
            return subsetElements.toArray();
        }
        return this.fElements;
    }
}

