/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.dialogs;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.internal.ui.BuildDefinitionLabelProvider;
import com.ibm.team.build.internal.ui.BuildUIMessages;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class EnterpriseBuildDefinitionLabelProvider
extends BuildDefinitionLabelProvider {
    private boolean fShowProjectArea = true;
    private boolean fShowRepository = false;
    private HashMap<String, String> fUUIDToProcessAreaNames = null;
    private IProcessAreaHandle fProcessArea = null;

    public EnterpriseBuildDefinitionLabelProvider(IProcessAreaHandle processArea) {
        this(false, processArea);
    }

    public EnterpriseBuildDefinitionLabelProvider(boolean showRepository, IProcessAreaHandle processArea) {
        this(showRepository, processArea != null ? (ITeamRepository)processArea.getOrigin() : null);
        this.fProcessArea = processArea;
    }

    public EnterpriseBuildDefinitionLabelProvider(boolean showRepository, ITeamRepository repository) {
        super(showRepository);
        this.fShowRepository = showRepository;
        if (repository != null) {
            try {
                this.fUUIDToProcessAreaNames = this.getProcessAreaNames(this.getProcessAreas(repository));
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        }
    }

    private HashMap<String, String> getProcessAreaNames(List<IProcessArea> projectAreas) {
        HashMap<String, String> paNames = new HashMap<String, String>();
        if (projectAreas != null) {
            for (IProcessArea pa : projectAreas) {
                if (pa == null) continue;
                paNames.put(pa.getItemId().getUuidValue(), pa.getName());
            }
        }
        return paNames;
    }

    private List<IProcessArea> getProcessAreas(final ITeamRepository repository) throws TeamRepositoryException {
        final ArrayList<IProcessArea> processAreas = new ArrayList<IProcessArea>();
        Job fetchProjectAreasJob = new Job(Messages.EnterpriseBuildDefinitionLabelProvider_JOB_FETCH_PROCESS_AREAS){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (repository != null) {
                        processAreas.addAll(repository.itemManager().fetchCompleteItems(repository.itemManager().getKnownSharedItems(IProjectArea.ITEM_TYPE), 2, (IProgressMonitor)new NullProgressMonitor()));
                        processAreas.addAll(repository.itemManager().fetchCompleteItems(repository.itemManager().getKnownSharedItems(ITeamArea.ITEM_TYPE), 2, (IProgressMonitor)new NullProgressMonitor()));
                    }
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        fetchProjectAreasJob.schedule();
        try {
            fetchProjectAreasJob.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return processAreas;
    }

    public void setShowProjectArea(boolean showProjectArea) {
        this.fShowProjectArea = showProjectArea;
    }

    protected String getLabel(IBuildDefinitionHandle definitionHandle, String id) {
        String completeId = id;
        if (this.fShowProjectArea && this.fUUIDToProcessAreaNames != null) {
            try {
                if (definitionHandle != null && definitionHandle instanceof IBuildDefinition) {
                    IProcessAreaHandle pa = ((IBuildDefinition)definitionHandle.getFullState()).getProcessArea();
                    completeId = NLS.bind((String)Messages.EnterpriseBuildDefinitionLabelProvider_BUILD_DEFINITION_LABEL_WITH_PROJECT_AREA, (Object)id, (Object)this.fUUIDToProcessAreaNames.get(pa.getItemId().getUuidValue()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return super.getLabel(definitionHandle, id);
            }
        }
        if (this.fShowRepository && definitionHandle.getOrigin() != null) {
            ITeamRepository repo = (ITeamRepository)definitionHandle.getOrigin();
            String repoId = repo.getName();
            if (repoId == null || repoId.length() == 0) {
                repoId = repo.getRepositoryURI();
            }
            return NLS.bind((String)BuildUIMessages.BUILD_DEFINITION_LABEL_WITH_REPOSITORY, (Object)completeId, (Object)repoId);
        }
        return completeId;
    }
}

