/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.dialogs;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.build.common.IBuildUtility;
import com.ibm.team.enterprise.build.ui.dialogs.EnterpriseBuildDefinitionSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.IPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosPlatformObject;
import com.ibm.team.process.common.IProcessAreaHandle;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Shell;

public class DependencyBuildDefinitionSelectionDialog
extends EnterpriseBuildDefinitionSelectionDialog {
    Class<? extends IPlatformObject> platform = null;
    private static final String IBMidependencyBuildId = "com.ibm.team.enterprise.ibmi.build.common.IIBMiDependencyBuildConfigurationElement";
    private static final String zOSdependencyBuildId = "com.ibm.teamz.build.dependency";
    private static final String zOSNewdependencyBuildId = "com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement";

    public DependencyBuildDefinitionSelectionDialog(Shell parent, boolean isMultiSelectAllowed, IProcessAreaHandle processArea, Class<? extends IPlatformObject> p) {
        super(parent, isMultiSelectAllowed, processArea);
        this.platform = p;
    }

    public DependencyBuildDefinitionSelectionDialog(Shell parent, boolean isMultiSelectAllowed, IProcessAreaHandle processArea) {
        super(parent, isMultiSelectAllowed, processArea);
    }

    @Override
    public void setListElements(Object[] elements) {
        ArrayList<IBuildDefinition> buildDefinitions = new ArrayList<IBuildDefinition>();
        boolean isAtLeastOneBuildDefinition = false;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IBuildDefinition) {
                IBuildDefinition buildDefinition = (IBuildDefinition)element;
                if (this.platform == null) {
                    if (this.isDependencyBuildTemplate(buildDefinition)) {
                        buildDefinitions.add(buildDefinition);
                    }
                } else if (this.platform.equals(IIBMiPlatformObject.class)) {
                    if (buildDefinition.getConfigurationElement(IBMidependencyBuildId) != null) {
                        buildDefinitions.add(buildDefinition);
                    }
                } else if (this.platform.equals(IZosPlatformObject.class) && (buildDefinition.getConfigurationElement(zOSdependencyBuildId) != null || buildDefinition.getConfigurationElement(zOSNewdependencyBuildId) != null)) {
                    buildDefinitions.add(buildDefinition);
                }
            }
            ++n2;
        }
        if (buildDefinitions.size() > 0) {
            super.setListElements(buildDefinitions.toArray());
        } else {
            super.setListElements(elements);
        }
    }

    private boolean isDependencyBuildTemplate(IBuildDefinition depBuildDefinition) {
        return IBuildUtility.isDependencyBuild((IBuildDefinition)depBuildDefinition) || IBuildUtility.isOldDependencyBuild((IBuildDefinition)depBuildDefinition);
    }
}

