/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.dialogs;

import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.jface.labelProviders.BaseLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class ComponentSelectionDialog
extends ListSelectionDialog {
    private static List<IComponent> allComponents;

    public ComponentSelectionDialog(Shell parentShell, ITeamRepository repository, IWorkspaceHandle workspaceHandle, String title, String message, Collection<IComponentHandle> initialSelection) {
        allComponents = ComponentSelectionDialog.sortComponents(ComponentSelectionDialog.fetchComponents(repository, workspaceHandle));
        super(parentShell, allComponents, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new ComponentLabelProvider(), message);
        this.setInitialElementSelections(this.getInitialIComponents(initialSelection));
        this.setTitle(title);
    }

    private static List<IComponent> fetchComponents(final ITeamRepository repository, final IWorkspaceHandle workspaceHandle) {
        final ArrayList<IComponent> components = new ArrayList<IComponent>();
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repository).getWorkspaceConnection(workspaceHandle, monitor);
                    IFetchResult fetchResult = repository.itemManager().fetchCompleteItemsPermissionAware(connection.getComponents(), 0, monitor);
                    for (Object o : fetchResult.getRetrievedItems()) {
                        if (!(o instanceof IComponent)) continue;
                        components.add((IComponent)o);
                    }
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return components;
    }

    private static List<IComponent> sortComponents(List<IComponent> components) {
        if (components != null) {
            Collections.sort(components, new Comparator<IComponent>(){

                @Override
                public int compare(IComponent o1, IComponent o2) {
                    String name1 = o1.getName();
                    String name2 = o2.getName();
                    return name1.compareToIgnoreCase(name2);
                }
            });
        }
        return components;
    }

    private List<IComponent> getInitialIComponents(Collection<IComponentHandle> initialSelection) {
        ArrayList<IComponent> initialComponentSelection = new ArrayList<IComponent>();
        ArrayList<UUID> initialUUIDs = new ArrayList<UUID>();
        if (initialSelection != null) {
            for (IComponentHandle handle : initialSelection) {
                initialUUIDs.add(handle.getItemId());
            }
            if (allComponents != null) {
                for (IComponent o : allComponents) {
                    if (!initialUUIDs.contains(o.getItemId())) continue;
                    initialComponentSelection.add(o);
                }
            }
        }
        return initialComponentSelection;
    }

    private static class ComponentLabelProvider
    extends BaseLabelProvider {
        private Image componentImage;

        private ComponentLabelProvider() {
        }

        public void updateLabel(ViewerLabel label, Object element) {
            if (element instanceof IComponent) {
                label.setText(((IComponent)element).getName());
            }
            if (this.componentImage == null) {
                this.componentImage = this.getImage(ImagePool.COMPONENT);
            }
            label.setImage(this.componentImage);
        }
    }
}

