/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.dialogs;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableFilesViewer;
import com.ibm.team.enterprise.buildablesubset.common.IBuildSubsetRule;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetFileDesc;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddFileToSubsetSummaryDialog
extends TrayDialog {
    private IBuildSubsetRule rule;
    private List<ISubsetFileDesc> buildableFiles;
    private Text ruleSummaryField;
    private ITeamRepository repository;
    private IBuildDefinition buildDefinition;
    private List<ISubsetCriteria> criteria;

    public AddFileToSubsetSummaryDialog(IBuildSubsetRule rule, ISubsetFileDesc[] buildableFiles, Shell shell, ITeamRepository repository, IBuildDefinition buildDefinition) {
        this(rule, buildableFiles, shell, repository, buildDefinition, null);
    }

    public AddFileToSubsetSummaryDialog(IBuildSubsetRule rule, ISubsetFileDesc[] buildableFiles, Shell shell, ITeamRepository repository, IBuildDefinition buildDefinition, List<ISubsetCriteria> criteria) {
        super(shell);
        this.rule = rule;
        this.repository = repository;
        this.buildDefinition = buildDefinition;
        this.criteria = criteria;
        this.buildableFiles = Arrays.asList(buildableFiles);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AddFileToSubsetSummaryDialog_TITLE);
        this.setHelpAvailable(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (composite.getLayoutData() instanceof GridData) {
            ((GridData)composite.getLayoutData()).grabExcessHorizontalSpace = true;
        }
        Label label = new Label(composite, 16384);
        label.setText(Messages.AddFileToSubsetSummaryDialog_CRITERIA_LABEL);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        if (this.rule != null) {
            this.ruleSummaryField = new Text(composite, 2826);
            GridDataFactory.fillDefaults().hint(600, this.ruleSummaryField.getLineHeight() * 6).grab(true, false).applyTo((Control)this.ruleSummaryField);
            this.ruleSummaryField.setText(this.rule.getCriteriaSummary());
        }
        int size = this.buildableFiles.size();
        label = new Label(composite, 16384);
        label.setText(NLS.bind((String)Messages.AddFileToSubsetSummaryDialog_NUMBER_OF_FILES_LABEL, (Object[])new String[]{String.valueOf(size)}));
        GridDataFactory.fillDefaults().applyTo((Control)label);
        BuildableFilesViewer viewer = new BuildableFilesViewer(this.repository, this.buildDefinition, null, false, true);
        viewer.createContents(composite);
        GridDataFactory.fillDefaults().minSize(600, 200).grab(true, true).applyTo((Control)viewer.getMainComposite());
        if (this.criteria != null) {
            viewer.setCriteria(this.criteria);
        }
        viewer.resolvePaths(this.buildableFiles);
        viewer.getBuildableFiles().addAll(this.buildableFiles);
        viewer.getTableViewer().setInput(viewer.getBuildableFiles());
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected boolean isResizable() {
        return true;
    }
}

