/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.data.export;

import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableData {
    private List<ColumnHeader> columnHeaders = new ArrayList<ColumnHeader>();
    private List<Row> rows;

    public TableData(TableColumn[] columns) {
        int i = 0;
        while (i < columns.length) {
            TableColumn column = columns[i];
            if (!column.getText().trim().equals("")) {
                if (column.getData() == null || !(column.getData() instanceof String)) {
                    this.columnHeaders.add(new ColumnHeader(i, column.getText()));
                } else {
                    this.columnHeaders.add(new ColumnHeader(i, (String)column.getData(), column.getText()));
                }
            }
            ++i;
        }
        this.rows = new ArrayList<Row>();
    }

    public void addRow(SelectResult selectResult) {
        Row row = new Row(this.columnHeaders.size());
        for (Binding binding : selectResult.getBindings()) {
            int i = 0;
            while (i < this.columnHeaders.size()) {
                if (binding.getName().equals(this.columnHeaders.get(i).getId())) {
                    row.setColumnValue(i, binding.getValue());
                }
                ++i;
            }
        }
        this.rows.add(row);
    }

    public void addRow(TableItem tableItem) {
        Row row = new Row(this.columnHeaders.size());
        int i = 0;
        while (i < this.columnHeaders.size()) {
            ColumnHeader header = this.columnHeaders.get(i);
            row.setColumnValue(i, tableItem.getText(header.index));
            ++i;
        }
        this.rows.add(row);
    }

    public List<ColumnHeader> getColumnHeaders() {
        return this.columnHeaders;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    protected class ColumnHeader {
        int index;
        String name;
        String id;

        public ColumnHeader(int index, String id, String name) {
            this.index = index;
            this.id = this.stripOutParentFromComplexItem(id);
            this.name = name;
        }

        public ColumnHeader(int index, String id) {
            this.index = index;
            this.id = this.stripOutParentFromComplexItem(id);
            this.name = id;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        private String stripOutParentFromComplexItem(String id) {
            int index = id.indexOf(" > ");
            if (index > -1) {
                if (index + 3 < id.length()) {
                    return id.substring(index + 3);
                }
                return "";
            }
            return id;
        }
    }

    class Row {
        private String[] columnValues;

        public Row(int numColumns) {
            this.columnValues = new String[numColumns];
        }

        public void setColumnValue(int columnIndex, String value) {
            if (columnIndex < 0 || columnIndex >= this.columnValues.length) {
                throw new IndexOutOfBoundsException(String.valueOf(columnIndex) + "," + this.columnValues.length);
            }
            this.columnValues[columnIndex] = value;
        }

        public String getColumnValue(int columnIndex) {
            if (columnIndex < 0 || columnIndex >= this.columnValues.length) {
                throw new IndexOutOfBoundsException(String.valueOf(columnIndex) + "," + this.columnValues.length);
            }
            return this.columnValues[columnIndex];
        }
    }
}

