/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.data.export;

import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.data.export.IMetadataQueryResultExporter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class MetadataQueryResultExporterFactory {
    private static MetadataQueryResultExporterFactory _instance;
    private final Map<String, IMetadataQueryResultExporter> exporterMap = new HashMap<String, IMetadataQueryResultExporter>();

    private MetadataQueryResultExporterFactory() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("com.ibm.team.enterprise.build.ui.dataExporter");
        IConfigurationElement[] members = extensionPoint.getConfigurationElements();
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            try {
                IMetadataQueryResultExporter exporter = this.createExporter(member);
                this.exporterMap.put(exporter.getId(), exporter);
            }
            catch (Exception e) {
                Activator.getDefault().logError(e);
            }
            ++m;
        }
    }

    public IMetadataQueryResultExporter getExporter(String id) {
        return this.exporterMap.get(id);
    }

    public List<IMetadataQueryResultExporter> getAllExporters() {
        ArrayList<IMetadataQueryResultExporter> exporters = new ArrayList<IMetadataQueryResultExporter>(this.exporterMap.size());
        exporters.addAll(this.exporterMap.values());
        return exporters;
    }

    public static MetadataQueryResultExporterFactory getInstance() {
        if (_instance == null) {
            _instance = new MetadataQueryResultExporterFactory();
        }
        return _instance;
    }

    private IMetadataQueryResultExporter createExporter(IConfigurationElement element) throws ClassNotFoundException {
        try {
            Object obj = element.createExecutableExtension("class");
            if (obj instanceof IMetadataQueryResultExporter) {
                IMetadataQueryResultExporter exporter = (IMetadataQueryResultExporter)obj;
                String id = element.getAttribute("id");
                if (id == null || id.trim().equals("")) {
                    throw new NullPointerException("id is NULL");
                }
                exporter.setId(id);
                String label = element.getAttribute("label");
                if (label == null || label.trim().equals("")) {
                    label = id;
                }
                exporter.setLabel(label);
                String fileExtension = element.getAttribute("fileExtension");
                if (fileExtension == null || fileExtension.trim().equals("")) {
                    fileExtension = "*.*";
                }
                if (!fileExtension.startsWith("*.")) {
                    fileExtension = fileExtension.startsWith(".") ? "*" + fileExtension : "*." + fileExtension;
                }
                exporter.setFileExtension(fileExtension);
                return exporter;
            }
            throw new ClassNotFoundException(IMetadataQueryResultExporter.class.getName());
        }
        catch (CoreException e) {
            throw new ClassNotFoundException(e.getLocalizedMessage(), e);
        }
    }
}

