/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.data.export;

import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.data.export.IMetadataQueryResultExporter;
import com.ibm.team.enterprise.build.ui.data.export.MetadataQueryResultExporterFactory;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportMetadataQueryResultDialog
extends TrayDialog {
    private Combo methodCombo;
    private Text fileLocationField;
    private Button browseBtn;
    private String fileLocation;
    private IMetadataQueryResultExporter exporter;

    public ExportMetadataQueryResultDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setHelpAvailable(false);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ExportMetadataQueryResultDialog_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 3;
        ((GridData)composite.getLayoutData()).minimumWidth = 400;
        Label label = new Label(composite, 16384);
        label.setText(Messages.ExportMetadataQueryResultDialog_PROMPT);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)label);
        label = new Label(composite, 16384);
        label.setText(Messages.ExportMetadataQueryResultDialog_FILE_FORMAT);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.methodCombo = new Combo(composite, 12);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.methodCombo);
        this.fillExporters();
        label = new Label(composite, 16384);
        label.setText(Messages.ExportMetadataQueryResultDialog_DESTINATION);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fileLocationField = new Text(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fileLocationField);
        this.fileLocationField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportMetadataQueryResultDialog.this.updateButtons();
            }
        });
        this.browseBtn = new Button(composite, 8);
        this.browseBtn.setText(Messages.ExportMetadataQueryResultDialog_BROWSE);
        GridDataFactory.fillDefaults().applyTo((Control)this.browseBtn);
        this.browseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedFile;
                String[] filePathAndName;
                FileDialog dlg = new FileDialog(ExportMetadataQueryResultDialog.this.getParentShell(), 8192);
                IMetadataQueryResultExporter exporter = (IMetadataQueryResultExporter)ExportMetadataQueryResultDialog.this.methodCombo.getData(ExportMetadataQueryResultDialog.this.methodCombo.getText());
                if (exporter != null && exporter.getFileExtension() != null) {
                    dlg.setFilterExtensions(new String[]{exporter.getFileExtension()});
                }
                if ((filePathAndName = ExportMetadataQueryResultDialog.this.retrieveFilePathAndName())[0] != null) {
                    dlg.setFilterPath(filePathAndName[0]);
                }
                if (filePathAndName[1] != null) {
                    dlg.setFileName(filePathAndName[1]);
                }
                if ((selectedFile = dlg.open()) != null) {
                    ExportMetadataQueryResultDialog.this.fileLocationField.setText(selectedFile);
                }
                ExportMetadataQueryResultDialog.this.updateButtons();
            }
        });
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.updateButtons();
        return buttonBar;
    }

    private void fillExporters() {
        List<IMetadataQueryResultExporter> exporters = MetadataQueryResultExporterFactory.getInstance().getAllExporters();
        Collections.sort(exporters, new Comparator<IMetadataQueryResultExporter>(){

            @Override
            public int compare(IMetadataQueryResultExporter exporter1, IMetadataQueryResultExporter exporter2) {
                return exporter1.getLabel().compareTo(exporter2.getLabel());
            }
        });
        for (IMetadataQueryResultExporter exporter : exporters) {
            this.methodCombo.add(exporter.getLabel());
            this.methodCombo.setData(exporter.getLabel(), (Object)exporter);
        }
        this.methodCombo.select(0);
    }

    protected void okPressed() {
        this.fileLocation = this.fileLocationField.getText();
        String exporterId = this.methodCombo.getText();
        this.exporter = (IMetadataQueryResultExporter)this.methodCombo.getData(exporterId);
        super.okPressed();
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public IMetadataQueryResultExporter getMethod() {
        return this.exporter;
    }

    private void updateButtons() {
        this.getButton(0).setEnabled(this.validateInputs());
    }

    private boolean validateInputs() {
        if (this.methodCombo.getText().trim().isEmpty()) {
            return false;
        }
        return !this.fileLocationField.getText().trim().isEmpty();
    }

    private String[] retrieveFilePathAndName() {
        String filePath = null;
        String fileName = null;
        try {
            String fileLocationText;
            if (this.fileLocationField != null && (fileLocationText = this.fileLocationField.getText()) != null && fileLocationText.length() > 0) {
                int index = fileLocationText.lastIndexOf(File.separator);
                if (index > 0) {
                    filePath = fileLocationText.substring(0, index + 1);
                }
                if (index < fileLocationText.length() - 1) {
                    fileName = fileLocationText.substring(index + 1);
                }
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError(e);
        }
        return new String[]{filePath, fileName};
    }
}

