/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.data.export;

import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.data.export.ExportMetadataQueryResultDialog;
import com.ibm.team.enterprise.build.ui.data.export.IMetadataQueryResultExporter;
import com.ibm.team.enterprise.build.ui.data.export.IQueryResultExportSupplier;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ExportDataQueryResultAction
implements IViewActionDelegate,
IEditorActionDelegate {
    private IViewPart view;
    private IEditorPart editor;
    private IQueryResultExportSupplier exportSupplier;

    public void run(IAction action) {
        if (this.exportSupplier == null || this.view == null && this.editor == null) {
            return;
        }
        final Shell shell = this.view == null ? this.editor.getSite().getShell() : this.view.getSite().getShell();
        ExportMetadataQueryResultDialog dlg = new ExportMetadataQueryResultDialog(shell);
        if (dlg.open() == 0) {
            final IMetadataQueryResultExporter exporter = dlg.getMethod();
            final String fileLocation = dlg.getFileLocation();
            try {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            File file = new File(fileLocation);
                            if (file.exists() && !MessageDialog.openConfirm((Shell)shell, (String)Messages.ExportAllScdQueryResultAction_TITLE, (String)Messages.ExportAllScdQueryResultAction_OVERWRITE_CONFIRM)) {
                                return;
                            }
                            FileOutputStream fos = new FileOutputStream(file);
                            exporter.serializeToStream(ExportDataQueryResultAction.this.exportSupplier.gatherExportData(monitor), fos);
                            fos.close();
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                new ProgressMonitorDialog(shell).run(false, true, op);
            }
            catch (InterruptedException op) {
            }
            catch (InvocationTargetException e) {
                String errorMessage = e.getLocalizedMessage();
                if (errorMessage == null && e.getCause() != null) {
                    errorMessage = e.getCause().getLocalizedMessage();
                }
                MessageDialog.openError((Shell)shell, (String)Messages.ExportAllScdQueryResultAction_TITLE, (String)NLS.bind((String)Messages.ExportAllScdQueryResultAction_ERROR, (Object)errorMessage));
                Activator.getDefault().logError(e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart view) {
        this.view = view;
        if (view instanceof IQueryResultExportSupplier) {
            this.exportSupplier = (IQueryResultExportSupplier)view;
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor;
        if (targetEditor instanceof IQueryResultExportSupplier) {
            this.exportSupplier = (IQueryResultExportSupplier)targetEditor;
        }
    }
}

