/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.data.export;

import com.ibm.team.enterprise.build.ui.data.export.AbstractMetadataQueryResultExporter;
import com.ibm.team.enterprise.build.ui.data.export.IMetadataQueryResultExporter;
import com.ibm.team.enterprise.build.ui.data.export.TableData;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;

public abstract class AbstractMetadataQueryResultCsvExporter
extends AbstractMetadataQueryResultExporter
implements IMetadataQueryResultExporter {
    private static final String DEFAULT_ENCODING = "UTF-8";

    public abstract String getSeparator();

    @Override
    public void serializeToStream(TableData tableData, OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, DEFAULT_ENCODING));
        Iterator<TableData.ColumnHeader> columnIterator = tableData.getColumnHeaders().iterator();
        while (columnIterator.hasNext()) {
            writer.append(columnIterator.next().getName());
            if (!columnIterator.hasNext()) continue;
            writer.append(this.getSeparator());
        }
        if (tableData.getColumnHeaders().size() > 0) {
            writer.append("\n");
        }
        Iterator<TableData.Row> rowIterator = tableData.getRows().iterator();
        while (rowIterator.hasNext()) {
            TableData.Row nextRow = rowIterator.next();
            int col = 0;
            while (col < tableData.getColumnHeaders().size()) {
                writer.append("\"").append(nextRow.getColumnValue(col)).append("\"");
                if (col < tableData.getColumnHeaders().size() - 1) {
                    writer.append(this.getSeparator());
                }
                ++col;
            }
            if (!rowIterator.hasNext()) continue;
            writer.append("\n");
        }
        writer.flush();
    }
}

