/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.browser;

import com.ibm.team.enterprise.build.ui.editors.EnterpriseBrowserEditor;
import com.ibm.team.enterprise.ibmi.internal.definitions.ui.actions.EditSystemDefinitionActionDelegate;
import com.ibm.team.enterprise.internal.build.ui.browser.AbstractOpenEditorAction;
import com.ibm.team.enterprise.internal.build.ui.browser.IBrowserAction;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISearchPath;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.common.impl.ProjectAreaHandleImpl;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class OpenLocalSysDefinitionAction
extends AbstractOpenEditorAction
implements IBrowserAction {
    private static final String EMPTY_STRING = "";
    private static final String UTF_8 = "UTF-8";
    private static final String URL_PARM_UUID = "uuid";
    private static final String URL_PARM_STATEID = "stateid";
    private static final String URL_PARM_TYPE = "type";
    private static final String SYSTEMDEFINITIONS = "systemdefinitions";
    public static final String PARM_LANGDEF = "languageDefinition";
    public static final String PARM_TRANSLATOR = "translator";
    public static final String PARM_SEARCHPATH = "searchPathDefinition";
    public static final String PARM_RESDEF = "resourceDefinition";
    private static boolean isLatestSysDef = true;
    private String fileLocation = null;
    private ITeamRepository repository = null;

    @Override
    protected IEditorInput getEditorInput(String editorId, String filePath, ITeamRepository teamRepository) throws Exception {
        this.fileLocation = filePath;
        this.repository = teamRepository;
        return null;
    }

    @Override
    protected boolean canSupportFile(String filePath) {
        return filePath.contains("systemdefinition");
    }

    @Override
    protected void openEditor(IEditorInput editorInput, String editorId, EnterpriseBrowserEditor browser, IProgressMonitor monitor) throws PartInitException {
        block5: {
            try {
                String type;
                String uriString = this.fileLocation;
                Map<String, List<String>> queryParms = OpenLocalSysDefinitionAction.parseParmsFromURL(uriString);
                String uuid = queryParms.containsKey(URL_PARM_UUID) ? queryParms.get(URL_PARM_UUID).get(0) : null;
                String stateid = queryParms.containsKey(URL_PARM_STATEID) ? queryParms.get(URL_PARM_STATEID).get(0) : null;
                String string = type = queryParms.containsKey(URL_PARM_TYPE) ? queryParms.get(URL_PARM_TYPE).get(0) : null;
                if (uuid == null || type == null || stateid == null) break block5;
                try {
                    ISystemDefinition systemDefinition = null;
                    systemDefinition = OpenLocalSysDefinitionAction.fetchSystemDefinition(this.repository, uuid, stateid, type);
                    if (systemDefinition == null) break block5;
                    String projectAreaUUID = systemDefinition.getProjectArea().getItemId().getUuidValue();
                    IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(UUID.valueOf((String)projectAreaUUID), null);
                    ((ProjectAreaHandleImpl)projectAreaHandle).setOrigin((Object)this.repository);
                    if (systemDefinition instanceof IZosLanguageDefinition || systemDefinition instanceof IZosTranslator || systemDefinition instanceof IDataSetDefinition) {
                        com.ibm.team.enterprise.zos.internal.systemdefinition.ui.domain.actions.EditSystemDefinitionActionDelegate.run((ISystemDefinition)systemDefinition, (IProjectAreaHandle)projectAreaHandle, (IWorkbenchPage)browser.getEditorSite().getPage(), (boolean)isLatestSysDef, (boolean)true);
                        break block5;
                    }
                    EditSystemDefinitionActionDelegate.run((ISystemDefinition)systemDefinition, (IProjectAreaHandle)projectAreaHandle, (IWorkbenchPage)browser.getEditorSite().getPage(), (boolean)isLatestSysDef, (boolean)true);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, List<String>> parseParmsFromURL(String url) throws UnsupportedEncodingException {
        String[] urlQuery;
        HashMap<String, List<String>> parms = new HashMap<String, List<String>>();
        if (url != null && (urlQuery = url.split("\\?")).length > 1) {
            String urlParms = urlQuery[1];
            String[] stringArray = urlParms.split("&");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArrayList<String> parmValues;
                String urlParm = stringArray[n2];
                String[] parm = urlParm.split("=");
                String parmName = URLDecoder.decode(parm[0], UTF_8);
                String parmValue = EMPTY_STRING;
                if (parm.length > 1) {
                    parmValue = URLDecoder.decode(parm[1], UTF_8);
                }
                if ((parmValues = (ArrayList<String>)parms.get(parmName)) == null) {
                    parmValues = new ArrayList<String>();
                    parms.put(parmName, parmValues);
                }
                parmValues.add(parmValue);
                ++n2;
            }
        }
        return parms;
    }

    private static ISystemDefinition fetchSystemDefinition(ITeamRepository teamRepository, String sysDefUUID, String stateid, String sysDefType) {
        ISystemDefinition result = null;
        isLatestSysDef = true;
        class FetchJob
        extends Job {
            public ISystemDefinition sysDef;
            private final /* synthetic */ ITeamRepository val$teamRepository;
            private final /* synthetic */ String val$sysDefType;
            private final /* synthetic */ String val$sysDefUUID;
            private final /* synthetic */ String val$stateid;

            public FetchJob(ITeamRepository iTeamRepository, String string, String string2, String string3) {
                this.val$teamRepository = iTeamRepository;
                this.val$sysDefType = string;
                this.val$sysDefUUID = string2;
                this.val$stateid = string3;
                super("fetch translator");
                this.sysDef = null;
            }

            protected IStatus run(IProgressMonitor monitor) {
                ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)this.val$teamRepository.getClientLibrary(ISystemDefinitionModelClient.class);
                ISystemDefinition latestSysDef = null;
                try {
                    if (OpenLocalSysDefinitionAction.PARM_LANGDEF.equals(this.val$sysDefType)) {
                        this.sysDef = client.findSystemDefinitionComplete(this.val$sysDefUUID, this.val$stateid, ILanguageDefinition.ITEM_TYPE, monitor);
                        latestSysDef = client.findSystemDefinition(this.val$sysDefUUID, null, ILanguageDefinition.ITEM_TYPE, monitor);
                    } else if (OpenLocalSysDefinitionAction.PARM_RESDEF.equals(this.val$sysDefType)) {
                        this.sysDef = client.findSystemDefinitionComplete(this.val$sysDefUUID, this.val$stateid, IResourceDefinition.ITEM_TYPE, monitor);
                        latestSysDef = client.findSystemDefinition(this.val$sysDefUUID, null, IResourceDefinition.ITEM_TYPE, monitor);
                    } else if (OpenLocalSysDefinitionAction.PARM_SEARCHPATH.equals(this.val$sysDefType)) {
                        this.sysDef = client.findSystemDefinitionComplete(this.val$sysDefUUID, this.val$stateid, ISearchPath.ITEM_TYPE, monitor);
                        latestSysDef = client.findSystemDefinition(this.val$sysDefUUID, null, ISearchPath.ITEM_TYPE, monitor);
                    } else if (OpenLocalSysDefinitionAction.PARM_TRANSLATOR.equals(this.val$sysDefType)) {
                        this.sysDef = client.findSystemDefinitionComplete(this.val$sysDefUUID, this.val$stateid, ITranslator.ITEM_TYPE, monitor);
                        latestSysDef = client.findSystemDefinition(this.val$sysDefUUID, null, ITranslator.ITEM_TYPE, monitor);
                    }
                    Timestamp fetchedTimestamp = client.getModifiedDateByStateId((ISystemDefinitionHandle)this.sysDef, monitor);
                    Timestamp latestTimestamp = client.getModifiedDateByStateId((ISystemDefinitionHandle)latestSysDef, monitor);
                    if (fetchedTimestamp != null && latestTimestamp != null && !fetchedTimestamp.equals(latestTimestamp)) {
                        isLatestSysDef = false;
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        }
        FetchJob fetchJob = new FetchJob(teamRepository, sysDefType, sysDefUUID, stateid);
        fetchJob.schedule();
        try {
            fetchJob.join();
            result = fetchJob.sysDef;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }
}

