/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.browser;

import com.ibm.team.build.extensions.common.debug.DebugStack;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.Mnm;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.editors.EnterpriseBrowserEditor;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapEditorInput;
import com.ibm.team.enterprise.internal.build.ui.browser.AbstractOpenEditorAction;
import com.ibm.team.enterprise.internal.build.ui.browser.IBrowserAction;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenLocalBuildMapAction
extends AbstractOpenEditorAction
implements IBrowserAction {
    private static final String BUILD_MAP_NAMESPACE = "enterprise_buildmap";

    @Override
    protected boolean canSupportFile(String filePath) {
        return filePath.contains(BUILD_MAP_NAMESPACE);
    }

    @Override
    public void run(URI uri, EnterpriseBrowserEditor browser, IProgressMonitor monitor, ITeamRepository repository) {
        Debugger dbg = new Debugger(this.getClass());
        DebugStack.debug((IDebugger)dbg, (String)this.getClass().getName(), (String)new Mnm(){}.get());
        try {
            final BuildMapEditorInput editorInput = new BuildMapEditorInput(this.rewriteURI(uri), null, null, null, null, repository);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(editorInput, "com.ibm.team.enterprise.build.ui.editors.buildMapEditor");
                    }
                    catch (PartInitException ex) {
                        Activator.getDefault().logError(ex);
                    }
                }
            });
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)browser.getSite().getShell(), (String)Messages.DIALOG_TITLE_ERROR, (String)(String.valueOf(Messages.DIALOG_MSG_ERROR_PREFIX) + e.getLocalizedMessage()));
            Activator.getDefault().logError(e);
        }
    }

    private URI rewriteURI(URI uri) {
        URI result = uri;
        String[] temp = this.parseURI(uri);
        String filePath = temp[1];
        int slugIndex = filePath.indexOf(BUILD_MAP_NAMESPACE);
        if (slugIndex >= 0) {
            String slug = filePath.substring(slugIndex + BUILD_MAP_NAMESPACE.length() + 1);
            try {
                result = new URI(slug);
            }
            catch (URISyntaxException e) {
                result = uri;
            }
        }
        return result;
    }

    @Override
    protected IEditorInput getEditorInput(String editorId, String filePath, ITeamRepository repository) throws Exception {
        return null;
    }
}

