/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.actions;

import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.actions.AbstractViewBuildMapAction;
import com.ibm.team.enterprise.common.client.util.ZComponentUtils;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildUtils;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;

public class ViewBuildMapFromLocalFileAction
extends AbstractViewBuildMapAction {
    @Override
    protected IStatus init(IStructuredSelection selection) throws Exception {
        Object obj = selection.getFirstElement();
        IFile localFile = null;
        if (obj instanceof IFile) {
            localFile = (IFile)obj;
        } else if (obj instanceof IFolder) {
            IFolder folder = (IFolder)obj;
            if (ZComponentUtils.isZComponentProject((Object)folder.getParent()) && !ZComponentUtils.isZSourceFolder((Object)folder)) {
                localFile = folder;
            } else if (ZComponentUtils.isZHfsComponentProject((Object)folder.getParent())) {
                localFile = folder;
            }
        }
        if (localFile != null) {
            IShareable remoteFile = BuildUtils.getShareable((IAdaptable)localFile);
            if (remoteFile == null) {
                return Activator.getDefault().createErrorStatus(NLS.bind((String)Messages.ViewBuildMapAction_ERROR_LOCAL_FILE_NOT_SHARED, (Object)localFile.getFullPath().toOSString()));
            }
            this.versionableHandle = remoteFile.getRemote(null);
            if (this.versionableHandle != null) {
                ISharingDescriptor sharingDesc = remoteFile.getShare(null).getSharingDescriptor();
                this.repository = RepositoryUtils.getTeamRepository((ISharingDescriptor)sharingDesc);
            }
        }
        return Status.OK_STATUS;
    }
}

