/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.actions;

import com.ibm.team.enterprise.build.common.BuildableFileBuildResult;
import com.ibm.team.enterprise.build.common.buildreport.BuildReportCache;
import com.ibm.team.enterprise.build.common.buildreport.IReportBuildFile;
import com.ibm.team.enterprise.build.ui.actions.AbstractSubsetFromArtifactAction;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class SubsetFromBuildReportAction
extends AbstractSubsetFromArtifactAction {
    private BuildableFileBuildResult fBuildResult;
    private boolean isCreateAction;

    public SubsetFromBuildReportAction(BuildableFileBuildResult buildResult, ITeamRepository repo, boolean isCreateAction) {
        this.fBuildResult = buildResult;
        this.repository = repo;
        this.isCreateAction = isCreateAction;
    }

    @Override
    protected void initialize(List selection) throws TeamRepositoryException {
    }

    @Override
    protected boolean createNewSubset() {
        return this.isCreateAction;
    }

    @Override
    protected Set<ISubsetFileDesc> calculateBuildableFileDescs(List<Object> elements, IProgressMonitor monitor) throws Exception {
        HashSet<ISubsetFileDesc> result = new HashSet<ISubsetFileDesc>();
        for (Object element : elements) {
            if (element instanceof BuildReportCache) {
                BuildReportCache brCache = (BuildReportCache)element;
                String fileUUID = null;
                String componentUUID = null;
                int size = brCache.getBuildFileSize(this.fBuildResult);
                int i = 0;
                while (i < size) {
                    IReportBuildFile reportBuildFile = brCache.getReportBuildFile(i, this.fBuildResult);
                    componentUUID = reportBuildFile.getComponentUUID();
                    fileUUID = reportBuildFile.getUUID();
                    if (fileUUID != null && componentUUID != null) {
                        result.add(BuildableSubsetUtil.createFileDesc((String)componentUUID, (String)fileUUID));
                    }
                    ++i;
                }
            }
            if (monitor.isCanceled()) break;
        }
        return result;
    }
}

