/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.ui.domain.BuildDefinitionQueryNode;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.actions.QueryBuildMapsAction;
import com.ibm.team.enterprise.build.ui.dialogs.QueryBuildMapDialog;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.query.OutputsByNameBuildMapQuery;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public class QueryBuildMapsActionDelegate
extends ActionDelegate
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    private static final String ACTION_DESCRIPTION = Messages.QueryBuildMapsActionDelegate_DEFAULTDESC;
    private static final String ACTION_NAME = Messages.QueryBuildMapsActionDelegate_DEFAULTNAME;
    private IStructuredSelection selection;
    private IWorkbenchWindow window;
    private ITeamRepository repository;
    private IBuildDefinition buildDef;

    protected IStatus init(IStructuredSelection selection) throws Exception {
        Object obj = selection.getFirstElement();
        if (!(obj instanceof BuildDefinitionQueryNode)) {
            return new Status(4, "com.ibm.team.enterprise.build.ui", Messages.QueryBuildMapsActionDelegate_ERRORLOG);
        }
        BuildDefinitionQueryNode buildNode = (BuildDefinitionQueryNode)obj;
        this.repository = buildNode.getTeamRepository();
        this.buildDef = buildNode.getBuildDefinition();
        return Status.OK_STATUS;
    }

    protected IStatus validateSelection(IStructuredSelection selection) {
        this.repository = null;
        if (selection == null || selection.isEmpty()) {
            return Activator.getDefault().createErrorStatus(Messages.ViewBuildMapAction_ERROR_INVALID_SELECTION);
        }
        try {
            IStatus status = this.init(selection);
            if (status != null && !status.isOK()) {
                return status;
            }
            if (this.repository == null) {
                return Activator.getDefault().createErrorStatus(Messages.ViewBuildMapAction_ERROR_INVALID_SELECTION);
            }
        }
        catch (Exception e) {
            return Activator.getDefault().createErrorStatus(NLS.bind((String)Messages.QueryBuildMapsActionDelegate_ERRORLOGNLS, (Object)e.getMessage()), e);
        }
        return Status.OK_STATUS;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        QueryBuildMapDialog dlg;
        if (this.window == null) {
            this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        Shell shell = this.window.getShell();
        IStatus status = this.validateSelection(this.selection);
        if (!status.isOK()) {
            MessageDialog.openError((Shell)shell, (String)Messages.QueryBuildMapsActionDelegate_ERRORDIALOG, (String)status.getMessage());
            if (status.getException() != null) {
                Activator.getDefault().logError(status.getException());
            }
            return;
        }
        QueryBuildMapDialog queryBuildMapDialog = dlg = this.buildDef == null ? new QueryBuildMapDialog(ACTION_NAME, ACTION_DESCRIPTION, this.repository, shell) : new QueryBuildMapDialog(ACTION_NAME, ACTION_DESCRIPTION, this.repository, shell, this.buildDef);
        if (dlg.open() == 0) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("build.def", dlg.getBuildDefinition());
            parameters.put("file.name", dlg.getFileName());
            QueryBuildMapsAction action = new QueryBuildMapsAction(new OutputsByNameBuildMapQuery(), parameters);
            action.run();
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        BuildDefinitionQueryNode queryNode;
        IStructuredSelection iStructuredSelection = this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
        if (this.selection != null && this.selection.getFirstElement() instanceof BuildDefinitionQueryNode && ((queryNode = (BuildDefinitionQueryNode)this.selection.getFirstElement()).getBuildDefinition().getConfigurationElement("com.ibm.team.enterprise.zos.build.common.IZosDependencyBuildConfigurationElement") != null || queryNode.getBuildDefinition().getConfigurationElement("com.ibm.team.enterprise.ibmi.build.common.IIBMiDependencyBuildConfigurationElement") != null)) {
            action.setEnabled(true);
            return;
        }
        action.setEnabled(false);
    }
}

