/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.actions;

import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.query.IBuildMapQuery;
import com.ibm.team.enterprise.build.ui.views.BuildMapsQueryView;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class QueryBuildMapsAction
extends Action {
    private Shell shell;
    private IBuildMapQuery fQuery;

    public QueryBuildMapsAction(IBuildMapQuery query, HashMap<String, Object> parameters) {
        this.fQuery = query;
        this.fQuery.setQueryParameters(parameters);
    }

    public void run() {
        if (this.shell == null) {
            this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        final Job runQueryJob = new Job(Messages.QueryBuildMapsAction_QUERYJOB){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.QueryBuildMapsAction_MONITOR, 2000);
                    QueryBuildMapsAction.this.fQuery.run((IProgressMonitor)new SubProgressMonitor(monitor, 1800));
                    Status status = new Status(0, "PluginID", 0, null, null);
                    return status;
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
        };
        runQueryJob.schedule();
        runQueryJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                QueryBuildMapsAction.this.shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BuildMapsQueryView view = QueryBuildMapsAction.openQueryView();
                        if (runQueryJob.getResult().getCode() == -1) {
                            view.setColumns(null);
                            view.setInput(runQueryJob.getResult(), Messages.QueryBuildMapsAction_JOBERROR);
                            MessageDialog.openError((Shell)QueryBuildMapsAction.this.shell, (String)Messages.QueryBuildMapsAction_JOBERRORLOG, (String)NLS.bind((String)Messages.QueryBuildMapsAction_JOBERRORNLS, (Object)runQueryJob.getResult().getMessage(), (Object[])new Object[0]));
                        } else {
                            view.setColumns(QueryBuildMapsAction.this.fQuery.getColumns());
                            view.setInput(QueryBuildMapsAction.this.fQuery.getResult().getResults(), NLS.bind((String)Messages.QueryBuildMapsAction_RESULTLABEL, (Object)QueryBuildMapsAction.this.fQuery.getResult().getTotalResults(), (Object[])new Object[]{QueryBuildMapsAction.this.fQuery.getQueryParameters().get("file.name")}));
                        }
                    }
                });
            }
        });
    }

    private static final BuildMapsQueryView openQueryView() {
        try {
            return (BuildMapsQueryView)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ibm.team.enterprise.build.ui.views.BuildMapQueryView");
        }
        catch (PartInitException e) {
            Activator.getDefault().logError(e);
            return null;
        }
    }
}

