/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.common.DependencyBuildPropertyFactory;
import com.ibm.team.enterprise.build.ui.actions.OpenRemoteFileAction;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableFilesViewer;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableFileDesc;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildUtils;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.progress.UIJob;

public class OpenRemoteFileDescAction
extends ActionDelegate
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    private IStructuredSelection selection;
    private IWorkbenchPart targetPart;

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (this.selection != null && !this.selection.isEmpty() && this.targetPart != null) {
            final IBuildDefinition buildDefinition = (IBuildDefinition)this.targetPart.getAdapter(IBuildDefinition.class);
            final BuildableFilesViewer viewer = (BuildableFilesViewer)((BuildableSubsetEditor)this.targetPart).getAdapter(BuildableFilesViewer.class);
            ITeamRepository repository = (ITeamRepository)this.targetPart.getAdapter(ITeamRepository.class);
            if (buildDefinition != null) {
                TeamBuildJob job = new TeamBuildJob(Messages.OpenRemoteFileDescAction_JOB_NAME, true, repository){

                    protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                        IWorkspaceHandle workspaceHandle = this.getWorkspaceHandle(buildDefinition);
                        if (workspaceHandle != null) {
                            IWorkspace resolvedWorkspace = new BuildUtils().getWorkspaceStream(workspaceHandle, this.getJobTeamRepository());
                            IWorkspaceConnection wsConn = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getJobTeamRepository()).getWorkspaceConnection((IWorkspaceHandle)resolvedWorkspace.getItemHandle(), monitor);
                            HashMap<String, ArrayList<IBuildableFileDesc>> filesByComponent = new HashMap<String, ArrayList<IBuildableFileDesc>>();
                            for (Object object : OpenRemoteFileDescAction.this.selection.toList()) {
                                if (!(object instanceof IBuildableFileDesc)) continue;
                                IBuildableFileDesc desc = (IBuildableFileDesc)object;
                                ArrayList<IBuildableFileDesc> files = (ArrayList<IBuildableFileDesc>)filesByComponent.get(desc.getComponentId());
                                if (files == null) {
                                    files = new ArrayList<IBuildableFileDesc>();
                                    filesByComponent.put(desc.getComponentId(), files);
                                }
                                files.add(desc);
                            }
                            ArrayList<IBuildableFileDesc> unresolvedItems = new ArrayList<IBuildableFileDesc>();
                            for (Map.Entry entry : filesByComponent.entrySet()) {
                                IComponentHandle component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)((String)entry.getKey())), null);
                                IConfiguration configuration = wsConn.configuration(component);
                                ArrayList<IFileItemHandle> descHandles = new ArrayList<IFileItemHandle>(((List)entry.getValue()).size());
                                for (IBuildableFileDesc desc : (List)entry.getValue()) {
                                    descHandles.add((IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)desc.getFileItemId()), null));
                                }
                                int index = 0;
                                List itemsWithState = configuration.fetchPartialItems(descHandles, Arrays.asList(IItem.STATE_ID_PROPERTY), monitor);
                                for (IVersionable item : itemsWithState) {
                                    if (item == null) {
                                        unresolvedItems.add((IBuildableFileDesc)((List)entry.getValue()).get(index));
                                    } else {
                                        String scmLocation = viewer != null ? viewer.getScmLocation(component.getItemId().getUuidValue(), item.getItemId()) : null;
                                        new OpenRemoteFileAction(this.getJobTeamRepository(), item.getItemId(), item.getStateId(), OpenRemoteFileDescAction.this.targetPart, scmLocation).run();
                                    }
                                    ++index;
                                }
                            }
                            if (!unresolvedItems.isEmpty()) {
                                new UIJob(""){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        String message = Messages.OpenRemoteFileDescAction_ERROR_MESSAGE_MULTIPLE;
                                        if (OpenRemoteFileDescAction.this.selection.size() == 1) {
                                            message = Messages.OpenRemoteFileDescAction_ERROR_MESSAGE_SINGLE;
                                        }
                                        MessageDialog.openWarning((Shell)OpenRemoteFileDescAction.this.targetPart.getSite().getShell(), (String)Messages.OpenRemoteFileDescAction_ERROR_TITLE, (String)message);
                                        return Status.OK_STATUS;
                                    }
                                }.schedule();
                            }
                        }
                        return Status.OK_STATUS;
                    }

                    private IWorkspaceHandle getWorkspaceHandle(IBuildDefinition buildDefinition2) {
                        String workspaceUUIDProperty = DependencyBuildPropertyFactory.getInstance().resolvePropertyId("teamz.scm.workspaceUUID", buildDefinition2);
                        String workspaceUUID = buildDefinition2.getPropertyValue(workspaceUUIDProperty, null);
                        if (workspaceUUID == null) {
                            return null;
                        }
                        return (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)workspaceUUID), null);
                    }
                };
                job.schedule();
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            action.setEnabled(true);
        } else {
            this.selection = null;
            action.setEnabled(false);
        }
    }
}

