/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.actions;

import com.ibm.team.enterprise.build.ui.editors.EditorUtil;
import com.ibm.team.enterprise.build.ui.editors.RemoteFileEditorInput;
import com.ibm.team.enterprise.common.ui.Activator;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.StateId;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchPart;

public class OpenRemoteFileAction
extends Action {
    private ITeamRepository fTeamRepository;
    private UUID remoteFileUUID;
    private UUID remoteFileStateUUID;
    private IWorkbenchPart part;
    private String scmLocation;

    public OpenRemoteFileAction(ITeamRepository fTeamRepository, UUID remoteFileUUID, UUID remoteFileStateUUID, IWorkbenchPart part, String scmLocation) {
        this.fTeamRepository = fTeamRepository;
        this.remoteFileUUID = remoteFileUUID;
        this.remoteFileStateUUID = remoteFileStateUUID;
        this.part = part;
        this.scmLocation = scmLocation;
    }

    public void run() {
        UIUpdaterJob job = new UIUpdaterJob(""){
            RemoteFileEditorInput remoteFile;
            {
                this.remoteFile = null;
            }

            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    this.remoteFile = RemoteFileEditorInput.createInput(OpenRemoteFileAction.this.fTeamRepository, (StateId<? extends IVersionable>)new StateId(IFileItem.ITEM_TYPE, OpenRemoteFileAction.this.remoteFileUUID, OpenRemoteFileAction.this.remoteFileStateUUID), OpenRemoteFileAction.this.scmLocation, monitor);
                }
                catch (TeamRepositoryException e) {
                    Activator.log((Throwable)e);
                }
                return super.runInBackground(monitor);
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (this.remoteFile == null) {
                    OpenRemoteFileAction.this.setEnabled(false);
                } else {
                    UIContext context = UIContext.createPartContext((IWorkbenchPart)OpenRemoteFileAction.this.part);
                    EditorUtil.openEditor(context, this.remoteFile, true);
                }
                return super.runInUI(monitor);
            }
        };
        job.schedule();
    }

    public String getText() {
        return Messages.OpenRemoteFileAction_Open_Action_Label;
    }
}

