/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.actions;

import com.ibm.team.build.internal.ui.jobs.TeamBuildJob;
import com.ibm.team.enterprise.build.ui.actions.OpenLocalFileInBuildAction;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableFileDesc;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.progress.UIJob;

public class OpenLocalFileDescAction
extends ActionDelegate
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    private IStructuredSelection selection;
    private IWorkbenchPart targetPart;

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (this.selection != null && !this.selection.isEmpty() && this.targetPart != null) {
            ITeamRepository repository = (ITeamRepository)this.targetPart.getAdapter(ITeamRepository.class);
            TeamBuildJob job = new TeamBuildJob(Messages.OpenLocalFileDescAction_JOB_NAME, true, repository){

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    HashMap<String, IComponentHandle> components = new HashMap<String, IComponentHandle>();
                    ArrayList<IBuildableFileDesc> unresolvedItems = new ArrayList<IBuildableFileDesc>();
                    for (Object object : OpenLocalFileDescAction.this.selection.toList()) {
                        if (!(object instanceof IBuildableFileDesc)) continue;
                        IBuildableFileDesc desc = (IBuildableFileDesc)object;
                        IComponentHandle component = (IComponentHandle)components.get(desc.getComponentId());
                        if (component == null) {
                            component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)desc.getComponentId()), null);
                            components.put(desc.getComponentId(), component);
                        }
                        IFileItemHandle fileHandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)desc.getFileItemId()), null);
                        Collection shareables = SharingManager.getInstance().findShareables(component, (IVersionableHandle)fileHandle, monitor);
                        if (shareables.isEmpty()) {
                            unresolvedItems.add(desc);
                            continue;
                        }
                        for (IShareable shareable : shareables) {
                            new OpenLocalFileInBuildAction(shareable, OpenLocalFileDescAction.this.targetPart.getSite()).run();
                        }
                    }
                    if (!unresolvedItems.isEmpty()) {
                        new UIJob(""){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                String message = Messages.OpenLocalFileDescAction_ERROR_MESSAGE_MULTIPLE;
                                if (OpenLocalFileDescAction.this.selection.size() == 1) {
                                    message = Messages.OpenLocalFileDescAction_ERROR_MESSAGE_SINGLE;
                                }
                                MessageDialog.openWarning((Shell)OpenLocalFileDescAction.this.targetPart.getSite().getShell(), (String)Messages.OpenLocalFileDescAction_ERROR_TITLE, (String)message);
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }
}

