/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.actions;

import com.ibm.team.enterprise.build.ui.actions.AbstractSubsetFromArtifactAction;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.build.ui.utils.BuildUtils;
import com.ibm.team.enterprise.rdf.query.common.select.result.Binding;
import com.ibm.team.enterprise.rdf.query.common.select.result.SelectResult;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddToSubsetFromSCDAction
extends AbstractSubsetFromArtifactAction {
    public AddToSubsetFromSCDAction() {
        this.setText(Messages.AddToSubsetFromSCDAction_LABEL);
    }

    @Override
    protected void initialize(List selection) throws TeamRepositoryException {
        block0: for (Object o : selection) {
            if (!(o instanceof SelectResult)) continue;
            for (Binding binding : ((SelectResult)o).getBindings()) {
                if (!"repositoryId".equals(binding.getName())) continue;
                this.repository = this.findRepositoryById(binding.getValue());
                if (this.repository != null) continue block0;
            }
        }
    }

    private ITeamRepository findRepositoryById(String repositoryId) {
        ITeamRepository[] repos;
        UUID repositoryUUID = UUID.valueOf((String)repositoryId);
        ITeamRepository[] iTeamRepositoryArray = repos = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int n = repos.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repo = iTeamRepositoryArray[n2];
            if (repo.getId().equals((Object)repositoryUUID)) {
                return repo;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected boolean createNewSubset() {
        return false;
    }

    @Override
    protected Set<ISubsetFileDesc> calculateBuildableFileDescs(List<Object> elements, IProgressMonitor monitor) throws Exception {
        HashSet<ISubsetFileDesc> descs = new HashSet<ISubsetFileDesc>();
        ISystemDefinitionModelClient sysDefClient = (ISystemDefinitionModelClient)this.repository.getClientLibrary(ISystemDefinitionModelClient.class);
        HashMap<String, IWorkspaceConnection> workspaceConnections = new HashMap<String, IWorkspaceConnection>();
        for (Object element : elements) {
            if (element instanceof SelectResult) {
                SelectResult result = (SelectResult)element;
                String fileUUID = null;
                String componentUUID = null;
                String streamUUID = null;
                for (Binding binding : result.getBindings()) {
                    if ("fileItemId".equals(binding.getName())) {
                        fileUUID = binding.getValue();
                    } else if ("componentId".equals(binding.getName())) {
                        componentUUID = binding.getValue();
                    } else if ("streamId".equals(binding.getName())) {
                        streamUUID = binding.getValue();
                    }
                    if (fileUUID != null && componentUUID != null && streamUUID != null) break;
                }
                if (streamUUID != null) {
                    IWorkspaceConnection connection = (IWorkspaceConnection)workspaceConnections.get(streamUUID);
                    if (connection == null) {
                        IWorkspaceHandle streamHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf(streamUUID), null);
                        connection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.repository).getWorkspaceConnection(streamHandle, null);
                        workspaceConnections.put(streamUUID, connection);
                    }
                    if (this.isBuildableFile(fileUUID, componentUUID, connection, sysDefClient)) {
                        descs.add(BuildableSubsetUtil.createFileDesc((String)componentUUID, (String)fileUUID));
                    }
                }
            }
            if (monitor.isCanceled()) break;
        }
        return descs;
    }

    private boolean isBuildableFile(String fileUUID, String componentUUID, IWorkspaceConnection connection, ISystemDefinitionModelClient sysDefClient) throws TeamRepositoryException {
        if (fileUUID == null || componentUUID == null) {
            return false;
        }
        IFileItemHandle fileItemHandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(UUID.valueOf((String)fileUUID), null);
        IComponentHandle component = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)componentUUID), null);
        IConfiguration configuration = connection.configuration(component);
        IFileItem fileItem = (IFileItem)configuration.fetchCompleteItem((IVersionableHandle)fileItemHandle, null);
        return BuildUtils.isBuildableFile((IVersionable)fileItem, sysDefClient);
    }
}

