/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.actions;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.enterprise.build.buildmap.common.model.query.BaseBuildMapQueryModel;
import com.ibm.team.enterprise.build.common.buildreport.BuildReportCache;
import com.ibm.team.enterprise.build.common.buildreport.IReportBuildFile;
import com.ibm.team.enterprise.build.ui.actions.AbstractSubsetFromArtifactAction;
import com.ibm.team.enterprise.build.ui.editors.result.internal.BuildReportParser;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.ModelFactory;
import com.ibm.team.enterprise.buildablesubset.common.internal.model.SubsetFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IDataRow;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class AddToSubsetFromBuildResultAction
extends AbstractSubsetFromArtifactAction {
    @Override
    protected void initialize(List selection) throws TeamRepositoryException {
        for (Object o : selection) {
            if (!(o instanceof IBuildResultRecord)) continue;
            this.repository = (ITeamRepository)((IBuildResultRecord)o).getBuildResult().getOrigin();
            if (this.repository != null) break;
        }
    }

    @Override
    protected boolean createNewSubset() {
        return false;
    }

    @Override
    protected IBuildDefinition getBuildDefinitionAssociatedWithSelection() {
        IBuildDefinition currentDef = null;
        for (Object o : this.selection.toList()) {
            if (!(o instanceof IBuildResultRecord)) continue;
            if (currentDef == null) {
                currentDef = ((IBuildResultRecord)o).getBuildDefinition();
                continue;
            }
            if (((IBuildResultRecord)o).getBuildDefinition().sameItemId((IItemHandle)currentDef)) continue;
            return null;
        }
        return currentDef;
    }

    @Override
    protected Set<ISubsetFileDesc> calculateBuildableFileDescs(List<Object> elements, IProgressMonitor monitor) throws Exception {
        HashSet<ISubsetFileDesc> descs = new HashSet<ISubsetFileDesc>();
        for (Object element : elements) {
            AddToSubsetFromBuildResultAction.parseBuildableFilesFromBuildReport(((IBuildResultRecord)element).getBuildResult(), this.repository, descs, monitor);
            if (monitor.isCanceled()) break;
        }
        return descs;
    }

    public static void parseBuildableFilesFromBuildReport(IBuildResult buildResult, ITeamRepository repository, Set<ISubsetFileDesc> buildableFileDescs, IProgressMonitor monitor) throws Exception {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask("", 1);
        subMonitor.setTaskName(NLS.bind((String)Messages.AddToSubsetFromBuildResultAction_ProcessingBuildResult, (Object)buildResult.getLabel()));
        ITeamBuildClient client = ClientFactory.getTeamBuildClient((ITeamRepository)repository);
        IBuildResultContribution[] contributions = client.getBuildResultContributions((IBuildResultHandle)buildResult, new String[]{IBuildResultContribution.ARTIFACT_EXTENDED_CONTRIBUTION_ID}, monitor);
        if (contributions.length > 0) {
            IBuildResultContribution[] iBuildResultContributionArray = contributions;
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                IBuildResultContribution contribution = iBuildResultContributionArray[n2];
                String fileName = contribution.getExtendedContributionProperty(IBuildResultContribution.PROPERTY_NAME_FILE_NAME);
                if ("buildReport.xml".equals(fileName)) {
                    AddToSubsetFromBuildResultAction.parseBuildReport(buildResult, contribution, buildableFileDescs, repository, monitor);
                    break;
                }
                ++n2;
            }
        }
        subMonitor.worked(1);
    }

    protected static void parseBuildReport(IBuildResult buildResult, IBuildResultContribution contribution, Set<ISubsetFileDesc> descs, ITeamRepository repository, IProgressMonitor monitor) throws Exception {
        IContent content = contribution.getExtendedContributionData();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IContentManager contentManager = repository.contentManager();
        contentManager.retrieveContent(content, (OutputStream)baos, monitor);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BuildReportCache cache = new BuildReportCache();
        BuildReportParser parser = new BuildReportParser(repository, false, null, false, true);
        parser.parseXMLFromInputStream(bais, cache, false, null);
        int length = cache.getSuccessBuildFileSize();
        if (length > 0) {
            HashMap<String, String> componentNameToUUID = new HashMap<String, String>();
            int i = 0;
            while (i < length) {
                String componentName;
                IReportBuildFile file = cache.getSuccessReportBuildFile(i);
                String fileUUID = file.getUUID();
                String componentUUID = file.getComponentUUID();
                if ((componentUUID == null || componentUUID.isEmpty()) && (componentUUID = (String)componentNameToUUID.get(componentName = file.getComponent())) == null) {
                    BaseBuildMapQueryModel.BuildMapQueryModel model = BaseBuildMapQueryModel.BuildMapQueryModel.ROOT;
                    IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
                    IPredicate filter = model.temporary()._isFalse()._and(model.archived()._isFalse())._and(model.buildDefinition().itemId()._eq((IUUID)query.newUUIDArg()));
                    filter = filter._and(model.buildableFile().itemId()._eq((IUUID)query.newUUIDArg()));
                    query.filter(filter);
                    query.select((ISelectionElement)model.self().component().itemId());
                    IQueryService queryService = ((TeamRepository)repository).getQueryService();
                    IDataQueryPage page = queryService.queryData(query, new Object[]{buildResult.getBuildDefinition().getItemId(), UUID.valueOf((String)fileUUID)}, 512);
                    if (page.getSize() > 0) {
                        IDataRow row = page.getRow(0);
                        componentUUID = row.getString(0);
                        componentNameToUUID.put(componentName, componentUUID);
                    }
                }
                if (componentUUID != null && fileUUID != null) {
                    SubsetFileDesc desc = ModelFactory.eINSTANCE.createSubsetFileDesc();
                    desc.setComponent(BuildableSubsetUtil.createComponentHandle((String)componentUUID));
                    desc.setFileItem((IVersionableHandle)BuildableSubsetUtil.createFileItemHandle((String)fileUUID));
                    descs.add((ISubsetFileDesc)desc);
                }
                ++i;
            }
        }
    }
}

