/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.dialogs.ViewBuildMapDialog;
import com.ibm.team.enterprise.build.ui.editors.buildmap.BuildMapEditorInput;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.enterprise.internal.buildmap.common.IBuildMap;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXException;

public abstract class AbstractViewBuildMapAction
extends Action
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    protected IVersionableHandle versionableHandle;
    protected ITeamRepository repository;
    private IStructuredSelection selection;
    private IWorkbenchWindow window;
    private UIUpdaterJob job;

    protected abstract IStatus init(IStructuredSelection var1) throws Exception;

    public AbstractViewBuildMapAction() {
        super(Messages.ViewBuildMapAction_LABEL);
    }

    protected IStatus validateSelection(IStructuredSelection selection) {
        this.versionableHandle = null;
        this.repository = null;
        if (selection == null || selection.isEmpty()) {
            return Activator.getDefault().createErrorStatus(Messages.ViewBuildMapAction_ERROR_INVALID_SELECTION);
        }
        try {
            IStatus status = this.init(selection);
            if (status != null && !status.isOK()) {
                return status;
            }
            if (this.versionableHandle == null || this.repository == null) {
                return Activator.getDefault().createErrorStatus(Messages.ViewBuildMapAction_ERROR_INVALID_SELECTION);
            }
        }
        catch (Exception e) {
            return Activator.getDefault().createErrorStatus(NLS.bind((String)Messages.ViewBuildMapAction_GENERAL_ERROR, (Object)e.getMessage()), e);
        }
        return Status.OK_STATUS;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        if (this.window == null) {
            this.window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        Shell shell = this.window.getShell();
        IStatus status = this.validateSelection(this.selection);
        if (!status.isOK()) {
            MessageDialog.openError((Shell)shell, (String)Messages.ViewBuildMapDialog_TITLE, (String)status.getMessage());
            if (status.getException() != null) {
                Activator.getDefault().logError(status.getException());
            }
            return;
        }
        ViewBuildMapDialog dlg = new ViewBuildMapDialog(this.repository, shell);
        if (dlg.open() == 0) {
            IBuildDefinition buildDefinition = dlg.getBuildDefinition();
            UUID fileUUID = this.versionableHandle.getItemId();
            final BuildMapEditorInput editorInput = new BuildMapEditorInput(fileUUID, buildDefinition.getItemId(), this.repository);
            if (this.job != null) {
                this.job.cancel();
            }
            this.job = new UIUpdaterJob(""){
                IBuildMap buildMap;
                {
                    super($anonymous0);
                    this.buildMap = null;
                }

                public IStatus runInBackground(IProgressMonitor monitor) {
                    try {
                        this.buildMap = editorInput.fetchBuildMap(null);
                    }
                    catch (TeamRepositoryException e) {
                        Activator.getDefault().logError(e);
                    }
                    catch (SAXException e) {
                        Activator.getDefault().logError(e);
                    }
                    catch (IOException e) {
                        Activator.getDefault().logError(e);
                    }
                    catch (ParserConfigurationException e) {
                        Activator.getDefault().logError(e);
                    }
                    return super.runInBackground(monitor);
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    if (this.buildMap != null) {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "com.ibm.team.enterprise.build.ui.editors.buildMapEditor");
                        }
                        catch (PartInitException ex) {
                            Activator.getDefault().logError(ex);
                        }
                    } else {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ViewBuildMapDialog_TITLE, (String)Messages.ViewBuildMapAction_ERROR_INVALID_SELECTION);
                    }
                    return super.runInUI(monitor);
                }
            };
            this.job.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
        this.setEnabled(this.selection != null && this.selection.size() == 1);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

