/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.ui.actions;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.enterprise.build.ui.Activator;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetDefinitionSelectionDialog;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetEditorInput;
import com.ibm.team.enterprise.build.ui.subset.BuildSubsetSelectionDialog;
import com.ibm.team.enterprise.build.ui.subset.EditSubsetActionDelegate;
import com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubset;
import com.ibm.team.enterprise.buildablesubset.common.model.ISubsetFileDesc;
import com.ibm.team.enterprise.internal.build.ui.nls.Messages;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public abstract class AbstractSubsetFromArtifactAction
extends Action
implements IObjectActionDelegate {
    protected IStructuredSelection selection;
    protected IWorkbenchPart targetPart;
    protected ITeamRepository repository;
    protected ISubset targetSubset;
    protected IBuildDefinition buildDefinition;
    protected List<IProjectAreaHandle> projectAreas;

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        if (this.targetPart != null && this.selection != null && !this.selection.isEmpty()) {
            try {
                final List elements = this.selection.toList();
                this.initialize(elements);
                if (this.repository == null) {
                    throw new TeamRepositoryException(this.createNewSubset() ? Messages.AbstractSubsetFromArtifactAction_NO_REPOSITORY_CREATE_MSG : Messages.AbstractSubsetFromArtifactAction_NO_REPOSITORY_MODIFY_MSG);
                }
                this.resolveProjectAreas();
                new Job(Messages.AbstractSubsetFromArtifactAction_CALCULATE_FILES_JOB){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            final Set<ISubsetFileDesc> descs = AbstractSubsetFromArtifactAction.this.calculateBuildableFileDescs(elements, monitor);
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            new UIJob(Messages.AbstractSubsetFromArtifactAction_OPEN_EDITOR_JOB){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    try {
                                        if (descs != null && !descs.isEmpty()) {
                                            (this).AbstractSubsetFromArtifactAction.this.targetSubset = AbstractSubsetFromArtifactAction.this.createTargetSubsetHandle(elements);
                                            BuildSubsetEditorInput input = AbstractSubsetFromArtifactAction.this.createEditorInput((this).AbstractSubsetFromArtifactAction.this.targetSubset, descs);
                                            IEditorPart part = EditSubsetActionDelegate.run(input, (this).AbstractSubsetFromArtifactAction.this.targetPart.getSite().getPage());
                                            if (part != null) {
                                                IEditorInput actualInput = part.getEditorInput();
                                                if (input != actualInput && part instanceof BuildableSubsetEditor) {
                                                    ((BuildableSubsetEditor)part).appendInput(input);
                                                }
                                                if (part instanceof BuildableSubsetEditor) {
                                                    ((BuildableSubsetEditor)part).setActivePage("com.ibm.team.enterprise.build.ui.subset.editors.BuildableSubsetEditor.CONTENTS");
                                                }
                                            }
                                        } else {
                                            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.AbstractSubsetFromArtifactAction_NO_FILES_TITLE, (String)(AbstractSubsetFromArtifactAction.this.createNewSubset() ? Messages.AbstractSubsetFromArtifactAction_NO_FILES_CREATE_MSG : Messages.AbstractSubsetFromArtifactAction_NO_FILES_MODIFY_MSG));
                                        }
                                    }
                                    catch (OperationCanceledException input) {
                                    }
                                    catch (Exception e) {
                                        AbstractSubsetFromArtifactAction.this.reportError(e);
                                    }
                                    return Status.OK_STATUS;
                                }
                            }.schedule();
                        }
                        catch (OperationCanceledException descs) {
                        }
                        catch (Exception e) {
                            new UIJob(""){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    AbstractSubsetFromArtifactAction.this.reportError(e);
                                    return Status.OK_STATUS;
                                }
                            }.schedule();
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            catch (OperationCanceledException elements) {
            }
            catch (TeamRepositoryException e) {
                this.reportError((Exception)((Object)e));
            }
        }
    }

    protected void reportError(Exception e) {
        Activator.getDefault().logError(e);
        ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.AbstractSubsetFromArtifactAction_ERROR_TITLE, (String)Messages.AbstractSubsetFromArtifactAction_ERROR_MSG, (IStatus)new Status(4, "com.ibm.team.enterprise.build.ui", e.getMessage(), (Throwable)e));
    }

    protected void resolveProjectAreas() throws TeamRepositoryException {
        Job job = new Job(Messages.AbstractSubsetFromArtifactAction_RESOLVE_PROJECT_AREAS_JOB){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    List rawProjectAreas = AbstractSubsetFromArtifactAction.this.repository.itemManager().fetchCompleteItems(AbstractSubsetFromArtifactAction.this.repository.itemManager().getKnownSharedItems(IProjectArea.ITEM_TYPE), 2, null);
                    AbstractSubsetFromArtifactAction.this.projectAreas = new ArrayList<IProjectAreaHandle>(rawProjectAreas.size());
                    for (IProjectArea pa : rawProjectAreas) {
                        if (pa == null || pa.isArchived()) continue;
                        AbstractSubsetFromArtifactAction.this.projectAreas.add((IProjectAreaHandle)pa);
                    }
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.enterprise.build.ui", e.getMessage(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    protected abstract void initialize(List var1) throws TeamRepositoryException;

    protected abstract Set<ISubsetFileDesc> calculateBuildableFileDescs(List<Object> var1, IProgressMonitor var2) throws Exception;

    protected abstract boolean createNewSubset();

    protected ISubset createTargetSubsetHandle(List selection) throws TeamRepositoryException {
        if (this.createNewSubset()) {
            this.buildDefinition = this.getBuildDefinitionAssociatedWithSelection();
            if (this.buildDefinition == null) {
                BuildSubsetDefinitionSelectionDialog dialog = new BuildSubsetDefinitionSelectionDialog(this.projectAreas, this.targetPart.getSite().getShell(), Messages.AbstractSubsetFromArtifactAction_SELECT_BUILD_DEF_MSG, true);
                if (dialog.open() == 0) {
                    this.buildDefinition = dialog.getFirstSelectedBuildDefinition();
                } else {
                    throw new OperationCanceledException();
                }
            }
            return null;
        }
        try {
            BuildSubsetSelectionDialog dialog = new BuildSubsetSelectionDialog(this.targetPart.getSite().getShell(), this.repository, this.getBuildDefinitionAssociatedWithSelection(), true, false);
            if (dialog.open() == 0) {
                ISubset subsetHandle = (ISubset)dialog.getResult()[0];
                this.buildDefinition = (IBuildDefinition)this.repository.itemManager().fetchCompleteItem((IItemHandle)subsetHandle.getBuildDefinition(), 0, null);
                return subsetHandle;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw new OperationCanceledException();
    }

    protected IBuildDefinition getBuildDefinitionAssociatedWithSelection() {
        return null;
    }

    protected BuildSubsetEditorInput createEditorInput(ISubset targetSubset, Set<ISubsetFileDesc> descs) throws TeamRepositoryException {
        IProjectAreaHandle projectArea = null;
        if (this.buildDefinition.getProcessArea() instanceof IProjectAreaHandle) {
            projectArea = (IProjectAreaHandle)this.buildDefinition.getProcessArea();
        }
        return new BuildSubsetEditorInput(targetSubset, (IBuildDefinitionHandle)this.buildDefinition, descs, null, this.repository, projectArea);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            this.setEnabled(!this.selection.isEmpty());
        } else {
            this.setEnabled(false);
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }
}

