/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.extensions.internal.common;

import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.enterprise.build.extensions.common.IBuildFileItemContentItem;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.dto.IVersionableIdentifier;

public class BuildFileItemContentItem
implements IBuildFileItemContentItem {
    private final IDebugger dbg;
    private final String simpleName;
    private String buildReason;
    private IChange change;
    private boolean changed;
    private IComponent component;
    private IComponentHandle componentHandle;
    private IVersionable fileVersionable;
    private IVersionableIdentifier fileVersionableIdentifier;

    public BuildFileItemContentItem() {
        this((IDebugger)new Debugger(BuildFileItemContentItem.class));
    }

    public BuildFileItemContentItem(IDebugger dbg) {
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        if (dbg.isDebug()) {
            Debug.setup((IDebugger)dbg, (String[])new String[]{this.simpleName});
        }
    }

    @Override
    public final String getBuildReason() {
        return this.buildReason;
    }

    @Override
    public final IChange getChange() {
        return this.change;
    }

    @Override
    public final IComponent getComponent() {
        return this.component;
    }

    @Override
    public final IComponentHandle getComponentHandle() {
        return this.componentHandle;
    }

    @Override
    public final IVersionable getFileVersionable() {
        return this.fileVersionable;
    }

    @Override
    public final IVersionableIdentifier getFileVersionableIdentifier() {
        return this.fileVersionableIdentifier;
    }

    @Override
    public final boolean isChanged() {
        return this.changed;
    }

    @Override
    public final void setBuildReason(String buildReason) {
        this.buildReason = buildReason;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((String)this.buildReason)});
        }
    }

    @Override
    public final void setChange(IChange change) {
        this.change = change;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((Object)this.change)});
        }
    }

    @Override
    public final void setChanged(boolean changed) {
        this.changed = changed;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((boolean)this.changed)});
        }
    }

    @Override
    public final void setComponent(IComponent component) {
        this.component = component;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((IItem)this.component)});
        }
    }

    @Override
    public final void setComponentHandle(IComponentHandle componentHandle) {
        this.componentHandle = componentHandle;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)this.componentHandle)});
        }
    }

    @Override
    public final void setFileVersionable(IVersionable fileVersionable) {
        this.fileVersionable = fileVersionable;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((IItem)this.fileVersionable)});
        }
    }

    @Override
    public final void setFileVersionableIdentifier(IVersionableIdentifier fileVersionableIdentifier) {
        this.fileVersionableIdentifier = fileVersionableIdentifier;
        if (this.dbg.isDebug()) {
            Debug.inout((IDebugger)this.dbg, (String[])new String[]{this.simpleName, new MethodName(){}.getName(), LogString.valueOf((Object)this.fileVersionableIdentifier)});
        }
    }
}

