/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.extensions.client;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.model.IBuildDefinitionHandle;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.extensions.client.BuildCacheFactory;
import com.ibm.team.build.extensions.common.IFetchItem;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.Debugger;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogField;
import com.ibm.team.build.extensions.common.nls.Common;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.build.extensions.client.BuildCacheFactoryEE;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.IBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IResourceDefinitionHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildItemFetch
implements IFetchItem {
    private final IDebugger dbg;
    private final String simpleName;
    private final ITeamRepository repository;
    private final IProgressMonitor monitor;
    private final IProcessAreaHandle processArea;
    private final boolean fetch;
    private final List<IItemHandle> itemsToFetch = new ArrayList<IItemHandle>();

    public BuildItemFetch(ITeamRepository repository, IProcessAreaHandle processArea, IProgressMonitor monitor, boolean fetch) {
        this(repository, processArea, monitor, fetch, (IDebugger)new Debugger(BuildItemFetch.class));
    }

    public BuildItemFetch(ITeamRepository repository, IProcessAreaHandle processArea, IProgressMonitor monitor, boolean fetch, IDebugger dbg) {
        this.repository = repository;
        this.processArea = processArea;
        this.monitor = monitor;
        this.fetch = fetch;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        if (this.dbg.isDebug()) {
            Debug.setup((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
    }

    public final IItem execute(IItemHandle handle) {
        if (handle == null) {
            return null;
        }
        IItem item = null;
        String uuid = handle.getItemId().getUuidValue();
        if (handle instanceof IBuildDefinitionHandle) {
            if (BuildCacheFactory.containsBuildDefinition((Object)this.repository, (IProcessAreaHandle)this.processArea) && BuildCacheFactory.getBuildDefinition((Object)this.repository, (IProcessAreaHandle)this.processArea).containsUuid(uuid)) {
                item = (IItem)BuildCacheFactory.getBuildDefinition((Object)this.repository, (IProcessAreaHandle)this.processArea).getUuid(uuid);
            }
        } else if (handle instanceof IBuildEngineHandle) {
            if (BuildCacheFactory.containsBuildEngine((Object)this.repository, (IProcessAreaHandle)this.processArea) && BuildCacheFactory.getBuildEngine((Object)this.repository, (IProcessAreaHandle)this.processArea).containsUuid(uuid)) {
                item = (IItem)BuildCacheFactory.getBuildEngine((Object)this.repository, (IProcessAreaHandle)this.processArea).getUuid(uuid);
            }
        } else if (handle instanceof IResourceDefinitionHandle) {
            if (BuildCacheFactoryEE.containsDataset(this.repository, this.processArea) && BuildCacheFactoryEE.getDataset(this.repository, this.processArea).containsUuid(uuid)) {
                item = (IItem)BuildCacheFactoryEE.getDataset(this.repository, this.processArea).getUuid(uuid);
            } else if (BuildCacheFactoryEE.containsLibrary(this.repository, this.processArea) && BuildCacheFactoryEE.getLibrary(this.repository, this.processArea).containsUuid(uuid)) {
                item = (IItem)BuildCacheFactoryEE.getLibrary(this.repository, this.processArea).getUuid(uuid);
            }
        }
        if (item == null && this.fetch) {
            try {
                item = this.repository.itemManager().fetchCompleteItem(handle, 0, this.monitor);
                if (item != null) {
                    if (item instanceof IBuildDefinition) {
                        BuildCacheFactory.addBuildDefinition((ITeamRepository)this.repository, (IProcessAreaHandle)this.processArea, (IBuildDefinition)((IBuildDefinition)item));
                    } else if (item instanceof IBuildEngine) {
                        BuildCacheFactory.addBuildEngine((ITeamRepository)this.repository, (IProcessAreaHandle)this.processArea, (IBuildEngine)((IBuildEngine)item));
                    } else if (item instanceof IDataSetDefinition) {
                        BuildCacheFactoryEE.addDataset(this.repository, this.processArea, (IResourceDefinition)((IDataSetDefinition)item));
                    } else if (item instanceof IBMiResourceDefinition) {
                        BuildCacheFactoryEE.addLibrary(this.repository, this.processArea, (IResourceDefinition)item);
                    }
                }
            }
            catch (TeamRepositoryException e) {
                throw new RuntimeException(NLS.bind((String)Common.COMMON_BUILDITEMFETCH_FAILED_ITEM, (Object)LogField.valueOf((IItemHandle)handle), (Object[])new Object[0]), e);
            }
        }
        if (item == null && !this.fetch) {
            this.itemsToFetch.add(handle);
        }
        return item;
    }

    public final void fetchItems(IProgressMonitor monitor) {
        try {
            List items = this.repository.itemManager().fetchCompleteItems(this.itemsToFetch, 0, monitor);
            for (IItem item : items) {
                if (item == null) continue;
                if (item instanceof IBuildDefinition) {
                    BuildCacheFactory.addBuildDefinition((ITeamRepository)this.repository, (IProcessAreaHandle)this.processArea, (IBuildDefinition)((IBuildDefinition)item));
                    continue;
                }
                if (item instanceof IBuildEngine) {
                    BuildCacheFactory.addBuildEngine((ITeamRepository)this.repository, (IProcessAreaHandle)this.processArea, (IBuildEngine)((IBuildEngine)item));
                    continue;
                }
                if (item instanceof IDataSetDefinition) {
                    BuildCacheFactoryEE.addDataset(this.repository, this.processArea, (IResourceDefinition)((IDataSetDefinition)item));
                    continue;
                }
                if (!(item instanceof IResourceDefinition)) continue;
                BuildCacheFactoryEE.addLibrary(this.repository, this.processArea, (IResourceDefinition)item);
            }
        }
        catch (TeamRepositoryException e) {
            throw new RuntimeException(NLS.bind((String)Common.COMMON_BUILDITEMFETCH_FAILED_ITEMS, (Object)LogField.valueOf(this.itemsToFetch), (Object[])new Object[0]), e);
        }
    }

    public final boolean hasItemsToFetch() {
        return Verification.isNonEmpty(this.itemsToFetch);
    }
}

