/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.extensions.client;

import com.ibm.team.build.extensions.client.IBuildCacheItem;
import com.ibm.team.build.extensions.client.IBuildDefinitionResource;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.enterprise.build.extensions.client.BuildCacheFactoryEE;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;

public class BuildDefinitionResourceDatasetExisting
implements IBuildDefinitionResource {
    private IBuildCacheItem<ISystemDefinition> datasetCacheItem;
    private final ISystemDefinition.Platform platform = ISystemDefinition.Platform.zos;

    public void init(ITeamRepository repository, IProcessArea processArea, IDebugger dbg) throws TeamRepositoryException {
        this.datasetCacheItem = BuildCacheFactoryEE.loadDataset(repository, (IProcessAreaHandle)processArea, this.platform, 3, dbg);
    }

    public IBuildCacheItem<?> getCacheItem() {
        return this.datasetCacheItem;
    }

    public String getDerivedPropertyValue(String originalValue) {
        String result = null;
        if (this.datasetCacheItem.containsName(originalValue.trim())) {
            result = ((ISystemDefinition)this.datasetCacheItem.getName(originalValue.trim())).getItemId().getUuidValue();
        }
        return result;
    }

    public String getOriginalPropertyValue(String derivedValue) {
        String result = null;
        if (this.datasetCacheItem.containsUuid(derivedValue)) {
            result = ((ISystemDefinition)this.datasetCacheItem.getUuid(derivedValue)).getName();
        }
        return result;
    }
}

