/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.extensions.client;

import com.ibm.team.build.extensions.common.IBuildCacheLoad;
import com.ibm.team.build.extensions.common.IBuildCacheLoadExecute;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.build.extensions.client.BuildCacheItemTranslator;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BuildCacheLoadTranslator
implements IBuildCacheLoad,
IBuildCacheLoadExecute<ISystemDefinition>,
Callable<IBuildCacheLoad> {
    private final BuildCacheItemTranslator buildCacheItem;
    private final ITeamRepository repository;
    private final IProcessAreaHandle processArea;
    private final String processAreaId;
    private final ISystemDefinition.Platform platform;
    private final ISystemDefinition item;
    private final List<ISystemDefinition> items;
    private final ISystemDefinitionHandle itemHandle;
    private final List<ISystemDefinitionHandle> itemHandles;
    private final String itemString;
    private final List<String> itemStrings;
    private boolean append;
    private int usage = -1;
    private boolean returnItemList;
    private List<ISystemDefinition> itemList;
    private final IDebugger dbg;
    private final String simpleName;
    private final IProgressMonitor monitor;

    public BuildCacheLoadTranslator(ITeamRepository repository, IProcessAreaHandle processArea, ISystemDefinition.Platform platform, BuildCacheItemTranslator buildCacheItem, ISystemDefinition item, List<ISystemDefinition> items, ISystemDefinitionHandle itemHandle, List<ISystemDefinitionHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this.repository = repository;
        this.processArea = processArea;
        this.processAreaId = processArea.getItemId().getUuidValue();
        this.platform = platform;
        this.buildCacheItem = buildCacheItem;
        this.item = item;
        this.items = items;
        this.itemHandle = itemHandle;
        this.itemHandles = itemHandles;
        this.itemString = itemString;
        this.itemStrings = itemStrings;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.monitor = new NullProgressMonitor();
    }

    public List<ISystemDefinition> execute() throws TeamRepositoryException {
        this.returnItemList = true;
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return this.itemList;
    }

    @Override
    public IBuildCacheLoad call() throws Exception {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        if (this.item != null || this.items != null || this.itemHandle != null || this.itemHandles != null || this.itemString != null || this.itemStrings != null) {
            ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)this.repository.getClientLibrary(ISystemDefinitionModelClient.class);
            ArrayList<ISystemDefinition> itemList = new ArrayList<ISystemDefinition>();
            if (this.item != null) {
                itemList.add(this.item);
            }
            if (this.items != null) {
                itemList.addAll(this.items);
            }
            if (this.itemHandle != null) {
                itemList.add(client.fetchSystemDefinitionComplete(this.itemHandle, false, this.monitor));
            }
            if (this.itemHandles != null) {
                itemList.addAll(client.fetchSystemDefinitionsComplete(this.itemHandles, false, this.monitor));
            }
            if (this.itemString != null) {
                if (Verification.isUUID((String)this.itemString)) {
                    itemList.add(client.fetchSystemDefinitionComplete((ISystemDefinitionHandle)ITranslator.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.itemString), null), false, this.monitor));
                } else {
                    itemList.add(client.findSystemDefinitionByName(this.itemString, ITranslator.ITEM_TYPE, this.monitor));
                }
            }
            if (this.itemStrings != null && this.itemStrings.get(0) != null) {
                if (Verification.isUUID((String)this.itemString)) {
                    ArrayList<ISystemDefinitionHandle> systemDefinitionHandles = new ArrayList<ISystemDefinitionHandle>();
                    for (String string : this.itemStrings) {
                        systemDefinitionHandles.add((ISystemDefinitionHandle)ITranslator.ITEM_TYPE.createItemHandle(UUID.valueOf((String)string), null));
                    }
                    itemList.addAll(client.fetchSystemDefinitionsComplete(systemDefinitionHandles, false, this.monitor));
                } else {
                    for (String name : this.itemStrings) {
                        itemList.add(client.findSystemDefinitionByName(name, ITranslator.ITEM_TYPE, this.monitor));
                    }
                }
            }
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, ISystemDefinition> itemMapByName = new HashMap<String, ISystemDefinition>();
            HashMap<String, ISystemDefinition> hashMap = new HashMap<String, ISystemDefinition>();
            for (ISystemDefinition item : itemList) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = item.getName();
                    itemMapByName.put(itemName, item);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                hashMap.put(itemUuid, item);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(this.processArea);
            this.buildCacheItem.setProcessAreaId(this.processAreaId);
            this.buildCacheItem.setItemHandle(null);
            this.buildCacheItem.setItemHandleId(null);
            this.buildCacheItem.setPartial();
            if (this.buildCacheItem.hasItemList()) {
                this.buildCacheItem.addAllItemList(itemList);
            }
            if (this.buildCacheItem.hasItemMapByName()) {
                this.buildCacheItem.addAllItemMapByName(itemMapByName);
            }
            if (this.buildCacheItem.hasItemMapByUuid()) {
                this.buildCacheItem.addAllItemMapByUuid(hashMap);
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        } else {
            ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)this.repository.getClientLibrary(ISystemDefinitionModelClient.class);
            List itemList = null;
            itemList = this.platform == null ? client.findSystemDefinitionsComplete(ITranslator.ITEM_TYPE, (IProjectAreaHandle)this.processArea, -1, false, this.monitor) : (this.platform.equals((Object)ISystemDefinition.Platform.zos) ? client.findSystemDefinitionsComplete(IZosTranslator.ITEM_TYPE, (IProjectAreaHandle)this.processArea, -1, false, this.monitor) : client.findSystemDefinitionsComplete(IIBMiTranslator.ITEM_TYPE, (IProjectAreaHandle)this.processArea, -1, false, this.monitor));
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, ISystemDefinition> itemMapByName = new HashMap<String, ISystemDefinition>();
            HashMap<String, ISystemDefinition> hashMap = new HashMap<String, ISystemDefinition>();
            for (ISystemDefinition item : itemList) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = item.getName();
                    itemMapByName.put(itemName, item);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                hashMap.put(itemUuid, item);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(this.processArea);
            this.buildCacheItem.setProcessAreaId(this.processAreaId);
            this.buildCacheItem.setItemHandle(null);
            this.buildCacheItem.setItemHandleId(null);
            this.buildCacheItem.setComplete();
            if (!this.append) {
                this.buildCacheItem.clear();
                this.buildCacheItem.clearPlatformEntry();
                this.buildCacheItem.setUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.setItemList(itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.setItemMapByName(itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.setItemMapByUuid(hashMap);
                }
            } else {
                this.buildCacheItem.addUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.addAllItemList(itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.addAllItemMapByName(itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.addAllItemMapByUuid(hashMap);
                }
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        return this;
    }

    public final void setAppend(boolean append) {
        this.append = append;
    }

    public final void setUsage(int usage) {
        this.usage = usage;
    }
}

