/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.extensions.client;

import com.ibm.team.build.extensions.common.IBuildCacheLoad;
import com.ibm.team.build.extensions.common.IBuildCacheLoadExecute;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.enterprise.build.extensions.client.BuildCacheItemLibraryHandle;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IIBMiResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BuildCacheLoadLibraryHandle
implements IBuildCacheLoad,
IBuildCacheLoadExecute<ISystemDefinitionHandle>,
Callable<IBuildCacheLoad> {
    private final BuildCacheItemLibraryHandle buildCacheItem;
    private final ITeamRepository repository;
    private final IProcessAreaHandle processArea;
    private final String processAreaId;
    private final ISystemDefinition.Platform platform;
    private boolean append;
    private int usage = -1;
    private boolean returnItemList;
    private List<ISystemDefinitionHandle> itemList;
    private final IDebugger dbg;
    private final String simpleName;
    private final IProgressMonitor monitor;

    public BuildCacheLoadLibraryHandle(ITeamRepository repository, IProcessAreaHandle processArea, ISystemDefinition.Platform platform, BuildCacheItemLibraryHandle buildCacheItem, IDebugger dbg) {
        this.repository = repository;
        this.processArea = processArea;
        this.processAreaId = processArea.getItemId().getUuidValue();
        this.platform = platform;
        this.buildCacheItem = buildCacheItem;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.monitor = new NullProgressMonitor();
    }

    public List<ISystemDefinitionHandle> execute() throws TeamRepositoryException {
        this.returnItemList = true;
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return this.itemList;
    }

    @Override
    public IBuildCacheLoad call() throws Exception {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)this.repository.getClientLibrary(ISystemDefinitionModelClient.class);
        ArrayList<ISystemDefinitionHandle> itemList = this.buildCacheItem.hasItemMapByName() ? new ArrayList<ISystemDefinitionHandle>(client.findSystemDefinitions(IIBMiResourceDefinition.ITEM_TYPE, (IProjectAreaHandle)this.processArea, this.usage, false, Arrays.asList(ISystemDefinition.SMALL_PROFILE), this.monitor)) : client.findSystemDefinitionHandles(IIBMiResourceDefinition.ITEM_TYPE, (IProjectAreaHandle)this.processArea, this.usage, false, this.monitor);
        HashMap<String, ISystemDefinitionHandle> itemMapByName = new HashMap<String, ISystemDefinitionHandle>();
        HashMap<String, ISystemDefinitionHandle> itemMapByUuid = new HashMap<String, ISystemDefinitionHandle>();
        for (ISystemDefinitionHandle item : itemList) {
            if (this.buildCacheItem.hasItemMapByName()) {
                String itemName = ((ISystemDefinition)item).getName();
                itemMapByName.put(itemName, item);
            }
            if (!this.buildCacheItem.hasItemMapByUuid()) continue;
            String itemUuid = item.getItemId().getUuidValue();
            itemMapByUuid.put(itemUuid, item);
        }
        this.buildCacheItem.setRepository(this.repository);
        this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
        this.buildCacheItem.setProcessArea(this.processArea);
        this.buildCacheItem.setProcessAreaId(this.processAreaId);
        this.buildCacheItem.setItemHandle(null);
        this.buildCacheItem.setItemHandleId(null);
        if (this.usage == -1) {
            this.buildCacheItem.setComplete();
        } else {
            this.buildCacheItem.setPartial();
        }
        if (!this.append) {
            this.buildCacheItem.clear();
            this.buildCacheItem.clearPlatformEntry();
            this.buildCacheItem.setUsage(this.usage);
            this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
            if (this.buildCacheItem.hasItemList()) {
                this.buildCacheItem.setItemList(itemList);
            }
            if (this.buildCacheItem.hasItemMapByName()) {
                this.buildCacheItem.setItemMapByName(itemMapByName);
            }
            if (this.buildCacheItem.hasItemMapByUuid()) {
                this.buildCacheItem.setItemMapByUuid(itemMapByUuid);
            }
        } else {
            this.buildCacheItem.addUsage(this.usage);
            this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
            if (this.buildCacheItem.hasItemList()) {
                this.buildCacheItem.addAllItemList(itemList);
            }
            if (this.buildCacheItem.hasItemMapByName()) {
                this.buildCacheItem.addAllItemMapByName(itemMapByName);
            }
            if (this.buildCacheItem.hasItemMapByUuid()) {
                this.buildCacheItem.addAllItemMapByUuid(itemMapByUuid);
            }
        }
        if (this.returnItemList) {
            this.itemList = itemList;
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        return this;
    }

    public final void setAppend(boolean append) {
        this.append = append;
    }

    public final void setUsage(int usage) {
        this.usage = usage;
    }

    public final void setLibraryUsageAll() {
        this.usage = -1;
    }

    public final void setLibraryUsageObject() {
        this.usage = 0;
    }

    public final void setLibraryUsageExisting() {
        this.usage = 1;
    }
}

