/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.extensions.client;

import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.extensions.common.IBuildCacheLoad;
import com.ibm.team.build.extensions.common.IBuildCacheLoadExecute;
import com.ibm.team.build.extensions.common.IBuildCachePlatform;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMapHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.query.BaseBuildMapQueryModel;
import com.ibm.team.enterprise.build.extensions.client.BuildCacheItemBuildMapHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BuildCacheLoadBuildMapHandle
implements IBuildCacheLoad,
IBuildCacheLoadExecute<IBuildMapHandle>,
Callable<IBuildCacheLoad> {
    private final BuildCacheItemBuildMapHandle buildCacheItem;
    private final ITeamRepository repository;
    private final IBuildResultHandle buildResult;
    private final String buildResultId;
    private final IBuildCachePlatform.Platform platform;
    private final IBuildMap item;
    private final List<IBuildMap> items;
    private final IBuildMapHandle itemHandle;
    private final List<IBuildMapHandle> itemHandles;
    private final String itemString;
    private final List<String> itemStrings;
    private boolean append;
    private int usage = -1;
    private boolean returnItemList;
    private List<IBuildMapHandle> itemList;
    private final IDebugger dbg;
    private final String simpleName;
    private final IProgressMonitor monitor;

    public BuildCacheLoadBuildMapHandle(ITeamRepository repository, IBuildResultHandle buildResult, BuildCacheItemBuildMapHandle buildCacheItem, IBuildMap item, List<IBuildMap> items, IBuildMapHandle itemHandle, List<IBuildMapHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this(repository, buildResult, IBuildCachePlatform.Platform.none, buildCacheItem, item, items, itemHandle, itemHandles, itemString, itemStrings, dbg);
    }

    public BuildCacheLoadBuildMapHandle(ITeamRepository repository, IBuildResultHandle buildResult, IBuildCachePlatform.Platform platform, BuildCacheItemBuildMapHandle buildCacheItem, IBuildMap item, List<IBuildMap> items, IBuildMapHandle itemHandle, List<IBuildMapHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this.repository = repository;
        this.buildResult = buildResult;
        this.buildResultId = buildResult == null ? null : buildResult.getItemId().getUuidValue();
        this.platform = platform;
        this.buildCacheItem = buildCacheItem;
        this.item = item;
        this.items = items;
        this.itemHandle = itemHandle;
        this.itemHandles = itemHandles;
        this.itemString = itemString;
        this.itemStrings = itemStrings;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.monitor = new NullProgressMonitor();
    }

    public List<IBuildMapHandle> execute() throws TeamRepositoryException {
        this.returnItemList = true;
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return this.itemList;
    }

    @Override
    public IBuildCacheLoad call() throws Exception {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        if (this.item != null || this.items != null || this.itemHandle != null || this.itemHandles != null || this.itemString != null || this.itemStrings != null) {
            ArrayList<IBuildMapHandle> itemList = new ArrayList<IBuildMapHandle>();
            if (this.item != null) {
                itemList.add((IBuildMapHandle)this.item);
            }
            if (this.items != null) {
                itemList.addAll(this.items);
            }
            if (this.itemHandle != null) {
                itemList.add(this.itemHandle);
            }
            if (this.itemHandles != null) {
                itemList.addAll(this.itemHandles);
            }
            if (this.itemString != null && Verification.isUUID((String)this.itemString)) {
                itemList.add((IBuildMapHandle)IBuildMap.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.itemString), null));
            }
            if (this.itemStrings != null) {
                ArrayList<IBuildMapHandle> handles = new ArrayList<IBuildMapHandle>();
                for (String itemId : this.itemStrings) {
                    if (!Verification.isUUID((String)itemId)) continue;
                    handles.add((IBuildMapHandle)IBuildMap.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), null));
                }
                itemList.addAll(handles);
            }
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IBuildMapHandle> itemMapByName = new HashMap<String, IBuildMapHandle>();
            HashMap<String, IBuildMapHandle> itemMapByUuid = new HashMap<String, IBuildMapHandle>();
            for (IBuildMapHandle item : itemList) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = item.getItemId().getUuidValue();
                    itemMapByName.put(itemName, item);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, item);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(null);
            this.buildCacheItem.setProcessAreaId(null);
            this.buildCacheItem.setItemHandle((IItemHandle)this.buildResult);
            this.buildCacheItem.setItemHandleId(this.buildResultId);
            this.buildCacheItem.setPartial();
            if (this.buildCacheItem.hasItemList()) {
                this.buildCacheItem.addAllItemList(itemList);
            }
            if (this.buildCacheItem.hasItemMapByName()) {
                this.buildCacheItem.addAllItemMapByName(itemMapByName);
            }
            if (this.buildCacheItem.hasItemMapByUuid()) {
                this.buildCacheItem.addAllItemMapByUuid(itemMapByUuid);
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        } else {
            IQueryService queryClient = ((TeamRepository)this.repository).getQueryService();
            ArrayList<IBuildMapHandle> itemHandles = new ArrayList<IBuildMapHandle>();
            BaseBuildMapQueryModel.BuildMapQueryModel model = BaseBuildMapQueryModel.BuildMapQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            IPredicate filter = model._isTypeOf(IBuildMap.ITEM_TYPE);
            filter._and(model.buildResult()._eq((IItemHandle)this.buildResult));
            query.filter(filter);
            ArrayList parms = new ArrayList();
            int options = 512;
            IItemQueryPage resultPage = queryClient.queryItems(query, parms.toArray(), options);
            if (resultPage.getSize() > 0) {
                itemHandles.addAll(resultPage.getItemHandles());
                while (resultPage.hasNext() && !this.monitor.isCanceled()) {
                    resultPage = (IItemQueryPage)queryClient.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize());
                    itemHandles.addAll(resultPage.getItemHandles());
                }
            }
            ArrayList<IBuildMapHandle> itemList = itemHandles;
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IBuildMapHandle> itemMapByName = new HashMap<String, IBuildMapHandle>();
            HashMap<String, IBuildMapHandle> itemMapByUuid = new HashMap<String, IBuildMapHandle>();
            for (IBuildMapHandle item : itemList) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = item.getItemId().getUuidValue();
                    itemMapByName.put(itemName, item);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, item);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(null);
            this.buildCacheItem.setProcessAreaId(null);
            this.buildCacheItem.setItemHandle((IItemHandle)this.buildResult);
            this.buildCacheItem.setItemHandleId(this.buildResultId);
            if (this.usage == -1) {
                this.buildCacheItem.setComplete();
            } else {
                this.buildCacheItem.setPartial();
            }
            if (!this.append) {
                this.buildCacheItem.clear();
                this.buildCacheItem.clearPlatformEntry();
                this.buildCacheItem.setUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.setItemList(itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.setItemMapByName(itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.setItemMapByUuid(itemMapByUuid);
                }
            } else {
                this.buildCacheItem.addUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.addAllItemList(itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.addAllItemMapByName(itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.addAllItemMapByUuid(itemMapByUuid);
                }
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        return this;
    }

    public final void setAppend(boolean append) {
        this.append = append;
    }

    public final void setUsage(int usage) {
        this.usage = usage;
    }
}

