/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.extensions.client;

import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.extensions.common.IBuildCacheLoad;
import com.ibm.team.build.extensions.common.IBuildCacheLoadExecute;
import com.ibm.team.build.extensions.common.IBuildCachePlatform;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMapHandle;
import com.ibm.team.enterprise.build.buildmap.common.model.query.BaseBuildMapQueryModel;
import com.ibm.team.enterprise.build.extensions.client.BuildCacheItemBuildMap;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class BuildCacheLoadBuildMap
implements IBuildCacheLoad,
IBuildCacheLoadExecute<IBuildMap>,
Callable<IBuildCacheLoad> {
    private final BuildCacheItemBuildMap buildCacheItem;
    private final ITeamRepository repository;
    private final IBuildResultHandle buildResult;
    private final String buildResultId;
    private final IBuildCachePlatform.Platform platform;
    private final IBuildMap item;
    private final List<IBuildMap> items;
    private final IBuildMapHandle itemHandle;
    private final List<IBuildMapHandle> itemHandles;
    private final String itemString;
    private final List<String> itemStrings;
    private boolean append;
    private int usage = -1;
    private boolean returnItemList;
    private List<IBuildMap> itemList;
    private final IDebugger dbg;
    private final String simpleName;
    private final IProgressMonitor monitor;

    public BuildCacheLoadBuildMap(ITeamRepository repository, IBuildResultHandle buildResult, BuildCacheItemBuildMap buildCacheItem, IBuildMap item, List<IBuildMap> items, IBuildMapHandle itemHandle, List<IBuildMapHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this(repository, buildResult, IBuildCachePlatform.Platform.none, buildCacheItem, item, items, itemHandle, itemHandles, itemString, itemStrings, dbg);
    }

    public BuildCacheLoadBuildMap(ITeamRepository repository, IBuildResultHandle buildResult, IBuildCachePlatform.Platform platform, BuildCacheItemBuildMap buildCacheItem, IBuildMap item, List<IBuildMap> items, IBuildMapHandle itemHandle, List<IBuildMapHandle> itemHandles, String itemString, List<String> itemStrings, IDebugger dbg) {
        this.repository = repository;
        this.buildResult = buildResult;
        this.buildResultId = buildResult == null ? null : buildResult.getItemId().getUuidValue();
        this.platform = platform;
        this.buildCacheItem = buildCacheItem;
        this.item = item;
        this.items = items;
        this.itemHandle = itemHandle;
        this.itemHandles = itemHandles;
        this.itemString = itemString;
        this.itemStrings = itemStrings;
        this.dbg = dbg;
        this.simpleName = this.getClass().getSimpleName();
        this.monitor = new NullProgressMonitor();
    }

    public List<IBuildMap> execute() throws TeamRepositoryException {
        this.returnItemList = true;
        try {
            this.call();
        }
        catch (Exception e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        return this.itemList;
    }

    @Override
    public IBuildCacheLoad call() throws Exception {
        if (this.dbg.isDebug()) {
            Debug.enter((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        if (this.item != null || this.items != null || this.itemHandle != null || this.itemHandles != null || this.itemString != null || this.itemStrings != null) {
            IItemManager client = this.repository.itemManager();
            ArrayList<IBuildMap> itemList = new ArrayList<IBuildMap>();
            if (this.item != null) {
                itemList.add(this.item);
            }
            if (this.items != null) {
                itemList.addAll(this.items);
            }
            if (this.itemHandle != null) {
                itemList.add((IBuildMap)client.fetchCompleteItem((IItemHandle)this.itemHandle, 0, this.monitor));
            }
            if (this.itemHandles != null) {
                itemList.addAll(client.fetchCompleteItems(this.itemHandles, 0, this.monitor));
            }
            if (this.itemString != null && Verification.isUUID((String)this.itemString)) {
                itemList.add((IBuildMap)client.fetchCompleteItem(IBuildMap.ITEM_TYPE.createItemHandle(UUID.valueOf((String)this.itemString), null), 0, this.monitor));
            }
            if (this.itemStrings != null) {
                ArrayList<IBuildMap> handles = new ArrayList<IBuildMap>();
                for (String itemId : this.itemStrings) {
                    if (!Verification.isUUID((String)itemId)) continue;
                    handles.add((IBuildMap)client.fetchCompleteItem(IBuildMap.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), null), 0, this.monitor));
                }
                itemList.addAll(client.fetchCompleteItems(handles, 0, this.monitor));
            }
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IBuildMap> itemMapByName = new HashMap<String, IBuildMap>();
            HashMap<String, IBuildMap> itemMapByUuid = new HashMap<String, IBuildMap>();
            for (IBuildMap item : itemList) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = item.getItemId().getUuidValue();
                    itemMapByName.put(itemName, item);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, item);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(null);
            this.buildCacheItem.setProcessAreaId(null);
            this.buildCacheItem.setItemHandle((IItemHandle)this.buildResult);
            this.buildCacheItem.setItemHandleId(this.buildResultId);
            this.buildCacheItem.setPartial();
            if (this.buildCacheItem.hasItemList()) {
                this.buildCacheItem.addAllItemList(itemList);
            }
            if (this.buildCacheItem.hasItemMapByName()) {
                this.buildCacheItem.addAllItemMapByName(itemMapByName);
            }
            if (this.buildCacheItem.hasItemMapByUuid()) {
                this.buildCacheItem.addAllItemMapByUuid(itemMapByUuid);
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        } else {
            IItemManager itemClient = this.repository.itemManager();
            IQueryService queryClient = ((TeamRepository)this.repository).getQueryService();
            ArrayList itemHandles = new ArrayList();
            BaseBuildMapQueryModel.BuildMapQueryModel model = BaseBuildMapQueryModel.BuildMapQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)model);
            IPredicate filter = model._isTypeOf(IBuildMap.ITEM_TYPE);
            filter._and(model.buildResult()._eq((IItemHandle)this.buildResult));
            query.filter(filter);
            ArrayList parms = new ArrayList();
            int options = 512;
            IItemQueryPage resultPage = queryClient.queryItems(query, parms.toArray(), options);
            if (resultPage.getSize() > 0) {
                itemHandles.addAll(resultPage.getItemHandles());
                while (resultPage.hasNext() && !this.monitor.isCanceled()) {
                    resultPage = (IItemQueryPage)queryClient.fetchPage(resultPage.getToken(), resultPage.getNextStartPosition(), resultPage.getSize());
                    itemHandles.addAll(resultPage.getItemHandles());
                }
            }
            List itemList = itemClient.fetchCompleteItems(itemHandles, 0, this.monitor);
            itemList.removeAll(Collections.singleton(null));
            HashMap<String, IBuildMap> itemMapByName = new HashMap<String, IBuildMap>();
            HashMap<String, IBuildMap> itemMapByUuid = new HashMap<String, IBuildMap>();
            for (IBuildMap item : itemList) {
                if (this.buildCacheItem.hasItemMapByName()) {
                    String itemName = item.getItemId().getUuidValue();
                    itemMapByName.put(itemName, item);
                }
                if (!this.buildCacheItem.hasItemMapByUuid()) continue;
                String itemUuid = item.getItemId().getUuidValue();
                itemMapByUuid.put(itemUuid, item);
            }
            this.buildCacheItem.setRepository(this.repository);
            this.buildCacheItem.setRepositoryId(this.repository.getId().getUuidValue());
            this.buildCacheItem.setProcessArea(null);
            this.buildCacheItem.setProcessAreaId(null);
            this.buildCacheItem.setItemHandle((IItemHandle)this.buildResult);
            this.buildCacheItem.setItemHandleId(this.buildResultId);
            if (this.usage == -1) {
                this.buildCacheItem.setComplete();
            } else {
                this.buildCacheItem.setPartial();
            }
            if (!this.append) {
                this.buildCacheItem.clear();
                this.buildCacheItem.clearPlatformEntry();
                this.buildCacheItem.setUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.setItemList(itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.setItemMapByName(itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.setItemMapByUuid(itemMapByUuid);
                }
            } else {
                this.buildCacheItem.addUsage(this.usage);
                this.buildCacheItem.setPlatformEntry(this.platform, this.usage, itemList);
                if (this.buildCacheItem.hasItemList()) {
                    this.buildCacheItem.addAllItemList(itemList);
                }
                if (this.buildCacheItem.hasItemMapByName()) {
                    this.buildCacheItem.addAllItemMapByName(itemMapByName);
                }
                if (this.buildCacheItem.hasItemMapByUuid()) {
                    this.buildCacheItem.addAllItemMapByUuid(itemMapByUuid);
                }
            }
            if (this.returnItemList) {
                this.itemList = itemList;
            }
        }
        if (this.dbg.isDebug()) {
            Debug.leave((IDebugger)this.dbg, (String[])new String[]{this.simpleName});
        }
        return this;
    }

    public final void setAppend(boolean append) {
        this.append = append;
    }

    public final void setUsage(int usage) {
        this.usage = usage;
    }
}

