/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.extensions.client;

import com.ibm.team.build.extensions.client.IBuildCacheItem;
import com.ibm.team.build.extensions.common.ItemArrayList;
import com.ibm.team.build.extensions.common.nls.Common;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.build.extensions.common.IBuildCachePlatform;
import com.ibm.team.enterprise.systemdefinition.common.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BuildCacheItemDataset
implements IBuildCacheItem<ISystemDefinition>,
IBuildCachePlatform<ISystemDefinition> {
    private ITeamRepository repository;
    private IProcessAreaHandle processArea;
    private IItemHandle itemHandle;
    private String repositoryId;
    private String processAreaId;
    private String itemHandleId;
    private boolean partial;
    private boolean standard;
    private boolean complete;
    private final boolean hasItemList;
    private final boolean hasItemMapByName;
    private final boolean hasItemMapByUuid;
    private ItemArrayList<ISystemDefinition> itemList;
    private Map<String, ISystemDefinition> itemMapByName;
    private Map<String, ISystemDefinition> itemMapByUuid;
    private final Set<Integer> usages = new HashSet<Integer>();
    private final Map<ISystemDefinition.Platform, Map<Integer, List<ISystemDefinition>>> platformLists = new HashMap<ISystemDefinition.Platform, Map<Integer, List<ISystemDefinition>>>();

    public BuildCacheItemDataset(boolean hasItemList, boolean hasItemMapByName, boolean hasItemMapByUuid) throws TeamRepositoryException {
        this.hasItemList = hasItemList;
        this.hasItemMapByName = hasItemMapByName;
        this.hasItemMapByUuid = hasItemMapByUuid;
        if (!this.hasItemList && !this.hasItemMapByName && this.hasItemMapByUuid) {
            throw new TeamRepositoryException(NLS.bind((String)Common.COMMON_BUILDCACHE_ITEM_EMPTY, (Object)this.getClass().getSimpleName(), (Object[])new Object[0]));
        }
        if (this.hasItemList) {
            this.itemList = new ItemArrayList();
        }
        if (this.hasItemMapByName) {
            this.itemMapByName = Collections.synchronizedMap(new HashMap());
        }
        if (this.hasItemMapByUuid) {
            this.itemMapByUuid = Collections.synchronizedMap(new HashMap());
        }
    }

    public final void addUsage(int usage) {
        this.usages.add(usage);
    }

    public final boolean hasUsage(int usage) {
        return this.usages.contains(usage);
    }

    public final void setUsage(int usage) {
        this.usages.clear();
        this.usages.add(usage);
    }

    public final List<ISystemDefinition> getPlatformEntry(ISystemDefinition.Platform platform, Integer usage) {
        if (this.platformLists.containsKey(platform)) {
            return this.platformLists.get(platform).get(usage);
        }
        return null;
    }

    public final void clearPlatformEntry() {
        this.platformLists.clear();
    }

    public final boolean hasPlatformEntry(ISystemDefinition.Platform platform) {
        return this.platformLists.containsKey(platform);
    }

    public final boolean hasPlatformEntry(ISystemDefinition.Platform platform, Integer usage) {
        if (this.platformLists.containsKey(platform)) {
            return this.platformLists.get(platform).containsKey(usage);
        }
        return false;
    }

    public final void setPlatformEntry(ISystemDefinition.Platform platform, Integer usage, List<ISystemDefinition> items) {
        if (!this.platformLists.containsKey(platform)) {
            this.platformLists.put(platform, new HashMap());
        }
        this.platformLists.get(platform).put(usage, items);
    }

    public final ITeamRepository getRepository() {
        return this.repository;
    }

    public final IProcessAreaHandle getProcessArea() {
        return this.processArea;
    }

    public final IItemHandle getItemHandle() {
        return this.itemHandle;
    }

    public final String getRepositoryId() {
        return this.repositoryId;
    }

    public final String getProcessAreaId() {
        return this.processAreaId;
    }

    public final String getItemHandleId() {
        return this.itemHandleId;
    }

    public final List<?> getList() {
        return this.itemList;
    }

    public final List<ISystemDefinition> getItemList() {
        return this.itemList;
    }

    public final Map<String, ISystemDefinition> getItemMapByName() {
        return this.itemMapByName;
    }

    public final Map<String, ISystemDefinition> getItemMapByUuid() {
        return this.itemMapByUuid;
    }

    public final ISystemDefinition get(ISystemDefinition item) {
        ISystemDefinition result = null;
        result = this.hasItemList ? this.getItemList(item) : (this.hasItemMapByName ? this.getItemMapByName(item) : this.getItemMapByUuid(item));
        return result;
    }

    public final ISystemDefinition get(String item) {
        if (Verification.isUUID((String)item)) {
            return this.getUuid(item);
        }
        return this.getName(item);
    }

    public final ISystemDefinition getName(String name) {
        ISystemDefinition result = null;
        result = this.hasItemMapByName ? this.getItemMapByName(name) : this.getItemListByName(name);
        return result;
    }

    public final ISystemDefinition getUuid(String uuid) {
        ISystemDefinition result = null;
        result = this.hasItemMapByUuid ? this.getItemMapByUuid(uuid) : this.getItemListByUuid(uuid);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ISystemDefinition getItemList(int location) {
        ISystemDefinition result = null;
        if (this.hasItemList) {
            ItemArrayList<ISystemDefinition> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                if (location <= this.itemList.size()) {
                    result = (ISystemDefinition)this.itemList.get(location);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ISystemDefinition getItemList(ISystemDefinition item) {
        ISystemDefinition result = null;
        if (this.hasItemList) {
            ItemArrayList<ISystemDefinition> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                result = (ISystemDefinition)this.itemList.get((IItemHandle)item);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ISystemDefinition getItemListByName(String name) {
        ISystemDefinition result = null;
        if (name != null) {
            if (this.hasItemList) {
                ItemArrayList<ISystemDefinition> itemArrayList = this.itemList;
                synchronized (itemArrayList) {
                    for (ISystemDefinition item : this.itemList) {
                        if (!name.equals(item.getName())) continue;
                        result = item;
                        break;
                    }
                }
            }
            if (this.hasItemMapByUuid) {
                Map<String, ISystemDefinition> map = this.itemMapByUuid;
                synchronized (map) {
                    for (ISystemDefinition item : this.itemMapByUuid.values()) {
                        if (!name.equals(item.getName())) continue;
                        result = item;
                        break;
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ISystemDefinition getItemListByUuid(String uuid) {
        ISystemDefinition result = null;
        if (uuid != null) {
            if (this.hasItemList) {
                ItemArrayList<ISystemDefinition> itemArrayList = this.itemList;
                synchronized (itemArrayList) {
                    for (ISystemDefinition item : this.itemList) {
                        if (!uuid.equals(item.getItemId().getUuidValue())) continue;
                        result = item;
                        break;
                    }
                }
            }
            if (this.hasItemMapByName) {
                Map<String, ISystemDefinition> map = this.itemMapByName;
                synchronized (map) {
                    for (ISystemDefinition item : this.itemMapByName.values()) {
                        if (!uuid.equals(item.getItemId().getUuidValue())) continue;
                        result = item;
                        break;
                    }
                }
            }
        }
        return result;
    }

    public final ISystemDefinition getItemMapByName(String name) {
        ISystemDefinition result = null;
        if (this.hasItemMapByName) {
            result = this.itemMapByName.get(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ISystemDefinition getItemMapByName(ISystemDefinition itemArg) {
        ISystemDefinition result = null;
        if (this.hasItemMapByName) {
            Map<String, ISystemDefinition> map = this.itemMapByName;
            synchronized (map) {
                for (ISystemDefinition item : this.itemMapByName.values()) {
                    if (!itemArg.sameItemId((IItemHandle)item)) continue;
                    result = item;
                    break;
                }
            }
        }
        return result;
    }

    public final ISystemDefinition getItemMapByUuid(String uuid) {
        ISystemDefinition result = null;
        if (this.hasItemMapByUuid) {
            result = this.itemMapByUuid.get(uuid);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ISystemDefinition getItemMapByUuid(ISystemDefinition itemArg) {
        ISystemDefinition result = null;
        if (this.hasItemMapByUuid) {
            Map<String, ISystemDefinition> map = this.itemMapByUuid;
            synchronized (map) {
                for (ISystemDefinition item : this.itemMapByUuid.values()) {
                    if (!itemArg.sameItemId((IItemHandle)item)) continue;
                    result = item;
                    break;
                }
            }
        }
        return result;
    }

    public final boolean hasRepository() {
        return this.repository != null;
    }

    public final boolean hasProcessArea() {
        return this.processArea != null;
    }

    public final boolean hasItemHandle() {
        return this.itemHandle != null;
    }

    public final boolean hasRepositoryId() {
        return this.repositoryId != null;
    }

    public final boolean hasProcessAreaId() {
        return this.processAreaId != null;
    }

    public final boolean hasItemHandleId() {
        return this.itemHandleId != null;
    }

    public final boolean hasItemList() {
        return this.hasItemList;
    }

    public final boolean hasItemMapByName() {
        return this.hasItemMapByName;
    }

    public final boolean hasItemMapByUuid() {
        return this.hasItemMapByUuid;
    }

    public final boolean isPartial() {
        return this.partial;
    }

    public final boolean isStandard() {
        return this.standard;
    }

    public final boolean isComplete() {
        return this.complete;
    }

    public final boolean isEmpty() {
        return this.isItemListEmpty() && this.isItemMapByNameEmpty() && this.isItemMapByUuidEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isItemListEmpty() {
        boolean result = true;
        if (this.hasItemList) {
            ItemArrayList<ISystemDefinition> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                result = this.itemList.size() == 0;
            }
        }
        return result;
    }

    public final boolean isItemMapByNameEmpty() {
        return this.hasItemMapByName ? this.itemMapByName.size() == 0 : true;
    }

    public final boolean isItemMapByUuidEmpty() {
        return this.hasItemMapByUuid ? this.itemMapByUuid.size() == 0 : true;
    }

    public final void setRepository(ITeamRepository repository) {
        this.repository = repository;
    }

    public final void setProcessArea(IProcessAreaHandle processArea) {
        this.processArea = processArea;
    }

    public final void setItemHandle(IItemHandle itemHandle) {
        this.itemHandle = itemHandle;
    }

    public final void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public final void setProcessAreaId(String processAreaId) {
        this.processAreaId = processAreaId;
    }

    public final void setItemHandleId(String itemHandleId) {
        this.itemHandleId = itemHandleId;
    }

    public final void setPartial() {
        this.partial = true;
        this.standard = false;
        this.complete = false;
    }

    public final void setStandard() {
        this.partial = false;
        this.standard = true;
        this.complete = false;
    }

    public final void setComplete() {
        this.partial = false;
        this.standard = false;
        this.complete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setItemList(List<ISystemDefinition> itemList) {
        if (this.hasItemList) {
            ItemArrayList<ISystemDefinition> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                this.itemList.clear();
                this.itemList.addAll(itemList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setItemMapByName(Map<String, ISystemDefinition> itemMapByName) {
        if (this.hasItemMapByName) {
            Map<String, ISystemDefinition> map = this.itemMapByName;
            synchronized (map) {
                this.itemMapByName.clear();
                this.itemMapByName.putAll(itemMapByName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setItemMapByUuid(Map<String, ISystemDefinition> itemMapByUuid) {
        if (this.hasItemMapByUuid) {
            Map<String, ISystemDefinition> map = this.itemMapByUuid;
            synchronized (map) {
                this.itemMapByUuid.clear();
                this.itemMapByUuid.putAll(itemMapByUuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<ISystemDefinition> toItemList() {
        ItemArrayList result = null;
        if (this.hasItemList) {
            ItemArrayList<ISystemDefinition> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                result = new ItemArrayList(this.itemList);
            }
        }
        return result;
    }

    public final Map<String, ISystemDefinition> toItemMapByName() {
        HashMap<String, ISystemDefinition> result = null;
        if (this.hasItemMapByName) {
            result = new HashMap<String, ISystemDefinition>(this.itemMapByName);
        }
        return result;
    }

    public final Map<String, ISystemDefinition> toItemMapByUuid() {
        HashMap<String, ISystemDefinition> result = null;
        if (this.hasItemMapByUuid) {
            result = new HashMap<String, ISystemDefinition>(this.itemMapByUuid);
        }
        return result;
    }

    public final void add(ISystemDefinition item) {
        if (this.hasItemList) {
            this.addItemList(item);
        }
        if (this.hasItemMapByName) {
            this.addItemMapByName(item.getName(), item);
        }
        if (this.hasItemMapByUuid) {
            this.addItemMapByUuid(item.getItemId().getUuidValue(), item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addItemList(ISystemDefinition item) {
        boolean result = false;
        if (this.hasItemList) {
            ItemArrayList<ISystemDefinition> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                this.itemList.removeAny((Object)item);
                result = this.itemList.add((Object)item);
            }
        }
        return result;
    }

    public final void addItemMapByName(String name, ISystemDefinition item) {
        if (this.hasItemMapByName) {
            this.itemMapByName.put(name, item);
        }
    }

    public final void addItemMapByUuid(String uuid, ISystemDefinition item) {
        if (this.hasItemMapByUuid) {
            this.itemMapByUuid.put(uuid, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addAllItemList(List<ISystemDefinition> items) {
        boolean result = false;
        if (this.hasItemList) {
            ItemArrayList<ISystemDefinition> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                for (ISystemDefinition item : items) {
                    if (!this.itemList.contains((Object)item)) continue;
                    this.itemList.removeAny((Object)item);
                }
                result = this.itemList.addAll(items);
            }
        }
        return result;
    }

    public final void addAllItemMapByName(Map<String, ISystemDefinition> items) {
        if (this.hasItemMapByName) {
            this.itemMapByName.putAll(items);
        }
    }

    public final void addAllItemMapByUuid(Map<String, ISystemDefinition> items) {
        if (this.hasItemMapByUuid) {
            this.itemMapByUuid.putAll(items);
        }
    }

    public final void clear() {
        this.clearItemList();
        this.clearItemMapByName();
        this.clearItemMapByUuid();
        this.clearPlatformEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearItemList() {
        if (this.hasItemList) {
            ItemArrayList<ISystemDefinition> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                this.itemList.clear();
            }
        }
    }

    public final void clearItemMapByName() {
        if (this.hasItemMapByName) {
            this.itemMapByName.clear();
        }
    }

    public final void clearItemMapByUuid() {
        if (this.hasItemMapByUuid) {
            this.itemMapByUuid.clear();
        }
    }

    public final boolean contains(ISystemDefinition item) {
        boolean result = false;
        result = this.hasItemList ? this.itemListContains(item) : (this.hasItemMapByName ? this.itemMapByNameContains(item) : this.itemMapByUuidContains(item));
        return result;
    }

    public final boolean contains(String item) {
        if (Verification.isUUID((String)item)) {
            return this.containsUuid(item);
        }
        return this.containsName(item);
    }

    public final boolean contains(UUID item) {
        return this.containsUuid(item.getUuidValue());
    }

    /*
     * Unable to fully structure code
     */
    public final boolean containsAll(List<?> itemList) {
        block4: {
            block6: {
                block8: {
                    block7: {
                        block5: {
                            result = false;
                            if (itemList == null || itemList.size() <= 0) break block4;
                            search = true;
                            iterator = itemList.iterator();
                            if (!(itemList.get(0) instanceof ISystemDefinition)) break block5;
                            while (search && iterator.hasNext() && iterator.next() != null) {
                                search = this.contains((ISystemDefinition)iterator.next());
                            }
                            break block6;
                        }
                        if (!(itemList.get(0) instanceof UUID)) break block7;
                        while (search && iterator.hasNext() && iterator.next() != null) {
                            search = this.contains((UUID)iterator.next());
                        }
                        break block6;
                    }
                    if (!(itemList.get(0) instanceof String)) break block8;
                    if (!Verification.isUUID((String)((String)itemList.get(0)))) ** GOTO lbl24
                    while (search && iterator.hasNext() && iterator.next() != null) {
                        search = this.containsUuid((String)iterator.next());
                    }
                    break block6;
lbl-1000:
                    // 1 sources

                    {
                        search = this.containsName((String)iterator.next());
lbl24:
                        // 2 sources

                        ** while (search && iterator.hasNext() && iterator.next() != null)
                    }
lbl25:
                    // 1 sources

                    break block6;
                }
                search = false;
            }
            result = search;
        }
        return result;
    }

    public final boolean containsName(String name) {
        boolean result = false;
        result = this.hasItemMapByName ? this.itemMapByNameContains(name) : this.itemListContainsName(name);
        return result;
    }

    public final boolean containsUuid(String uuid) {
        boolean result = false;
        result = this.hasItemMapByUuid ? this.itemMapByUuidContains(uuid) : this.itemListContainsUuid(uuid);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean itemListContains(ISystemDefinition item) {
        boolean result = false;
        if (this.hasItemList) {
            ItemArrayList<ISystemDefinition> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                result = this.itemList.contains((Object)item);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean itemListContainsName(String name) {
        boolean result = false;
        if (name != null) {
            if (this.hasItemList) {
                ItemArrayList<ISystemDefinition> itemArrayList = this.itemList;
                synchronized (itemArrayList) {
                    for (ISystemDefinition item : this.itemList) {
                        if (!name.equals(item.getName())) continue;
                        result = true;
                        break;
                    }
                }
            }
            if (this.hasItemMapByUuid) {
                Map<String, ISystemDefinition> map = this.itemMapByUuid;
                synchronized (map) {
                    for (ISystemDefinition item : this.itemMapByUuid.values()) {
                        if (!name.equals(item.getName())) continue;
                        result = true;
                        break;
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean itemListContainsUuid(String uuid) {
        boolean result = false;
        if (uuid != null) {
            if (this.hasItemList) {
                ItemArrayList<ISystemDefinition> itemArrayList = this.itemList;
                synchronized (itemArrayList) {
                    for (ISystemDefinition item : this.itemList) {
                        if (!uuid.equals(item.getItemId().getUuidValue())) continue;
                        result = true;
                        break;
                    }
                }
            }
            if (this.hasItemMapByName) {
                Map<String, ISystemDefinition> map = this.itemMapByName;
                synchronized (map) {
                    for (ISystemDefinition item : this.itemMapByName.values()) {
                        if (!uuid.equals(item.getItemId().getUuidValue())) continue;
                        result = true;
                        break;
                    }
                }
            }
        }
        return result;
    }

    public final boolean itemMapByNameContains(String name) {
        boolean result = false;
        if (this.hasItemMapByName) {
            result = this.itemMapByName.containsKey(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean itemMapByNameContains(ISystemDefinition itemArg) {
        boolean result = false;
        if (this.hasItemMapByName) {
            Map<String, ISystemDefinition> map = this.itemMapByName;
            synchronized (map) {
                for (ISystemDefinition item : this.itemMapByName.values()) {
                    if (item == null || !item.sameItemId((IItemHandle)itemArg)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public final boolean itemMapByUuidContains(String uuid) {
        boolean result = false;
        if (this.hasItemMapByUuid) {
            result = this.itemMapByUuid.containsKey(uuid);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean itemMapByUuidContains(ISystemDefinition itemArg) {
        boolean result = false;
        if (this.hasItemMapByUuid) {
            Map<String, ISystemDefinition> map = this.itemMapByUuid;
            synchronized (map) {
                for (ISystemDefinition item : this.itemMapByUuid.values()) {
                    if (item == null || !item.sameItemId((IItemHandle)itemArg)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeItemList(ISystemDefinition item) {
        boolean result = false;
        if (this.hasItemList) {
            ItemArrayList<ISystemDefinition> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                result = this.itemList.remove((Object)item);
            }
        }
        return result;
    }

    public final void removeItemMapByName(String name) {
        if (this.hasItemMapByName) {
            this.itemMapByName.remove(name);
        }
    }

    public final void removeItemMapByUuid(String uuid) {
        if (this.hasItemMapByUuid) {
            this.itemMapByUuid.remove(uuid);
        }
    }
}

