/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.extensions.client;

import com.ibm.team.build.extensions.client.IBuildCacheItem;
import com.ibm.team.build.extensions.common.IBuildCachePlatform;
import com.ibm.team.build.extensions.common.ItemArrayList;
import com.ibm.team.build.extensions.common.nls.Common;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMapHandle;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BuildCacheItemBuildMapHandle
implements IBuildCacheItem<IBuildMapHandle>,
IBuildCachePlatform<IBuildMapHandle> {
    private ITeamRepository repository;
    private IProcessAreaHandle processArea;
    private IItemHandle itemHandle;
    private String repositoryId;
    private String processAreaId;
    private String itemHandleId;
    private boolean partial;
    private boolean standard;
    private boolean complete;
    private final boolean hasItemList;
    private final boolean hasItemMapByName;
    private final boolean hasItemMapByUuid;
    private ItemArrayList<IBuildMapHandle> itemList;
    private Map<String, IBuildMapHandle> itemMapByName;
    private Map<String, IBuildMapHandle> itemMapByUuid;
    private final Set<Integer> usages = new HashSet<Integer>();
    private final Map<IBuildCachePlatform.Platform, Map<Integer, List<IBuildMapHandle>>> platformLists = new HashMap<IBuildCachePlatform.Platform, Map<Integer, List<IBuildMapHandle>>>();

    public BuildCacheItemBuildMapHandle(boolean hasItemList, boolean hasItemMapByName, boolean hasItemMapByUuid) throws TeamRepositoryException {
        this.hasItemList = hasItemList;
        this.hasItemMapByName = hasItemMapByName;
        this.hasItemMapByUuid = hasItemMapByUuid;
        if (!this.hasItemList && !this.hasItemMapByName && this.hasItemMapByUuid) {
            throw new TeamRepositoryException(NLS.bind((String)Common.COMMON_BUILDCACHE_ITEM_EMPTY, (Object)this.getClass().getSimpleName(), (Object[])new Object[0]));
        }
        if (this.hasItemList) {
            this.itemList = new ItemArrayList();
        }
        if (this.hasItemMapByName) {
            this.itemMapByName = Collections.synchronizedMap(new HashMap());
        }
        if (this.hasItemMapByUuid) {
            this.itemMapByUuid = Collections.synchronizedMap(new HashMap());
        }
    }

    public final void addUsage(int usage) {
        this.usages.add(usage);
    }

    public final boolean hasUsage(int usage) {
        return this.usages.contains(usage);
    }

    public final void setUsage(int usage) {
        this.usages.clear();
        this.usages.add(usage);
    }

    public final List<IBuildMapHandle> getPlatformEntry(IBuildCachePlatform.Platform platform, Integer usage) {
        if (this.platformLists.containsKey(platform)) {
            return this.platformLists.get(platform).get(usage);
        }
        return null;
    }

    public final void clearPlatformEntry() {
        this.platformLists.clear();
    }

    public final boolean hasPlatformEntry(IBuildCachePlatform.Platform platform) {
        return this.platformLists.containsKey(platform);
    }

    public final boolean hasPlatformEntry(IBuildCachePlatform.Platform platform, Integer usage) {
        if (this.platformLists.containsKey(platform)) {
            return this.platformLists.get(platform).containsKey(usage);
        }
        return false;
    }

    public final void setPlatformEntry(IBuildCachePlatform.Platform platform, Integer usage, List<IBuildMapHandle> items) {
        if (!this.platformLists.containsKey(platform)) {
            this.platformLists.put(platform, new HashMap());
        }
        this.platformLists.get(platform).put(usage, items);
    }

    public final ITeamRepository getRepository() {
        return this.repository;
    }

    public final IProcessAreaHandle getProcessArea() {
        return this.processArea;
    }

    public final IItemHandle getItemHandle() {
        return this.itemHandle;
    }

    public final String getRepositoryId() {
        return this.repositoryId;
    }

    public final String getProcessAreaId() {
        return this.processAreaId;
    }

    public final String getItemHandleId() {
        return this.itemHandleId;
    }

    public final List<?> getList() {
        return this.itemList;
    }

    public final List<IBuildMapHandle> getItemList() {
        return this.itemList;
    }

    public final Map<String, IBuildMapHandle> getItemMapByName() {
        return this.itemMapByName;
    }

    public final Map<String, IBuildMapHandle> getItemMapByUuid() {
        return this.itemMapByUuid;
    }

    public final IBuildMapHandle get(IBuildMapHandle item) {
        IBuildMapHandle result = null;
        result = this.hasItemList ? this.getItemList(item) : (this.hasItemMapByName ? this.getItemMapByName(item) : this.getItemMapByUuid(item));
        return result;
    }

    public final IBuildMapHandle get(String item) {
        if (Verification.isUUID((String)item)) {
            return this.getUuid(item);
        }
        return this.getName(item);
    }

    public final IBuildMapHandle getName(String name) {
        IBuildMapHandle result = null;
        result = this.hasItemMapByName ? this.getItemMapByName(name) : this.getItemListByName(name);
        return result;
    }

    public final IBuildMapHandle getUuid(String uuid) {
        IBuildMapHandle result = null;
        result = this.hasItemMapByUuid ? this.getItemMapByUuid(uuid) : this.getItemListByUuid(uuid);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IBuildMapHandle getItemList(int location) {
        IBuildMapHandle result = null;
        if (this.hasItemList) {
            ItemArrayList<IBuildMapHandle> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                if (location <= this.itemList.size()) {
                    result = (IBuildMapHandle)this.itemList.get(location);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IBuildMapHandle getItemList(IBuildMapHandle item) {
        IBuildMapHandle result = null;
        if (this.hasItemList) {
            ItemArrayList<IBuildMapHandle> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                result = (IBuildMapHandle)this.itemList.get((IItemHandle)item);
            }
        }
        return result;
    }

    public final IBuildMapHandle getItemListByName(String name) {
        IBuildMapHandle result = null;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IBuildMapHandle getItemListByUuid(String uuid) {
        IBuildMapHandle result = null;
        if (uuid != null) {
            if (this.hasItemList) {
                ItemArrayList<IBuildMapHandle> itemArrayList = this.itemList;
                synchronized (itemArrayList) {
                    for (IBuildMapHandle item : this.itemList) {
                        if (!uuid.equals(item.getItemId().getUuidValue())) continue;
                        result = item;
                        break;
                    }
                }
            }
            if (this.hasItemMapByName) {
                Map<String, IBuildMapHandle> map = this.itemMapByName;
                synchronized (map) {
                    for (IBuildMapHandle item : this.itemMapByName.values()) {
                        if (!uuid.equals(item.getItemId().getUuidValue())) continue;
                        result = item;
                        break;
                    }
                }
            }
        }
        return result;
    }

    public final IBuildMapHandle getItemMapByName(String name) {
        IBuildMapHandle result = null;
        if (this.hasItemMapByName) {
            result = this.itemMapByName.get(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IBuildMapHandle getItemMapByName(IBuildMapHandle itemArg) {
        IBuildMapHandle result = null;
        if (this.hasItemMapByName) {
            Map<String, IBuildMapHandle> map = this.itemMapByName;
            synchronized (map) {
                for (IBuildMapHandle item : this.itemMapByName.values()) {
                    if (!itemArg.sameItemId((IItemHandle)item)) continue;
                    result = item;
                    break;
                }
            }
        }
        return result;
    }

    public final IBuildMapHandle getItemMapByUuid(String uuid) {
        IBuildMapHandle result = null;
        if (this.hasItemMapByUuid) {
            result = this.itemMapByUuid.get(uuid);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IBuildMapHandle getItemMapByUuid(IBuildMapHandle itemArg) {
        IBuildMapHandle result = null;
        if (this.hasItemMapByUuid) {
            Map<String, IBuildMapHandle> map = this.itemMapByUuid;
            synchronized (map) {
                for (IBuildMapHandle item : this.itemMapByUuid.values()) {
                    if (!itemArg.sameItemId((IItemHandle)item)) continue;
                    result = item;
                    break;
                }
            }
        }
        return result;
    }

    public final boolean hasRepository() {
        return this.repository != null;
    }

    public final boolean hasProcessArea() {
        return this.processArea != null;
    }

    public final boolean hasItemHandle() {
        return this.itemHandle != null;
    }

    public final boolean hasRepositoryId() {
        return this.repositoryId != null;
    }

    public final boolean hasProcessAreaId() {
        return this.processAreaId != null;
    }

    public final boolean hasItemHandleId() {
        return this.itemHandleId != null;
    }

    public final boolean hasItemList() {
        return this.hasItemList;
    }

    public final boolean hasItemMapByName() {
        return this.hasItemMapByName;
    }

    public final boolean hasItemMapByUuid() {
        return this.hasItemMapByUuid;
    }

    public final boolean isPartial() {
        return this.partial;
    }

    public final boolean isStandard() {
        return this.standard;
    }

    public final boolean isComplete() {
        return this.complete;
    }

    public final boolean isEmpty() {
        return this.isItemListEmpty() && this.isItemMapByNameEmpty() && this.isItemMapByUuidEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isItemListEmpty() {
        boolean result = true;
        if (this.hasItemList) {
            ItemArrayList<IBuildMapHandle> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                result = this.itemList.size() == 0;
            }
        }
        return result;
    }

    public final boolean isItemMapByNameEmpty() {
        return this.hasItemMapByName ? this.itemMapByName.size() == 0 : true;
    }

    public final boolean isItemMapByUuidEmpty() {
        return this.hasItemMapByUuid ? this.itemMapByUuid.size() == 0 : true;
    }

    public final void setRepository(ITeamRepository repository) {
        this.repository = repository;
    }

    public final void setProcessArea(IProcessAreaHandle processArea) {
        this.processArea = processArea;
    }

    public final void setItemHandle(IItemHandle itemHandle) {
        this.itemHandle = itemHandle;
    }

    public final void setRepositoryId(String repositoryId) {
        this.repositoryId = repositoryId;
    }

    public final void setProcessAreaId(String processAreaId) {
        this.processAreaId = processAreaId;
    }

    public final void setItemHandleId(String itemHandleId) {
        this.itemHandleId = itemHandleId;
    }

    public final void setPartial() {
        this.partial = true;
        this.standard = false;
        this.complete = false;
    }

    public final void setStandard() {
        this.partial = false;
        this.standard = true;
        this.complete = false;
    }

    public final void setComplete() {
        this.partial = false;
        this.standard = false;
        this.complete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setItemList(List<IBuildMapHandle> itemList) {
        if (this.hasItemList) {
            ItemArrayList<IBuildMapHandle> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                this.itemList.clear();
                this.itemList.addAll(itemList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setItemMapByName(Map<String, IBuildMapHandle> itemMapByName) {
        if (this.hasItemMapByName) {
            Map<String, IBuildMapHandle> map = this.itemMapByName;
            synchronized (map) {
                this.itemMapByName.clear();
                this.itemMapByName.putAll(itemMapByName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setItemMapByUuid(Map<String, IBuildMapHandle> itemMapByUuid) {
        if (this.hasItemMapByUuid) {
            Map<String, IBuildMapHandle> map = this.itemMapByUuid;
            synchronized (map) {
                this.itemMapByUuid.clear();
                this.itemMapByUuid.putAll(itemMapByUuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<IBuildMapHandle> toItemList() {
        ItemArrayList result = null;
        if (this.hasItemList) {
            ItemArrayList<IBuildMapHandle> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                result = new ItemArrayList(this.itemList);
            }
        }
        return result;
    }

    public final Map<String, IBuildMapHandle> toItemMapByName() {
        HashMap<String, IBuildMapHandle> result = null;
        if (this.hasItemMapByName) {
            result = new HashMap<String, IBuildMapHandle>(this.itemMapByName);
        }
        return result;
    }

    public final Map<String, IBuildMapHandle> toItemMapByUuid() {
        HashMap<String, IBuildMapHandle> result = null;
        if (this.hasItemMapByUuid) {
            result = new HashMap<String, IBuildMapHandle>(this.itemMapByUuid);
        }
        return result;
    }

    public final void add(IBuildMapHandle item) {
        if (this.hasItemList) {
            this.addItemList(item);
        }
        if (this.hasItemMapByName) {
            this.addItemMapByName(item.getItemId().getUuidValue(), item);
        }
        if (this.hasItemMapByUuid) {
            this.addItemMapByUuid(item.getItemId().getUuidValue(), item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addItemList(IBuildMapHandle item) {
        boolean result = false;
        if (this.hasItemList) {
            ItemArrayList<IBuildMapHandle> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                this.itemList.removeAny((Object)item);
                result = this.itemList.add((Object)item);
            }
        }
        return result;
    }

    public final void addItemMapByName(String name, IBuildMapHandle item) {
        if (this.hasItemMapByName) {
            this.itemMapByName.put(name, item);
        }
    }

    public final void addItemMapByUuid(String uuid, IBuildMapHandle item) {
        if (this.hasItemMapByUuid) {
            this.itemMapByUuid.put(uuid, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addAllItemList(List<IBuildMapHandle> items) {
        boolean result = false;
        if (this.hasItemList) {
            ItemArrayList<IBuildMapHandle> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                for (IBuildMapHandle item : items) {
                    if (!this.itemList.contains((Object)item)) continue;
                    this.itemList.removeAny((Object)item);
                }
                result = this.itemList.addAll(items);
            }
        }
        return result;
    }

    public final void addAllItemMapByName(Map<String, IBuildMapHandle> items) {
        if (this.hasItemMapByName) {
            this.itemMapByName.putAll(items);
        }
    }

    public final void addAllItemMapByUuid(Map<String, IBuildMapHandle> items) {
        if (this.hasItemMapByUuid) {
            this.itemMapByUuid.putAll(items);
        }
    }

    public final void clear() {
        this.clearItemList();
        this.clearItemMapByName();
        this.clearItemMapByUuid();
        this.clearPlatformEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearItemList() {
        if (this.hasItemList) {
            ItemArrayList<IBuildMapHandle> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                this.itemList.clear();
            }
        }
    }

    public final void clearItemMapByName() {
        if (this.hasItemMapByName) {
            this.itemMapByName.clear();
        }
    }

    public final void clearItemMapByUuid() {
        if (this.hasItemMapByUuid) {
            this.itemMapByUuid.clear();
        }
    }

    public final boolean contains(IBuildMapHandle item) {
        boolean result = false;
        result = this.hasItemList ? this.itemListContains(item) : (this.hasItemMapByName ? this.itemMapByNameContains(item) : this.itemMapByUuidContains(item));
        return result;
    }

    public final boolean contains(String item) {
        if (Verification.isUUID((String)item)) {
            return this.containsUuid(item);
        }
        return this.containsName(item);
    }

    public final boolean contains(UUID item) {
        return this.containsUuid(item.getUuidValue());
    }

    /*
     * Unable to fully structure code
     */
    public final boolean containsAll(List<?> itemList) {
        block4: {
            block6: {
                block8: {
                    block7: {
                        block5: {
                            result = false;
                            if (itemList == null || itemList.size() <= 0) break block4;
                            search = true;
                            iterator = itemList.iterator();
                            if (!(itemList.get(0) instanceof IBuildMapHandle)) break block5;
                            while (search && iterator.hasNext() && iterator.next() != null) {
                                search = this.contains((IBuildMapHandle)iterator.next());
                            }
                            break block6;
                        }
                        if (!(itemList.get(0) instanceof UUID)) break block7;
                        while (search && iterator.hasNext() && iterator.next() != null) {
                            search = this.contains((UUID)iterator.next());
                        }
                        break block6;
                    }
                    if (!(itemList.get(0) instanceof String)) break block8;
                    if (!Verification.isUUID((String)((String)itemList.get(0)))) ** GOTO lbl24
                    while (search && iterator.hasNext() && iterator.next() != null) {
                        search = this.containsUuid((String)iterator.next());
                    }
                    break block6;
lbl-1000:
                    // 1 sources

                    {
                        search = this.containsName((String)iterator.next());
lbl24:
                        // 2 sources

                        ** while (search && iterator.hasNext() && iterator.next() != null)
                    }
lbl25:
                    // 1 sources

                    break block6;
                }
                search = false;
            }
            result = search;
        }
        return result;
    }

    public final boolean containsName(String name) {
        boolean result = false;
        result = this.hasItemMapByName ? this.itemMapByNameContains(name) : this.itemListContainsName(name);
        return result;
    }

    public final boolean containsUuid(String uuid) {
        boolean result = false;
        result = this.hasItemMapByUuid ? this.itemMapByUuidContains(uuid) : this.itemListContainsUuid(uuid);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean itemListContains(IBuildMapHandle item) {
        boolean result = false;
        if (this.hasItemList) {
            ItemArrayList<IBuildMapHandle> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                result = this.itemList.contains((Object)item);
            }
        }
        return result;
    }

    public final boolean itemListContainsName(String name) {
        boolean result = false;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean itemListContainsUuid(String uuid) {
        boolean result = false;
        if (uuid != null) {
            if (this.hasItemList) {
                ItemArrayList<IBuildMapHandle> itemArrayList = this.itemList;
                synchronized (itemArrayList) {
                    for (IBuildMapHandle item : this.itemList) {
                        if (!uuid.equals(item.getItemId().getUuidValue())) continue;
                        result = true;
                        break;
                    }
                }
            }
            if (this.hasItemMapByName) {
                Map<String, IBuildMapHandle> map = this.itemMapByName;
                synchronized (map) {
                    for (IBuildMapHandle item : this.itemMapByName.values()) {
                        if (!uuid.equals(item.getItemId().getUuidValue())) continue;
                        result = true;
                        break;
                    }
                }
            }
        }
        return result;
    }

    public final boolean itemMapByNameContains(String name) {
        boolean result = false;
        if (this.hasItemMapByName) {
            result = this.itemMapByName.containsKey(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean itemMapByNameContains(IBuildMapHandle itemArg) {
        boolean result = false;
        if (this.hasItemMapByName) {
            Map<String, IBuildMapHandle> map = this.itemMapByName;
            synchronized (map) {
                for (IBuildMapHandle item : this.itemMapByName.values()) {
                    if (item == null || !item.sameItemId((IItemHandle)itemArg)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public final boolean itemMapByUuidContains(String uuid) {
        boolean result = false;
        if (this.hasItemMapByUuid) {
            result = this.itemMapByUuid.containsKey(uuid);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean itemMapByUuidContains(IBuildMapHandle itemArg) {
        boolean result = false;
        if (this.hasItemMapByUuid) {
            Map<String, IBuildMapHandle> map = this.itemMapByUuid;
            synchronized (map) {
                for (IBuildMapHandle item : this.itemMapByUuid.values()) {
                    if (item == null || !item.sameItemId((IItemHandle)itemArg)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeItemList(IBuildMapHandle item) {
        boolean result = false;
        if (this.hasItemList) {
            ItemArrayList<IBuildMapHandle> itemArrayList = this.itemList;
            synchronized (itemArrayList) {
                result = this.itemList.remove((Object)item);
            }
        }
        return result;
    }

    public final void removeItemMapByName(String name) {
        if (this.hasItemMapByName) {
            this.itemMapByName.remove(name);
        }
    }

    public final void removeItemMapByUuid(String uuid) {
        if (this.hasItemMapByUuid) {
            this.itemMapByUuid.remove(uuid);
        }
    }
}

