/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.extensions.client;

import com.ibm.team.build.extensions.client.IBuildCacheItem;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionLogString;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildCacheItemAddLanguage {
    private static final String className = BuildCacheItemAddLanguage.class.getSimpleName();

    public static ILanguageDefinition add(ITeamRepository repository, IBuildCacheItem<ISystemDefinition> buildCacheItem, ILanguageDefinition item, ISystemDefinitionHandle itemHandle, String itemString, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repository.getClientLibrary(ISystemDefinitionModelClient.class);
        ILanguageDefinition itemDefinition = null;
        if (item != null) {
            if (buildCacheItem.containsUuid(item.getItemId().getUuidValue())) {
                return (ILanguageDefinition)buildCacheItem.getUuid(item.getItemId().getUuidValue());
            }
            itemDefinition = item;
        } else if (itemHandle != null) {
            if (buildCacheItem.containsUuid(itemHandle.getItemId().getUuidValue())) {
                return (ILanguageDefinition)buildCacheItem.getUuid(itemHandle.getItemId().getUuidValue());
            }
            itemDefinition = (ILanguageDefinition)client.fetchSystemDefinitionComplete(itemHandle, false, monitor);
        } else if (itemString != null) {
            if (buildCacheItem.containsUuid(itemString)) {
                return (ILanguageDefinition)buildCacheItem.getUuid(itemString);
            }
            itemDefinition = Verification.isUUID((String)itemString) ? (ILanguageDefinition)client.fetchSystemDefinitionComplete((ISystemDefinitionHandle)ILanguageDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemString), null), false, monitor) : (ILanguageDefinition)client.findSystemDefinitionByName(itemString, ILanguageDefinition.ITEM_TYPE, monitor);
        }
        if (itemDefinition == null) {
            return itemDefinition;
        }
        String itemDefinitionName = itemDefinition.getName();
        String itemDefinitionUuid = itemDefinition.getItemId().getUuidValue();
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addItemList((Object)itemDefinition);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addItemMapByName(itemDefinitionName, (Object)itemDefinition);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addItemMapByUuid(itemDefinitionUuid, (Object)itemDefinition);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), SystemDefinitionLogString.valueOf((ILanguageDefinition)itemDefinition)});
        }
        return itemDefinition;
    }

    public static List<ISystemDefinition> add(ITeamRepository repository, IBuildCacheItem<ISystemDefinition> buildCacheItem, List<ILanguageDefinition> items, List<ISystemDefinitionHandle> itemHandles, List<String> itemStrings, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ISystemDefinitionModelClient client = (ISystemDefinitionModelClient)repository.getClientLibrary(ISystemDefinitionModelClient.class);
        ArrayList<ISystemDefinition> itemList = new ArrayList<ISystemDefinition>();
        if (items != null) {
            itemList.addAll(items);
        } else if (itemHandles != null) {
            itemList.addAll(client.fetchSystemDefinitionsComplete(itemHandles, false, monitor));
        } else if (itemStrings != null && itemStrings.get(0) != null) {
            if (Verification.isUUID((String)itemStrings.get(0))) {
                ArrayList<ISystemDefinitionHandle> systemDefinitionHandles = new ArrayList<ISystemDefinitionHandle>();
                for (String string : itemStrings) {
                    systemDefinitionHandles.add((ISystemDefinitionHandle)ILanguageDefinition.ITEM_TYPE.createItemHandle(UUID.valueOf((String)string), null));
                }
                itemList.addAll(client.fetchSystemDefinitionsComplete(systemDefinitionHandles, false, monitor));
            } else {
                for (String name : itemStrings) {
                    itemList.add(client.findSystemDefinitionByName(name, ILanguageDefinition.ITEM_TYPE, monitor));
                }
            }
        }
        itemList.removeAll(Collections.singleton(null));
        HashMap<String, ISystemDefinition> itemMapByName = new HashMap<String, ISystemDefinition>();
        HashMap<String, ISystemDefinition> hashMap = new HashMap<String, ISystemDefinition>();
        for (ISystemDefinition item : itemList) {
            if (buildCacheItem.hasItemMapByName()) {
                String itemName = item.getName();
                itemMapByName.put(itemName, item);
            }
            if (!buildCacheItem.hasItemMapByUuid()) continue;
            String itemUuid = item.getItemId().getUuidValue();
            hashMap.put(itemUuid, item);
        }
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addAllItemList(itemList);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addAllItemMapByName(itemMapByName);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addAllItemMapByUuid(hashMap);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(itemList)});
        }
        return itemList;
    }
}

