/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.build.extensions.client;

import com.ibm.team.build.extensions.client.IBuildCacheItem;
import com.ibm.team.build.extensions.common.debug.Debug;
import com.ibm.team.build.extensions.common.debug.IDebugger;
import com.ibm.team.build.extensions.common.debug.LogString;
import com.ibm.team.build.extensions.common.debug.MethodName;
import com.ibm.team.build.extensions.common.util.Verification;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMap;
import com.ibm.team.enterprise.build.buildmap.common.model.IBuildMapHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildCacheItemAddBuildMapHandle {
    private static final String className = BuildCacheItemAddBuildMapHandle.class.getSimpleName();

    public static IBuildMapHandle add(ITeamRepository repository, IBuildCacheItem<IBuildMapHandle> buildCacheItem, IBuildMap item, IBuildMapHandle itemHandle, String itemString, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        IBuildMap itemDefinition = null;
        if (item != null) {
            if (buildCacheItem.containsUuid(item.getItemId().getUuidValue())) {
                return (IBuildMapHandle)buildCacheItem.getUuid(item.getItemId().getUuidValue());
            }
            itemDefinition = item;
        } else if (itemHandle != null) {
            if (buildCacheItem.containsUuid(itemHandle.getItemId().getUuidValue())) {
                return (IBuildMapHandle)buildCacheItem.getUuid(itemHandle.getItemId().getUuidValue());
            }
            itemDefinition = itemHandle;
        } else if (itemString != null) {
            if (buildCacheItem.contains(itemString)) {
                return (IBuildMapHandle)buildCacheItem.get(itemString);
            }
            if (Verification.isUUID((String)itemString)) {
                itemDefinition = (IBuildMapHandle)IBuildMap.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemString), null);
            }
        }
        if (itemDefinition == null) {
            return itemDefinition;
        }
        String itemDefinitionName = itemDefinition.getItemId().getUuidValue();
        String itemDefinitionUuid = itemDefinition.getItemId().getUuidValue();
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addItemList((Object)itemDefinition);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addItemMapByName(itemDefinitionName, (Object)itemDefinition);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addItemMapByUuid(itemDefinitionUuid, (Object)itemDefinition);
        }
        if (dbg.isDebug()) {
            Debug.inout((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf((IItemHandle)itemDefinition)});
        }
        return itemDefinition;
    }

    public static List<IBuildMapHandle> add(ITeamRepository repository, IBuildCacheItem<IBuildMapHandle> buildCacheItem, List<IBuildMap> items, List<IBuildMapHandle> itemHandles, List<String> itemStrings, IProgressMonitor monitor, IDebugger dbg) throws TeamRepositoryException {
        if (dbg.isDebug()) {
            Debug.enter((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName()});
        }
        ArrayList<IBuildMapHandle> itemList = new ArrayList<IBuildMapHandle>();
        if (items != null) {
            itemList.addAll(items);
        } else if (itemHandles != null) {
            itemList.addAll(itemHandles);
        } else if (itemStrings != null) {
            ArrayList<IBuildMapHandle> handles = new ArrayList<IBuildMapHandle>();
            for (String itemId : itemStrings) {
                if (!Verification.isUUID((String)itemId)) continue;
                handles.add((IBuildMapHandle)IBuildMap.ITEM_TYPE.createItemHandle(UUID.valueOf((String)itemId), null));
            }
            itemList.addAll(handles);
        }
        itemList.removeAll(Collections.singleton(null));
        HashMap<String, IBuildMapHandle> itemMapByName = new HashMap<String, IBuildMapHandle>();
        HashMap<String, IBuildMapHandle> itemMapByUuid = new HashMap<String, IBuildMapHandle>();
        for (IBuildMapHandle item : itemList) {
            if (buildCacheItem.hasItemMapByName()) {
                String itemName = item.getItemId().getUuidValue();
                itemMapByName.put(itemName, item);
            }
            if (!buildCacheItem.hasItemMapByUuid()) continue;
            String itemUuid = item.getItemId().getUuidValue();
            itemMapByUuid.put(itemUuid, item);
        }
        if (buildCacheItem.hasItemList()) {
            buildCacheItem.addAllItemList(itemList);
        }
        if (buildCacheItem.hasItemMapByName()) {
            buildCacheItem.addAllItemMapByName(itemMapByName);
        }
        if (buildCacheItem.hasItemMapByUuid()) {
            buildCacheItem.addAllItemMapByUuid(itemMapByUuid);
        }
        if (dbg.isDebug()) {
            Debug.leave((IDebugger)dbg, (String[])new String[]{className, new MethodName(){}.getName(), LogString.valueOf(itemList)});
        }
        return itemList;
    }
}

